<?php
// Arquivo: proxy_player.php
// VERSÃO: CORREÇÃO DE URLENCODE (Resolve carregamento infinito)

$DNS_IPTV = "http://topiptv.tvsbr.top"; 

// 1. Limpeza de Lixo/Erros
ini_set('display_errors', 0);
error_reporting(0);
if (function_exists('ob_clean')) { @ob_clean(); } // Limpa qualquer saida anterior

// Configurações
set_time_limit(0);
ini_set('memory_limit', '512M');

$url_final = "";

// Lógica de construção da URL
if (isset($_GET['ts_url'])) {
    // DECODIFICAÇÃO SEGURA DO LINK DO VÍDEO
    $url_final = base64_decode($_GET['ts_url']);
} elseif (isset($_GET['user']) && isset($_GET['pwd']) && isset($_GET['stream'])) {
    $user = $_GET['user'];
    $pwd = $_GET['pwd'];
    $stream = $_GET['stream'];
    // Força HLS
    $url_final = $DNS_IPTV . "/get.php?username=$user&password=$pwd&stream_id=$stream&output=m3u8";
} else {
    http_response_code(400);
    exit;
}

// CURL
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $url_final);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
// Trocamos o User Agent para IPTVSmarters para garantir compatibilidade
curl_setopt($ch, CURLOPT_USERAGENT, 'IPTVSmartersPro'); 

$data = curl_exec($ch);
$info = curl_getinfo($ch);
curl_close($ch);

if ($info['http_code'] >= 400 || empty($data)) {
    http_response_code(404);
    exit;
}

// === PROCESSAMENTO ===

// Se for a lista M3U8
if (strpos($data, '#EXTM3U') !== false) {
    header("Content-Type: application/vnd.apple.mpegurl");
    header("Access-Control-Allow-Origin: *");
    
    $lines = explode("\n", $data);
    foreach($lines as $line) {
        $line = trim($line);
        if (empty($line)) continue;
        
        if ($line[0] == '#') {
            echo $line . "\n";
        } else {
            // É UM LINK DE VÍDEO (.ts)
            $url_ts_real = $line;
            
            // Corrige link relativo
            if (strpos($line, 'http') !== 0) {
                $effective_url = $info['url'];
                if (strpos($effective_url, 'get.php') !== false) {
                     $base = str_replace(basename($effective_url), '', $effective_url);
                } else {
                     $base = dirname($effective_url) . '/';
                }
                $url_ts_real = rtrim($base, '/') . '/' . ltrim($line, '/');
            }
            
            // --- AQUI ESTÁ A CORREÇÃO MÁGICA (URLENCODE) ---
            // Sem urlencode, o base64 quebra e o player fica carregando infinito
            $link_seguro = urlencode(base64_encode($url_ts_real));
            echo "proxy_player.php?ts_url=" . $link_seguro . "\n";
        }
    }
} 
// Se for vídeo binário (.ts)
else {
    header("Content-Type: video/mp2t");
    header("Access-Control-Allow-Origin: *");
    echo $data;
}
?>