<?php
require_once $_SERVER['DOCUMENT_ROOT'] . '/api/controles/db.php';

if (!isset($_GET['id']) || !is_numeric($_GET['id'])) {
    die("Erro: ID inválido ou não fornecido.");
}

$id_para_excluir = intval($_GET['id']);
$tipo = isset($_GET['tipo']) ? $_GET['tipo'] : '';

try {
    $conn = conectar_bd();

    if ($tipo === 'serie') {
        $conn->beginTransaction();
        $stmt_ep = $conn->prepare("DELETE FROM series_episodes WHERE series_id = :id");
        $stmt_ep->bindParam(':id', $id_para_excluir, PDO::PARAM_INT);
        $stmt_ep->execute();
        $stmt_serie = $conn->prepare("DELETE FROM series WHERE id = :id");
        $stmt_serie->bindParam(':id', $id_para_excluir, PDO::PARAM_INT);
        $stmt_serie->execute();
        $conn->commit();
    } elseif ($tipo === 'filme') {
        $stmt = $conn->prepare("DELETE FROM streams WHERE id = :id AND stream_type = 'movie'");
        $stmt->bindParam(':id', $id_para_excluir, PDO::PARAM_INT);
        $stmt->execute();
    } elseif ($tipo === 'canal') {
        $stmt = $conn->prepare("DELETE FROM streams WHERE id = :id AND stream_type = 'live'");
        $stmt->bindParam(':id', $id_para_excluir, PDO::PARAM_INT);
        $stmt->execute();
    }
    
    // Redireciona de volta para a página anterior
    header('Location: ' . $_SERVER['HTTP_REFERER']);
    exit;

} catch (PDOException $e) {
    if (isset($conn) && $conn->inTransaction()) {
        $conn->rollBack();
    }
    die("Falha ao excluir do banco de dados: " . $e->getMessage());
}
?>