<?php
// ARQUIVO: /api/apagar_conteudo.php
header('Content-Type: application/json');
header("Access-Control-Allow-Origin: *");

// 1. Captura os dados (JSON)
$inputJSON = file_get_contents('php://input');
$input = json_decode($inputJSON, true);

$ids = $input['ids'] ?? [];
$tipo = $input['tipo'] ?? ''; // 'stream' (filmes/canais) ou 'series'

if (empty($ids) || !is_array($ids)) {
    echo json_encode(['success' => false, 'error' => 'Nenhum item selecionado.']);
    exit;
}

// Sanitização
$ids = array_map('intval', $ids);
$ids = array_filter($ids);

try {
    // 2. Conexão ao Banco
    if (file_exists(__DIR__ . '/controles/db.php')) {
        require_once(__DIR__ . '/controles/db.php');
    } elseif (file_exists(__DIR__ . '/../api/controles/db.php')) {
        require_once(__DIR__ . '/../api/controles/db.php');
    } else {
        throw new Exception("Arquivo de conexão db.php não encontrado.");
    }

    $pdo = conectar_bd();
    if (!$pdo) throw new Exception("Falha na conexão com o banco.");

    // 3. Define qual tabela apagar
    $tabela = '';
    if ($tipo === 'stream') {
        $tabela = 'streams'; // Filmes e Canais ficam aqui
    } elseif ($tipo === 'series') {
        $tabela = 'series'; // Séries ficam aqui
    } else {
        throw new Exception("Tipo de conteúdo inválido (use 'stream' ou 'series').");
    }

    // 4. Executa a exclusão
    $placeholders = implode(',', array_fill(0, count($ids), '?'));
    $sql = "DELETE FROM $tabela WHERE id IN ($placeholders)";
    
    $stmt = $pdo->prepare($sql);
    
    if ($stmt->execute($ids)) {
        echo json_encode(['success' => true, 'message' => count($ids) . ' itens excluídos com sucesso!']);
    } else {
        throw new Exception("O banco de dados recusou a exclusão.");
    }

} catch (Exception $e) {
    echo json_encode(['success' => false, 'error' => $e->getMessage()]);
}
?>