<?php
// ARQUIVO FINAL: api/api_monitor_ajax.php (Exibe LOGIN e NOME REAL)

header('Content-Type: application/json');
header("Cache-Control: no-cache, no-store, must-revalidate");
header("Pragma: no-cache");
header("Expires: 0");

require_once "controles/db.php"; 
date_default_timezone_set('America/Sao_Paulo');

$pdo = conectar_bd();

// Ação de Kick/Derrubar
if (isset($_GET['action']) && $_GET['action'] == 'kill' && isset($_GET['id'])) {
    $stmt = $pdo->prepare("DELETE FROM conexoes WHERE id = ?");
    $stmt->execute([$_GET['id']]);
    echo json_encode(['success' => true]);
    exit;
}

try {
    // SQL OTIMIZADO (igual, mas o processamento de nome muda no loop)
    $sql = "SELECT 
                c.id as id_conexao, 
                c.usuario AS login_user, 
                c.ip, c.stream_id, c.ultima_atividade, 
                cl.is_trial,
                cl.name AS real_name, 
                s.name as nome_stream, s.stream_type,
                se.title as nome_ep, ser.name as nome_serie, se.season, se.episode_num
            FROM conexoes c 
            LEFT JOIN clientes cl ON c.usuario = cl.usuario 
            LEFT JOIN streams s ON c.stream_id = s.id
            LEFT JOIN series_episodes se ON c.stream_id = se.id
            LEFT JOIN series ser ON se.series_id = ser.id
            ORDER BY c.ultima_atividade DESC";
            
    $stmt = $pdo->query($sql);
    $dados = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    $resultado = [];
    $agora = new DateTime();
    
    foreach ($dados as $row) {
        
        // 1. Definição do Nome (CORREÇÃO FINAL AQUI)
        $login = trim((string)$row['login_user']);
        $real_name = trim((string)$row['real_name']);
        
        // Prioriza Login, anexa Nome Real se for diferente
        $display_name = $login;
        if (!empty($real_name) && $real_name !== $login) {
             $display_name .= " (" . $real_name . ")"; 
        }

        $user_final = !empty($display_name) ? $display_name : "Desconhecido"; // Se tudo falhar, mostra Desconhecido
        
        // 2. Definição de Conteúdo e Tipo (igual)
        $conteudo = "ID: " . $row['stream_id'];
        $tipo = "---";

        if (!empty($row['nome_stream'])) {
            $conteudo = $row['nome_stream'];
            $tipo = ($row['stream_type'] == 'live') ? "TV" : "FILME";
        } elseif (!empty($row['nome_ep'])) {
            $s = str_pad($row['season'], 2, '0', STR_PAD_LEFT);
            $e = str_pad($row['episode_num'], 2, '0', STR_PAD_LEFT);
            $serie = !empty($row['nome_serie']) ? $row['nome_serie'] : "Série";
            $conteudo = "$serie S{$s}E{$e} - " . $row['nome_ep'];
            $tipo = "SERIE";
        }

        // 3. Cálculo do Tempo (igual)
        $ultima = new DateTime($row['ultima_atividade']);
        $diff = $agora->diff($ultima);
        
        $tempo_online = [];
        if ($diff->h > 0) $tempo_online[] = $diff->h . "h";
        if ($diff->i > 0) $tempo_online[] = $diff->i . "m";
        $tempo_online[] = $diff->s . "s";
        $ping_formatado = implode(" ", $tempo_online);

        $resultado[] = [
            'id_conexao' => $row['id_conexao'],
            'usuario' => $display_name, // Nome final
            'is_trial' => $row['is_trial'],
            'ip' => $row['ip'],
            'conteudo' => $conteudo,
            'tipo' => $tipo,
            'hora' => $ultima->format('H:i:s'),
            'ping' => $ping_formatado
        ];
    }

    echo json_encode(['total' => count($resultado), 'conexoes' => $resultado]);

} catch (Exception $e) {
    echo json_encode(['total' => 0, 'conexoes' => []]);
}
?>
