<?php
/**
 * Arquivo de Configurao e Conexo com o Banco de Dados
 *
 * Centraliza as credenciais e a lgica de conexo, alm de outras
 * configuraes globais como chaves de API.
 */

// -------------------------------------------------------------------
// CHAVES DE API GLOBAIS
// -------------------------------------------------------------------

/**
 * Chave de API para o The Movie Database (TMDB)
 * Obtenha a sua em https://www.themoviedb.org/settings/api
 */
define('TMDB_API_KEY', 'f99aa9ae1fe7619969cc7db0938c1ae5');


// -------------------------------------------------------------------
// FUNO DE CONEXO COM O BANCO DE DADOS (VERSO CORRIGIDA)
// -------------------------------------------------------------------

/**
 * Estabelece e retorna uma conexo com o banco de dados usando PDO.
 *
 * @return PDO|null Retorna o objeto de conexo PDO em caso de sucesso
 * ou null em caso de falha.
 */
function conectar_bd() {
    $endereco = 'localhost';
    $banco = 'officextream';
    $dbusuario = 'user_officextream';
    $dbsenha = 'pass_officextream'; 
    $charset = 'utf8mb4';   

    $options = [
        PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
        PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
        PDO::ATTR_EMULATE_PREPARES   => false,
    ];

    $dsn = "mysql:host=$endereco;dbname=$banco;charset=$charset";

    try {
        $conexao = new PDO($dsn, $dbusuario, $dbsenha, $options);
        return $conexao;
        
    } catch(PDOException $e) {
        
        // --- ESTA  A CORREO ---
        
        // 1. Registra o erro real no log do servidor (muito importante para depurao)
        error_log('Falha na conexão com o banco de dados: ' . $e->getMessage());

        // 2. Retorna null para que a funo que chamou (ex: listar_revendedores)
        // possa tratar o erro e retornar o JSON correto para o JavaScript.
        return null;
        
        // --- FIM DA CORREO ---
    }
}
?>