<?php
// Arquivo: /api/controles/funcoes_clientes.php
// VERSÃO FINAL - MENSAGEM CURTA NA RENOVAÇÃO

// --- Funções Auxiliares ---
function encurtar_url($long_url) {
    if (empty($long_url) || !filter_var($long_url, FILTER_VALIDATE_URL)) return $long_url;
    // Mantido para compatibilidade
    $api = 'https://is.gd/create.php?format=simple&url=' . urlencode($long_url);
    $ret = @file_get_contents($api);
    return ($ret && filter_var($ret, FILTER_VALIDATE_URL)) ? trim($ret) : $long_url;
}

function obter_url_load_balance_ou_padrao($conexao) {
    $padrao = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http") . "://" . $_SERVER['HTTP_HOST'];
    try {
        $stmt = $conexao->prepare("SELECT server_ip, server_port FROM servers WHERE status = 1 LIMIT 1");
        $stmt->execute();
        if ($s = $stmt->fetch(PDO::FETCH_ASSOC)) {
            $url = rtrim($s['server_ip'], '/');
            $port = $s['server_port'];
            if (strpos($url, 'http') !== 0) $url = ($port == 443 ? 'https://' : 'http://') . $url;
            if (!empty($port) && $port != 80 && $port != 443) $url .= ':' . $port;
            return $url;
        }
    } catch (Exception $e) {}
    return $padrao;
}

function gerar_mensagem_template($pdo, $user, $pass, $vencimento) {
    $url = obter_url_load_balance_ou_padrao($pdo);
    // Garante que não tenha barra no final para montar a URL bonitinha
    $url = rtrim($url, '/');

    $exp_format = date('d/m/Y H:i', strtotime($vencimento));
    $arquivo_template = $_SERVER['DOCUMENT_ROOT'] . '/template_mensagem.txt';
    
    if (file_exists($arquivo_template)) {
        $template = file_get_contents($arquivo_template);
    } else {
        $template = "✅ *DADOS DE ACESSO* ✅\n\n👤 *Usuário:* #username#\n🔑 *Senha:* #password#\n📅 *Vencimento:* #exp_date#\n\n🔗 *URL:* #url#";
    }

    // --- CRIAÇÃO DOS LINKS CURTOS (REWRITE) ---
    $link_ts_curto  = "$url/m3u-ts/$user/$pass";
    $link_hls_curto = "$url/m3u-hls/$user/$pass";
    $link_ssiptv    = "$url/ssiptv/$user/$pass";

    $replacements = [
        '#username#' => $user, '#password#' => $pass, '#url#' => $url, '#exp_date#' => $exp_format,
        
        // Links Originais (Longos)
        '#m3u_link#' => "$url/get.php?username=$user&password=$pass&type=m3u_plus&output=ts",
        '#m3u_link_hls#' => "$url/get.php?username=$user&password=$pass&type=m3u_plus&output=m3u8",
        '#ssiptv_link#' => "$url/get.php?username=$user&password=$pass&type=m3u_plus&output=ts",
        
        // Links Curtos (Novas Variáveis)
        '#m3u_encurtado#' => $link_ts_curto,
        '#m3u_hls_encurtado#' => $link_hls_curto,
        '#ssiptv_encurtado#' => $link_ssiptv
    ];
    return str_replace(array_keys($replacements), array_values($replacements), $template);
}

// ========================================================
// 1. LISTAGEM DE CLIENTES
// ========================================================
function listar_clientes($req) {
    try {
        $pdo = conectar_bd();
        $id_logado = $_SESSION['admin_id'];
        $stmt = $pdo->prepare("SELECT admin FROM admin WHERE id = ?");
        $stmt->execute([$id_logado]);
        $u = $stmt->fetch();
        $is_dono = ($u && $u['admin'] == 1);

        $condicoes = ["is_trial = 0", "is_p2p = 0"];
        $params = [];

        if ($is_dono) {
            if (!empty($req['filtro_revenda']) && $req['filtro_revenda'] !== 'todos') {
                $condicoes[] = "admin_id = :filtro_id";
                $params[':filtro_id'] = $req['filtro_revenda'];
            } elseif (empty($req['filtro_revenda'])) {
                $condicoes[] = "admin_id = :meu_id";
                $params[':meu_id'] = $id_logado;
            }
        } else {
            $condicoes[] = "admin_id = :meu_id";
            $params[':meu_id'] = $id_logado;
        }

        $sql_search = "";
        $params_search = [];
        if (!empty($req['search']['value'])) {
            $termo = "%" . $req['search']['value'] . "%";
            $sql_search = " AND (name LIKE :s1 OR usuario LIKE :s2) ";
            $params_search[':s1'] = $termo;
            $params_search[':s2'] = $termo;
        }

        $sql_where = " WHERE " . implode(" AND ", $condicoes);

        $stmt_total = $pdo->prepare("SELECT COUNT(id) FROM clientes " . $sql_where);
        $stmt_total->execute($params);
        $total_records = $stmt_total->fetchColumn();

        $stmt_filt = $pdo->prepare("SELECT COUNT(id) FROM clientes " . $sql_where . $sql_search);
        $stmt_filt->execute(array_merge($params, $params_search));
        $total_filtered = $stmt_filt->fetchColumn();

        $colunas = [0=>'id', 1=>'name', 2=>'usuario', 3=>'status', 4=>'Vencimento'];
        $ordem = $req['order'][0]['dir'] ?? 'desc';
        $limit = $req['length'] ?? 10;
        $offset = $req['start'] ?? 0;

        $sql = "SELECT * FROM clientes " . $sql_where . $sql_search . " ORDER BY id $ordem LIMIT $limit OFFSET $offset";
        $stmt = $pdo->prepare($sql);
        $stmt->execute(array_merge($params, $params_search));

        $data = [];
        while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
            $id = $row['id'];
            if ($row['is_banned'] == 1) $st = '<span class="badge bg-danger">Bloqueado</span>';
            elseif (strtotime($row['Vencimento']) < time()) $st = '<span class="badge bg-warning text-dark">Vencido</span>';
            else $st = '<span class="badge bg-success">Ativo</span>';

            $btns = "<div class='btn-group'>";
            $btns .= "<button class='btn btn-sm btn-info' onclick='modal_master(\"api/clientes.php\", \"info_cliente\", \"$id\")' title='Info'><i class='fas fa-eye'></i></button>";
            $btns .= "<button class='btn btn-sm btn-primary' onclick='modal_master(\"api/clientes.php\", \"edite_cliente\", \"$id\")' title='Editar'><i class='fas fa-edit'></i></button>";
            $btns .= "<button class='btn btn-sm btn-success' onclick='modal_master(\"api/clientes.php\", \"renovar_cliente\", \"$id\")' title='Renovar'><i class='fas fa-retweet'></i></button>";
            $icon = $row['is_banned'] ? 'fa-unlock' : 'fa-lock';
            $cls = $row['is_banned'] ? 'btn-outline-success' : 'btn-outline-danger';
            $btns .= "<button class='btn btn-sm $cls' onclick='modal_master(\"api/clientes.php\", \"toggle_bloqueio_cliente\", \"$id\")' title='Bloqueio'><i class='fas $icon'></i></button>";
            $btns .= "<button class='btn btn-sm btn-danger' onclick='modal_master(\"api/clientes.php\", \"delete_cliente\", \"$id\")' title='Excluir'><i class='fas fa-trash-alt'></i></button>";
            $btns .= "</div>";

            $data[] = ["id"=>$id, "name"=>$row['name'], "usuario"=>$row['usuario'], "status"=>$st, "vencimento"=>date('d/m/Y H:i', strtotime($row['Vencimento'])), "acao"=>$btns];
        }
        return ["draw"=>intval($req['draw']), "recordsTotal"=>$total_records, "recordsFiltered"=>$total_filtered, "data"=>$data];
    } catch (Exception $e) { return ["data"=>[], "error"=>$e->getMessage()]; }
}

// ========================================================
// 2. MODAIS E AÇÕES
// ========================================================

// --- ADICIONAR ---
function adicionar_clientes() {
    $pdo = conectar_bd();
    $id = $_SESSION['admin_id'];
    
    $stmt = $pdo->prepare("SELECT id, nome FROM planos WHERE admin_id = ? ORDER BY nome");
    $stmt->execute([$id]);
    $opt_p = "<option value='' disabled selected>Selecione...</option>";
    while($r = $stmt->fetch()) $opt_p .= "<option value='{$r['id']}'>{$r['nome']}</option>";

    $stmt = $pdo->query("SELECT id, bouquet_name FROM bouquets ORDER BY bouquet_name");
    $opt_b = "<option value='' disabled selected>Selecione...</option>";
    while($r = $stmt->fetch()) $opt_b .= "<option value='{$r['id']}'>{$r['bouquet_name']}</option>";

    $html = '
    <form id="formAdd">
        <input type="hidden" name="confirme_adicionar_clientes" value="1">
        <div class="row">
            <div class="col-6 mb-2"><label>Nome</label><input type="text" name="name" class="form-control" required></div>
            <div class="col-6 mb-2"><label>WhatsApp</label><input type="text" name="WhatsApp" class="form-control"></div>
            
            <div class="col-12 mb-2 text-end">
                <button type="button" class="btn btn-sm btn-outline-info" onclick="gerarDadosAcesso()">
                    <i class="fas fa-magic"></i> Gerar Automático
                </button>
            </div>

            <div class="col-6 mb-2"><label>Usuário</label><input type="text" name="usuario" class="form-control" required></div>
            <div class="col-6 mb-2"><label>Senha</label><input type="text" name="senha" class="form-control" required></div>
            <div class="col-6 mb-2"><label>Plano</label><select name="plano" class="form-select" required>'.$opt_p.'</select></div>
            <div class="col-6 mb-2"><label>Pacote</label><select name="bouquet_id" class="form-select" required>'.$opt_b.'</select></div>
            <div class="col-6 mb-2"><label>Meses</label><input type="number" name="meses" value="1" class="form-control"></div>
            <div class="col-6 mb-2"><label>Conexões</label><input type="number" name="conexoes" value="1" class="form-control"></div>
        </div>
    </form>';
    $ft = '<button class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button> <button class="btn btn-primary" onclick="enviarFormulario(\'formAdd\', \'api/clientes.php\')">Salvar</button>';
    return ['modal_titulo'=>'Novo Cliente', 'modal_body'=>$html, 'modal_footer'=>$ft];
}

function confirme_adicionar_clientes($p) {
    try {
        $pdo = conectar_bd();
        $admin_id = $_SESSION['admin_id'];
        $meses = $p['meses'] ?? 1;
        
        // Verifica Crédito
        $stmt = $pdo->prepare("SELECT admin, creditos FROM admin WHERE id = ?");
        $stmt->execute([$admin_id]);
        $u = $stmt->fetch();
        
        $eh_revenda = ($u['admin'] != 1);
        if ($eh_revenda && $u['creditos'] < $meses) {
            return ['title'=>'Sem Crédito', 'msg'=>'Créditos insuficientes.', 'icon'=>'warning'];
        }

        // Cria Cliente
        $venc = date('Y-m-d 23:59:59', strtotime("+{$meses} month"));
        $sql = "INSERT INTO clientes (admin_id, name, usuario, senha, WhatsApp, plano, bouquet_id, Vencimento, conexoes, Criado_em, is_trial, is_p2p) 
                VALUES (?,?,?,?,?,?,?,?,?,NOW(),0,0)";
        $pdo->prepare($sql)->execute([$admin_id, $p['name'], $p['usuario'], $p['senha'], $p['WhatsApp'], $p['plano'], $p['bouquet_id'], $venc, $p['conexoes']]);
        
        // Desconta Crédito
        if ($eh_revenda) {
            $pdo->prepare("UPDATE admin SET creditos = creditos - ? WHERE id = ?")->execute([$meses, $admin_id]);
            $pdo->prepare("INSERT INTO credits_log (admin_id, target_id, amount, reason, date) VALUES (?, ?, ?, ?, ?)")
                ->execute([$admin_id, $admin_id, -$meses, "Criou cliente: {$p['usuario']}", time()]);
        }

        $msg_cliente = gerar_mensagem_template($pdo, $p['usuario'], $p['senha'], $venc);
        
        return ['title'=>'Sucesso', 'msg'=>'Criado!', 'icon'=>'success', 'data_table'=>'atualizar', 'dados_cliente_msg' => $msg_cliente];
    } catch(Exception $e) { return ['title'=>'Erro', 'msg'=>$e->getMessage(), 'icon'=>'error']; }
}

// --- EDITAR ---
function edite_cliente($id) {
    try {
        $pdo = conectar_bd();
        $stmt = $pdo->prepare("SELECT * FROM clientes WHERE id = ?");
        $stmt->execute([$id]);
        $c = $stmt->fetch(PDO::FETCH_ASSOC);
        if(!$c) return ['modal_titulo'=>'Erro', 'modal_body'=>'Cliente não encontrado'];

        $id_adm = $_SESSION['admin_id'];
        $stmt_p = $pdo->prepare("SELECT id, nome FROM planos WHERE admin_id = ?"); 
        $stmt_p->execute([$id_adm]);
        $opt_p = "<option value=''>Sem Plano</option>"; 
        while($r=$stmt_p->fetch()) {
            $sel = ($c['plano'] == $r['id']) ? 'selected' : '';
            $opt_p .= "<option value='{$r['id']}' $sel>{$r['nome']}</option>";
        }
        $stmt_b = $pdo->query("SELECT id, bouquet_name FROM bouquets");
        $opt_b = "<option value=''>Sem Pacote</option>"; 
        while($r=$stmt_b->fetch()) {
            $sel = ($c['bouquet_id'] == $r['id']) ? 'selected' : '';
            $opt_b .= "<option value='{$r['id']}' $sel>{$r['bouquet_name']}</option>";
        }

        $nome = htmlspecialchars($c['name'] ?? '');
        $whats = htmlspecialchars($c['WhatsApp'] ?? '');
        $user = htmlspecialchars($c['usuario'] ?? '');
        $pass = htmlspecialchars($c['senha'] ?? '');
        $con = htmlspecialchars($c['conexoes'] ?? 1);
        $venc = date('Y-m-d', strtotime($c['Vencimento']));

        $html = '
        <form id="formEdit">
            <input type="hidden" name="confirme_edite_cliente" value="1">
            <input type="hidden" name="id" value="'.$id.'">
            <div class="row">
                <div class="col-6 mb-2"><label>Nome</label><input type="text" name="name" value="'.$nome.'" class="form-control"></div>
                <div class="col-6 mb-2"><label>WhatsApp</label><input type="text" name="WhatsApp" value="'.$whats.'" class="form-control"></div>
                <div class="col-6 mb-2"><label>Usuário</label><input type="text" name="usuario" value="'.$user.'" class="form-control"></div>
                <div class="col-6 mb-2"><label>Senha</label><input type="text" name="senha" value="'.$pass.'" class="form-control"></div>
                <div class="col-6 mb-2"><label>Vencimento</label><input type="date" name="vencimento" value="'.$venc.'" class="form-control"></div>
                <div class="col-6 mb-2"><label>Conexões</label><input type="number" name="conexoes" value="'.$con.'" class="form-control"></div>
                <div class="col-6 mb-2"><label>Plano</label><select name="plano" class="form-select">'.$opt_p.'</select></div>
                <div class="col-6 mb-2"><label>Pacote</label><select name="bouquet_id" class="form-select">'.$opt_b.'</select></div>
            </div>
        </form>';

        $ft = '<button class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button> <button class="btn btn-primary" onclick="enviarFormulario(\'formEdit\', \'api/clientes.php\')">Salvar</button>';
        return ['modal_titulo'=>'Editar: '.$user, 'modal_body'=>$html, 'modal_footer'=>$ft];
    } catch (Exception $e) { return ['modal_titulo'=>'Erro', 'modal_body'=>'Erro: '.$e->getMessage()]; }
}

function confirme_edite_cliente($p) {
    try {
        $pdo = conectar_bd();
        $venc = date('Y-m-d 23:59:59', strtotime($p['vencimento']));
        $sql = "UPDATE clientes SET name=?, WhatsApp=?, usuario=?, senha=?, Vencimento=?, conexoes=?, plano=?, bouquet_id=? WHERE id=?";
        $pdo->prepare($sql)->execute([$p['name'], $p['WhatsApp'], $p['usuario'], $p['senha'], $venc, $p['conexoes'], $p['plano'], $p['bouquet_id'], $p['id']]);
        return ['title'=>'Sucesso', 'msg'=>'Atualizado!', 'icon'=>'success', 'data_table'=>'atualizar'];
    } catch(Exception $e) { return ['title'=>'Erro', 'msg'=>$e->getMessage(), 'icon'=>'error']; }
}

// --- INFO ---
function info_cliente($id) {
    $pdo = conectar_bd();
    $stmt = $pdo->prepare("SELECT * FROM clientes WHERE id = ?");
    $stmt->execute([$id]);
    $c = $stmt->fetch(PDO::FETCH_ASSOC);
    if(!$c) return ['modal_titulo'=>'Erro', 'modal_body'=>'Não encontrado'];

    $msg = gerar_mensagem_template($pdo, $c['usuario'], $c['senha'], $c['Vencimento']);

    $html = '<textarea class="form-control" rows="12" readonly style="font-family:monospace;">'.$msg.'</textarea>';
    $ft = '<button class="btn btn-secondary" data-bs-dismiss="modal">Fechar</button>
           <button class="btn btn-primary" onclick="navigator.clipboard.writeText(`'.$msg.'`);alert(\'Copiado!\')">Copiar</button>
           <a href="https://wa.me/?text='.urlencode($msg).'" target="_blank" class="btn btn-success">WhatsApp</a>';
    return ['modal_titulo'=>'Dados do Cliente', 'modal_body'=>$html, 'modal_footer'=>$ft];
}

// --- RENOVAR (COM MENSAGEM CURTA) ---
function renovar_cliente($id) {
    $pdo = conectar_bd();
    $stmt = $pdo->prepare("SELECT usuario FROM clientes WHERE id = ?");
    $stmt->execute([$id]);
    $c = $stmt->fetch();
    
    $confianca_ativa = 0;
    try {
        $stmt_cfg = $pdo->query("SELECT confianca_ativo FROM admin WHERE admin = 1 LIMIT 1");
        $res = $stmt_cfg->fetch();
        $confianca_ativa = $res['confianca_ativo'] ?? 0;
    } catch(Exception $e) {}

    $html = '
    <form id="formRen">
        <input type="hidden" name="confirme_renovar_cliente" value="'.$id.'">
        <p>Cliente: <strong>'.$c['usuario'].'</strong></p>
        <label>Quantos meses?</label>
        <input type="number" name="meses" value="1" min="1" class="form-control">
        <p class="text-muted mt-2 small">Consumirá créditos.</p>
    </form>
    <form id="formConfianca" style="display:none;"><input type="hidden" name="confirme_renovar_confianca" value="'.$id.'"></form>';
    
    $ft = '<button class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>';
    $ft .= '<button class="btn btn-success" onclick="enviarFormulario(\'formRen\', \'api/clientes.php\')">Renovar</button>';
    if ($confianca_ativa == 1) {
        $ft .= '<button class="btn btn-outline-info ms-2" onclick="enviarFormulario(\'formConfianca\', \'api/clientes.php\')"><i class="fas fa-handshake"></i> Confiança</button>';
    }
    return ['modal_titulo'=>'Renovar Cliente', 'modal_body'=>$html, 'modal_footer'=>$ft];
}

function confirme_renovar_cliente($p) {
    $pdo = conectar_bd();
    $id = $p['confirme_renovar_cliente'];
    $meses = $p['meses'];
    $admin_id = $_SESSION['admin_id'];
    
    try {
        $pdo->beginTransaction();

        // 1. Verifica saldo
        $stmt = $pdo->prepare("SELECT admin, creditos FROM admin WHERE id = ?");
        $stmt->execute([$admin_id]);
        $u = $stmt->fetch();
        
        $eh_revenda = ($u['admin'] != 1);
        if ($eh_revenda && $u['creditos'] < $meses) {
            return ['title'=>'Sem Crédito', 'msg'=>'Créditos insuficientes.', 'icon'=>'error'];
        }

        // 2. Pega vencimento atual
        $c = $pdo->query("SELECT Vencimento, usuario, senha FROM clientes WHERE id=$id")->fetch();
        $base = (strtotime($c['Vencimento']) > time()) ? $c['Vencimento'] : date('Y-m-d H:i:s');
        $novo = date('Y-m-d 23:59:59', strtotime("+$meses month", strtotime($base)));
        
        // 3. Renova
        $pdo->prepare("UPDATE clientes SET Vencimento = ?, data_renovacao_confianca = NULL WHERE id = ?")->execute([$novo, $id]);
        
        // 4. Debita e Loga (SE FOR REVENDA)
        if ($eh_revenda) {
            $pdo->prepare("UPDATE admin SET creditos = creditos - ? WHERE id = ?")->execute([$meses, $admin_id]);
            $pdo->prepare("INSERT INTO credits_log (admin_id, target_id, amount, reason, date) VALUES (?, ?, ?, ?, ?)")
                ->execute([$admin_id, $admin_id, -$meses, "Renovou: {$c['usuario']} (+{$meses}m)", time()]);
        }

        $pdo->commit();

        // 5. GERA MENSAGEM CURTA E ESPECÍFICA
        $venc_formatado = date('d/m/Y', strtotime($novo));
        
        $msg_personalizada = "Plano renovado com sucesso!\n\n";
        $msg_personalizada .= "👤 Usuário: " . $c['usuario'] . "\n";
        $msg_personalizada .= "🔑 Senha: " . $c['senha'] . "\n";
        $msg_personalizada .= "📅 Próximo vencimento: " . $venc_formatado;
        
        return [
            'title'=>'Renovado!', 
            'msg'=>"Vencimento: ".date('d/m/Y', strtotime($novo)), 
            'icon'=>'success', 
            'data_table'=>'atualizar',
            'dados_cliente_msg' => $msg_personalizada
        ];

    } catch (Exception $e) {
        $pdo->rollBack();
        return ['title'=>'Erro', 'msg'=>$e->getMessage(), 'icon'=>'error'];
    }
}

function confirme_renovar_confianca($p) {
    $pdo = conectar_bd();
    $id = $p['confirme_renovar_confianca'];
    try {
        $stmt_cfg = $pdo->query("SELECT confianca_dias FROM admin WHERE admin = 1 LIMIT 1");
        $cfg = $stmt_cfg->fetch();
        $dias = $cfg['confianca_dias'] ?? 2;
        
        $c = $pdo->query("SELECT Vencimento, data_renovacao_confianca FROM clientes WHERE id=$id")->fetch();
        if ($c['data_renovacao_confianca'] != null) {
            return ['title'=>'Atenção', 'msg'=>'Confiança já usada!', 'icon'=>'warning'];
        }
        
        $base = (strtotime($c['Vencimento']) > time()) ? $c['Vencimento'] : date('Y-m-d H:i:s');
        $novo = date('Y-m-d 23:59:59', strtotime("+$dias days", strtotime($base)));
        
        $pdo->prepare("UPDATE clientes SET Vencimento = ?, data_renovacao_confianca = NOW() WHERE id = ?")->execute([$novo, $id]);
        return ['title'=>'Sucesso!', 'msg'=>"Renovado por $dias dias (Confiança).", 'icon'=>'success', 'data_table'=>'atualizar'];
    } catch (Exception $e) { return ['title'=>'Erro', 'msg'=>$e->getMessage(), 'icon'=>'error']; }
}

// --- BLOQUEAR ---
function toggle_bloqueio_cliente($id) {
    $html = "<form id='formLock'><input type='hidden' name='confirme_toggle_bloqueio_cliente' value='$id'>Alterar status?</form>";
    $ft = '<button class="btn btn-secondary" data-bs-dismiss="modal">Não</button> <button class="btn btn-warning" onclick="enviarFormulario(\'formLock\', \'api/clientes.php\')">Sim</button>';
    return ['modal_titulo'=>'Bloqueio', 'modal_body'=>$html, 'modal_footer'=>$ft];
}

function confirme_toggle_bloqueio_cliente($p) {
    $pdo = conectar_bd();
    $id = $p['confirme_toggle_bloqueio_cliente'];
    $pdo->prepare("UPDATE clientes SET is_banned = NOT is_banned WHERE id = ?")->execute([$id]);
    return ['title'=>'Sucesso', 'msg'=>'Status alterado', 'icon'=>'success', 'data_table'=>'atualizar'];
}

// --- EXCLUIR ---
function delete_cliente($id) {
    $html = "<form id='formDel'><input type='hidden' name='confirme_delete_cliente' value='$id'>Excluir cliente?</form>";
    $ft = '<button class="btn btn-secondary" data-bs-dismiss="modal">Não</button> <button class="btn btn-danger" onclick="enviarFormulario(\'formDel\', \'api/clientes.php\')">Sim, Excluir</button>';
    return ['modal_titulo'=>'Excluir', 'modal_body'=>$html, 'modal_footer'=>$ft];
}

function confirme_delete_cliente($p) {
    $pdo = conectar_bd();
    $id = is_array($p) ? $p['confirme_delete_cliente'] : $p;
    $pdo->prepare("DELETE FROM clientes WHERE id = ?")->execute([$id]);
    return ['title'=>'Deletado', 'msg'=>'Cliente removido.', 'icon'=>'success', 'data_table'=>'atualizar'];
}
?>