<?php
// Arquivo: /api/controles/funcoes_testes.php
// VERSO FINAL - CORRIGIDA E BLINDADA

function encurtar_url($long_url) {
    if (empty($long_url) || !filter_var($long_url, FILTER_VALIDATE_URL)) return $long_url;
    $api = 'https://is.gd/create.php?format=simple&url=' . urlencode($long_url);
    $ret = @file_get_contents($api);
    return ($ret && filter_var($ret, FILTER_VALIDATE_URL)) ? trim($ret) : $long_url;
}

function obter_url_load_balance_ou_padrao($conexao) {
    $padrao = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http") . "://" . $_SERVER['HTTP_HOST'];
    try {
        $stmt = $conexao->prepare("SELECT server_ip, server_port FROM servers WHERE status = 1 LIMIT 1");
        $stmt->execute();
        if ($s = $stmt->fetch(PDO::FETCH_ASSOC)) {
            $url = rtrim($s['server_ip'], '/');
            $port = $s['server_port'];
            if (strpos($url, 'http') !== 0) $url = ($port == 443 ? 'https://' : 'http://') . $url;
            if (!empty($port) && $port != 80 && $port != 443) $url .= ':' . $port;
            return $url;
        }
    } catch (Exception $e) {}
    return $padrao;
}

function buscar_template_mensagem() {
    $caminhos = [
        $_SERVER['DOCUMENT_ROOT'] . '/template_mensagem.txt',
        '../template_mensagem.txt',
        '../../template_mensagem.txt'
    ];
    
    foreach ($caminhos as $arq) {
        if (file_exists($arq)) {
            $conteudo = file_get_contents($arq);
            if ($conteudo) return mb_convert_encoding($conteudo, 'UTF-8', 'auto');
        }
    }
    return "? *TESTE* ?\n\n?? *Usurio:* #username#\n?? *Senha:* #password#\n?? *Vencimento:* #exp_date#\n\n?? *URL:* #url#";
}

function gerar_mensagem_template($pdo, $user, $pass, $vencimento) {
    $url = obter_url_load_balance_ou_padrao($pdo);
    $url = rtrim($url, '/'); 
    $exp_format = date('d/m/Y H:i', strtotime($vencimento));
    
    $template = buscar_template_mensagem();

    $replacements = [
        '#username#' => $user, 
        '#password#' => $pass, 
        '#url#' => $url, 
        '#exp_date#' => $exp_format,
        '#m3u_link#' => "$url/get.php?username=$user&password=$pass&type=m3u_plus&output=ts",
        '#m3u_link_hls#' => "$url/get.php?username=$user&password=$pass&type=m3u_plus&output=m3u8",
        '#m3u_encurtado#' => "$url/m3u-ts/$user/$pass",
        '#m3u_hls_encurtado#' => "$url/m3u-m3u8/$user/$pass",
        '#ssiptv_encurtado#' => "$url/ssiptv/$user/$pass"
    ];
    return str_replace(array_keys($replacements), array_values($replacements), $template);
}

// ========================================================
// 1. LISTAGEM DE TESTES
// ========================================================
function listar_testes($req) {
    try {
        $pdo = conectar_bd();
        $id_logado = $_SESSION['admin_id'];
        $stmt = $pdo->prepare("SELECT admin FROM admin WHERE id = ?");
        $stmt->execute([$id_logado]);
        $u = $stmt->fetch();
        $is_dono = ($u && $u['admin'] == 1);

        $condicoes = ["is_trial = 1", "is_p2p = 0"];
        $params = [];

        if (!$is_dono) {
            $condicoes[] = "admin_id = :meu_id";
            $params[':meu_id'] = $id_logado;
        }

        if ($is_dono && !empty($req['filtro_revenda']) && $req['filtro_revenda'] !== 'todos') {
            $condicoes[] = "admin_id = :filtro_id";
            $params[':filtro_id'] = $req['filtro_revenda'];
        }

        $sql_search = "";
        $params_search = [];
        if (!empty($req['search']['value'])) {
            $termo = "%" . $req['search']['value'] . "%";
            $sql_search = " AND (name LIKE :s1 OR usuario LIKE :s2) ";
            $params_search[':s1'] = $termo;
            $params_search[':s2'] = $termo;
        }

        $sql_where = " WHERE " . implode(" AND ", $condicoes);

        $stmt_total = $pdo->prepare("SELECT COUNT(id) FROM clientes " . $sql_where);
        $stmt_total->execute($params);
        $total_records = $stmt_total->fetchColumn();

        $stmt_filt = $pdo->prepare("SELECT COUNT(id) FROM clientes " . $sql_where . $sql_search);
        $stmt_filt->execute(array_merge($params, $params_search));
        $total_filtered = $stmt_filt->fetchColumn();

        $ordem = $req['order'][0]['dir'] ?? 'desc';
        $limit = $req['length'] ?? 10;
        $offset = $req['start'] ?? 0;

        $sql = "SELECT * FROM clientes " . $sql_where . $sql_search . " ORDER BY id $ordem LIMIT $limit OFFSET $offset";
        $stmt = $pdo->prepare($sql);
        $stmt->execute(array_merge($params, $params_search));

        $data = [];
        while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
            $id = $row['id'];
            if ($row['is_banned'] == 1) $st = '<span class="badge bg-danger">Bloqueado</span>';
            elseif (strtotime($row['Vencimento']) < time()) $st = '<span class="badge bg-warning text-dark">Expirado</span>';
            else $st = '<span class="badge bg-success">Ativo</span>';

            $btns = "<div class='btn-group'>";
            $btns .= "<button class='btn btn-sm btn-info' onclick='modal_master(\"api/testes.php\", \"info_teste\", \"$id\")' title='Info'><i class='fas fa-eye'></i></button>";
            $btns .= "<button class='btn btn-sm btn-success' onclick='modal_master(\"api/testes.php\", \"converter_teste\", \"$id\")' title='Converter'><i class='fas fa-check'></i></button>";
            $btns .= "<button class='btn btn-sm btn-danger' onclick='modal_master(\"api/testes.php\", \"delete_teste\", \"$id\")' title='Excluir'><i class='fas fa-trash-alt'></i></button>";
            $btns .= "</div>";

            $data[] = ["id"=>$id, "name"=>$row['name'], "usuario"=>$row['usuario'], "status"=>$st, "vencimento"=>date('d/m/Y H:i', strtotime($row['Vencimento'])), "acao"=>$btns];
        }
        return ["draw"=>intval($req['draw']), "recordsTotal"=>$total_records, "recordsFiltered"=>$total_filtered, "data"=>$data];
    } catch (Exception $e) { return ["data"=>[], "error"=>$e->getMessage()]; }
}

// ========================================================
// 2. MODAIS E AES
// ========================================================

function adicionar_testes() {
    try {
        $pdo = conectar_bd();
        $stmt = $pdo->query("SELECT id, bouquet_name FROM bouquets ORDER BY bouquet_name");
        $opt_b = "<option value='' disabled selected>Selecione...</option>";
        while($r = $stmt->fetch()) $opt_b .= "<option value='{$r['id']}'>{$r['bouquet_name']}</option>";

        $html = '
        <form id="formAddTeste">
            <input type="hidden" name="confirme_adicionar_testes" value="1">
            <div class="row">
                <div class="col-12 mb-3 text-end">
                    <button type="button" class="btn btn-sm btn-outline-info" onclick="gerarDadosAcesso()">
                        <i class="fas fa-magic"></i> Gerar Automtico
                    </button>
                </div>
                <div class="col-6 mb-2"><label>Nome</label><input type="text" name="name" class="form-control" required></div>
                <div class="col-6 mb-2"><label>WhatsApp</label><input type="text" name="WhatsApp" class="form-control"></div>
                <div class="col-6 mb-2"><label>Usurio</label><input type="text" name="usuario" class="form-control" required></div>
                <div class="col-6 mb-2"><label>Senha</label><input type="text" name="senha" class="form-control" required></div>
                <div class="col-6 mb-2"><label>Durao (Horas)</label><input type="number" name="horas" value="3" class="form-control"></div>
                <div class="col-6 mb-2"><label>Pacote</label><select name="bouquet_id" class="form-select" required>'.$opt_b.'</select></div>
            </div>
        </form>';
        $ft = '<button class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button> <button class="btn btn-primary" onclick="enviarFormulario(\'formAddTeste\', \'api/testes.php\')">Salvar</button>';
        return ['modal_titulo'=>'Novo Teste', 'modal_body'=>$html, 'modal_footer'=>$ft];
    } catch (Exception $e) {
        return ['modal_titulo'=>'Erro', 'modal_body'=>'Erro Interno: ' . $e->getMessage()];
    }
}

function confirme_adicionar_testes($p) {
    try {
        $pdo = conectar_bd();
        $horas = $p['horas'] ?? 3;
        $venc = date('Y-m-d 23:59:59', strtotime("+$horas hours"));
        
        $sql = "INSERT INTO clientes (admin_id, name, usuario, senha, WhatsApp, bouquet_id, plano, Vencimento, conexoes, Criado_em, is_trial, is_p2p) 
                VALUES (?,?,?,?,?,?,?,?,1,NOW(),1,0)";
        
        $pdo->prepare($sql)->execute([
            $_SESSION['admin_id'], 
            $p['name'], 
            $p['usuario'], 
            $p['senha'], 
            $p['WhatsApp'], 
            $p['bouquet_id'], 
            $p['bouquet_id'], 
            $venc
        ]);
        
        $msg_cliente = gerar_mensagem_template($pdo, $p['usuario'], $p['senha'], $venc);
        
        return ['title'=>'Sucesso', 'msg'=>'Teste criado!', 'icon'=>'success', 'data_table'=>'atualizar', 'dados_cliente_msg' => $msg_cliente];
    } catch(Exception $e) { return ['title'=>'Erro', 'msg'=>$e->getMessage(), 'icon'=>'error']; }
}

function converter_teste($id) {
    $html = "<form id='formConv'><input type='hidden' name='confirme_converter_teste' value='$id'>Deseja transformar este teste em cliente oficial (1 crdito)?</form>";
    $ft = '<button class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button> <button class="btn btn-success" onclick="enviarFormulario(\'formConv\', \'api/testes.php\')">Converter</button>';
    return ['modal_titulo'=>'Converter', 'modal_body'=>$html, 'modal_footer'=>$ft];
}

function confirme_converter_teste($p) {
    $pdo = conectar_bd();
    $id = is_array($p) ? $p['confirme_converter_teste'] : $p;
    $novo_venc = date('Y-m-d 23:59:59', strtotime("+1 month"));
    
    try {
        $adm_id = $_SESSION['admin_id'];
        $stmt = $pdo->prepare("SELECT admin, creditos FROM admin WHERE id = ?");
        $stmt->execute([$adm_id]);
        $u = $stmt->fetch();
        
        if ($u['admin'] != 1 && $u['creditos'] < 1) {
            return ['title'=>'Sem Crdito', 'msg'=>'Voc no tem crditos suficientes.', 'icon'=>'error'];
        }
        
        if ($u['admin'] != 1) {
            $pdo->prepare("UPDATE admin SET creditos = creditos - 1 WHERE id = ?")->execute([$adm_id]);
        }
        
        $pdo->prepare("UPDATE clientes SET is_trial = 0, Vencimento = ? WHERE id = ?")->execute([$novo_venc, $id]);
        
        return [
            'title'=>'Convertido!', 
            'msg'=>'Agora  um cliente. Redirecionando...', 
            'icon'=>'success', 
            'data_table'=>'atualizar',
            'redirect_url' => 'clientes.php'
        ];
        
    } catch (Exception $e) {
        return ['title'=>'Erro', 'msg'=>$e->getMessage(), 'icon'=>'error'];
    }
}

function info_teste($id) {
    $pdo = conectar_bd();
    $stmt = $pdo->prepare("SELECT * FROM clientes WHERE id = ?");
    $stmt->execute([$id]);
    $c = $stmt->fetch(PDO::FETCH_ASSOC);
    if(!$c) return ['modal_titulo'=>'Erro', 'modal_body'=>'No encontrado'];

    $msg = gerar_mensagem_template($pdo, $c['usuario'], $c['senha'], $c['Vencimento']);

    $html = '<textarea class="form-control" rows="10" readonly style="font-family:monospace;">'.$msg.'</textarea>';
    $ft = '<button class="btn btn-secondary" data-bs-dismiss="modal">Fechar</button>
           <button class="btn btn-primary" onclick="navigator.clipboard.writeText(`'.$msg.'`);alert(\'Copiado!\')">Copiar</button>
           <a href="https://wa.me/?text='.urlencode($msg).'" target="_blank" class="btn btn-success">WhatsApp</a>';
    return ['modal_titulo'=>'Dados do Teste', 'modal_body'=>$html, 'modal_footer'=>$ft];
}

function delete_teste($id) {
    $html = "<form id='formDel'><input type='hidden' name='confirme_delete_teste' value='$id'>Excluir teste?</form>";
    $ft = '<button class="btn btn-secondary" data-bs-dismiss="modal">No</button> <button class="btn btn-danger" onclick="enviarFormulario(\'formDel\', \'api/testes.php\')">Sim, Excluir</button>';
    return ['modal_titulo'=>'Excluir', 'modal_body'=>$html, 'modal_footer'=>$ft];
}

function confirme_delete_teste($p) {
    $pdo = conectar_bd();
    $id = is_array($p) ? $p['confirme_delete_teste'] : $p;
    $pdo->prepare("DELETE FROM clientes WHERE id = ?")->execute([$id]);
    return ['title'=>'Deletado', 'msg'=>'Teste removido.', 'icon'=>'success', 'data_table'=>'atualizar'];
}

// ========================================================
// 3. FUNO: GERAR TESTE RPIDO (AUTOMTICO - INTERNO)
// ========================================================
function gerar_teste_rapido($p) {
    try {
        $pdo = conectar_bd();
        
        $tempo_horas = 3; 
        $prefixo = "teste"; 
        
        $rand = rand(1000, 9999);
        $usuario = $prefixo . $rand;
        $senha = "t" . $rand;
        $vencimento = date('Y-m-d H:i:s', strtotime("+$tempo_horas hours"));

        $stmt = $pdo->query("SELECT id FROM bouquets LIMIT 1");
        $pacote = $stmt->fetch(PDO::FETCH_ASSOC);
        
        if (!$pacote) {
            return ['title'=>'Erro', 'msg'=>'Nenhum pacote de canais cadastrado!', 'icon'=>'error'];
        }
        $bouquet_id = $pacote['id'];

        $admin_id = $_SESSION['admin_id'];
        
        $sql = "INSERT INTO clientes (admin_id, name, usuario, senha, WhatsApp, bouquet_id, plano, Vencimento, conexoes, Criado_em, is_trial, is_p2p) 
                VALUES (?, ?, ?, ?, '', ?, ?, ?, 1, NOW(), 1, 0)";
        
        $pdo->prepare($sql)->execute([
            $admin_id, 
            $usuario, 
            $usuario, 
            $senha, 
            $bouquet_id, 
            $bouquet_id, 
            $vencimento
        ]);

        $msg = gerar_mensagem_template($pdo, $usuario, $senha, $vencimento);

        $html = '<div class="alert alert-success text-center">Teste Criado com Sucesso!</div>';
        $html .= '<textarea class="form-control" rows="10" readonly style="font-family:monospace;">'.$msg.'</textarea>';
        
        $ft = '<button class="btn btn-secondary" data-bs-dismiss="modal">Fechar</button>
               <button class="btn btn-primary" onclick="navigator.clipboard.writeText(`'.$msg.'`);alert(\'Copiado!\')">Copiar</button>
               <a href="https://wa.me/?text='.urlencode($msg).'" target="_blank" class="btn btn-success">WhatsApp</a>';

        return ['modal_titulo'=>'Teste Rpido Gerado', 'modal_body'=>$html, 'modal_footer'=>$ft, 'data_table'=>'atualizar'];

    } catch (Exception $e) {
        return ['title'=>'Erro', 'msg'=>$e->getMessage(), 'icon'=>'error'];
    }
}
?>