<?php
set_time_limit(0);
require_once('db.php');
session_start();

// Bloco principal de tratamento de requisição
header('Content-Type: application/json');

// ===================================================================================
// MUDANÇA: Verificação de cURL antes de qualquer outra coisa
// ===================================================================================
if (!function_exists('curl_init')) {
    http_response_code(500); // Erro de servidor
    echo json_encode(['error' => 'A extensão cURL do PHP não está instalada ou ativada no servidor. É necessária para a busca no TMDB.']);
    exit; // Para a execução imediatamente
}

$TMDB_API_KEY = 'f99aa9ae1fe7619969cc7db0938c1ae5'; // <-- 🚨 COLOQUE SUA CHAVE AQUI!

function limparTituloParaBusca($title) {
    $title = preg_replace('/(\[.*?\]|\(.*?\))/i', '', $title);
    $title = preg_replace('/\b(dublado|legendado|nacional|hd|fhd|sd|4k|1080p|720p)\b/i', '', $title);
    $title = preg_replace('/[sS]\d{1,3}[eE]\d{1,4}.*/i', '', $title);
    $title = str_replace(['-', '_', '.'], ' ', $title);
    return trim($title);
}

function searchTmdb($title, $type) {
    global $TMDB_API_KEY;
    if (empty($TMDB_API_KEY) || $TMDB_API_KEY === 'SUA_CHAVE_DE_API_DO_TMDB_VAI_AQUI') return null;
    $cleanTitle = limparTituloParaBusca($title);
    if (empty($cleanTitle)) return null;

    $searchType = ($type === 'live' || $type === 'series') ? 'tv' : 'movie';
    $query = urlencode($cleanTitle);
    $url = "https://api.themoviedb.org/3/search/{$searchType}?api_key={$TMDB_API_KEY}&query={$query}&language=pt-BR";
    
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 10);
    $response = curl_exec($ch);
    $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    
    if ($http_code !== 200) return null;
    
    $data = json_decode($response, true);
    return $data['results'][0] ?? null;
}

function executarConsulta($conexao, $query, $parametros) {
    $stmt = $conexao->prepare($query);
    $stmt->execute($parametros);
    return $stmt;
}

function verificarLinksExistentes($conexao, $urls) {
    $tabelas = ['series_episodes', 'streams'];
    if (empty($urls)) return [];
    $resultss = [];
    $placeholders = implode(',', array_fill(0, count($urls), '?'));
    foreach ($tabelas as $tabela) {
        $stmt = $conexao->prepare("SELECT link FROM $tabela WHERE link IN ($placeholders)");
        $stmt->execute($urls);
        $resultss = array_merge($resultss, $stmt->fetchAll(PDO::FETCH_COLUMN, 0));
    }
    return array_unique($resultss);
}

function adicionarItensProcessados($items, $useTmdb) {
    $conexao = conectar_bd();
    $results = ['success' => [], 'exists' => 0, 'error' => [], 'urls' => 0, 'movie' => 0, 'live' => 0, 'series' => 0, 'episodios' => 0, 'temporadas' => 0];
    if (empty($items)) return $results;

    $conexao->beginTransaction();
    if (!isset($_SESSION['cache'])) $_SESSION['cache'] = [];

    try {
        $urls = array_column($items, 'url');
        $linksExistentes = verificarLinksExistentes($conexao, $urls);

        foreach ($items as $item) {
            $url = trim($item['url'] ?? '');
            if (empty($url) || in_array($url, $linksExistentes)) {
                if(!empty($url)) $results['exists']++;
                continue;
            }
            $results['urls']++;
            $groupTitle = trim($item['groupTitle'] ?? '');
            $channelName = trim($item['channelName'] ?? '');
            $tvgLogo = trim($item['tvgLogo'] ?? '');
            $type = null;
            $series_matches = [];
            if (preg_match('/^(.*?)(?:\s?|-|\.)[sStT]?(\d{1,2})[eExX\s.-](\d{1,3})/i', $channelName, $series_matches)) {
                $type = 'series';
            } else {
                $type = (preg_match('/\/live\b/i', $url)) ? 'live' : ((preg_match('/\/series\b/i', $url)) ? 'series' : ((preg_match('/\/movie\b/i', $url)) ? 'movie' : null));
                if(is_null($type)) $type = (preg_match('/\b(canais|tv)\b/i', $groupTitle)) ? 'live' : ((preg_match('/\b(series)\b/i', $groupTitle)) ? 'series' : 'movie');
            }
            $categoryId = null;
            if (!empty($groupTitle)) {
                if (!isset($_SESSION['cache'][$groupTitle])) {
                    $categoria = executarConsulta($conexao, "SELECT id FROM categoria WHERE nome = :nome", ['nome' => $groupTitle])->fetch(PDO::FETCH_ASSOC);
                    if ($categoria) {
                        $categoryId = $categoria['id'];
                    } else {
                        executarConsulta($conexao, "INSERT INTO categoria (nome, type, admin_id) VALUES (:nome, :type, :admin_id)", ['nome' => $groupTitle, 'admin_id' => $_SESSION['admin_id'] ?? 1, 'type' => $type]);
                        $categoryId = $conexao->lastInsertId();
                    }
                    $_SESSION['cache'][$groupTitle] = ['category_id' => $categoryId, 'series' => []];
                } else {
                    $categoryId = $_SESSION['cache'][$groupTitle]['category_id'];
                }
            }
            if (is_null($categoryId)) continue;
            $nomeFinal = $channelName; $capaFinal = $tvgLogo; $plotFinal = ''; $tmdb_id = null; $rating = null; $release_date = null;
            if ($useTmdb && ($type === 'movie' || $type === 'series')) {
                $tmdbData = searchTmdb($channelName, $type);
                if ($tmdbData) {
                    $nomeFinal = $tmdbData['title'] ?? $tmdbData['name'] ?? $channelName;
                    if (!empty($tmdbData['poster_path'])) $capaFinal = 'https://image.tmdb.org/t/p/w500' . $tmdbData['poster_path'];
                    $plotFinal = $tmdbData['overview'] ?? '';
                    $tmdb_id = $tmdbData['id'] ?? null;
                    $rating = $tmdbData['vote_average'] ?? null;
                    $release_date = $tmdbData['release_date'] ?? $tmdbData['first_air_date'] ?? null;
                } else {
                    $results['error'][] = ['name' => $channelName, 'reason' => 'Não encontrado no TMDB'];
                }
            }
            if ($type === 'series') {
                $nomeSerie = trim($series_matches[1]);
                $temporada = (int) $series_matches[2];
                $episodioNum = (int) $series_matches[3];
                if ($useTmdb && isset($tmdbData)) $nomeSerie = $tmdbData['name'] ?? $nomeSerie;
                if (!isset($_SESSION['cache'][$groupTitle]['series'][$nomeSerie])) {
                    $serieExistente = executarConsulta($conexao, "SELECT id FROM series WHERE name = :name AND category_id = :category_id", ['name' => $nomeSerie, 'category_id' => $categoryId])->fetch(PDO::FETCH_ASSOC);
                    if ($serieExistente) {
                        $series_id = $serieExistente['id'];
                    } else {
                        executarConsulta($conexao, "INSERT INTO series (name, category_id, cover, plot, tmdb_id, rating, release_date) VALUES (:name, :category_id, :cover, :plot, :tmdb_id, :rating, :release_date)", ['name' => $nomeSerie, 'category_id' => $categoryId, 'cover' => $capaFinal, 'plot' => $plotFinal, 'tmdb_id' => $tmdb_id, 'rating' => $rating, 'release_date' => $release_date]);
                        $series_id = $conexao->lastInsertId(); $results['series']++;
                    }
                    $_SESSION['cache'][$groupTitle]['series'][$nomeSerie] = ['series_id' => $series_id, 'seasons' => []];
                } else { $series_id = $_SESSION['cache'][$groupTitle]['series'][$nomeSerie]['series_id']; }
                if (!in_array($temporada, $_SESSION['cache'][$groupTitle]['series'][$nomeSerie]['seasons'])) {
                    if (!executarConsulta($conexao, "SELECT 1 FROM series_seasons WHERE series_id = :series_id AND season_number = :season_number", ['series_id' => $series_id, 'season_number' => $temporada])->fetch()) {
                        executarConsulta($conexao, "INSERT INTO series_seasons (series_id, season_number, name) VALUES (:series_id, :season_number, :name)", ['series_id' => $series_id, 'season_number' => $temporada, 'name' => 'Temporada ' . $temporada]);
                        $results['temporadas']++;
                    }
                    $_SESSION['cache'][$groupTitle]['series'][$nomeSerie]['seasons'][] = $temporada;
                }
                executarConsulta($conexao, "INSERT INTO series_episodes (link, series_id, season, episode_num, title, container_extension, movie_image, category_id, plot) VALUES (:link, :series_id, :season, :episode_num, :title, 'ts', :movie_image, :category_id, :plot)", ['link' => $url, 'series_id' => $series_id, 'season' => $temporada, 'episode_num' => $episodioNum, 'title' => $channelName, 'movie_image' => $capaFinal, 'category_id' => $categoryId, 'plot' => '']);
                $results['episodios']++;
                $results['success'][] = ['name' => $channelName, 'type' => 'Episódio'];
            } elseif ($type === 'live' || $type === 'movie') {
                executarConsulta($conexao, "INSERT INTO streams (link, category_id, name, plot, stream_type, container_extension, stream_icon) VALUES (:link, :category_id, :name, :plot, :stream_type, 'ts', :stream_icon)", ['link' => $url, 'category_id' => $categoryId, 'name' => $nomeFinal, 'plot' => $plotFinal, 'stream_type' => $type, 'stream_icon' => $capaFinal]);
                $results[$type]++;
                $results['success'][] = ['name' => $nomeFinal, 'type' => ucfirst($type)];
            }
        }
        $conexao->commit();
    } catch (Exception $e) {
        $conexao->rollBack();
        $results['error'][] = ['name' => 'Erro de Transação', 'reason' => $e->getMessage()];
    }
    return $results;
}

function adicionarepg($links) {
    // Sua função de EPG
    // ...
}

// Bloco principal de tratamento de requisição
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['epg'])) { /* ...código epg... */ exit; }
    
    $json_input = file_get_contents('php://input');
    $data = json_decode($json_input, true);
    if ($data && isset($data['items'])) {
        try {
            $items = $data['items'] ?? [];
            $useTmdb = $data['use_tmdb'] ?? false;
            echo json_encode(['results' => adicionarItensProcessados($items, $useTmdb)]);
        } catch (Exception $e) { http_response_code(500); echo json_encode(['error' => $e->getMessage()]); }
    } else { http_response_code(400); echo json_encode(['error' => 'Formato de requisição inválido.']); }
} else { http_response_code(405); echo json_encode(['error' => 'Método não permitido.']); }
?>