<?php
set_time_limit(0);
ini_set('memory_limit', '512M');
ini_set('display_errors', 0); // Desativa a exibição de erros para não quebrar o JSON
error_reporting(0); // Desativa a exibição de erros

require_once('db.php');
session_start();

$tmdb_api_key = "f99aa9ae1fe7619969cc7db0938c1ae5"; // <---!! API KEY INSERIDA !!

function executarConsulta($conexao, $query, $parametros) {
    $stmt = $conexao->prepare($query);
    $stmt->execute($parametros);
    return $stmt;
}

function getTmdbInfo($title, $type, $apiKey) {
    global $tmdb_logs; 
    
    if (empty($apiKey) || $apiKey == "SUA_API_KEY_AQUI") {
        $tmdb_logs[] = "[AVISO] TMDB pulado: API Key não configurada.";
        return null;
    }

    $year = null;
    $cleanTitle = $title; 

    if (preg_match('/(?:[\s._-]|–|—)?\s*\((\d{4})\)\s*$/', $title, $matches)) {
        $year = $matches[1];
        $cleanTitle = trim(preg_replace('/(?:[\s._-]|–|—)?\s*\((\d{4})\)\s*$/', '', $title));
    }

    $searchType = ($type == 'movie') ? 'movie' : 'tv';
    $url = "https://api.themoviedb.org/3/search/{$searchType}?api_key={$apiKey}&query=" . urlencode($cleanTitle) . "&language=pt-BR";
    if ($year) {
        $url .= "&year=" . $year;
    }

    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 10); 
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false); 
    $response = curl_exec($ch);
    $curl_error = curl_error($ch); 
    curl_close($ch);

    if ($curl_error) {
        $tmdb_logs[] = "[ERRO cURL Search] '{$cleanTitle}': {$curl_error}";
        return null;
    }

    $data = json_decode($response, true);

    if (isset($data['results']) && !empty($data['results'])) {
        $result = $data['results'][0]; // Pega o primeiro resultado

        $tmdbData = [
            'tmdb_id' => $result['id'] ?? null,
            'plot' => $result['overview'] ?? null,
            'cover' => $result['poster_path'] ? "https://image.tmdb.org/t/p/w500" . $result['poster_path'] : null,
            'cover_big' => $result['poster_path'] ? "https://image.tmdb.org/t/p/original" . $result['poster_path'] : null,
            'backdrop_path' => $result['backdrop_path'] ? "https://image.tmdb.org/t/p/w1280" . $result['backdrop_path'] : null,
            'release_date' => $result['release_date'] ?? $result['first_air_date'] ?? null,
            'genre' => null, 
            'rating' => $result['vote_average'] ?? null,
            'director' => null,
            'cast' => null,
            'youtube_trailer' => null,
        ];
        
        return $tmdbData;
    }
    
    $tmdb_logs[] = "[INFO] TMDB: Nenhum resultado encontrado para '{$cleanTitle}' (Ano: {$year}).";
    return null;
}


function adicionarLinks_Otimizado($links, $conexao, $useTmdb, $apiKey) {
    
    global $tmdb_logs; 
    $tmdb_logs = []; 
    
    $admin_id = $_SESSION['admin_id'] ?? 1; 

    $results = [
        'urls' => 0, 'movie' => 0, 'live' => 0, 'series' => 0, 'episodios' => 0,
        'temporadas' => 0, 'exists' => 0, 'error' => [],
        'importedItems' => [] 
    ];

    $urlsParaVerificar = array_column($links, 'url');
    if (empty($urlsParaVerificar)) return $results;

    $placeholders = implode(',', array_fill(0, count($urlsParaVerificar), '?'));
    $queryLinks = "(SELECT link FROM streams WHERE link IN ($placeholders)) UNION (SELECT link FROM series_episodes WHERE link IN ($placeholders))";
    $stmtLinks = executarConsulta($conexao, $queryLinks, array_merge($urlsParaVerificar, $urlsParaVerificar));
    $linksExistentes = array_flip($stmtLinks->fetchAll(PDO::FETCH_COLUMN));

    $streamsParaInserir = [];
    $episodiosParaInserir = [];
    $temporadasParaInserir = [];
    $seriesParaInserir = []; 
    $seriesParaAtualizar = []; 

    foreach ($links as $link) {
        $url = trim($link['url'] ?? '');
        if (isset($linksExistentes[$url]) || empty($url)) {
            $results['exists']++;
            continue;
        }

        $groupTitle = trim($link['category'] ?? 'Sem Categoria');
        $channelName = trim($link['name'] ?? 'Sem Nome');
        $tvgLogo = trim($link['tvgLogo'] ?? '');
        $container = preg_match('/\.(mp4|mkv|ts|m3u8)$/i', $url, $ext) ? strtolower($ext[1]) : 'ts';
        $type = $link['type'] ?? 'movie'; 

        static $categoriasCache = [];
        $cacheKeyCat = $groupTitle . '_' . $type;
        if (!isset($categoriasCache[$cacheKeyCat])) {
            $stmtCat = executarConsulta($conexao, "SELECT id FROM categoria WHERE nome = ? AND type = ?", [$groupTitle, $type]);
            $categoria = $stmtCat->fetch(PDO::FETCH_ASSOC);
            if ($categoria) {
                $categoriasCache[$cacheKeyCat] = $categoria['id'];
            } else {
                executarConsulta($conexao, "INSERT INTO categoria (nome, type, admin_id) VALUES (?, ?, ?)", [$groupTitle, $type, $admin_id]);
                $categoriasCache[$cacheKeyCat] = $conexao->lastInsertId();
            }
        }
        $category_id = $categoriasCache[$cacheKeyCat];

        
        // 1. É um EPISÓDIO?
        if ($type === 'series' && preg_match('/^(.*?)(?:[\s._-]+)?(?:[Ss]|Temporada)[\s._-]?(\d{1,2})[\s._-]?(?:[EeXx]|Episodio|x)[\s._-]?(\d{1,3})/i', $channelName, $matches)) {
            $nomeSerie = trim($matches[1]);
            $temporada = (int)$matches[2];
            $episodioNum = (int)$matches[3];
            $series_id = null;

            static $seriesCache = [];
            $cacheKeySerie = $nomeSerie . '_' . $category_id;

            if (!isset($seriesCache[$cacheKeySerie])) {
                $stmtSerie = executarConsulta($conexao, "SELECT id FROM series WHERE name = ? AND category_id = ?", [$nomeSerie, $category_id]);
                $serie = $stmtSerie->fetch(PDO::FETCH_ASSOC);
                
                if ($serie) {
                    $series_id = $serie['id'];
                    $seriesCache[$cacheKeySerie] = ['id' => $series_id]; 
                } else {
                    $tmdbData = null;
                    if ($useTmdb) {
                        $tmdbData = getTmdbInfo($nomeSerie, 'series', $apiKey); 
                    }
                    
                    // ==================================================
                    //         CORREÇÃO SÉRIES (Data)
                    // ==================================================
                    // Se o TMDB não achar data, usa a data de HOJE
                    $release_date_final = $tmdbData['release_date'] ?? date('Y-m-d H:i:s');
                    // ==================================================

                    $seriesData = [
                        $nomeSerie, $category_id,
                        $tmdbData['cover'] ?? $tvgLogo,
                        $tmdbData['plot'] ?? null,
                        $tmdbData['cast'] ?? null, 
                        $tmdbData['director'] ?? null, 
                        $tmdbData['genre'] ?? null, 
                        $release_date_final, // <-- VARIÁVEL CORRIGIDA AQUI
                        $tmdbData['rating'] ?? null,
                        $tmdbData['backdrop_path'] ?? null,
                        $tmdbData['youtube_trailer'] ?? null, 
                        $tmdbData['tmdb_id'] ?? null
                    ];
                    
                    $seriesParaInserir[] = $seriesData;
                    
                    $series_id = "temp_" . count($seriesParaInserir); 
                    $seriesCache[$cacheKeySerie] = ['id' => $series_id];
                    
                    $results['series']++;
                    $results['importedItems'][] = $nomeSerie; 
                }
            } else {
                 $series_id = $seriesCache[$cacheKeySerie]['id'];
            }

            // Inserir Temporada
            static $seasonsCache = [];
            $cacheKeySeason = $series_id . '_' . $temporada;
            if (!isset($seasonsCache[$cacheKeySeason])) {
                $temporadasParaInserir[] = [$series_id, $temporada, 'Temporada ' . $temporada];
                $seasonsCache[$cacheKeySeason] = true;
                $results['temporadas']++;
            }
            
            $episodiosParaInserir[] = [
                $url, $series_id, $temporada, $episodioNum, 
                $channelName, // title
                $container,
                $tvgLogo, // movie_image
                $category_id,
                null, // plot
                null  // tmdb_id
            ];
            $results['episodios']++;
        
        // 2. É um CANAL?
        } elseif ($type === 'live') {
            
            $tmdbData = null; 

            $streamsParaInserir[] = [
                $url, $category_id, $channelName, $type, $container, 
                $tvgLogo, // stream_icon
                // date('Y-m-d H:i:s'), // 'added' é adicionado por NOW() na query
                null, null, null, null, null, null, null, null, null, null // Campos TMDB
            ];
            $results[$type]++;

        // 3. É um FILME?
        } elseif ($type === 'movie' || $type === 'series') {
            
            $tmdbData = null;
            if ($useTmdb) {
                $tmdbData = getTmdbInfo($channelName, 'movie', $apiKey); 
            }

            $streamsParaInserir[] = [
                $url, $category_id, $channelName, 
                'movie', 
                $container, 
                $tmdbData['cover'] ?? $tvgLogo, // stream_icon
                // date('Y-m-d H:i:s'), // 'added' é adicionado por NOW() na query
                $tmdbData['tmdb_id'] ?? null,
                $tmdbData['cover_big'] ?? null,
                $tmdbData['plot'] ?? null,
                $tmdbData['cast'] ?? null, 
                $tmdbData['director'] ?? null, 
                $tmdbData['genre'] ?? null, 
                $tmdbData['release_date'] ?? null,
                $tmdbData['rating'] ?? null,
                $tmdbData['youtube_trailer'] ?? null, 
                $tmdbData['backdrop_path'] ?? null
            ];
            
            $results['movie']++; 
            $results['importedItems'][] = $channelName; 
        }
        $results['urls']++;
    }

    // =======================================================================
    // EXECUÇÃO DOS INSERTS
    // =======================================================================

    // 1. Inserir Séries
    if (!empty($seriesParaInserir)) {
        // A query de Séries já continha 'release_date'
        $sqlSerie = "INSERT INTO series (name, category_id, cover, plot, cast, director, genre, release_date, rating, backdrop_path, youtube_trailer, tmdb_id) 
                       VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        $stmtSerie = $conexao->prepare($sqlSerie);
        foreach ($seriesParaInserir as $serieData) {
            $stmtSerie->execute($serieData);
            // Atualiza o cache com o ID real
            $real_id = $conexao->lastInsertId();
            $temp_id = "temp_" . (array_search($serieData, $seriesParaInserir) + 1);
            $nomeSerie = $serieData[0];
            $category_id = $serieData[1];
            $cacheKeySerie = $nomeSerie . '_' . $category_id;
            
            $seriesCache[$cacheKeySerie]['id'] = $real_id; // Atualiza o ID no cache
            
            // Atualiza o ID nos episódios e temporadas que usaram o ID temporário
            foreach ($temporadasParaInserir as $k => $tempData) {
                if ($tempData[0] == $temp_id) $temporadasParaInserir[$k][0] = $real_id;
            }
            foreach ($episodiosParaInserir as $k => $epiData) {
                if ($epiData[1] == $temp_id) $episodiosParaInserir[$k][1] = $real_id;
            }
        }
    }

    // 2. Inserir Filmes e Live
    if (!empty($streamsParaInserir)) {
        
        // ==================================================
        //         CORREÇÃO FILMES/CANAIS (Query)
        // ==================================================
        // Adiciona a coluna 'added' e o valor 'NOW()'
        $sqlStream = "INSERT INTO streams (link, category_id, name, stream_type, container_extension, stream_icon, added, tmdb_id, cover_big, plot, cast, director, genre, release_date, rating, youtube_trailer, backdrop_path) 
                       VALUES (?, ?, ?, ?, ?, ?, NOW(), ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        // ==================================================
                       
        $stmtStream = $conexao->prepare($sqlStream);
        foreach (array_chunk($streamsParaInserir, 100) as $chunk) {
             foreach($chunk as $streamData) {
                // A data (NOW()) é inserida pelo SQL, então o array $streamData (que tem 16 itens)
                // bate com os 16 '?' da query.
                $stmtStream->execute($streamData);
            }
        }
    }

    // 3. Inserir Temporadas
    if (!empty($temporadasParaInserir)) {
        $sqlSeason = "INSERT IGNORE INTO series_seasons (series_id, season_number, name) VALUES (?, ?, ?)";
        $stmtSeason = $conexao->prepare($sqlSeason);
        foreach (array_chunk($temporadasParaInserir, 100) as $chunk) {
             foreach($chunk as $seasonData) {
                $stmtSeason->execute($seasonData);
            }
        }
    }
    
    // 4. Inserir Episódios
    if (!empty($episodiosParaInserir)) {
        $sqlEpisode = "INSERT IGNORE INTO series_episodes (link, series_id, season, episode_num, title, container_extension, movie_image, category_id, plot, tmdb_id) 
                          VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        $stmtEpisode = $conexao->prepare($sqlEpisode);
        foreach (array_chunk($episodiosParaInserir, 100) as $chunk) {
             foreach($chunk as $episodeData) {
                $stmtEpisode->execute($episodeData);
            }
        }
    }
    
    $results['error'] = array_merge($results['error'], $tmdb_logs); 
    return $results;
}

// Lógica de Roteamento Principal
header('Content-Type: application/json');
$conexao = conectar_bd(); // A conexão é iniciada aqui

$conexao->exec("SET NAMES 'utf8mb4'");

$json_payload = file_get_contents('php://input');

if (!mb_check_encoding($json_payload, 'UTF-8')) {
    $json_payload = mb_convert_encoding($json_payload, 'UTF-8', 'ISO-8859-1');
}
$json_payload = preg_replace('/[[:cntrl:]]|^\xEF\xBB\xBF/', '', $json_payload);

$data = json_decode($json_payload, true);

if (isset($data['part'])) {
    try {
        $links = $data['part'] ?? [];
        $useTmdb = $data['useTmdb'] ?? false; 
        
        if (empty($links)) {
            echo json_encode([
                'counters' => ['error' => 1],
                'logs' => [['type' => 'warning', 'message' => 'Bloco de links vazio.']]
            ]);
            exit;
        }
        
        $conexao->beginTransaction();
        $final_results = adicionarLinks_Otimizado($links, $conexao, $useTmdb, $tmdb_api_key); 
        $conexao->commit();
        
        $logs_para_js = [['type' => 'success', 'message' => 'Lote processado. Adicionados: ' . $final_results['urls'] . ', Duplicados: ' . $final_results['exists']]];
        if (!empty($final_results['error'])) {
            foreach($final_results['error'] as $errMsg) {
                $logType = strpos($errMsg, '[ERRO') === 0 ? 'error' : 'warning';
                $logs_para_js[] = ['type' => $logType, 'message' => $errMsg];
            }
        }

        echo json_encode([
            'counters' => $final_results,
            'logs' => $logs_para_js, 
            'importedItems' => $final_results['importedItems'] 
        ]);

    } catch (Exception $e) {
        if ($conexao->inTransaction()) $conexao->rollBack();
        http_response_code(500);
        
        echo json_encode([
            'counters' => ['error' => count($links ?? [1])],
            'logs' => [['type' => 'error', 'message' => 'Erro no Banco de Dados: ' . $e->getMessage()]]
        ]);
    }
} else {
    http_response_code(400);
    echo json_encode([
        'counters' => ['error' => 1],
        'logs' => [['type' => 'error', 'message' => 'Nenhum dado válido (part) recebido.']]
    ]);
}
?>