<?php
// Define limites mais altos para arquivos grandes
ini_set('memory_limit', '1024M'); 
ini_set('display_errors', 0);
error_reporting(0);

header('Content-Type: application/json');

$data = json_decode(file_get_contents('php://input'), true);

if (empty($data['url'])) {
    http_response_code(400);
    echo json_encode(['error' => 'URL no fornecida.']);
    exit;
}

$url = $data['url'];

// 1. Usa cURL para mais controle e timeout
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
curl_setopt($ch, CURLOPT_TIMEOUT, 60); // 60 segundos de timeout (para no "congelar")
curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true); // Segue redirecionamentos
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false); // Ignora SSL (comum em listas)
$content = curl_exec($ch);
$curl_error = curl_error($ch);
curl_close($ch);

// 2. Verifica se o cURL falhou (timeout ou erro de rede)
if ($curl_error || $content === false) {
    http_response_code(500);
    echo json_encode(['error' => 'PROXY_ERRO: Falha ao buscar URL com cURL: ' . $curl_error]);
    exit;
}

// 3. Verifica se o contedo est vazio
if (empty($content)) {
    http_response_code(500);
    echo json_encode(['error' => 'PROXY_ERRO: O arquivo da URL est vazio.']);
    exit;
}

// 4. Tenta forar UTF-8 (alguns arquivos podem estar em ISO-8859-1)
if (!mb_check_encoding($content, 'UTF-8')) {
    $content = mb_convert_encoding($content, 'UTF-8', 'ISO-8859-1');
}

// 5. Tenta codificar o JSON
$json_output = json_encode(['content' => $content]);

// 6. Verifica se o json_encode falhou (provavelmente por memria/arquivo gigante)
if ($json_output === false) {
    http_response_code(500);
    echo json_encode([
        'error' => 'PROXY_ERRO: Falha ao codificar JSON. O arquivo M3U  muito grande (Excedeu o limite de memria do PHP).',
        'json_last_error' => json_last_error_msg() // D o motivo exato
    ]);
    exit;
}

// Sucesso
echo $json_output;
?>

