<?php
// ==========================================================
// ARQUIVO: /api/limpar_api.php (VERSÃO 9.1 - CORREÇÃO SÉRIES)
// ==========================================================

// Aumenta o tempo limite para 15 minutos (900 segundos)
set_time_limit(900); 

require_once('controles/db.php');
@session_start();

// Verificação de Segurança
if (!isset($_SESSION['admin_id'])) {
    header('Content-Type: application/json; charset=utf-8');
    die(json_encode(['error' => 'Sessão expirada.']));
}

$conexao = conectar_bd();
$acao = $_POST['acao'] ?? null;
$admin_id = $_SESSION['admin_id'];

header('Content-Type: application/json; charset=utf-8');

// ==========================================================
// ROTEADOR DE 'POST' (DELETAR OS DUPLICADOS DIRETAMENTE)
// ==========================================================
if ($_SERVER['REQUEST_METHOD'] === 'POST' && $acao == 'deletar_rapido') {
    try {
        $tipo = $_POST['tipo'] ?? null;
        $sql = "";
        
        // NOTA: Estas queries dependem dos ÍNDICES DE BANCO DE DADOS
        // para terem a performance máxima.

        switch ($tipo) {
            // 1. DELETAR STREAMS (Filmes/Canais) - OK
            case 'streams':
                $sql = "DELETE t1
                        FROM streams AS t1
                        INNER JOIN streams AS t2
                        WHERE 
                            t1.id > t2.id AND
                            t1.name = t2.name AND
                            t1.link = t2.link;";
                break;

            // 2. DELETAR SÉRIES (CORRIGIDO)
            // Alterado de 't1.title = t2.title' para 't1.name = t2.name'
            case 'series':
                $sql = "DELETE t1
                        FROM series AS t1
                        INNER JOIN series AS t2
                        WHERE 
                            t1.id > t2.id AND
                            t1.name = t2.name;"; // <-- CORREÇÃO AQUI
                break;

            // 3. DELETAR EPISÓDIOS (OK)
            case 'episodios':
                $sql = "DELETE t1
                        FROM series_episodes AS t1
                        INNER JOIN series_episodes AS t2
                        WHERE 
                            t1.id > t2.id AND
                            t1.series_id = t2.series_id AND
                            t1.link = t2.link;";
                break;
                
            default:
                throw new Exception("Tipo de limpeza desconhecido.");
        }

        $stmt = $conexao->prepare($sql);
        $stmt->execute();
        
        $total_deletado = $stmt->rowCount();
        
        echo json_encode(['success' => true, 'total_deletado' => $total_deletado]);
        exit;

    } catch (Exception $e) {
        http_response_code(500); // Erro de Servidor
        echo json_encode(['error' => 'Falha na query de exclusão: ' . $e->getMessage()]);
    }
    exit;
}

// Se nenhuma ação for encontrada
http_response_code(400); // Bad Request
echo json_encode(['error' => 'Requisição inválida. Ação "deletar_rapido" esperada via POST.']);
?>