<?php
session_start();
// O arquivo db.php DEVE ser o responsável por definir a função conectar_bd().
require_once('./controles/db.php'); 

// ---------------------------------------------------------------------------------
// BLOCO 1: OBTER INFORMAÇÕES DO ADMIN (CHAMADO POR JS PARA ATUALIZAR CRÉDITOS)
// ---------------------------------------------------------------------------------
if (isset($_GET['info_admin'])) {
    header('Content-Type: application/json; charset=utf-8');
    
    // 1. VERIFICAÇÃO INICIAL DA SESSÃO
    if (!isset($_SESSION['admin_id']) || !isset($_SESSION['username'])) {
        echo json_encode(['icon' => 'error', 'title' => 'Sessão', 'msg' => 'Sessão expirada. Redirecionando...', 'creditos' => '0,00', 'tipo_admin' => 'Desconectado']);
        exit();
    }

    $admin_id = $_SESSION['admin_id'];

    // 2. CONEXÃO COM O BANCO DE DADOS
    try {
        $conexao = conectar_bd();
    } catch (Exception $e) {
        // Retorna um JSON de erro em caso de falha de conexão
        error_log("Erro de BD ao buscar info_admin: " . $e->getMessage());
        echo json_encode(['icon' => 'error', 'title' => 'Erro de BD', 'msg' => 'Falha na conexão com o banco de dados.', 'creditos' => '0,00', 'tipo_admin' => 'Erro']);
        exit();
    }

    // 3. CONSULTA SQL ROBUSTA
    // Busca 'admin' (nível) e 'creditos' (saldo)
    $stmt = $conexao->prepare("SELECT user AS usuario, admin AS nivel_admin, creditos FROM admin WHERE id = :admin_id");
    
    try {
        $stmt->execute([':admin_id' => $admin_id]);
        $admin_data = $stmt->fetch(PDO::FETCH_ASSOC);
    } catch (PDOException $e) {
        // Retorna um JSON de erro se a consulta SQL falhar
        error_log("Erro SQL ao buscar info_admin: " . $e->getMessage());
        echo json_encode(['icon' => 'error', 'title' => 'Erro SQL', 'msg' => 'Falha ao buscar dados do administrador.', 'creditos' => '0,00', 'tipo_admin' => 'Erro']);
        exit();
    }

    // 4. PROCESSAMENTO DOS DADOS E FORMATO
    if ($admin_data) {
        $nivel_admin = (int)($admin_data['nivel_admin'] ?? 0);
        
        // Usa o campo 'creditos' que parece ser o saldo correto
        $creditos_raw = (float)($admin_data['creditos'] ?? 0.0);
        $usuario = htmlspecialchars($admin_data['usuario']);

        $tipo_admin = ($nivel_admin === 1) ? 'Admin Master' : 'Revendedor';
        
        // CÓDIGO PARA CRÉDITOS INFINITOS (AGORA COM O SÍMBOLO):
        if ($creditos_raw < 0) {
            $creditos_display = '&infin;'; // Símbolo de infinito
        } else {
            // Formata para exibição em português (Ex: 0,99)
            $creditos_display = number_format($creditos_raw, 2, ',', '.');
        }
        
        // Retorna a resposta JSON esperada pelo JavaScript
        echo json_encode([
            'icon' => 'success',
            'title' => 'Sucesso',
            'msg' => 'Informações do admin atualizadas.',
            'creditos' => $creditos_display, 
            'tipo_admin' => $tipo_admin,
            'usuario' => $usuario
        ]);
    } else {
        // Se o admin_id existir na sessão mas não no banco (muito raro)
        echo json_encode(['icon' => 'error', 'title' => 'Erro', 'msg' => 'Admin não encontrado.', 'creditos' => '0,00', 'tipo_admin' => 'Erro']);
    }
    exit();
}


// ---------------------------------------------------------------------------------
// BLOCO 2: LISTAR CLIENTES (SUA LÓGICA ORIGINAL PARA DATATABLES)
// ---------------------------------------------------------------------------------
if (isset($_GET['listar_clientes'])) {
    header('Content-Type: application/json; charset=utf-8');
    
    // TENTA CONECTAR AO BANCO
    try {
        $conexao = conectar_bd();
    } catch (Exception $e) {
        // Retorna JSON de erro para o DataTable
        echo json_encode(["draw" => 0, "recordsTotal" => 0, "recordsFiltered" => 0, "data" => [], "error" => "Erro de conexão com o banco de dados."]);
        exit();
    }
    
    $dados_requisicao = $_REQUEST;
    $admin_id = $_SESSION['admin_id'] ?? 0;
    
    $colunas = [ 0 => 'id', 1 => 'name', 2 => 'usuario', 4 => 'Vencimento' ];

    // --- QUERY BASE E PARÂMETROS ---
    $query_base = " FROM clientes WHERE admin_id = :admin_id AND is_trial = 0";
    $params = [':admin_id' => $admin_id];

    // --- LÓGICA DE PESQUISA ---
    if (!empty($dados_requisicao['search']['value'])) {
        $search_value = "%" . $dados_requisicao['search']['value'] . "%";
        $query_base .= " AND (name LIKE :search_name OR usuario LIKE :search_usuario)";
        $params[':search_name'] = $search_value;
        $params[':search_usuario'] = $search_value;
    }

    // --- CONTAGEM DE REGISTOS ---
    $stmt_total = $conexao->prepare("SELECT COUNT(id) FROM clientes WHERE admin_id = :admin_id AND is_trial = 0");
    $stmt_total->execute([':admin_id' => $admin_id]);
    $total_records = $stmt_total->fetchColumn();

    $stmt_filtrado = $conexao->prepare("SELECT COUNT(id) " . $query_base);
    $stmt_filtrado->execute($params);
    $total_filtered = $stmt_filtrado->fetchColumn();

    // --- ORDENAÇÃO E PAGINAÇÃO ---
    $coluna_ordenacao = $colunas[$dados_requisicao['order'][0]['column']] ?? 'id';
    $direcao_ordenacao = $dados_requisicao['order'][0]['dir'] ?? 'desc';
    $inicio = (int)($dados_requisicao['start'] ?? 0);
    $quantidade = (int)($dados_requisicao['length'] ?? 10);
    
    $query_final = "SELECT * " . $query_base . " ORDER BY " . $coluna_ordenacao . " " . $direcao_ordenacao . " LIMIT " . $quantidade . " OFFSET " . $inicio;
    
    $stmt_principal = $conexao->prepare($query_final);
    $stmt_principal->execute($params);

    // --- MONTAGEM DOS DADOS DE RESPOSTA ---
    $dados = [];
    while ($row = $stmt_principal->fetch(PDO::FETCH_ASSOC)) {
        extract($row);
        
        $status = (strtotime($Vencimento) < time()) 
            ? '<span class="badge bg-warning w-100 text-dark"> Expirado </span>' 
            : '<span class="badge bg-success w-100 text-dark"> Ativo </span>';
        
        $acoes = '<div class="btn-group" role="group">';
        $acoes .= '<button type="button" class="btn btn-sm btn-outline-info" onclick=\'modal_master("api.php", "info_cliente", "' . $id . '")\' title="Ver detalhes"><i class="fa-solid fa-eye"></i></button>';
        $acoes .= '<button type="button" class="btn btn-sm btn-outline-primary" onclick=\'modal_master("api.php", "edite_cliente", "' . $id . '")\' title="Editar cliente"><i class="fa fa-edit"></i></button>';
        $acoes .= '<button type="button" class="btn btn-sm btn-outline-success" onclick=\'modal_master("api.php", "renovar_cliente", "' . $id . '")\' title="Renovar cliente"><i class="fas fa-retweet"></i></button>';
        $acoes .= '<button type="button" class="btn btn-sm btn-outline-danger" onclick=\'modal_master("api.php", "delete_cliente", "' . $id . '")\' title="Apagar cliente"><i class="far fa-trash-alt"></i></button>';
        $acoes .= '</div>';

        $dados[] = [
            "id" => $id, 
            "name" => $name, 
            "usuario" => $usuario,
            "indicados" => '', 
            "status" => $status,
            "vencimento" => date('d-m-Y H:i:s', strtotime($Vencimento)),
            "acao" => $acoes
        ];
    }
    
    echo json_encode([
        "draw" => intval($dados_requisicao['draw']),
        "recordsTotal" => intval($total_records),
        "recordsFiltered" => intval($total_filtered),
        "data" => $dados
    ]);
    exit();
}
?>
