<?php
// Arquivo: /api/planos.php
// [CORREÇÃO] Revertido para o método original de envio de dados
// para as funções 'confirme_', pois elas esperam argumentos separados.

session_start();
require_once('./controles/db.php');
require_once('./controles/planos.php'); // Funções (ex: edite_planos)
require_once('./controles/checkLogout.php');
header('Content-Type: application/json; charset=utf-8');

checkLogoutapi();

// --- ROTEADOR DE AÇÕES ---
if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    $action = array_key_first($_POST);

    if (!$action || !function_exists($action)) {
        echo json_encode(['title' => 'Erro!', 'msg' => 'Ação POST não reconhecida ou função não encontrada.', 'icon' => 'error']);
        exit();
    }

    $resposta = null;

    try {
        // Roda a ação correspondente
        switch ($action) {
            
            // Ações que abrem modal (chamadas por modal_master)
            case 'adicionar_planos':
            case 'edite_planos':
            case 'mover_clientes_plano':
                $id = $_POST[$action]; // Pega o valor (ID ou 'add')
                $resposta = $action($id); // Chama a função (ex: edite_planos($id))
                break;

            // Esta é a correção que fizemos antes (buscar o nome), está correta.
            case 'delete_plano':
                $id = $_POST[$action]; // Pega o ID
                
                $conexao_temp = conectar_bd(); 
                $stmt_nome = $conexao_temp->prepare("SELECT nome FROM planos WHERE id = ? AND admin_id = ?");
                $stmt_nome->execute([$id, $_SESSION['admin_id']]);
                $nome_plano = $stmt_nome->fetchColumn();
                
                if ($nome_plano) {
                    $resposta = delete_plano($id, $nome_plano); // Chama com ($id, $nome)
                } else {
                    $resposta = ['title' => 'Erro!', 'msg' => 'Plano não encontrado para deletar.', 'icon' => 'error'];
                }
                break;

            // ==================================================
            //         CORREÇÃO (REVERSÃO AO CÓDIGO ORIGINAL)
            // ==================================================
            // As funções 'confirme_' esperam argumentos separados, não o array $_POST.
            
            case 'confirme_adicionar_plano':
                $nome = isset($_POST["nome"]) ? htmlspecialchars($_POST["nome"]) : null;
                $valor = isset($_POST["valor"]) ? htmlspecialchars($_POST["valor"]) : null;
                $custo_por_credito = isset($_POST["custo_por_credito"]) ? htmlspecialchars($_POST["custo_por_credito"]) : null;
                
                // Limpeza (do seu código original)
                $nome = preg_replace("/[^a-zA-Z0-9 ]/", "", $nome);
                $valor = str_replace(',', '.', $valor);
                $valor = preg_replace("/[^a-zA-Z0-9.] /", "", $valor);
                $custo_por_credito = str_replace(',', '.', $custo_por_credito);
                $custo_por_credito = preg_replace("/[^a-zA-Z0-9.]/", "", $custo_por_credito);
                
                $resposta = confirme_adicionar_plano($nome, $valor, $custo_por_credito);
                break;

            case 'confirme_edite_planos':
                $id = isset($_POST["confirme_edite_planos"]) ? (int) $_POST["confirme_edite_planos"] : null;
                $nome = isset($_POST["nome"]) ? htmlspecialchars($_POST["nome"]) : null;
                $valor = isset($_POST["valor"]) ? htmlspecialchars($_POST["valor"]) : null;
                $custo_por_credito = isset($_POST["custo_por_credito"]) ? htmlspecialchars($_POST["custo_por_credito"]) : null;
                
                // Limpeza (do seu código original)
                $id = preg_replace("/[^a-zA-Z0-9]/", "", $id);
                $nome = preg_replace("/[^a-zA-Z0-9 ]/", "", $nome);
                $valor = str_replace(',', '.', $valor);
                $valor = preg_replace("/[^a-zA-Z0-9.] /", "", $valor);
                $custo_por_credito = str_replace(',', '.', $custo_por_credito);
                $custo_por_credito = preg_replace("/[^a-zA-Z0-9.]/", "", $custo_por_credito);
                
                $resposta = confirme_edite_planos($id, $nome, $valor, $custo_por_credito);
                break;

            case 'confirme_delete_plano':
                $id = $_POST['confirme_delete_plano'];
                
                // (do seu código original)
                $resposta = confirme_delete_plano($id, null); // Passando null para $nome
                break;
                
            case 'confirme_mover_clientes_plano':
                $plano_atual = $_POST['confirme_mover_clientes_plano'];
                $plano = isset($_POST['plano']) ? $_POST['plano'] : null;
                $resposta = confirme_mover_clientes_plano($plano_atual, $plano);
                break;
            // ==================================================
            //              FIM DA CORREÇÃO
            // ==================================================

            default:
                $resposta = ['title' => 'Erro!', 'msg' => 'Ação não tratada no roteador.', 'icon' => 'error'];
        }

        // Envia a resposta
        if (!$resposta) {
            echo json_encode(['title' => 'Erro!', 'msg' => 'A função não retornou uma resposta.', 'icon' => 'error']);
        } else {
            echo json_encode($resposta);
        }

    } catch (Exception $e) {
        echo json_encode(['title' => 'Erro Crítico!', 'msg' => 'Exceção capturada: ' . $e->getMessage(), 'icon' => 'error']);
    }

    exit();
}

// Resposta padrão caso não seja POST
echo json_encode(['title' => 'Erro!', 'msg' => 'Requisição inválida (Não é POST).', 'icon' => 'error']);
?>