﻿<?php
// ARQUIVO: api/testes.php
// CORREÇÃO: Campo 'plano' adicionado no INSERT e UPDATE para evitar erro SQL 1364.

// 1. CONFIGURAÇÕES
ob_start(); 
date_default_timezone_set('America/Sao_Paulo'); 
ini_set('display_errors', 0); 
error_reporting(E_ALL); 
header('Content-Type: application/json; charset=utf-8');

if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

// Verifica sessão
if (!isset($_SESSION['admin_id'])) {
    ob_clean();
    echo json_encode(['title'=>'Sessão Expirada', 'msg'=>'Faça login novamente.', 'icon'=>'error']);
    exit;
}

// 2. CONEXÃO BD
$pdo = null;
$caminhos = ['controles/db.php', '../controles/db.php', 'db.php', '../db.php'];
foreach ($caminhos as $c) {
    if (file_exists(__DIR__ . '/' . $c)) { require_once __DIR__ . '/' . $c; break; }
    elseif (file_exists($c)) { require_once $c; break; }
}

if (!function_exists('conectar_bd')) {
    ob_clean();
    echo json_encode(['title'=>'Erro Crítico', 'msg'=>'Banco de dados não encontrado.', 'icon'=>'error']);
    exit;
}

// ======================================================================
// 3. ROTEADOR
// ======================================================================

$acao = $_REQUEST['acao'] ?? $_REQUEST['action'] ?? null;

if (!$acao) {
    foreach ($_POST as $key => $value) {
        if (strpos($key, 'confirme_') === 0) { $acao = $key; break; }
    }
}

if (isset($_REQUEST['listar_testes'])) $acao = 'listar_testes';

if (!$acao) {
    ob_clean();
    echo json_encode(['status'=>'error', 'message'=>'Nenhuma ação definida']);
    exit;
}

$res = null;
switch ($acao) {
    case 'listar_testes':          $res = listar_testes($_REQUEST); break;
    case 'listar_revendedores':    $res = listar_revendedores(); break;
    case 'obter_contagens_testes': $res = obter_contagens_testes(); break;

    case 'adicionar_testes':       $res = modal_adicionar_testes(); break;
    case 'editar_teste':           $res = modal_editar_teste($_POST['id']); break;
    case 'bloquear_teste':         $res = modal_bloquear_teste($_POST['id']); break;
    case 'converter_teste':        $res = modal_converter_teste($_POST['id']); break;
    case 'delete_teste':           $res = modal_delete_teste($_POST['id']); break;
    case 'info_teste':             $res = modal_info_teste($_POST['id']); break;

    case 'confirme_adicionar_testes': $res = salvar_novo_teste($_POST); break;
    case 'confirme_editar_teste':     $res = salvar_edicao_teste($_POST); break;
    case 'confirme_bloquear_teste':   $res = salvar_bloqueio_teste($_POST); break;
    case 'confirme_converter_teste':  $res = salvar_conversao_teste($_POST); break;
    case 'confirme_delete_teste':     $res = salvar_delete_teste($_POST); break;
    
    default: $res = ['title'=>'Erro', 'msg'=>'Ação desconhecida', 'icon'=>'error'];
}

ob_clean();
echo json_encode($res);
exit;


// ======================================================================
// 4. FUNÇÕES
// ======================================================================

function listar_testes($req) {
    try {
        $pdo = conectar_bd();
        $id_logado = $_SESSION['admin_id'];
        
        $stmt = $pdo->prepare("SELECT admin FROM admin WHERE id = ?");
        $stmt->execute([$id_logado]);
        $u = $stmt->fetch();
        $is_dono = ($u && $u['admin'] == 1);

        $condicoes = ["is_trial = 1", "is_p2p = 0"];
        $params = [];

        if (!$is_dono) {
            $condicoes[] = "admin_id = :meu_id";
            $params[':meu_id'] = $id_logado;
        }

        if ($is_dono && !empty($req['filtro_revenda']) && $req['filtro_revenda'] !== 'todos') {
            $condicoes[] = "admin_id = :filtro_id";
            $params[':filtro_id'] = $req['filtro_revenda'];
        }

        $sql_search = "";
        $params_search = [];
        if (!empty($req['search']['value'])) {
            $termo = "%" . $req['search']['value'] . "%";
            $sql_search = " AND (name LIKE :s1 OR usuario LIKE :s2) ";
            $params_search[':s1'] = $termo;
            $params_search[':s2'] = $termo;
        }

        $sql_where = " WHERE " . implode(" AND ", $condicoes);

        $stmt_total = $pdo->prepare("SELECT COUNT(id) FROM clientes " . $sql_where);
        $stmt_total->execute($params);
        $total_records = $stmt_total->fetchColumn();

        $stmt_filt = $pdo->prepare("SELECT COUNT(id) FROM clientes " . $sql_where . $sql_search);
        $stmt_filt->execute(array_merge($params, $params_search));
        $total_filtered = $stmt_filt->fetchColumn();

        $ordem = $req['order'][0]['dir'] ?? 'desc';
        $limit = $req['length'] ?? 10;
        $offset = $req['start'] ?? 0;

        $sql = "SELECT * FROM clientes " . $sql_where . $sql_search . " ORDER BY id $ordem LIMIT $limit OFFSET $offset";
        $stmt = $pdo->prepare($sql);
        $stmt->execute(array_merge($params, $params_search));

        $data = [];
        while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
            $id = $row['id'];
            
            if ($row['is_banned'] == 1) $st = '<span class="badge bg-danger">Bloqueado</span>';
            elseif (strtotime($row['Vencimento']) < time()) $st = '<span class="badge bg-warning text-dark">Expirado</span>';
            else $st = '<span class="badge bg-success">Ativo</span>';

            $btns = "<div class='btn-group'>";
            $btns .= "<button class='btn btn-sm btn-info' onclick='modal_master(\"api/testes.php\", \"info_teste\", \"$id\")' title='Info'><i class='fas fa-eye'></i></button>";
            $btns .= "<button class='btn btn-sm btn-warning' onclick='modal_master(\"api/testes.php\", \"editar_teste\", \"$id\")' title='Editar'><i class='fas fa-edit'></i></button>";
            
            if ($row['is_banned'] == 1) {
                $btns .= "<button class='btn btn-sm btn-success' onclick='modal_master(\"api/testes.php\", \"bloquear_teste\", \"$id\")' title='Desbloquear'><i class='fas fa-lock-open'></i></button>";
            } else {
                $btns .= "<button class='btn btn-sm btn-danger' onclick='modal_master(\"api/testes.php\", \"bloquear_teste\", \"$id\")' title='Bloquear'><i class='fas fa-lock'></i></button>";
            }

            $btns .= "<button class='btn btn-sm btn-success' onclick='modal_master(\"api/testes.php\", \"converter_teste\", \"$id\")' title='Converter'><i class='fas fa-check'></i></button>";
            $btns .= "<button class='btn btn-sm btn-danger' onclick='modal_master(\"api/testes.php\", \"delete_teste\", \"$id\")' title='Excluir'><i class='fas fa-trash-alt'></i></button>";
            $btns .= "</div>";

            $data[] = [
                "id" => $id, "name" => $row['name'], "usuario" => $row['usuario'], 
                "status" => $st, "vencimento" => date('d/m/Y H:i', strtotime($row['Vencimento'])), 
                "acao" => $btns
            ];
        }
        return ["draw"=>intval($req['draw']), "recordsTotal"=>$total_records, "recordsFiltered"=>$total_filtered, "data"=>$data];
    } catch (Exception $e) { return ["data"=>[], "error"=>$e->getMessage()]; }
}

// --- MODAIS ---
function modal_adicionar_testes() {
    $pdo = conectar_bd();
    $stmt = $pdo->query("SELECT id, bouquet_name FROM bouquets ORDER BY bouquet_name");
    $opt_b = "<option value='' disabled selected>Selecione...</option>";
    while($r = $stmt->fetch()) $opt_b .= "<option value='{$r['id']}'>{$r['bouquet_name']}</option>";

    $html = '
    <form id="formAddTeste">
        <input type="hidden" name="confirme_adicionar_testes" value="1">
        <div class="row">
            <div class="col-12 mb-3 text-end">
                <button type="button" class="btn btn-sm btn-outline-info" onclick="gerarDadosAcesso()"><i class="fas fa-magic"></i> Gerar</button>
            </div>
            <div class="col-6 mb-2"><label>Nome</label><input type="text" name="name" class="form-control" required></div>
            <div class="col-6 mb-2"><label>WhatsApp</label><input type="text" name="WhatsApp" class="form-control"></div>
            <div class="col-6 mb-2"><label>Usuário</label><input type="text" name="usuario" class="form-control" required></div>
            <div class="col-6 mb-2"><label>Senha</label><input type="text" name="senha" class="form-control" required></div>
            <div class="col-6 mb-2"><label>Duração (Horas)</label><input type="number" name="horas" value="3" class="form-control"></div>
            <div class="col-6 mb-2"><label>Pacote</label><select name="bouquet_id" class="form-select" required>'.$opt_b.'</select></div>
        </div>
    </form>';
    $ft = '<button class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button> <button class="btn btn-primary" onclick="enviarFormulario(\'formAddTeste\', \'api/testes.php\')">Salvar</button>';
    return ['modal_titulo'=>'Novo Teste', 'modal_body'=>$html, 'modal_footer'=>$ft];
}

function modal_editar_teste($id) {
    $pdo = conectar_bd();
    $stmt = $pdo->prepare("SELECT * FROM clientes WHERE id = ?");
    $stmt->execute([$id]);
    $c = $stmt->fetch(PDO::FETCH_ASSOC);
    if(!$c) return ['modal_titulo'=>'Erro', 'modal_body'=>'Não encontrado'];

    $stmt_b = $pdo->query("SELECT id, bouquet_name FROM bouquets ORDER BY bouquet_name");
    $opt_b = "";
    while($r = $stmt_b->fetch()) {
        $sel = ($r['id'] == $c['bouquet_id']) ? 'selected' : '';
        $opt_b .= "<option value='{$r['id']}' $sel>{$r['bouquet_name']}</option>";
    }

    $html = '
    <form id="formEditTeste">
        <input type="hidden" name="confirme_editar_teste" value="'.$id.'">
        <div class="row">
            <div class="col-6 mb-2"><label>Nome</label><input type="text" name="name" value="'.$c['name'].'" class="form-control" required></div>
            <div class="col-6 mb-2"><label>WhatsApp</label><input type="text" name="WhatsApp" value="'.$c['WhatsApp'].'" class="form-control"></div>
            <div class="col-6 mb-2"><label>Usuário</label><input type="text" name="usuario" value="'.$c['usuario'].'" class="form-control" required></div>
            <div class="col-6 mb-2"><label>Senha</label><input type="text" name="senha" value="'.$c['senha'].'" class="form-control" required></div>
            <div class="col-12 mb-2"><label>Pacote</label><select name="bouquet_id" class="form-select" required>'.$opt_b.'</select></div>
        </div>
    </form>';
    $ft = '<button class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button> <button class="btn btn-warning" onclick="enviarFormulario(\'formEditTeste\', \'api/testes.php\')">Salvar</button>';
    return ['modal_titulo'=>'Editar Teste', 'modal_body'=>$html, 'modal_footer'=>$ft];
}

function modal_bloquear_teste($id) {
    $pdo = conectar_bd();
    $stmt = $pdo->prepare("SELECT is_banned FROM clientes WHERE id = ?");
    $stmt->execute([$id]);
    $c = $stmt->fetch();
    $acao = ($c['is_banned'] == 1) ? 'Desbloquear' : 'Bloquear';
    $cor  = ($c['is_banned'] == 1) ? 'success' : 'danger';
    
    $html = "<form id='formBlock'><input type='hidden' name='confirme_bloquear_teste' value='$id'>Confirmar <b>$acao</b>?</form>";
    $ft = '<button class="btn btn-secondary" data-bs-dismiss="modal">Não</button> <button class="btn btn-'.$cor.'" onclick="enviarFormulario(\'formBlock\', \'api/testes.php\')">Sim</button>';
    return ['modal_titulo'=>$acao, 'modal_body'=>$html, 'modal_footer'=>$ft];
}

function modal_converter_teste($id) {
    $html = "<form id='formConv'><input type='hidden' name='confirme_converter_teste' value='$id'>Converter para cliente oficial?</form>";
    $ft = '<button class="btn btn-secondary" data-bs-dismiss="modal">Não</button> <button class="btn btn-success" onclick="enviarFormulario(\'formConv\', \'api/testes.php\')">Converter</button>';
    return ['modal_titulo'=>'Converter', 'modal_body'=>$html, 'modal_footer'=>$ft];
}

function modal_delete_teste($id) {
    $html = "<form id='formDel'><input type='hidden' name='confirme_delete_teste' value='$id'>Excluir permanentemente?</form>";
    $ft = '<button class="btn btn-secondary" data-bs-dismiss="modal">Não</button> <button class="btn btn-danger" onclick="enviarFormulario(\'formDel\', \'api/testes.php\')">Excluir</button>';
    return ['modal_titulo'=>'Excluir', 'modal_body'=>$html, 'modal_footer'=>$ft];
}

function modal_info_teste($id) {
    $pdo = conectar_bd();
    $stmt = $pdo->prepare("SELECT * FROM clientes WHERE id = ?");
    $stmt->execute([$id]);
    $c = $stmt->fetch(PDO::FETCH_ASSOC);
    $msg = gerar_mensagem($pdo, $c['usuario'], $c['senha'], $c['Vencimento']);
    $html = '<textarea class="form-control" rows="10" readonly>'.$msg.'</textarea>';
    $ft = '<button class="btn btn-secondary" data-bs-dismiss="modal">Fechar</button>
           <button class="btn btn-primary" onclick="navigator.clipboard.writeText(`'.$msg.'`);alert(\'Copiado!\')">Copiar</button>
           <a href="https://wa.me/?text='.urlencode($msg).'" target="_blank" class="btn btn-success">WhatsApp</a>';
    return ['modal_titulo'=>'Dados', 'modal_body'=>$html, 'modal_footer'=>$ft];
}

// --- SALVAR (BD) ---

function salvar_novo_teste($p) {
    try {
        $pdo = conectar_bd();
        $horas = $p['horas'] ?? 3;
        $venc = date('Y-m-d H:i:s', strtotime("+$horas hours"));
        
        // CORREÇÃO: Adicionado campo 'plano' no INSERT e no VALUES
        $sql = "INSERT INTO clientes (admin_id, name, usuario, senha, WhatsApp, bouquet_id, plano, Vencimento, conexoes, Criado_em, is_trial, is_p2p) 
                VALUES (?,?,?,?,?,?,?,?,1,NOW(),1,0)";
        
        $pdo->prepare($sql)->execute([
            $_SESSION['admin_id'], 
            $p['name'], 
            $p['usuario'], 
            $p['senha'], 
            $p['WhatsApp'], 
            $p['bouquet_id'], 
            $p['bouquet_id'], // 'plano' recebe o mesmo valor de 'bouquet_id'
            $venc
        ]);
        
        $msg = gerar_mensagem($pdo, $p['usuario'], $p['senha'], $venc);
        return ['title'=>'Sucesso', 'msg'=>'Criado!', 'icon'=>'success', 'dados_cliente_msg'=>$msg];
    } catch(Exception $e) { return ['title'=>'Erro', 'msg'=>$e->getMessage(), 'icon'=>'error']; }
}

function salvar_edicao_teste($p) {
    try {
        $pdo = conectar_bd();
        // CORREÇÃO: Adicionado 'plano' no UPDATE também
        $sql = "UPDATE clientes SET name = ?, usuario = ?, senha = ?, WhatsApp = ?, bouquet_id = ?, plano = ? WHERE id = ?";
        $pdo->prepare($sql)->execute([
            $p['name'], 
            $p['usuario'], 
            $p['senha'], 
            $p['WhatsApp'], 
            $p['bouquet_id'],
            $p['bouquet_id'], // Atualiza 'plano' junto
            $p['confirme_editar_teste']
        ]);
        return ['title'=>'Sucesso', 'msg'=>'Atualizado.', 'icon'=>'success'];
    } catch(Exception $e) { return ['title'=>'Erro', 'msg'=>$e->getMessage(), 'icon'=>'error']; }
}

function salvar_bloqueio_teste($p) {
    try {
        $pdo = conectar_bd();
        $pdo->prepare("UPDATE clientes SET is_banned = NOT is_banned WHERE id = ?")->execute([$p['confirme_bloquear_teste']]);
        return ['title'=>'Sucesso', 'msg'=>'Status alterado.', 'icon'=>'success'];
    } catch(Exception $e) { return ['title'=>'Erro', 'msg'=>$e->getMessage(), 'icon'=>'error']; }
}

function salvar_conversao_teste($p) {
    try {
        $pdo = conectar_bd();
        $id = $p['confirme_converter_teste'];
        $adm_id = $_SESSION['admin_id'];
        
        $u = $pdo->query("SELECT admin, creditos FROM admin WHERE id = $adm_id")->fetch();
        if ($u['admin'] != 1 && $u['creditos'] < 1) return ['title'=>'Erro', 'msg'=>'Sem créditos.', 'icon'=>'error'];
        
        if ($u['admin'] != 1) $pdo->exec("UPDATE admin SET creditos = creditos - 1 WHERE id = $adm_id");
        
        $novo_venc = date('Y-m-d 23:59:59', strtotime("+1 month"));
        $pdo->prepare("UPDATE clientes SET is_trial = 0, Vencimento = ? WHERE id = ?")->execute([$novo_venc, $id]);
        
        return ['title'=>'Convertido!', 'msg'=>'Agora é cliente.', 'icon'=>'success', 'redirect_url'=>'clientes.php'];
    } catch(Exception $e) { return ['title'=>'Erro', 'msg'=>$e->getMessage(), 'icon'=>'error']; }
}

function salvar_delete_teste($p) {
    $pdo = conectar_bd();
    $pdo->prepare("DELETE FROM clientes WHERE id = ?")->execute([$p['confirme_delete_teste']]);
    return ['title'=>'Deletado', 'msg'=>'Removido.', 'icon'=>'success'];
}

// --- UTILS ---
function listar_revendedores() {
    $pdo = conectar_bd();
    $d = $pdo->query("SELECT id, user FROM admin ORDER BY user")->fetchAll(PDO::FETCH_ASSOC);
    return ['data' => $d];
}

function obter_contagens_testes() {
    $pdo = conectar_bd();
    $id = $_SESSION['admin_id'];
    $u = $pdo->query("SELECT admin FROM admin WHERE id = $id")->fetch();
    $where = ($u['admin'] == 1) ? "" : " AND admin_id = $id";
    $agora = date('Y-m-d H:i:s');
    
    $r = $pdo->query("SELECT 
        SUM(CASE WHEN is_trial=1 AND Vencimento > '$agora' AND is_banned=0 THEN 1 ELSE 0 END) as ativos,
        SUM(CASE WHEN is_trial=1 AND Vencimento < '$agora' THEN 1 ELSE 0 END) as vencidos,
        SUM(CASE WHEN is_trial=1 AND is_banned=1 THEN 1 ELSE 0 END) as bloqueados
        FROM clientes WHERE is_trial=1 $where")->fetch(PDO::FETCH_ASSOC);
    return $r;
}

function gerar_mensagem($pdo, $user, $pass, $venc) {
    $url = (isset($_SERVER['HTTPS']) ? "https" : "http") . "://" . $_SERVER['HTTP_HOST'];
    try {
        $s = $pdo->query("SELECT server_ip, server_port FROM servers WHERE status = 1 LIMIT 1")->fetch();
        if ($s) {
            $u = rtrim($s['server_ip'], '/');
            if (strpos($u, 'http') === false) $u = "http://" . $u;
            if ($s['server_port'] != 80) $u .= ":" . $s['server_port'];
            $url = $u;
        }
    } catch (Exception $e) {}

    $tpl_file = $_SERVER['DOCUMENT_ROOT'] . '/template_mensagem.txt';
    $tpl = file_exists($tpl_file) ? file_get_contents($tpl_file) : "✅ Teste Criado\nUser: #username#\nPass: #password#\nURL: #url#";
    
    $replaces = [
        '#username#' => $user, '#password#' => $pass, '#url#' => $url, '#exp_date#' => date('d/m H:i', strtotime($venc)),
        '#m3u_encurtado#' => "$url/m3u-ts/$user/$pass",
        '#m3u_hls_encurtado#' => "$url/m3u-hls/$user/$pass",
        '#ssiptv_encurtado#' => "$url/ssiptv/$user/$pass",
        '#m3u_link#' => "$url/get.php?username=$user&password=$pass&type=m3u_plus&output=ts",
        '#m3u_link_hls#' => "$url/get.php?username=$user&password=$pass&type=m3u_plus&output=m3u8"
    ];
    return str_replace(array_keys($replaces), array_values($replaces), $tpl);
}
?>