<?php
// chatbot_gerar_teste_final2.php
// Verso final com a remoo da coluna 'obs' que no existe no banco de dados.

require_once(__DIR__ . '/api/controles/db.php');

// ======================================================
// FUNES PARA O CHATBOT
// ======================================================

function getChatbotUrl($admin_id) {
    $conn = conectar_bd();
    $stmt = $conn->prepare("SELECT chatbot_token FROM admin WHERE id = ?");
    $stmt->execute([$admin_id]);
    $token = $stmt->fetchColumn();

    if (!$token) {
        $token = bin2hex(random_bytes(32));
        $stmt_update = $conn->prepare("UPDATE admin SET chatbot_token = ? WHERE id = ?");
        $stmt_update->execute([$token, $admin_id]);
    }
    
    $base_url = "https://" . $_SERVER['HTTP_HOST'] . "/api/chatbot_office_api.php";
    return $base_url . "?key=" . $token;
}

function getUserByChatbotToken($token) {
    $conn = conectar_bd();
    $stmt = $conn->prepare("SELECT * FROM admin WHERE chatbot_token = ? LIMIT 1");
    $stmt->execute([$token]);
    return $stmt->fetch(PDO::FETCH_ASSOC);
}

function addChatBotRule($admin_id, $rule_type, $rule_action, $response, $messages) {
    $conn = conectar_bd();
    $stmt = $conn->prepare("INSERT INTO chatbot (admin_id, rule_type, rule_action, response, status) VALUES (?, ?, ?, ?, 1)");
    $stmt->execute([$admin_id, $rule_type, $rule_action, $response]);
    $chatbot_id = $conn->lastInsertId();

    if ($chatbot_id) {
        foreach ($messages as $message) {
            if (!empty(trim($message))) {
                $stmt_msg = $conn->prepare("INSERT INTO chatbot_messages (chatbot_id, admin_id, message) VALUES (?, ?, ?)");
                $stmt_msg->execute([$chatbot_id, $admin_id, trim($message)]);
            }
        }
    }
    return $chatbot_id ? true : false;
}

function updateChatBotRule($admin_id, $chatbot_id, $rule_type, $rule_action, $response, $messages) {
    $conn = conectar_bd();
    $stmt = $conn->prepare("UPDATE chatbot SET rule_type = ?, rule_action = ?, response = ? WHERE id = ? AND admin_id = ?");
    $stmt->execute([$rule_type, $rule_action, $response, $chatbot_id, $admin_id]);
    
    $stmt_del = $conn->prepare("DELETE FROM chatbot_messages WHERE chatbot_id = ? AND admin_id = ?");
    $stmt_del->execute([$chatbot_id, $admin_id]);

    foreach ($messages as $message) {
        if (!empty(trim($message))) {
            $stmt_msg = $conn->prepare("INSERT INTO chatbot_messages (chatbot_id, admin_id, message) VALUES (?, ?, ?)");
            $stmt_msg->execute([$chatbot_id, $admin_id, trim($message)]);
        }
    }
    return true;
}

function getChatbotRuleById($chatbot_id, $admin_id) {
    $conn = conectar_bd();
    $stmt = $conn->prepare("SELECT * FROM chatbot WHERE id = ? AND admin_id = ?");
    $stmt->execute([$chatbot_id, $admin_id]);
    $rule = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($rule) {
        $stmt_msg = $conn->prepare("SELECT message FROM chatbot_messages WHERE chatbot_id = ?");
        $stmt_msg->execute([$chatbot_id]);
        $messages = $stmt_msg->fetchAll(PDO::FETCH_COLUMN);
        $rule['messages'] = $messages;
    }
    return $rule;
}

function getAllChatbotRulesByAdmin($admin_id) {
     $conn = conectar_bd();
     $stmt = $conn->prepare("SELECT * FROM chatbot WHERE admin_id = ? ORDER BY id DESC");
     $stmt->execute([$admin_id]);
     $rules = $stmt->fetchAll(PDO::FETCH_ASSOC);

     foreach ($rules as $key => $rule) {
        $stmt_msg = $conn->prepare("SELECT message FROM chatbot_messages WHERE chatbot_id = ?");
        $stmt_msg->execute([$rule['id']]);
        $messages = $stmt_msg->fetchAll(PDO::FETCH_COLUMN);
        $rules[$key]['messages'] = $messages;
     }
     return $rules;
}

function incrementChatbotRuleRuns($chatbot_id) {
    $conn = conectar_bd();
    $stmt = $conn->prepare("UPDATE chatbot SET runs = runs + 1 WHERE id = ?");
    $stmt->execute([$chatbot_id]);
}

function deleteChatBotRule($admin_id, $rule_id) {
    $conn = conectar_bd();
    $stmt = $conn->prepare("DELETE FROM chatbot WHERE id = ? AND admin_id = ?");
    $stmt->execute([$rule_id, $admin_id]);
    return $stmt->rowCount() > 0;
}

// ... (Suas outras funes continuam aqui) ...

// =========================================================================
// FUNO DE CRIAR TESTE (CORRIGIDA)
// =========================================================================
function confirme_adicionar_testes(
    $name, $usuario, $senha, $conexoes, $plano_id,
    $revendedor_id, $categoria_id, $forma_pgto_id,
    $obs, $whatsapp, $mac, $key, $id, $horas
) {
    if (empty($usuario) || empty($senha) || empty($plano_id)) {
        return ['title' => 'Erro!', 'msg' => 'Usuario, senha e plano sao obrigatorios.', 'icon' => 'error'];
    }

    try {
        $conexao = conectar_bd();
        $admin_id = $_SESSION['admin_id'];

        // Valida se o plano pertence ao admin da sesso
        $stmt_plano = $conexao->prepare("SELECT id FROM planos WHERE id = :plano_id AND admin_id = :admin_id");
        $stmt_plano->execute([':plano_id' => $plano_id, ':admin_id' => $admin_id]);
        if ($stmt_plano->fetch() === false) {
             return ['title' => 'Erro de Permisso!', 'msg' => 'O plano selecionado no pertence a este administrador.', 'icon' => 'error'];
        }

        $data_vencimento = date("Y-m-d H:i:s", strtotime("+$horas hours"));

        // ==================================================================
        // CORREO APLICADA: A coluna 'obs' foi removida da query INSERT.
        // ==================================================================
        $sql = "INSERT INTO clientes (admin_id, name, usuario, senha, Vencimento, is_trial, Criado_em, plano, conexoes) VALUES (?, ?, ?, ?, ?, 1, NOW(), ?, ?)";
        
        $stmt = $conexao->prepare($sql);
        // Os parmetros tambm foram atualizados para corresponder  nova query.
        $stmt->execute([
            $admin_id, $name, $usuario, $senha, $data_vencimento,
            $plano_id, $conexoes
        ]);

        return ['title' => 'Sucesso!', 'msg' => 'Teste adicionado!', 'icon' => 'success'];

    } catch (Throwable $e) {
        error_log("Erro em confirme_adicionar_testes: " . $e->getMessage());
        return ['title' => 'Erro de Banco de Dados!', 'msg' => 'Falha ao adicionar teste: ' . $e->getMessage(), 'icon' => 'error'];
    }
}
?>

