<?php
ini_set('display_errors', 0);
error_reporting(E_ALL);

if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

if (file_exists("menu.php")) {
    require_once("menu.php");
} else {
    echo '<div class="alert alert-danger">ERRO: menu.php não encontrado.</div>';
}

$api_url = '/api/clientes.php'; 
?>
<!DOCTYPE html>
<html lang="pt-br" data-bs-theme="light">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Gerenciamento de Clientes</title>
    
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
    <link rel="stylesheet" href="//cdn.datatables.net/2.0.7/css/dataTables.dataTables.min.css">
    <style>
        /* Estilos Profissionais */
        div.dataTables_processing { z-index: 1050; background-color: white !important; }
        
        .card-dashboard {
            border: none;
            border-radius: 12px;
            color: #fff;
            position: relative;
            overflow: hidden;
            transition: transform 0.3s ease, box-shadow 0.3s ease;
            height: 100%;
            box-shadow: 0 4px 6px rgba(0,0,0,0.1);
        }
        .card-dashboard:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 20px rgba(0,0,0,0.2) !important;
        }
        .card-dashboard .card-body {
            position: relative;
            z-index: 2;
            padding: 1.5rem;
        }
        .card-dashboard .icon-bg {
            position: absolute;
            right: 15px;
            bottom: 10px;
            font-size: 4rem;
            opacity: 0.2;
            z-index: 1;
            transform: rotate(-10deg);
        }
        .card-dashboard h5 {
            font-size: 0.9rem;
            text-transform: uppercase;
            font-weight: 600;
            opacity: 0.9;
            margin-bottom: 5px;
        }
        .card-dashboard h3 {
            font-size: 2.2rem;
            font-weight: 700;
            margin-bottom: 0;
        }
        
        /* Gradientes Clientes */
        .bg-gradient-success-custom { background: linear-gradient(135deg, #11998e 0%, #38ef7d 100%); }
        .bg-gradient-warning-custom { background: linear-gradient(135deg, #f2994a 0%, #f2c94c 100%); color: #fff !important; }
        .bg-gradient-danger-custom { background: linear-gradient(135deg, #cb2d3e 0%, #ef473a 100%); }

        /* --- AJUSTE MOBILE DE PONTA A PONTA --- */
        @media (max-width: 768px) {
            .mobile-full-width {
                margin-left: -1.5rem !important; 
                margin-right: -1.5rem !important;
                width: calc(100% + 3rem) !important;
                border-radius: 0 !important;
                box-shadow: none !important;
                border-left: 0 !important;
                border-right: 0 !important;
            }
            .mobile-full-width .card-header {
                border-radius: 0 !important;
                padding-left: 1.5rem;
                padding-right: 1.5rem;
            }
            .mobile-full-width .card-body {
                padding: 0; 
            }
            .mobile-full-width .table-responsive {
                border: none !important;
            }
        }
        
        /* TEMA ESCURO */
        [data-theme="dark"] .card { background-color: #2a2e33 !important; color: #e4e6eb !important; border-color: #3a3f44 !important; }
        [data-theme="dark"] .table { color: #e4e6eb !important; border-color: #3a3f44 !important; background-color: transparent !important; }
        [data-theme="dark"] .table th { background-color: #212529 !important; color: #fff !important; border-color: #3a3f44 !important; }
        [data-theme="dark"] .table td { background-color: transparent !important; color: #e4e6eb !important; border-color: #3a3f44 !important; }
    </style>
</head>
<body>

<div class="container-fluid pt-3">
    <div class="row mb-4 g-3">
        <div class="col-md-4">
            <div class="card card-dashboard bg-gradient-success-custom shadow-sm">
                <div class="card-body">
                    <h5>Clientes Ativos</h5>
                    <h3 id="c-ativos"><i class="fas fa-spinner fa-spin fa-xs"></i></h3>
                    <i class="fas fa-users icon-bg"></i>
                </div>
            </div>
        </div>
        
        <div class="col-md-4">
            <div class="card card-dashboard bg-gradient-warning-custom shadow-sm">
                <div class="card-body">
                    <h5>Clientes Vencidos</h5>
                    <h3 id="c-vencidos"><i class="fas fa-spinner fa-spin fa-xs"></i></h3>
                    <i class="fas fa-calendar-xmark icon-bg"></i>
                </div>
            </div>
        </div>
        
        <div class="col-md-4">
            <div class="card card-dashboard bg-gradient-danger-custom shadow-sm">
                <div class="card-body">
                    <h5>Clientes Bloqueados</h5>
                    <h3 id="c-bloqueados"><i class="fas fa-spinner fa-spin fa-xs"></i></h3>
                    <i class="fas fa-user-slash icon-bg"></i>
                </div>
            </div>
        </div>
    </div>

    <div class="card shadow border-0 mobile-full-width" style="border-radius: 12px;">
        <div class="card-header d-flex justify-content-between align-items-center flex-wrap gap-2 bg-white border-bottom py-3">
            <h4 class="mb-0 text-secondary fw-bold"><i class="fas fa-user-tag me-2"></i>Gerenciar Clientes</h4>
            <div class="d-flex gap-2 align-items-center">
                <select id="filtro_revenda" class="form-select form-select-sm shadow-none" style="width: auto; min-width: 200px; border-radius: 20px;">
                    <option value="">Meus Clientes</option>
                </select>
                <button class="btn btn-primary btn-sm text-nowrap shadow-sm rounded-pill px-3" onclick="modal_master('<?php echo $api_url; ?>', 'adicionar_clientes')">
                    <i class="fas fa-plus-circle me-1"></i> Novo Cliente
                </button>
            </div>
        </div>
        <div class="card-body p-0"> <div class="table-responsive">
                <table id="tabela_clientes_v3" class="table table-hover align-middle mb-0" style="width:100%">
                    <thead class="table-light">
                        <tr>
                            <th class="ps-3">#</th>
                            <th>Nome</th>
                            <th>Usuário</th>
                            <th>Status</th>
                            <th>Vencimento</th>
                            <th class="text-end pe-3" style="min-width: 160px;">Ações</th>
                        </tr>
                    </thead>
                    <tbody></tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="modal_master" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header" id="modal_master-header">
                <h5 class="modal-title" id="modal_master-titulo"></h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div id="modal_master-body" class="modal-body"></div>
            <div id="modal_master-footer" class="modal-footer"></div>
        </div>
    </div>
</div>

<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<script src="//cdn.datatables.net/2.0.7/js/dataTables.js"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script src="/js/app.js"></script> 

<script>
/**
 * GERADOR DE SENHA E USUÁRIO ALEATÓRIO
 */
window.gerarDadosAcesso = function() {
    const chars = 'abcdefghijklmnopqrstuvwxyz0123456789';
    const rand = (length) => {
        let result = '';
        for (let i = 0; i < length; i++) result += chars.charAt(Math.floor(Math.random() * chars.length));
        return result;
    };
    
    // Gera usuario e senha (8 caracteres)
    $('input[name="usuario"]').val(rand(8));
    $('input[name="senha"]').val(rand(8));
};

/**
 * SOBRESCREVE A FUNÇÃO DE ENVIO DO PAINEL
 */
window.enviarFormulario = function(formId, urlApi) {
    var formData = $('#' + formId).serialize();
    $('#modal_master').modal('hide');
    
    Swal.fire({ title: 'Processando...', didOpen: () => { Swal.showLoading() } });

    $.ajax({
        type: "POST",
        url: urlApi,
        data: formData,
        dataType: "json",
        success: function(res) {
            if (res.icon === 'success' || (res.title && res.title.toLowerCase().includes('sucesso'))) {
                if(window.tabelaClientes) window.tabelaClientes.ajax.reload(null, false);
                window.atualizarCardsGlobais();

                // SE TIVER MENSAGEM DE RETORNO (Criação/Renovação), MOSTRA OS BOTÕES
                if (res.dados_cliente_msg) {
                    const msgEncoded = encodeURIComponent(res.dados_cliente_msg);
                    const htmlContent = `
                        <textarea id="txtMsgFinal" class="form-control" rows="6" style="font-size:0.9rem">${res.dados_cliente_msg}</textarea>
                        <div class="mt-3 d-flex gap-2 justify-content-center">
                            <button class="btn btn-primary" onclick="navigator.clipboard.writeText(document.getElementById('txtMsgFinal').value); const Toast = Swal.mixin({toast: true, position: 'top-end', showConfirmButton: false, timer: 2000}); Toast.fire({icon: 'success', title: 'Copiado!'});"><i class="fas fa-copy"></i> Copiar</button>
                            <a href="https://wa.me/?text=${msgEncoded}" target="_blank" class="btn btn-success"><i class="fab fa-whatsapp"></i> WhatsApp</a>
                        </div>
                    `;
                    
                    Swal.fire({
                        icon: 'success',
                        title: res.title || 'Sucesso!',
                        html: htmlContent,
                        showConfirmButton: false,
                        showCloseButton: true
                    });
                } else {
                    Swal.fire({ icon: 'success', title: res.title, text: res.msg, showConfirmButton: true });
                }

            } else {
                Swal.fire({ icon: res.icon || 'error', title: res.title || 'Erro', text: res.msg || 'Erro inesperado.' });
            }
        },
        error: function(xhr) {
            Swal.fire('Erro no Servidor', xhr.responseText, 'error');
        }
    });
};

$(document).ready(function() {
    const API = '<?php echo $api_url; ?>';

    // 1. TABELA
    window.tabelaClientes = $('#tabela_clientes_v3').DataTable({
        "processing": true,
        "serverSide": true,
        "destroy": true,
        "ajax": {
            "url": API + "?listar_clientes=1",
            "type": "POST",
            "data": function(d) { d.filtro_revenda = $('#filtro_revenda').val(); },
            "dataSrc": function(json) { return json.data || []; }
        },
        "columns": [
            { "data": "id", "className": "ps-3" }, // Padding na esquerda
            { "data": "name" },
            { "data": "usuario" },
            { "data": "status" },
            { "data": "vencimento" },
            { "data": "acao", "orderable": false, "searchable": false, "className": "text-end pe-3" } // Padding na direita
        ],
        "language": { "url": "//cdn.datatables.net/plug-ins/2.0.7/i18n/pt-BR.json" },
        "order": [[ 0, "desc" ]]
    });

    // 2. CARDS
    window.atualizarCardsGlobais = function() {
        $.getJSON(API, { acao: 'obter_contagens', _: new Date().getTime() }, function(res) {
            $('#c-ativos').text(res.ativos ?? 0);
            $('#c-vencidos').text(res.vencidos ?? 0);
            $('#c-bloqueados').text(res.bloqueados ?? 0);
        });
    };

    // 3. FILTROS
    $.getJSON(API, { acao: 'listar_revendedores' }, function(res) {
        const sel = $('#filtro_revenda');
        sel.empty();
        sel.append('<option value="">Meus Clientes (Padrão)</option>');
        sel.append('<option value="todos">--- Ver Todos (Admin) ---</option>');
        if(res.data) res.data.forEach(r => sel.append(`<option value="${r.id}">${r.user}</option>`));
    });

    $('#filtro_revenda').change(function() { window.tabelaClientes.ajax.reload(); });
    window.atualizarCardsGlobais();
    document.documentElement.setAttribute('data-bs-theme', localStorage.getItem('theme') || 'light');
});
</script>
</body>
</html>