<?php
// Inclui o cabeçalho e menu do seu painel principal
require_once 'menu.php';

// --- LÓGICA PHP ATUALIZADA ---
require_once './api/controles/db.php'; 

// Inicializa a variável como uma lista vazia para evitar erros
$clientes_p2p = [];
$template_p2p_atual = ''; // Inicializa a variável do template

$conexao = conectar_bd();
if ($conexao) {
    try {
        // Busca o template de mensagem para usar no botão "Ver Informações"
        $stmt_template = $conexao->prepare("SELECT valor FROM configuracoes WHERE chave = 'p2p_message_template' LIMIT 1");
        $stmt_template->execute();
        $template_p2p_atual = $stmt_template->fetchColumn();

        // A query filtra para planos que NÃO SÃO 'Teste P2P'
        $sql = "SELECT id, usuario, name, whatsapp, Vencimento FROM clientes WHERE is_p2p = 1 AND plano <> 'Teste P2P'";
        $params = [];

        // Filtro para revendedores
        if (isset($_SESSION['nivel_admin']) && $_SESSION['nivel_admin'] == 0) {
            $sql .= " AND admin_id = :admin_id";
            $params[':admin_id'] = $_SESSION['admin_id'];
        }
        
        $sql .= " ORDER BY id DESC";

        $stmt = $conexao->prepare($sql);
        $stmt->execute($params);
        $clientes_p2p = $stmt->fetchAll(PDO::FETCH_ASSOC);

    } catch(PDOException $e) {
        // Em caso de erro, as variáveis continuarão vazias, evitando o erro na tabela.
    }
}
?>

<style>
    /* 1. Define as cores padrão (TEMA CLARO) */
    .card {
        color: #212529; 
    }
    .table {
        color: #212529; 
        background-color: #fff; /* Fundo da tabela claro */
    }
    /* Cor da linha listrada (claro) */
    .table-striped > tbody > tr:nth-of-type(odd) > * {
         --bs-table-accent-bg: rgba(0, 0, 0, 0.05);
    }
    /* Cor do hover (claro) */
    .table-hover > tbody > tr:hover > * {
         --bs-table-accent-bg: rgba(0, 0, 0, 0.075);
    }


    /* 2. Sobrescreve para o TEMA ESCURO */
    [data-theme="dark"] .card {
        background-color: #2a2e33 !important; 
        color: #e4e6eb !important; 
        border-color: #3a3f44 !important;
    }
    
    /* [CORREÇÃO] Força a tabela e seus filhos a terem fundo transparente e texto claro */
    [data-theme="dark"] .table,
    [data-theme="dark"] .table th,
    [data-theme="dark"] .table td {
        background-color: transparent !important; /* Fundo transparente para pegar a cor do card */
        color: #e4e6eb !important; /* Texto claro */
        border-color: #3a3f44 !important;
    }
    
    /* [CORREÇÃO LISTRAS] Define a cor da linha listrada (ímpar) no tema escuro */
    [data-theme="dark"] .table-striped > tbody > tr:nth-of-type(odd) > * {
        --bs-table-accent-bg: rgba(255, 255, 255, 0.05) !important; 
        color: #e4e6eb !important;
    }
    
    /* [CORREÇÃO HOVER] Define o fundo do hover no tema escuro */
    [data-theme="dark"] .table-hover > tbody > tr:hover > * {
        --bs-table-accent-bg: rgba(255, 255, 255, 0.1) !important; 
        color: #e4e6eb !important;
    }

    /* Garante que o cabeçalho (thead) fique com o fundo azul */
    [data-theme="dark"] .table > thead.bg-primary {
         background-color: #0d6efd !important; 
         color: #fff !important; 
    }
</style>
<div class="container-fluid py-4">
    <div class="card shadow-sm border-0 rounded-3 p-4">
        
        <h4 class="card-title text-primary d-flex justify-content-between align-items-center mb-4">
            <span class="fw-bold">Gerenciar Clientes P2P</span>
            <div>
                <a href="p2p_criar.php" class="btn btn-primary rounded-pill"><i class="fas fa-plus me-2"></i> Adicionar Cliente</a>
                <?php if (isset($_SESSION['nivel_admin']) && $_SESSION['nivel_admin'] == 1): ?>
                <a href="p2p_config.php" class="btn btn-secondary rounded-pill"><i class="fas fa-cogs me-2"></i> Configurações</a>
                <?php endif; ?>
            </div>
        </h4>
        
        <?php if (isset($_SESSION['mensagem'])): ?>
            <div class="alert <?php echo strpos($_SESSION['msg_type'], 'success') !== false ? 'alert-success' : 'alert-danger'; ?> alert-dismissible fade show" role="alert">
                <?php echo $_SESSION['mensagem']; ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        <?php unset($_SESSION['mensagem']); unset($_SESSION['msg_type']); ?>
        <?php endif; ?>

        <div class="table-responsive">
            <table class="display table table-striped table-hover border" style="width: 100%;">
                <thead class="bg-primary text-white">
                    <tr>
                        <th>#</th>
                        <th>Nome / Descrição</th>
                        <th>Código (Usuário)</th>
                        <th>Vencimento</th>
                        <th class="text-end">Ações</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (!empty($clientes_p2p)): ?>
                        <?php foreach ($clientes_p2p as $cliente): ?>
                            <tr>
                                <td><?php echo $cliente['id']; ?></td>
                                <td><?php echo htmlspecialchars($cliente['name']); ?></td>
                                <td><?php echo htmlspecialchars($cliente['usuario']); ?></td>
                                <td><?php echo date('d/m/Y H:i', strtotime($cliente['Vencimento'])); ?></td>
                                <td class="text-end">
                                    
                                    <button class="btn btn-info btn-sm rounded-circle" style="width: 32px; height: 32px; line-height: 1.5;" title="Ver Informações"
                                        onclick="exibirModalP2P('Informações do Cliente', 
                                        `<?php 
                                            $venc_fmt = date('d/m/Y H:i', strtotime($cliente['Vencimento']));
                                            $mensagem_pronta = str_replace(
                                                ['#cliente#', '#codigo#', '#vencimento#'], 
                                                [htmlspecialchars($cliente['name']), $cliente['usuario'], $venc_fmt], 
                                                $template_p2p_atual
                                            );
                                            echo addslashes($mensagem_pronta); 
                                        ?>`, 
                                        '<?php echo $cliente['whatsapp']; // Adiciona o número de WhatsApp ?>')">
                                        <i class="fas fa-eye"></i>
                                    </button>

                                    <a href="p2p_renovar.php?id=<?php echo $cliente['id']; ?>" class="btn btn-warning btn-sm rounded-circle" style="width: 32px; height: 32px; line-height: 1.5;" title="Renovar"><i class="fas fa-sync-alt"></i></a>
                                    <a href="action_p2p_excluir.php?id=<?php echo $cliente['id']; ?>&from=codigos_p2p.php" class="btn btn-danger btn-sm rounded-circle" style="width: 32px; height: 32px; line-height: 1.5;" title="Excluir" onclick="return confirm('Tem certeza que deseja excluir este cliente?');"><i class="fas fa-trash"></i></a>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <tr>
                            <td colspan="5" class="text-center">Nenhum cliente P2P encontrado.</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<?php
require_once 'footer.php';
?>

<script>
function exibirModalP2P(title, message, whatsappNumber) {
    // Remove as barras invertidas que o addslashes() colocou
    const cleanMessage = message.replace(/\\'/g, "'").replace(/\\"/g, '"').replace(/\\`/g, '`');

    Swal.fire({
        title: title,
        html: `<pre style="white-space: pre-wrap; text-align: left; font-size: 0.9rem;">${cleanMessage}</pre>`,
        icon: 'info',
        showCancelButton: true,
        confirmButtonText: '<i class="fas fa-copy"></i> Copiar',
        cancelButtonText: '<i class="fab fa-whatsapp"></i> WhatsApp',
        confirmButtonColor: '#0d6efd',
        cancelButtonColor: '#25D366',
        reverseButtons: true // Coloca o botão de WhatsApp à esquerda
    }).then((result) => {
        if (result.isConfirmed) {
            // Ação de Copiar
            navigator.clipboard.writeText(cleanMessage).then(() => {
                Swal.fire('Copiado!', 'A mensagem foi copiada para a área de transferência.', 'success');
            }).catch(err => {
                Swal.fire('Erro!', 'Não foi possível copiar a mensagem.', 'error');
            });
        } else if (result.dismiss === Swal.DismissReason.cancel) {
            // Ação de WhatsApp
            if (whatsappNumber && whatsappNumber.trim() !== '') {
                const encodedMessage = encodeURIComponent(cleanMessage);
                const whatsappURL = `https://api.whatsapp.com/send?phone=${whatsappNumber}&text=${encodedMessage}`;
                window.open(whatsappURL, '_blank');
            } else {
                Swal.fire('Atenção!', 'O cliente não tem um número de WhatsApp cadastrado.', 'warning');
            }
        }
    });
}

document.addEventListener('DOMContentLoaded', function() {
    <?php
    if (isset($_SESSION['show_p2p_modal_message'])) {
        echo "exibirModalP2P('" . addslashes($_SESSION['show_p2p_modal_title']) . "', `" . addslashes($_SESSION['show_p2p_modal_message']) . "`, '');";
        unset($_SESSION['show_p2p_modal_message']);
        unset($_SESSION['show_p2p_modal_title']);
    }
    ?>
});
</script>