<?php
// =======================================================================
// 1. LÓGICA DE SALVAR (Deve ficar ANTES de qualquer HTML ou menu.php)
// =======================================================================
session_start(); // Inicia a sessão para garantir acesso às variáveis de admin
require_once './api/controles/db.php'; 

// Verifica se é uma requisição AJAX para salvar o pacote
if (isset($_POST['acao']) && $_POST['acao'] == 'salvar_pacote_p2p') {
    // Limpa qualquer lixo de memória anterior
    ob_clean(); 
    header('Content-Type: application/json');
    
    $conexao = conectar_bd();
    $cliente_id = intval($_POST['cliente_id']);
    $bouquet_id = intval($_POST['bouquet_id']);
    
    // Verificação básica de segurança (se está logado)
    if (!isset($_SESSION['admin_id'])) {
        echo json_encode(['erro' => true, 'msg' => 'Sessão expirada. Atualize a página.']);
        exit;
    }

    if ($cliente_id > 0 && $bouquet_id > 0) {
        try {
            // Atualiza o pacote
            $stmt = $conexao->prepare("UPDATE clientes SET bouquet_id = :bouquet_id WHERE id = :id");
            $stmt->execute([':bouquet_id' => $bouquet_id, ':id' => $cliente_id]);
            
            // (Opcional) Se quiser atualizar o 'is_p2p' para garantir
            // $conexao->prepare("UPDATE clientes SET is_p2p = 1 WHERE id = ?")->execute([$cliente_id]);

            echo json_encode(['erro' => false, 'msg' => 'Pacote alterado com sucesso!']);
        } catch (Exception $e) {
            echo json_encode(['erro' => true, 'msg' => 'Erro SQL: ' . $e->getMessage()]);
        }
    } else {
        echo json_encode(['erro' => true, 'msg' => 'Dados inválidos (ID ou Pacote zerado).']);
    }
    exit; // <--- IMPORTANTE: Mata o script aqui para não carregar o HTML do menu
}

// =======================================================================
// 2. CARREGAMENTO DA PÁGINA HTML (Menu, Tabelas, etc)
// =======================================================================
require_once 'menu.php';

// --- LÓGICA DE EXIBIÇÃO ---
$clientes_p2p = [];
$lista_bouquets = []; 
$template_p2p_atual = '';
$cont_p2p_ativos = 0;
$cont_p2p_vencidos = 0;
$cont_p2p_bloqueados = 0;

$conexao = conectar_bd(); // Reconecta ou usa conexão existente
if ($conexao) {
    try {
        // 1. BUSCAR LISTA DE PACOTES (BOUQUETS)
        $stmt_bouquets = $conexao->prepare("SELECT id, bouquet_name FROM bouquets ORDER BY bouquet_name ASC");
        $stmt_bouquets->execute();
        $lista_bouquets = $stmt_bouquets->fetchAll(PDO::FETCH_ASSOC);

        // Busca template de mensagem
        $stmt_template = $conexao->prepare("SELECT valor FROM configuracoes WHERE chave = 'p2p_message_template' LIMIT 1");
        $stmt_template->execute();
        $template_p2p_atual = $stmt_template->fetchColumn();

        // ==================================================
        // ### LÓGICA DE CONTAGEM ###
        // ==================================================
        
        $agora_php = date("Y-m-d H:i:s");
        $sql_base_p2p = " FROM clientes WHERE is_p2p = 1 AND plano <> 'Teste P2P'";
        $params_contagem = [];

        if (isset($_SESSION['nivel_admin']) && $_SESSION['nivel_admin'] == 0) {
            $sql_base_p2p .= " AND admin_id = :admin_id";
            $params_contagem[':admin_id'] = $_SESSION['admin_id'];
        }

        // Contagens
        $sql_ativos = "SELECT COUNT(*) " . $sql_base_p2p . " AND (is_banned IS NULL OR is_banned = 0) AND Vencimento >= :agora";
        $stmt_ativos = $conexao->prepare($sql_ativos);
        $stmt_ativos->execute(array_merge($params_contagem, [':agora' => $agora_php]));
        $cont_p2p_ativos = $stmt_ativos->fetchColumn();

        $sql_vencidos = "SELECT COUNT(*) " . $sql_base_p2p . " AND (is_banned IS NULL OR is_banned = 0) AND Vencimento < :agora";
        $stmt_vencidos = $conexao->prepare($sql_vencidos);
        $stmt_vencidos->execute(array_merge($params_contagem, [':agora' => $agora_php]));
        $cont_p2p_vencidos = $stmt_vencidos->fetchColumn();
        
        $sql_bloqueados = "SELECT COUNT(*) " . $sql_base_p2p . " AND is_banned = 1";
        $stmt_bloqueados = $conexao->prepare($sql_bloqueados);
        $stmt_bloqueados->execute($params_contagem);
        $cont_p2p_bloqueados = $stmt_bloqueados->fetchColumn();
        
        // ==================================================
        // ### LÓGICA DA TABELA (COM JOIN PACOTES) ###
        // ==================================================
        $sql = "SELECT c.id, c.usuario, c.name, c.whatsapp, c.Vencimento, c.is_banned, c.bouquet_id, b.bouquet_name 
                FROM clientes c 
                LEFT JOIN bouquets b ON c.bouquet_id = b.id 
                WHERE c.is_p2p = 1 AND c.plano <> 'Teste P2P'";
        
        $params = [];

        if (isset($_SESSION['nivel_admin']) && $_SESSION['nivel_admin'] == 0) {
            $sql .= " AND c.admin_id = :admin_id";
            $params[':admin_id'] = $_SESSION['admin_id'];
        }
        
        $sql .= " ORDER BY c.id DESC";

        $stmt = $conexao->prepare($sql);
        $stmt->execute($params);
        $clientes_p2p = $stmt->fetchAll(PDO::FETCH_ASSOC);

    } catch(PDOException $e) {
        error_log("Erro na página P2P: " . $e->getMessage());
    }
}
?>

<style>
    /* MANTIVE OS MESMOS ESTILOS */
    .card { color: #212529; }
    .table { color: #212529; background-color: #fff; }
    .table-striped > tbody > tr:nth-of-type(odd) > * { --bs-table-accent-bg: rgba(0, 0, 0, 0.05); }
    .table-hover > tbody > tr:hover > * { --bs-table-accent-bg: rgba(0, 0, 0, 0.075); }
    [data-theme="dark"] .card { background-color: #2a2e33 !important; color: #e4e6eb !important; border-color: #3a3f44 !important; }
    [data-theme="dark"] .table, [data-theme="dark"] .table th, [data-theme="dark"] .table td { background-color: transparent !important; color: #e4e6eb !important; border-color: #3a3f44 !important; }
    [data-theme="dark"] .table-striped > tbody > tr:nth-of-type(odd) > * { --bs-table-accent-bg: rgba(255, 255, 255, 0.05) !important; color: #e4e6eb !important; }
    [data-theme="dark"] .table-hover > tbody > tr:hover > * { --bs-table-accent-bg: rgba(255, 255, 255, 0.1) !important; color: #e4e6eb !important; }
    [data-theme="dark"] .table > thead.bg-primary { background-color: #0d6efd !important; color: #fff !important; }
    
    /* CARDS E BADGES */
    .stat-card { border: none; border-left-width: 5px; border-left-style: solid; box-shadow: 0 4px 12px rgba(0, 0, 0, 0.05); transition: transform 0.2s ease, box-shadow 0.2s ease; border-radius: 8px; }
    .stat-card:hover { transform: translateY(-5px); box-shadow: 0 6px 16px rgba(0, 0, 0, 0.08); }
    .stat-card .card-body { display: flex; justify-content: space-between; align-items: center; padding: 1.5rem; }
    .stat-info .stat-label { font-size: 0.9rem; color: #adb5bd; text-transform: uppercase; font-weight: 700; }
    .stat-info .stat-value { font-size: 2.25rem; font-weight: 700; margin: 0; color: var(--bs-heading-color); }
    .stat-icon { font-size: 3.5rem; opacity: 0.15; }
    
    .stat-card.card-p2p-ativos { border-color: #0d6efd; }
    .stat-card.card-p2p-ativos .stat-label, .stat-card.card-p2p-ativos .stat-icon { color: #0d6efd; }
    .stat-card.card-p2p-vencidos { border-color: #ffc107; }
    .stat-card.card-p2p-vencidos .stat-label, .stat-card.card-p2p-vencidos .stat-icon { color: #ffc107; }
    .stat-card.card-p2p-bloqueados { border-color: #dc3545; }
    .stat-card.card-p2p-bloqueados .stat-label, .stat-card.card-p2p-bloqueados .stat-icon { color: #dc3545; }
    
    .status-badge { padding: .3em .6em; border-radius: .375rem; font-size: 0.75em; font-weight: bold; text-transform: uppercase; display: inline-block; white-space: nowrap; line-height: 1; text-align: center; }
    .status-badge.status-ativo { background-color: #d4edda; color: #155724; }
    .status-badge.status-expirado { background-color: #fff3cd; color: #664d03; }
    .status-badge.status-bloqueado { background-color: #f8d7da; color: #721c24; }
    [data-theme="dark"] .status-badge.status-ativo { background-color: #198754; color: #fff; }
    [data-theme="dark"] .status-badge.status-expirado { background-color: #ffc107; color: #000; }
    [data-theme="dark"] .status-badge.status-bloqueado { background-color: #dc3545; color: #fff; }
</style>

<div class="container-fluid py-4">

    <div class="row mb-4">
        <div class="col-md-4 mb-4">
            <div class="card stat-card card-p2p-ativos h-100">
                <div class="card-body">
                    <div class="stat-info">
                        <div class="stat-label">Clientes P2P Ativos</div>
                        <p class="stat-value"><?php echo $cont_p2p_ativos; ?></p>
                    </div>
                    <div class="stat-icon"><i class="fa-solid fa-user-check"></i></div>
                </div>
            </div>
        </div>
        <div class="col-md-4 mb-4">
            <div class="card stat-card card-p2p-vencidos h-100">
                <div class="card-body">
                    <div class="stat-info">
                        <div class="stat-label">Clientes P2P Vencidos</div>
                        <p class="stat-value"><?php echo $cont_p2p_vencidos; ?></p>
                    </div>
                    <div class="stat-icon"><i class="fa-solid fa-user-clock"></i></div>
                </div>
            </div>
        </div>
        <div class="col-md-4 mb-4">
            <div class="card stat-card card-p2p-bloqueados h-100">
                <div class="card-body">
                    <div class="stat-info">
                        <div class="stat-label">Clientes P2P Bloqueados</div>
                        <p class="stat-value"><?php echo $cont_p2p_bloqueados; ?></p>
                    </div>
                    <div class="stat-icon"><i class="fa-solid fa-user-lock"></i></div>
                </div>
            </div>
        </div>
    </div>

    <div class="card shadow-sm border-0 rounded-3 p-4">
        
        <h4 class="card-title text-primary d-flex justify-content-between align-items-center mb-4">
            <span class="fw-bold">Gerenciar Clientes P2P</span>
            <div>
                <a href="p2p_criar.php" class="btn btn-primary rounded-pill"><i class="fas fa-plus me-2"></i> Adicionar Cliente</a>
                <?php if (isset($_SESSION['nivel_admin']) && $_SESSION['nivel_admin'] == 1): ?>
                <a href="p2p_config.php" class="btn btn-secondary rounded-pill"><i class="fas fa-cogs me-2"></i> Configurações</a>
                <?php endif; ?>
            </div>
        </h4>
        
        <?php if (isset($_SESSION['mensagem'])): ?>
            <div class="alert <?php echo strpos($_SESSION['msg_type'], 'success') !== false ? 'alert-success' : 'alert-danger'; ?> alert-dismissible fade show" role="alert">
                <?php echo $_SESSION['mensagem']; ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        <?php unset($_SESSION['mensagem']); unset($_SESSION['msg_type']); ?>
        <?php endif; ?>

        <div class="table-responsive">
            <table class="display table table-striped table-hover border" style="width: 100%;">
                <thead class="bg-primary text-white">
                    <tr>
                        <th>#</th>
                        <th>Nome / Descrição</th>
                        <th>Pacote Atual</th> <th>Código (Usuário)</th>
                        <th>Vencimento</th>
                        <th>Status</th> 
                        <th class="text-end">Ações</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (!empty($clientes_p2p)): ?>
                        <?php foreach ($clientes_p2p as $cliente): ?>
                            <?php
                                $is_banned = isset($cliente['is_banned']) ? $cliente['is_banned'] : 0;
                                $id = $cliente['id'];
                                $vencimento_time = strtotime($cliente['Vencimento']);
                                // Define nome do pacote ou avisa se está sem
                                $nome_pacote = !empty($cliente['bouquet_name']) ? $cliente['bouquet_name'] : '<span class="text-danger fw-bold">SEM PACOTE</span>';
                                $id_pacote_atual = !empty($cliente['bouquet_id']) ? $cliente['bouquet_id'] : 0;
                            ?>
                            <tr>
                                <td><?php echo $id; ?></td>
                                <td><?php echo htmlspecialchars($cliente['name']); ?></td>
                                
                                <td><?php echo $nome_pacote; ?></td>

                                <td><?php echo htmlspecialchars($cliente['usuario']); ?></td>
                                <td><?php echo date('d/m/Y H:i', $vencimento_time); ?></td>
                                
                                <td>
                                    <?php
                                        if ($is_banned == 1) {
                                            echo '<span class="status-badge status-bloqueado">Bloqueado</span>';
                                        } elseif ($vencimento_time < time()) {
                                            echo '<span class="status-badge status-expirado">Expirado</span>';
                                        } else {
                                            echo '<span class="status-badge status-ativo">Ativo</span>';
                                        }
                                    ?>
                                </td>
                                <td class="text-end">
                                    
                                    <button class="btn btn-secondary btn-sm rounded-circle" style="width: 32px; height: 32px; line-height: 1.5;" title="Alterar Pacote"
                                        onclick="modalEditarPacote(<?php echo $id; ?>, '<?php echo htmlspecialchars($cliente['usuario']); ?>', <?php echo $id_pacote_atual; ?>)">
                                        <i class="fas fa-box-open"></i>
                                    </button>

                                    <button class="btn btn-info btn-sm rounded-circle" style="width: 32px; height: 32px; line-height: 1.5;" title="Ver Informações"
                                        onclick="exibirModalP2P('Informações do Cliente', 
                                        `<?php 
                                            $venc_fmt = date('d/m/Y H:i', $vencimento_time);
                                            $mensagem_pronta = str_replace(
                                                ['#cliente#', '#codigo#', '#vencimento#'], 
                                                [htmlspecialchars($cliente['name']), $cliente['usuario'], $venc_fmt], 
                                                $template_p2p_atual
                                            );
                                            echo addslashes($mensagem_pronta); 
                                        ?>`, 
                                        '<?php echo $cliente['whatsapp']; ?>')">
                                        <i class="fas fa-eye"></i>
                                    </button>

                                    <a href="p2p_renovar.php?id=<?php echo $id; ?>" class="btn btn-warning btn-sm rounded-circle" style="width: 32px; height: 32px; line-height: 1.5;" title="Renovar"><i class="fas fa-sync-alt"></i></a>
                                    
                                    <?php if ($is_banned == 1): ?>
                                        <button class="btn btn-outline-success btn-sm rounded-circle" style="width: 32px; height: 32px; line-height: 1.5;" title="Desbloquear"
                                            onclick="modalBloquearP2P('<?php echo $id; ?>', '<?php echo htmlspecialchars($cliente['usuario']); ?>', 1)">
                                            <i class="fas fa-unlock"></i>
                                        </button>
                                    <?php else: ?>
                                        <button class="btn btn-outline-danger btn-sm rounded-circle" style="width: 32px; height: 32px; line-height: 1.5;" title="Bloquear"
                                            onclick="modalBloquearP2P('<?php echo $id; ?>', '<?php echo htmlspecialchars($cliente['usuario']); ?>', 0)">
                                            <i class="fas fa-lock"></i>
                                        </button>
                                    <?php endif; ?>

                                    <a href="action_p2p_excluir.php?id=<?php echo $id; ?>&from=codigos_p2p.php" class="btn btn-danger btn-sm rounded-circle" style="width: 32px; height: 32px; line-height: 1.5;" title="Excluir" onclick="return confirm('Tem certeza que deseja excluir este cliente?');"><i class="fas fa-trash"></i></a>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <tr>
                            <td colspan="7" class="text-center">Nenhum cliente P2P encontrado.</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<?php
require_once 'footer.php';
?>

<script>
// Passa a lista de pacotes do PHP para o JavaScript
const listaBouquets = <?php echo json_encode($lista_bouquets); ?>;

// Função para abrir o modal de edição de pacote
function modalEditarPacote(id, usuario, bouquetAtualId) {
    let options = '<option value="" disabled>Selecione um pacote...</option>';
    listaBouquets.forEach(pacote => {
        const selected = (pacote.id == bouquetAtualId) ? 'selected' : '';
        options += `<option value="${pacote.id}" ${selected}>${pacote.bouquet_name}</option>`;
    });

    Swal.fire({
        title: 'Alterar Pacote',
        html: `
            <p>Cliente: <strong>${usuario}</strong></p>
            <label class="form-label">Selecione o novo pacote:</label>
            <select id="swal-input-bouquet" class="form-select">
                ${options}
            </select>
        `,
        showCancelButton: true,
        confirmButtonText: 'Salvar',
        cancelButtonText: 'Cancelar',
        preConfirm: () => {
            const novoBouquet = document.getElementById('swal-input-bouquet').value;
            if (!novoBouquet) {
                Swal.showValidationMessage('Você precisa selecionar um pacote');
            }
            return novoBouquet;
        }
    }).then((result) => {
        if (result.isConfirmed) {
            const novoBouquetId = result.value;
            
            $.ajax({
                url: window.location.href,
                type: 'POST',
                data: {
                    acao: 'salvar_pacote_p2p',
                    cliente_id: id,
                    bouquet_id: novoBouquetId
                },
                dataType: 'json',
                success: function(res) {
                    if (!res.erro) {
                        Swal.fire('Sucesso!', res.msg, 'success').then(() => {
                            location.reload();
                        });
                    } else {
                        Swal.fire('Erro!', res.msg, 'error');
                    }
                },
                error: function(xhr, status, error) {
                    console.error("Resposta do servidor:", xhr.responseText); // Ajuda a debugar se der erro de novo
                    Swal.fire('Erro!', 'Falha na comunicação com o servidor (Verifique o Console).', 'error');
                }
            });
        }
    });
}

// Demais funções (Copiar, Bloquear)
function exibirModalP2P(title, message, whatsappNumber) {
    const cleanMessage = message.replace(/\\'/g, "'").replace(/\\"/g, '"').replace(/\\`/g, '`');

    Swal.fire({
        title: title,
        html: `<pre style="white-space: pre-wrap; text-align: left; font-size: 0.9rem;">${cleanMessage}</pre>`,
        icon: 'info',
        showCancelButton: true,
        confirmButtonText: '<i class="fas fa-copy"></i> Copiar',
        cancelButtonText: '<i class="fab fa-whatsapp"></i> WhatsApp',
        confirmButtonColor: '#0d6efd',
        cancelButtonColor: '#25D366',
        reverseButtons: true 
    }).then((result) => {
        if (result.isConfirmed) {
            navigator.clipboard.writeText(cleanMessage).then(() => {
                Swal.fire('Copiado!', 'A mensagem foi copiada para a área de transferência.', 'success');
            }).catch(err => {
                Swal.fire('Erro!', 'Não foi possível copiar a mensagem.', 'error');
            });
        } else if (result.dismiss === Swal.DismissReason.cancel) {
            if (whatsappNumber && whatsappNumber.trim() !== '') {
                const encodedMessage = encodeURIComponent(cleanMessage);
                const whatsappURL = `https://api.whatsapp.com/send?phone=${whatsappNumber}&text=${encodedMessage}`;
                window.open(whatsappURL, '_blank');
            } else {
                Swal.fire('Atenção!', 'O cliente não tem um número de WhatsApp cadastrado.', 'warning');
            }
        }
    });
}

function modalBloquearP2P(clienteId, clienteUsuario, isBanned) {
    const acaoTexto = isBanned ? "DESBLOQUEAR" : "BLOQUEAR";
    const acaoIcon = isBanned ? "success" : "warning";
    const acaoBtn = isBanned ? "Sim, desbloquear!" : "Sim, bloquear!";
    const acaoBtnColor = isBanned ? '#198754' : '#dc3545';

    Swal.fire({
        title: acaoTexto + ' CLIENTE',
        html: `Tem certeza que deseja <strong>${acaoTexto}</strong> o cliente (<strong>${clienteUsuario}</strong>)?`,
        icon: acaoIcon,
        showCancelButton: true,
        confirmButtonText: acaoBtn,
        cancelButtonText: 'Cancelar',
        confirmButtonColor: acaoBtnColor,
        reverseButtons: true
    }).then((result) => {
        if (result.isConfirmed) {
            Swal.fire({
                title: 'A processar...',
                allowOutsideClick: false,
                didOpen: () => { Swal.showLoading(); }
            });

            $.ajax({
                url: '/api/clientes.php', 
                type: 'POST',
                data: {
                    confirme_toggle_bloqueio_cliente: clienteId 
                },
                dataType: 'json',
                success: function(response) {
                    if (response && response.icon === 'success') {
                        Swal.fire(response.title, response.msg, 'success').then(() => {
                            location.reload(); 
                        });
                    } else {
                        Swal.fire(response.title || 'Erro!', response.msg || 'Não foi possível completar a ação.', 'error');
                    }
                },
                error: function(xhr) {
                    console.error("Erro AJAX:", xhr.responseText);
                    Swal.fire('Erro de Comunicação!', 'Não foi possível contactar a API.', 'error');
                }
            });
        }
    });
}

document.addEventListener('DOMContentLoaded', function() {
    <?php
    if (isset($_SESSION['show_p2p_modal_message'])) {
        echo "exibirModalP2P('" . addslashes($_SESSION['show_p2p_modal_title']) . "', `" . addslashes($_SESSION['show_p2p_modal_message']) . "`, '');";
        unset($_SESSION['show_p2p_modal_message']);
        unset($_SESSION['show_p2p_modal_title']);
    }
    ?>
});
</script>