<?php
// ARQUIVO: Monitor Usuários Online em Tempo Real (Final)
require_once("menu.php");
require_once("api/controles/db.php");
?>

<style>
    /* Estilos Visuais */
    .stream-logo { width: 24px; height: 24px; border-radius: 4px; margin-right: 8px; object-fit: cover; vertical-align: middle; background-color: #eee; }
    [data-theme="dark"] .stream-logo { background-color: #444; }
    .content-name { vertical-align: middle; }

    /* Classes de Cor do Monitor Real-Time */
    .username-visible { color: #39ff14 !important; font-weight: bold; } /* Verde para o usuário */
    .badge-tv { background-color: #198754; color: white; }
    .badge-movie { background-color: #0dcaf0; color: black; }
    .badge-serie { background-color: #d63384; color: white; }
    .user-test { color: #ffc107; font-weight: bold; }
    .pulse-dot { animation: pulse 2s infinite; }
    @keyframes pulse { 0% { box-shadow: 0 0 0 0 rgba(25, 135, 84, 0.4); } 70% { box-shadow: 0 0 0 10px rgba(25, 135, 84, 0); } 100% { box-shadow: 0 0 0 0 rgba(25, 135, 84, 0); } }
</style>

<div class="container-fluid py-4">
    <div class="page-header">
        <h1><i class="bi bi-broadcast me-2"></i>Usuários Online em Tempo Real</h1>
    </div>

    <div class="row mb-4">
        <div class="col-md-4 mb-3">
            <div class="card border-0 shadow-sm">
                <div class="card-body text-center">
                    <i class="bi bi-circle-fill text-success fs-1 pulse-dot"></i>
                    <h3 class="mt-2 mb-0" id="stat-online">0</h3>
                    <p class="text-muted mb-0">Conexões Ativas</p>
                </div>
            </div>
        </div>
        <div class="col-md-4 mb-3">
            <div class="card border-0 shadow-sm">
                <div class="card-body text-center">
                    <i class="bi bi-person-fill fs-1 text-primary"></i>
                    <h3 class="mt-2 mb-0" id="stat-users">0</h3>
                    <p class="text-muted mb-0">Usuários Únicos</p>
                </div>
            </div>
        </div>
        <div class="col-md-4 mb-3">
            <div class="card border-0 shadow-sm">
                <div class="card-body text-center">
                    <i class="bi bi-globe fs-1 text-info"></i>
                    <h3 class="mt-2 mb-0" id="stat-ips">0</h3>
                    <p class="text-muted mb-0">IPs Únicos</p>
                </div>
            </div>
        </div>
    </div>
    <div class="card shadow-sm">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h5 class="mb-0"><i class="bi bi-wifi me-2"></i>Lista de Conexões Ativas</h5>
            <div>
                <span class="badge bg-info text-dark" id="timer-badge">Atualizando em 2s...</span>
                <button type="button" class="btn btn-success btn-sm" id="btnAtualizar">
                    <i class="bi bi-arrow-clockwise me-1"></i>Atualizar Agora
                </button>
            </div>
        </div>
        
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-striped table-hover mb-0">
                    <thead>
                        <tr>
                            <th style="min-width: 150px;">Usuário (Login)</th>
                            <th>IP</th>
                            <th>User Agent (App)</th>
                            <th>Conteúdo Assistindo</th>
                            <th>Última Atividade</th>
                            <th class="text-center">Ação</th>
                        </tr>
                    </thead>
                    <tbody id="online-users-table">
                        <tr><td colspan="6" class="text-center p-4">Inicializando monitor...</td></tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<?php
require_once("footer.php"); 
?>

<script>
    $(document).ready(function() {
        let timerInterval;
        let countdown = 3; 
        const timerBadge = $('#timer-badge');
        const tableBody = $('#online-users-table');
        const btnAtualizar = $('#btnAtualizar');

        // --- FUNÇÃO CORRIGIDA PARA ATUALIZAR CARDS ---
        function updateStats(stats) {
            $('#stat-online').text(stats.conexoes_ativas || 0);
            $('#stat-users').text(stats.usuarios_unicos || 0);
            $('#stat-ips').text(stats.ips_unicos || 0);
        }

        // --- Função para Atualizar a Tabela ---
        function updateTable(users) {
            tableBody.empty(); 
            if (users.length === 0) {
                tableBody.html('<tr><td colspan="6" class="text-center p-4 text-muted">Nenhum usuário online no momento.</td></tr>');
                return;
            }

            users.forEach(user => {
                // Mapeamento de Classes e Conteúdo (Simplificado)
                let tipoBadge = '';
                if (user.tipo === 'TV') tipoBadge = 'badge-tv';
                else if (user.tipo === 'FILME') tipoBadge = 'badge-movie';
                else if (user.tipo === 'SERIE') tipoBadge = 'badge-serie';
                
                let userClass = (user.is_trial == 1) ? 'user-test' : 'username-visible';
                let userNameDisplay = `<span class="${userClass}">${user.usuario}</span>`;
                if (user.is_trial == 1) {
                    userNameDisplay += ` <span class="badge bg-warning text-dark ms-1">TESTE</span>`;
                }
                
                // Formatação do User Agent
                let userAgent = user.user_agent || 'Desconhecido';
                if (userAgent.length > 50) userAgent = userAgent.substring(0, 50) + '...';

                const row = `
                    <tr>
                        <td>${userNameDisplay}</td>
                        <td>${user.ip || 'N/A'}</td>
                        <td><small>${userAgent}</small></td>
                        <td>
                            <span class="badge ${tipoBadge} me-2">${user.tipo}</span>
                            <span class="content-name">${user.conteudo}</span>
                        </td>
                        <td>${user.ping || user.hora}</td>
                        <td class="text-center">
                            <button class="btn btn-danger btn-sm btn-kick" data-id="${user.id_conexao}" data-user="${user.usuario}" title="Derrubar Conexão">
                                <i class="bi bi-x-circle-fill"></i>
                            </button>
                        </td>
                    </tr>
                `;
                tableBody.append(row);
            });
        }
        
        // --- Função de Carga Principal ---
        function fetchOnlineUsers() {
            btnAtualizar.prop('disabled', true).html('<span class="spinner-border spinner-border-sm" role="status"></span>');
            
            $.ajax({
                url: 'api/api_monitor_ajax.php?nocache=' + Date.now(),
                type: 'GET',
                dataType: 'json',
                success: function(response) {
                    if (response.conexoes) {
                        updateTable(response.conexoes);
                        updateStats(response.stats); // <--- CHAMA A FUNÇÃO DE ESTATÍSTICA
                    } else {
                         tableBody.html('<tr><td colspan="6" class="text-center p-4 text-danger">Erro no formato da API.</td></tr>');
                    }
                },
                error: function() {
                     tableBody.html(`<tr><td colspan="6" class="text-center p-4 text-danger">Erro de comunicação com a API.</td></tr>`);
                },
                complete: function() {
                    btnAtualizar.prop('disabled', false).html('<i class="bi bi-arrow-clockwise me-1"></i>Atualizar Agora');
                    resetTimer();
                }
            });
        }
        
        // --- Funções de Timer ---
        function startTimer() {
            countdown = 3;
            timerBadge.text(`Atualizando em ${countdown}s...`).removeClass('bg-danger').addClass('bg-info text-dark');
            clearInterval(timerInterval); 
            timerInterval = setInterval(() => {
                countdown--;
                if (countdown > 0) {
                    timerBadge.text(`Atualizando em ${countdown}s...`);
                } else {
                    clearInterval(timerInterval);
                    timerBadge.text('Atualizando...');
                    fetchOnlineUsers();
                }
            }, 1000);
        }
        function resetTimer() {
            clearInterval(timerInterval);
            startTimer();
        }

        // --- Eventos e Início ---
        btnAtualizar.on('click', function() {
            clearInterval(timerInterval);
            timerBadge.text('Atualizando...');
            fetchOnlineUsers();
        });

        // Inicia a carga inicial e o timer
        fetchOnlineUsers();
    });
</script>