<?php
// 1. Inclui o menu e conecta ao banco
require_once("menu.php");

// Garante a conexão
if (!function_exists('conectar_bd')) {
    require_once('api/controles/db.php');
}
$pdo = conectar_bd();

// --- GARANTIA: CRIA A TABELA DE CONFIG SE NÃO EXISTIR ---
$pdo->exec("CREATE TABLE IF NOT EXISTS `painel_config` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `chave` varchar(50) NOT NULL,
  `valor` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `chave` (`chave`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;");

// --- LÊ A CONFIGURAÇÃO ATUAL ---
$stmt = $pdo->prepare("SELECT valor FROM painel_config WHERE chave = 'migracao_cobrar_credito'");
$stmt->execute();
$res = $stmt->fetchColumn();

// Se não tiver configuração salva, o padrão é 1 (Cobrar)
$cobrar_credito = ($res !== false) ? (int)$res : 1;
?>

<style>
    /* Ajustes visuais */
    .card-config {
        background-color: var(--bs-card-bg);
        border: 1px solid var(--bs-border-color);
        border-radius: 10px;
        box-shadow: 0 4px 6px rgba(0,0,0,0.05);
    }
    
    .form-switch .form-check-input {
        width: 3em;
        height: 1.5em;
        cursor: pointer;
    }
    
    .form-switch .form-check-label {
        margin-left: 10px;
        font-size: 1.1rem;
        font-weight: 600;
        padding-top: 2px;
        cursor: pointer;
        color: var(--bs-heading-color);
    }
    
    .text-desc {
        color: var(--bs-secondary-color);
        font-size: 0.95rem;
    }

    /* Modo Escuro */
    body.dark-mode .card-config {
        background-color: #1e1e1e;
        border-color: #333;
    }
    body.dark-mode .form-check-input:checked {
        background-color: #198754;
        border-color: #198754;
    }
</style>

<div class="container-fluid p-md-4 p-2">
    
    <div class="page-header mb-4">
        <h1 class="h3 mb-0"><i class="bi bi-gear-wide-connected me-2"></i>Configuração de Migração</h1>
        <p class="text-muted">Defina as regras para a importação de clientes.</p>
    </div>

    <div class="row">
        <div class="col-md-8 col-lg-6">
            <div class="card card-config">
                <div class="card-header bg-primary text-white">
                    <h5 class="mb-0"><i class="bi bi-wallet2 me-2"></i>Política de Cobrança</h5>
                </div>
                <div class="card-body p-4">
                    
                    <div class="d-flex align-items-center mb-3">
                        <div class="form-check form-switch">
                            <input class="form-check-input" type="checkbox" id="toggle_cobrar_credito" <?= $cobrar_credito == 1 ? 'checked' : '' ?>>
                            <label class="form-check-label" for="toggle_cobrar_credito">
                                Cobrar Crédito na Migração
                            </label>
                        </div>
                    </div>

                    <div class="alert alert-info">
                        <i class="bi bi-info-circle-fill me-2"></i>
                        <strong>Como funciona:</strong>
                        <ul class="mb-0 mt-2 pl-3">
                            <li><strong>ATIVADO:</strong> Revendedores pagam 1 crédito por cada cliente importado.</li>
                            <li><strong>DESATIVADO:</strong> A importação é gratuita para todos os revendedores.</li>
                        </ul>
                        <small class="d-block mt-2 text-muted">* O Admin Master nunca é cobrado.</small>
                    </div>

                    <hr>

                    <button id="btn_salvar_config" class="btn btn-success w-100 btn-lg">
                        <i class="bi bi-save me-2"></i>Salvar Configuração
                    </button>

                </div>
            </div>
        </div>
    </div>
</div>

<?php
// 2. Inclui o rodapé
require_once("footer.php");
?>

<script>
document.addEventListener('DOMContentLoaded', function() {
    
    const btnSalvar = document.getElementById('btn_salvar_config');
    const toggle = document.getElementById('toggle_cobrar_credito');

    btnSalvar.addEventListener('click', function() {
        const cobrar = toggle.checked ? 1 : 0;
        const originalText = btnSalvar.innerHTML;
        
        btnSalvar.disabled = true;
        btnSalvar.innerHTML = '<span class="spinner-border spinner-border-sm"></span> Salvando...';

        // Envia para a API
        fetch('api/migrar_acao.php', {
            method: 'POST',
            headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
            body: 'action=salvar_config&cobrar_credito=' + cobrar + '&token=' + SESSION_TOKEN
        })
        .then(response => response.json())
        .then(data => {
            if(data.status === 'success'){
                Swal.fire('Sucesso!', 'Configuração atualizada.', 'success');
            } else {
                Swal.fire('Erro!', data.message, 'error');
            }
        })
        .catch(error => {
            console.error(error);
            Swal.fire('Erro', 'Falha na conexão com a API.', 'error');
        })
        .finally(() => {
            btnSalvar.disabled = false;
            btnSalvar.innerHTML = originalText;
        });
    });
});
</script>