<?php
session_start();
require_once('./api/controles/db.php');
require_once('./api/controles/dashboard.php');

// --- LÓGICA PARA DESCOBRIR O NOME REAL DO USUÁRIO ---
$nome_logado = "Administrador"; // Nome padrão caso falhe tudo

// Lista de possíveis nomes que os painéis costumam usar na Sessão
$possiveis_chaves = ['user', 'usuario', 'username', 'nome', 'login', 'user_name', 'conta'];

// Procura qual chave tem valor
foreach ($possiveis_chaves as $chave) {
    if (isset($_SESSION[$chave]) && !empty($_SESSION[$chave])) {
        $nome_logado = $_SESSION[$chave];
        break; // Achou? Para de procurar e usa esse.
    }
}
// ----------------------------------------------------

// 1. Carrega os dados
$dadosAtivos = Dashboard();
$dadosTestes = testes();
$dadosVencimentos = getDadosVencimentos(7);

// 2. Dados Admin
$conteudos = ['TotalLiveStreams' => 0, 'TotalMovieStreams' => 0, 'TotalSeries' => 0, 'TotalEpisodes' => 0];
$is_admin = (isset($_SESSION['nivel_admin']) && $_SESSION['nivel_admin'] == 1);

if ($is_admin) {
    $conteudos = conteudos(); 
}

// 3. Menu
require_once("menu.php"); 
?>

<style>
    /* --- ESTILO ZENPANEL PREMIUM --- */
    :root {
        --primary-gradient: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        --success-gradient: linear-gradient(135deg, #4facfe 0%, #00f2fe 100%);
        --warning-gradient: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);
        --info-gradient: linear-gradient(135deg, #43e97b 0%, #38f9d7 100%);
        --teal-gradient: linear-gradient(135deg, #00b4db 0%, #0083b0 100%);
        --orange-gradient: linear-gradient(135deg, #fa709a 0%, #fee140 100%);
        --card-radius: 16px;
    }

    /* CARD ESTILO ZENPANEL */
    .pro-card {
        border-radius: var(--card-radius);
        color: white;
        padding: 1.5rem;
        position: relative;
        overflow: hidden;
        transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        box-shadow: 0 8px 32px rgba(0, 0, 0, 0.1);
        border: none;
        height: 100%;
        display: flex;
        flex-direction: column;
        justify-content: center;
    }

    .pro-card:hover {
        transform: translateY(-8px);
        box-shadow: 0 20px 40px rgba(0, 0, 0, 0.15);
    }

    .pro-card::before {
        content: '';
        position: absolute;
        top: -50%;
        right: -30%;
        width: 200px;
        height: 200px;
        background: rgba(255, 255, 255, 0.1);
        border-radius: 50%;
        transition: all 0.3s ease;
        pointer-events: none;
    }

    .pro-card:hover::before { transform: scale(1.2); }

    .pro-info { position: relative; z-index: 2; }

    .pro-value {
        font-size: 2.2rem;
        font-weight: 700;
        margin-bottom: 0.2rem;
        text-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
        color: #fff !important;
        line-height: 1.2;
    }

    .pro-label {
        font-size: 0.85rem;
        opacity: 0.9;
        text-transform: uppercase;
        letter-spacing: 1.5px;
        font-weight: 600;
        color: rgba(255, 255, 255, 0.9) !important;
    }

    .pro-icon-float {
        font-size: 3.5rem;
        opacity: 0.2;
        position: absolute;
        right: 20px;
        top: 50%;
        transform: translateY(-50%);
        transition: all 0.3s ease;
        color: white;
    }

    .pro-card:hover .pro-icon-float { opacity: 0.3; transform: translateY(-50%) scale(1.1); }

    /* CORES (GRADIENTES) */
    .bg-blue { background: var(--primary-gradient); }
    .bg-cyan { background: var(--success-gradient); }
    .bg-pink { background: var(--warning-gradient); }
    .bg-green { background: var(--info-gradient); }
    .bg-teal { background: var(--teal-gradient); }
    .bg-orange { background: var(--orange-gradient); }

    /* --- LÓGICA DE CORES INTELIGENTE --- */
    
    /* 1. PADRÃO (TEMA CLARO) */
    .section-title {
        font-weight: 800;
        text-transform: uppercase;
        font-size: 0.85rem;
        letter-spacing: 1.2px;
        margin-bottom: 1rem;
        color: #495057; /* Cinza escuro */
        opacity: 0.9;
    }
    
    /* Título DASHBOARD no claro */
    .page-header h1 {
        color: #343a40; /* Cinza bem escuro */
    }

    /* 2. OVERRIDE PARA TEMA ESCURO */
    [data-bs-theme="dark"] .section-title {
        color: #ffffff !important;
        text-shadow: 0 2px 4px rgba(0,0,0,0.6);
    }
    
    [data-bs-theme="dark"] .page-header h1 {
        color: #ffffff !important;
    }
    
    [data-bs-theme="dark"] .text-body {
        color: #f8f9fa !important;
    }
    
    [data-bs-theme="dark"] .text-muted {
        color: rgba(255, 255, 255, 0.6) !important;
    }

    [data-bs-theme="dark"] .table-vencimentos td,
    [data-bs-theme="dark"] .table-vencimentos th {
        color: #ffffff !important;
        border-color: rgba(255,255,255,0.1);
    }

    /* --- VENCIMENTOS --- */
    .summary-card.v2 {
        display: flex; align-items: center; padding: 20px; 
        border-radius: var(--card-radius); color: #fff; 
        box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
        transition: transform 0.2s; border: none;
    }
    .summary-card.v2:hover { transform: translateY(-5px); }
    .summary-card.v2 .icon { font-size: 2rem; margin-right: 15px; opacity: 0.8; }
    .summary-card.v2 .value { font-size: 1.8rem; font-weight: bold; line-height: 1; }
    .summary-card.v2 .label { font-size: 0.8rem; opacity: 0.9; }
    
    .card-danger { background: linear-gradient(135deg, #ff5252 0%, #f48fb1 100%); }
    .card-warning { background: linear-gradient(135deg, #f6d365 0%, #fda085 100%); color: #fff; }
    .card-success { background: linear-gradient(135deg, #84fab0 0%, #8fd3f4 100%); color: #2c3e50; }

    /* Tabela e Recursos */
    .table-vencimentos td { vertical-align: middle; padding: 1rem; }

    .resource-card .circular-progress {
        position: relative; width: 120px; height: 120px; border-radius: 50%;
        display: grid; place-items: center;
        background: conic-gradient(var(--bs-primary) calc(var(--value, 0) * 1%), var(--bs-tertiary-bg) 0);
        margin: 0 auto;
    }
    .resource-card .circular-progress:before {
        content: ""; position: absolute; width: 100px; height: 100px; background-color: var(--bs-card-bg); border-radius: 50%;
    }
    .resource-card .progress-value { position: relative; font-size: 1.5rem; font-weight: 600; color: var(--bs-primary); }
</style>

<div class="container-fluid p-0"> 
    <div class="page-header mb-4 mt-2">
        <h1 class="h3 mb-1 fw-bold"><i class="fas fa-tachometer-alt me-2 text-primary"></i>Dashboard</h1>
        
        <p class="text-muted">
            Bem-vindo, <strong><?php echo htmlspecialchars($nome_logado); ?></strong>
        </p>
    </div>

    <?php if ($is_admin): ?>
    <div class="row g-3 mb-4">
        <div class="col-12"><h5 class="section-title">Conteúdo do Servidor</h5></div>
        
        <div class="col-sm-6 col-lg-3">
            <div class="pro-card bg-blue">
                <div class="pro-info">
                    <div class="pro-value"><?php echo number_format($conteudos['TotalLiveStreams'], 0, ',', '.'); ?></div>
                    <div class="pro-label">Canais</div>
                </div>
                <i class="fa-solid fa-tv pro-icon-float"></i>
            </div>
        </div>

        <div class="col-sm-6 col-lg-3">
            <div class="pro-card bg-pink">
                <div class="pro-info">
                    <div class="pro-value"><?php echo number_format($conteudos['TotalMovieStreams'], 0, ',', '.'); ?></div>
                    <div class="pro-label">Filmes</div>
                </div>
                <i class="fa-solid fa-film pro-icon-float"></i>
            </div>
        </div>

        <div class="col-sm-6 col-lg-3">
            <div class="pro-card bg-cyan">
                <div class="pro-info">
                    <div class="pro-value"><?php echo number_format($conteudos['TotalSeries'], 0, ',', '.'); ?></div>
                    <div class="pro-label">Séries</div>
                </div>
                <i class="fa-solid fa-clapperboard pro-icon-float"></i>
            </div>
        </div>

        <div class="col-sm-6 col-lg-3">
            <div class="pro-card bg-green">
                <div class="pro-info">
                    <div class="pro-value"><?php echo number_format($conteudos['TotalEpisodes'], 0, ',', '.'); ?></div>
                    <div class="pro-label">Episódios</div>
                </div>
                <i class="fa-solid fa-photo-film pro-icon-float"></i>
            </div>
        </div>
    </div>
    <?php endif; ?>
    
    
    <div class="row g-3 mb-4">
        <div class="col-12"><h5 class="section-title">Base de Usuários</h5></div>
        
        <div class="col-md-6 col-lg-4">
            <div class="pro-card bg-teal">
                <div class="pro-info">
                    <div class="pro-value"><?php echo $dadosAtivos['clientesAtivos']; ?></div>
                    <div class="pro-label">Clientes IPTV</div>
                </div>
                <i class="fa-solid fa-users pro-icon-float"></i>
            </div>
        </div>

        <div class="col-md-6 col-lg-4">
            <div class="pro-card bg-orange">
                <div class="pro-info">
                    <div class="pro-value"><?php echo $dadosAtivos['clientesP2PAtivos'] ?? 0; ?></div>
                    <div class="pro-label">Clientes P2P</div>
                </div>
                <i class="fa-solid fa-user-shield pro-icon-float"></i>
            </div>
        </div>
        
        <div class="col-md-6 col-lg-4">
            <div class="pro-card bg-blue">
                <div class="pro-info">
                    <div class="pro-value"><?php echo $dadosTestes['TestesAtivos']; ?></div>
                    <div class="pro-label">Testes Ativos</div>
                </div>
                <i class="fa-solid fa-vial pro-icon-float"></i>
            </div>
        </div>
    </div>


    <?php if ($is_admin): ?>
    <div class="row mb-4">
        <div class="col-12"><h5 class="section-title mb-3">Saúde do Servidor</h5></div>
        <div class="col-md-4 mb-3">
            <div class="card resource-card border-0 shadow-sm h-100 pt-3">
                <div class="card-body text-center"><div class="circular-progress" id="cpu-progress"><span class="progress-value">0%</span></div><h6 class="mt-3 mb-0 text-muted">CPU</h6></div>
            </div>
        </div>
        <div class="col-md-4 mb-3">
            <div class="card resource-card border-0 shadow-sm h-100 pt-3">
                <div class="card-body text-center"><div class="circular-progress" id="ram-progress"><span class="progress-value">0%</span></div><h6 class="mt-3 mb-0 text-muted">Memória RAM</h6></div>
            </div>
        </div>
        <div class="col-md-4 mb-3">
            <div class="card resource-card border-0 shadow-sm h-100 pt-3">
                <div class="card-body text-center"><div class="circular-progress" id="disk-progress"><span class="progress-value">0%</span></div><h6 class="mt-3 mb-0 text-muted">Disco Principal</h6></div>
            </div>
        </div>
    </div>
    <?php endif; ?>

    <div class="row mt-4">
        <div class="col-12 d-flex justify-content-between align-items-center mb-3">
            <h5 class="section-title mb-0">Financeiro e Vencimentos</h5>
            <div class="d-flex gap-2">
                <select id="refresh-interval" class="form-select form-select-sm shadow-none border-secondary" style="width: auto;">
                    <option value="30">30s</option><option value="60">1m</option><option value="300">5m</option><option value="0" selected>Manual</option>
                </select>
                <button id="update-btn" class="btn btn-sm btn-primary rounded-pill px-3">
                    <i class="fas fa-sync-alt"></i>
                </button>
            </div>
        </div>
    </div>
    
    <div class="row">
        <div class="col-lg-4 col-md-6 mb-4">
            <div class="card summary-card v2 card-danger h-100">
                <div class="icon"><i class="fas fa-user-times"></i></div>
                <div class="info">
                    <div class="value" id="nao-renovados-count"><?php echo $dadosVencimentos['nao_renovados_count']; ?></div>
                    <div class="label">Atrasados</div>
                </div>
            </div>
        </div>
        <div class="col-lg-4 col-md-6 mb-4">
            <div class="card summary-card v2 card-warning h-100">
                <div class="icon"><i class="fas fa-user-clock"></i></div>
                <div class="info">
                    <div class="value" id="proximos-vencimentos-count"><?php echo $dadosVencimentos['proximos_vencimentos_count']; ?></div>
                    <div class="label">Vencendo em Breve</div>
                </div>
            </div>
        </div>
        <div class="col-lg-4 col-md-12 mb-4">
            <div class="card summary-card v2 card-success h-100">
                <div class="icon"><i class="fas fa-wallet"></i></div>
                <div class="info">
                    <div class="value" id="valor-total-receber">R$ <?php echo number_format($dadosVencimentos['valor_total_a_receber'], 2, ',', '.'); ?></div>
                    <div class="label">Previsão de Receita</div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="card border-0 shadow-sm rounded-3 overflow-hidden">
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table mb-0 table-vencimentos">
                    <thead class="bg-light">
                        <tr>
                            <th class="py-3 px-4">Cliente</th>
                            <th class="py-3">Contato</th>
                            <th class="py-3">Vencimento</th>
                            <th class="py-3">Status</th>
                            <th class="py-3">Valor</th>
                            <th class="text-end px-4 py-3">Ações</th>
                        </tr>
                    </thead>
                    <tbody id="tabela-vencimentos-body">
                        <tr><td colspan="6" class="text-center text-muted py-5"><i class="fas fa-circle-notch fa-spin me-2"></i> Carregando lista...</td></tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<div class="version-footer">
    <p class="text-center mt-4 text-muted small">Versão 4.1.23 - Office Xtream</p>
    <p class="text-center mt-4 text-muted small">© TOP IPTV | powered by Todos os direitos reservados.</p>
</div>

<script>
document.addEventListener("DOMContentLoaded", function() {
    
    const IS_ADMIN = <?php echo json_encode($is_admin); ?>;

    if (IS_ADMIN) {
        const cpuProgress = document.getElementById('cpu-progress');
        const ramProgress = document.getElementById('ram-progress');
        const diskProgress = document.getElementById('disk-progress');
        
        if (cpuProgress && ramProgress && diskProgress) {
            const cpuValue = cpuProgress.querySelector('.progress-value');
            const ramValue = ramProgress.querySelector('.progress-value');
            const diskValue = diskProgress.querySelector('.progress-value');
            
            function updateServerStats() {
                fetch('api/get_server_stats.php')
                    .then(response => response.ok ? response.json() : Promise.reject('Erro Rede'))
                    .then(data => {
                        cpuValue.textContent = data.cpu + '%'; cpuProgress.style.setProperty('--value', data.cpu);
                        ramValue.textContent = data.ram + '%'; ramProgress.style.setProperty('--value', data.ram);
                        diskValue.textContent = data.disk + '%'; diskProgress.style.setProperty('--value', data.disk);
                    })
                    .catch(error => { 
                        console.error(error); 
                        cpuValue.textContent = '-'; ramValue.textContent = '-'; diskValue.textContent = '-'; 
                    });
            }
            updateServerStats(); 
            setInterval(updateServerStats, 5000); 
        }
    }

    const intervalSelect = document.getElementById('refresh-interval');
    const updateBtn = document.getElementById('update-btn');
    const tabelaBody = document.getElementById('tabela-vencimentos-body');
    let refreshTimer = null;

    async function updateVencimentosSection() {
        if(!updateBtn || !tabelaBody) return; 
        
        updateBtn.disabled = true;
        const originalIcon = updateBtn.innerHTML;
        updateBtn.innerHTML = '<i class="fas fa-circle-notch fa-spin"></i>';

        try {
            const response = await fetch('api/get_vencimentos_data.php');
            if (!response.ok) { throw new Error('Erro de conexão'); }
            const data = await response.json();

            document.getElementById('nao-renovados-count').textContent = data.nao_renovados_count;
            document.getElementById('proximos-vencimentos-count').textContent = data.proximos_vencimentos_count;
            document.getElementById('valor-total-receber').textContent = `R$ ${parseFloat(data.valor_total_a_receber).toLocaleString('pt-BR', { minimumFractionDigits: 2, maximumFractionDigits: 2 })}`;

            tabelaBody.innerHTML = ''; 

            if (data.lista_vencidos && data.lista_vencidos.length > 0) {
                data.lista_vencidos.forEach(cliente => {
                    const nomeCliente = cliente.name || cliente.usuario;
                    const telefoneLimpo = '55' + (cliente.telefone || '').replace(/\D/g, '');
                    const valorTotal = parseFloat(cliente.V_total).toLocaleString('pt-BR', { minimumFractionDigits: 2, maximumFractionDigits: 2 });
                    const vencimentoFormatado = new Date(cliente.Vencimento.replace(/-/g, '\/')).toLocaleDateString('pt-BR');

                    let statusHtml = '';
                    if (cliente.status === 'Atrasado') {
                        statusHtml = `
                            <td>
                                <span class="text-danger fw-bold">${vencimentoFormatado}</span><br>
                                <small class="text-muted">${cliente.dias_atrasado} dias atrás</small>
                            </td>
                            <td><span class="badge bg-danger">Bloqueado</span></td>
                        `;
                    } else {
                        let textoDias = cliente.dias_para_vencer === 0 ? 'Hoje' : (cliente.dias_para_vencer === 1 ? 'Amanhã' : `${cliente.dias_para_vencer} dias`);
                        statusHtml = `
                            <td>
                                <span class="fw-bold text-body">${vencimentoFormatado}</span><br>
                                <small class="text-success">Vence em ${textoDias}</small>
                            </td>
                            <td><span class="badge bg-success">Ativo</span></td>
                        `;
                    }
                    
                    const rowHTML = `
                        <tr>
                            <td class="px-4">
                                <div class="fw-bold text-body">${nomeCliente}</div>
                                <small class="text-muted">${cliente.usuario}</small>
                            </td>
                            <td>${cliente.telefone ? `<a href="https://wa.me/${telefoneLimpo}" target="_blank" class="text-success"><i class="fab fa-whatsapp"></i> ${cliente.telefone}</a>` : '-'}</td>
                            ${statusHtml}
                            <td class="fw-bold text-body">R$ ${valorTotal}</td>
                            <td class="text-end px-4">
                                <button class="btn btn-sm btn-light text-primary border" onclick="modal_master('/api/clientes.php', 'renovar_cliente', ${cliente.id})"><i class="fas fa-retweet"></i></button>
                            </td>
                        </tr>
                    `;
                    tabelaBody.insertAdjacentHTML('beforeend', rowHTML);
                });
            } else {
                tabelaBody.innerHTML = '<tr><td colspan="6" class="text-center text-muted py-5">Nenhum cliente vencido ou próximo.</td></tr>';
            }
        } catch (error) {
            console.error('Erro:', error);
            tabelaBody.innerHTML = `<tr><td colspan="6" class="text-center text-danger py-4">Erro ao carregar dados.</td></tr>`;
        } finally {
            updateBtn.disabled = false;
            updateBtn.innerHTML = originalIcon;
        }
    }
    
    updateBtn.addEventListener('click', function() {
        location.reload();
    });

    intervalSelect.addEventListener('change', function() {
        if (refreshTimer) { clearInterval(refreshTimer); refreshTimer = null; }
        const interval = parseInt(this.value, 10);
        if (interval > 0) {
            refreshTimer = setInterval(function(){ location.reload(); }, interval * 1000);
        }
    });

    updateVencimentosSection();
});
</script>
<?php require_once("footer.php"); ?>