<?php
require_once 'api/controles/db.php';
require_once("menu.php"); // Inclui o topo, menu e início da página

$conexao = conectar_bd();

if (!$conexao) {
    die("Falha crítica: Não foi possível conectar ao banco de dados.");
}

// O ID do administrador está definido aqui
$admin_id = 11;

try {
    $sql = "SELECT user, email, whatsapp, telegram FROM admin WHERE id = :id";
    $stmt = $conexao->prepare($sql);
    $stmt->bindParam(':id', $admin_id, PDO::PARAM_INT);
    $stmt->execute();
    $admin = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$admin) {
        die("Administrador com o ID $admin_id não encontrado.");
    }

} catch (PDOException $e) {
    die("Erro ao buscar dados do administrador: " . $e->getMessage());
}
?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Editar Perfil do Administrador - Admin Panel</title>
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@300;400;700&display=swap" rel="stylesheet">
    <style>
        :root {
            /* Cores para o tema CLARO */
            --bg-color: #f0f2f5;
            --card-bg: #ffffff;
            --text-color: #333;
            --secondary-text-color: #555;
            --border-color: #e0e0e0;
            --input-bg: #f9f9f9;
            --input-border: #ccc;
            --primary-color: #007bff; /* Azul vibrante */
            --primary-hover: #0056b3;
            --toggle-bg: #ccc;
            --toggle-circle: #fff;
        }

        /* Cores para o tema ESCURO */
        body.dark-theme {
            --bg-color: #212529;
            --card-bg: #2d3436;
            --text-color: #f8f9fa;
            --secondary-text-color: #ced4da;
            --border-color: #495057;
            --input-bg: #3a4042;
            --input-border: #6c757d;
            --primary-color: #6a00ff; /* Roxo vibrante */
            --primary-hover: #4e00b3;
            --toggle-bg: #555;
            --toggle-circle: #f8f9fa;
        }

        body {
            font-family: 'Roboto', sans-serif;
            margin: 0;
            padding: 0;
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: 100vh;
            background-color: var(--bg-color);
            color: var(--text-color);
            transition: background-color 0.3s ease, color 0.3s ease;
        }

        .container {
            background-color: var(--card-bg);
            padding: 40px;
            border-radius: 12px;
            box-shadow: 0 8px 16px rgba(0, 0, 0, 0.1);
            width: 100%;
            max-width: 550px;
            box-sizing: border-box;
            border: 1px solid var(--border-color);
        }

        h2 {
            text-align: center;
            color: var(--primary-color);
            margin-bottom: 30px;
            font-weight: 700;
        }

        .form-group {
            margin-bottom: 20px;
        }

        label {
            display: block;
            margin-bottom: 8px;
            font-weight: 400;
            color: var(--secondary-text-color);
        }

        input[type="text"],
        input[type="email"],
        input[type="password"] {
            width: calc(100% - 20px);
            padding: 12px 10px;
            border: 1px solid var(--input-border);
            border-radius: 8px;
            background-color: var(--input-bg);
            color: var(--text-color);
            font-size: 16px;
            transition: border-color 0.3s ease, background-color 0.3s ease;
            box-sizing: border-box;
        }

        input[type="text"]:focus,
        input[type="email"]:focus,
        input[type="password"]:focus {
            border-color: var(--primary-color);
            outline: none;
            box-shadow: 0 0 0 3px rgba(0, 123, 255, 0.25);
        }

        hr {
            border: none;
            border-top: 1px solid var(--border-color);
            margin: 30px 0;
        }
        
        .submit-btn {
            width: 100%;
            padding: 12px;
            background-color: var(--primary-color);
            color: white;
            border: none;
            border-radius: 8px;
            font-size: 18px;
            font-weight: 700;
            cursor: pointer;
            transition: background-color 0.3s ease, transform 0.2s ease;
        }

        .submit-btn:hover {
            background-color: var(--primary-hover);
            transform: translateY(-2px);
        }

        .theme-toggle {
            position: absolute;
            top: 20px;
            right: 20px;
            background: var(--toggle-bg);
            width: 60px;
            height: 30px;
            border-radius: 15px;
            cursor: pointer;
            display: flex;
            align-items: center;
            justify-content: flex-start;
            padding: 0 5px;
            transition: background 0.3s ease;
        }
    </style>
</head>
<body>

    <div class="theme-toggle" id="theme-toggle">
        <div class="toggle-circle"></div>
    </div>

    <div class="container">
        <h2>Editar Perfil do Administrador</h2>

        <form action="salvar_admin.php" method="POST">
            <input type="hidden" name="id" value="<?php echo $admin_id; ?>">

            <div class="form-group">
                <label for="user">Usuário:</label>
                <input type="text" id="user" name="user" value="<?php echo htmlspecialchars($admin['user']); ?>" required>
            </div>

            <div class="form-group">
                <label for="email">Email:</label>
                <input type="email" id="email" name="email" value="<?php echo htmlspecialchars($admin['email']); ?>">
            </div>

            <div class="form-group">
                <label for="whatsapp">Telefone (WhatsApp):</label>
                <input type="text" id="whatsapp" name="whatsapp" value="<?php echo htmlspecialchars($admin['whatsapp']); ?>">
            </div>
            
            <div class="form-group">
                <label for="telegram">Telegram:</label>
                <input type="text" id="telegram" name="telegram" value="<?php echo htmlspecialchars($admin['telegram']); ?>">
            </div>

            <hr>

            <div class="password-section">
                <h3>Alterar Senha</h3>
                <p style="font-size: 0.9em; color: var(--secondary-text-color); margin-bottom: 20px;">Deixe os campos abaixo em branco se não quiser alterar a senha.</p>

                <div class="form-group">
                    <label for="nova_senha">Nova Senha:</label>
                    <input type="password" id="nova_senha" name="nova_senha">
                </div>

                <div class="form-group">
                    <label for="confirma_senha">Confirmar Nova Senha:</label>
                    <input type="password" id="confirma_senha" name="confirma_senha">
                </div>
            </div>

            <button type="submit" class="submit-btn">Salvar Alterações</button>
        </form>
    </div>

    <script>
        const themeToggle = document.getElementById('theme-toggle');
        const body = document.body;

        function applyTheme(theme) {
            body.classList.toggle('dark-theme', theme === 'dark');
            themeToggle.classList.toggle('dark', theme === 'dark');
        }

        document.addEventListener('DOMContentLoaded', () => {
            const savedTheme = localStorage.getItem('theme') || (window.matchMedia('(prefers-color-scheme: dark)').matches ? 'dark' : 'light');
            applyTheme(savedTheme);
        });

        themeToggle.addEventListener('click', () => {
            const newTheme = body.classList.contains('dark-theme') ? 'light' : 'dark';
            applyTheme(newTheme);
            localStorage.setItem('theme', newTheme);
        });
    </script>
</body>
</html>