<?php
// Inclui o menu e o cabealho do seu painel
require_once 'menu.php';
?>

<link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css" />
<script type="text/javascript" src="https://cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
<script type="text/javascript" src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>

<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                <h4 class="mb-sm-0">Excluir Listas Expiradas / Testes</h4>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-lg-8 col-md-10 mx-auto">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title mb-4">Configuraes de Excluso</h5>
                   
                    <form id="form_excluir_listas">
                        <div class="mb-4">
                            <label for="daterange" class="form-label">Intervalo de data de vencimento:</label>
                            <input type="text" id="daterange" name="daterange" class="form-control" autocomplete="off" />
                        </div>

                        <div class="mb-4">
                            <label class="form-label">Tipo de lista a excluir:</label>
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" name="tipos[]" value="testes" id="check_testes">
                                <label class="form-check-label" for="check_testes">
                                    Testes (usurios marcados como "is_trial" = 1)
                                </label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" name="tipos[]" value="expiradas" id="check_expiradas">
                                <label class="form-check-label" for="check_expiradas">
                                    Expiradas (usurios com data de vencimento no passado)
                                </label>
                            </div>
                        </div>

                        <button type="submit" class="btn btn-danger w-100">Excluir Listas</button>
                    </form>

                </div>
            </div>
        </div>
    </div>
</div>

<script>
$(function() {
    // Inicializa o seletor de datas
    $('#daterange').daterangepicker({
        opens: 'center',
        autoUpdateInput: true, // Garante que a data aparea
        locale: {
          format: 'DD/MM/YYYY',
          separator: ' - ',
          applyLabel: 'Aplicar',
          cancelLabel: 'Cancelar',
          fromLabel: 'De',
          toLabel: 'At',
          customRangeLabel: 'Personalizado',
          weekLabel: 'S',
          daysOfWeek: ['Dom', 'Seg', 'Ter', 'Qua', 'Qui', 'Sex', 'Sb'],
          monthNames: ['Janeiro', 'Fevereiro', 'Maro', 'Abril', 'Maio', 'Junho', 'Julho', 'Agosto', 'Setembro', 'Outubro', 'Novembro', 'Dezembro'],
          firstDay: 1
        }
    });

    // Manipula o envio do formulrio
    $('#form_excluir_listas').on('submit', function(e) {
        e.preventDefault(); // Impede o recarregamento da pgina

        var formData = $(this).serialize();
        var tiposSelecionados = $('input[name="tipos[]"]:checked').length > 0;

        // Validao: Verifica se selecionou algum checkbox
        if (!tiposSelecionados) {
            Swal.fire('Ateno!', 'Voc precisa selecionar pelo menos um tipo de lista para excluir (Testes ou Expiradas).', 'warning');
            return;
        }

        // Alerta de confirmao
        Swal.fire({
            title: 'Voc tem CERTEZA?',
            html: "Esta ao ir excluir permanentemente os usurios que correspondem aos critrios selecionados.<br><br><strong style='color: red;'>ESTA AO  IRREVERSVEL!</strong>",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#d33',
            cancelButtonColor: '#3085d6',
            confirmButtonText: 'Sim, quero excluir!',
            cancelButtonText: 'Cancelar'
        }).then((result) => {
            if (result.isConfirmed) {
                // Prepara token se existir na sesso, seno envia vazio
                var token = (typeof SESSION_TOKEN !== 'undefined' ? SESSION_TOKEN : '');
                var dataToSend = formData + '&action=excluir_listas&token=' + token;

                $.ajax({
                    type: 'POST',
                    url: 'api/acoes_excluir.php', // Certifique-se que este arquivo existe
                    data: dataToSend,
                    dataType: 'json',
                    beforeSend: function() {
                        Swal.fire({
                            title: 'Excluindo...',
                            html: 'Por favor, aguarde enquanto as listas so removidas.',
                            allowOutsideClick: false,
                            didOpen: () => {
                                Swal.showLoading();
                            }
                        });
                    },
                    success: function(response) {
                        if (response.status === 'success') {
                            Swal.fire('Sucesso!', response.message, 'success').then(() => {
                                // Opcional: Recarregar a pgina aps sucesso
                                // location.reload(); 
                            });
                        } else {
                            Swal.fire('Erro!', response.message || 'Erro desconhecido', 'error');
                        }
                    },
                    error: function(xhr, status, error) {
                        console.error(xhr.responseText); // Ajuda a debugar no console se der erro
                        Swal.fire('Erro!', 'Falha na comunicao com o servidor. Verifique o console.', 'error');
                    }
                });
            }
        });
    });
});
</script>