<div class="modal fade" id="infoRevendedorModal" tabindex="-1" aria-labelledby="infoModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="infoModalLabel">Dados Criados com Sucesso</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <p>Anote ou copie os dados do revendedor abaixo:</p>
                <div id="dadosRevendedorParaCopiar" data-raw-text="">
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-success" onclick="enviarParaWhatsAppModal('dadosRevendedorParaCopiar')"><i class="fab fa-whatsapp"></i> Enviar WhatsApp</button>
                <button type="button" class="btn btn-primary" onclick="copiarTextoModal('dadosRevendedorParaCopiar')"><i class="fas fa-copy"></i> Copiar Texto</button>
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Fechar</button>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="infoCreditosModal" tabindex="-1" aria-labelledby="infoCreditosModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="infoCreditosModalLabel">Operação de Créditos</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div id="dadosCreditosParaCopiar" data-raw-text="">
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-success" onclick="enviarParaWhatsAppModal('dadosCreditosParaCopiar')"><i class="fab fa-whatsapp"></i> Enviar WhatsApp</button>
                <button type="button" class="btn btn-primary" onclick="copiarTextoModal('dadosCreditosParaCopiar')"><i class="fas fa-copy"></i> Copiar Texto</button>
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Fechar</button>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="modal_p2p_info" tabindex="-1" aria-labelledby="modal_p2p_info_label" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content rounded-4 shadow">
            <div class="modal-header bg-primary text-white rounded-top-4">
                <h5 class="modal-title" id="modal_p2p_info_label">🚀 Acesso Criado / Renovado!</h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body p-4">
                <pre id="p2p-info-content" class="bg-dark text-white p-3 rounded" style="white-space: pre-wrap; word-break: break-all;"></pre>
            </div>
            <div class="modal-footer border-top-0">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Fechar</button>
                <button type="button" class="btn btn-primary" onclick="copiarInfoP2P()"><i class="fas fa-copy"></i> Copiar</button>
                <a id="p2p-whatsapp-link" href="#" target="_blank" class="btn btn-success"><i class="fab fa-whatsapp"></i> Enviar</a>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="modal_master" tabindex="-1" aria-labelledby="modal_master_label" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content rounded-4 shadow">
            <div class="modal-header bg-primary text-white rounded-top-4" id="modal_master_header">
                <h5 class="modal-title" id="modal_master-titulo"></h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            
            <div id="modal_master-body" class="modal-body p-4 overflow-auto" style="max-height: 70vh;">
            </div>
            <div id="modal_master-footer" class="modal-footer border-top-0">
            </div>
            
        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js" crossorigin="anonymous"></script>
<script src="https://cdn.datatables.net/1.13.7/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.7/js/dataTables.bootstrap5.min.js"></script>
<script src="https://cdn.datatables.net/responsive/2.5.0/js/dataTables.responsive.min.js"></script>
<script src="https://cdn.datatables.net/responsive/2.5.0/js/responsive.bootstrap5.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/chart.js@4.4.0/dist/chart.umd.min.js"></script>

<script>
    var SESSION_TOKEN = '<?php echo isset($_SESSION['token']) ? $_SESSION['token'] : ""; ?>';
</script>
<script src="./js/sweetalert2.js"></script>
<script src="./js/custom.js?v=1"></script>
<script type="module" src="https://unpkg.com/ionicons@5.5.2/dist/ionicons/ionicons.esm.js"></script>
<script nomodule src="https://unpkg.com/ionicons@5.5.2/dist/ionicons/ionicons.js"></script>

<script>
    'use strict';
    
    // ==========================================
    // LÓGICA DA SIDEBAR E TOPBAR (do ZenPanel)
    // ==========================================
    (function() {
        // Lógica dos Dropdowns da SIDEBAR
        const dropdownToggles = document.querySelectorAll('.sidebar .nav-dropdown-toggle');
        dropdownToggles.forEach(toggle => {
            toggle.addEventListener('click', function(e) {
                e.preventDefault();
                const dropdown = this.nextElementSibling;
                const isOpen = dropdown.classList.contains('show');
                // Fechar outros dropdowns
                document.querySelectorAll('.sidebar .nav-dropdown-menu.show').forEach(menu => {
                    if (menu !== dropdown) {
                        menu.classList.remove('show');
                        menu.previousElementSibling.classList.remove('active');
                    }
                });
                // Toggle atual
                dropdown.classList.toggle('show');
                this.classList.toggle('active');
            });
        });

        // Lógica do Menu Mobile
        const sidebar = document.getElementById('sidebar');
        const mobileOverlay = document.getElementById('mobileOverlay');
        const mobileMenuToggle = document.getElementById('mobileMenuToggle');
        const sidebarClose = document.getElementById('sidebarClose');
        function openSidebar() {
            if(sidebar) sidebar.classList.add('active');
            if(mobileOverlay) mobileOverlay.classList.add('active');
            document.body.style.overflow = 'hidden';
            if (mobileMenuToggle) { mobileMenuToggle.innerHTML = '<i class="bi bi-x-lg"></i>'; }
        }
        function closeSidebar() {
            if(sidebar) sidebar.classList.remove('active');
            if(mobileOverlay) mobileOverlay.classList.remove('active');
            document.body.style.overflow = '';
            if (mobileMenuToggle) { mobileMenuToggle.innerHTML = '<i class="bi bi-list"></i>'; }
        }
        if (mobileMenuToggle) {
            mobileMenuToggle.addEventListener('click', function() {
                if (sidebar.classList.contains('active')) { closeSidebar(); } else { openSidebar(); }
            });
        }
        if (sidebarClose) { sidebarClose.addEventListener('click', closeSidebar); }
        if (mobileOverlay) { mobileOverlay.addEventListener('click', closeSidebar); }
        if (window.innerWidth <= 768) {
            document.querySelectorAll('.sidebar .nav-link:not(.nav-dropdown-toggle)').forEach(link => {
                link.addEventListener('click', closeSidebar);
            });
        }

        // Lógica do Toggle Desktop (Botão no Topbar)
        const topbarToggle = document.getElementById('topbarToggle'); 
        const contentWrapper = document.getElementById('content-wrapper');
        if (topbarToggle && sidebar && contentWrapper) {
            topbarToggle.addEventListener('click', function() {
                sidebar.classList.toggle('collapsed');
                contentWrapper.classList.toggle('full-width');
                localStorage.setItem('sidebarCollapsed', sidebar.classList.contains('collapsed'));
            });
        }
        // Restaurar estado
        if (window.innerWidth > 768 && localStorage.getItem('sidebarCollapsed') === 'true') {
            if(sidebar) sidebar.classList.add('collapsed');
            if(contentWrapper) contentWrapper.classList.add('full-width');
        }
    })();


    // ==========================================
    // LÓGICA DO TEMA (CORRIGIDA)
    // ==========================================
    (function() {
        const themeToggle = document.getElementById('theme-toggle');
        const htmlElement = document.documentElement;
        
        function applyTheme(theme) {
            // Aplica os dois atributos para garantir compatibilidade com CSS do Bootstrap e Personalizado
            htmlElement.setAttribute('data-theme', theme);
            htmlElement.setAttribute('data-bs-theme', theme); 
            localStorage.setItem('theme', theme);
        }
        
        if (themeToggle) {
            themeToggle.addEventListener('click', () => {
                const currentTheme = htmlElement.getAttribute('data-bs-theme') || 'light';
                const newTheme = currentTheme === 'dark' ? 'light' : 'dark';
                applyTheme(newTheme);
            });
        }
        
        const savedTheme = localStorage.getItem('theme') || 'light'; 
        applyTheme(savedTheme);
    })();

    // ==========================================
    // LÓGICA DOS MODAIS (do seu painel)
    // ==========================================
    function enviarFormulario (formId, url) {
        const form = document.getElementById(formId); 
        if (!form) {
            console.error('Formulário não encontrado:', formId);
            Swal.fire('Erro!', 'O formulário não foi encontrado. (formId: ' + formId + ')', 'error');
            return;
        }
        const formData = new FormData(form);
        Swal.fire({
            title: 'Aguarde...',
            text: 'Processando sua solicitação.',
            allowOutsideClick: false,
            didOpen: () => {
                Swal.showLoading();
            }
        });
        fetch(url, {
            method: 'POST',
            body: formData 
        })
        .then(response => response.json())
        .then(res => {
            if (res.title && res.msg && res.icon) {
                Swal.fire(res.title, res.msg, res.icon);
            } else {
                Swal.close();
            }
            if (res.data_table === 'atualizar') {
                try {
                    // Tenta recarregar DataTables se existirem
                    if (typeof $ !== 'undefined' && $.fn.DataTable.isDataTable('#tabela_revendedores')) {
                         $('#tabela_revendedores').DataTable().ajax.reload(null, false);
                    }
                    if (typeof $ !== 'undefined' && $.fn.DataTable.isDataTable('#tabela_clientes')) {
                         $('#tabela_clientes').DataTable().ajax.reload(null, false);
                    }
                    if (typeof $ !== 'undefined' && $.fn.DataTable.isDataTable('#tabela_testes')) {
                         $('#tabela_testes').DataTable().ajax.reload(null, false);
                    }
                } catch (e) {
                    console.warn("DataTable não encontrado ou erro ao recarregar:", e);
                }
                
                let modalAtivoEl = document.querySelector('.modal.show');
                if (modalAtivoEl && modalAtivoEl.id !== 'infoRevendedorModal' && modalAtivoEl.id !== 'infoCreditosModal') {
                    const modalAtivo = bootstrap.Modal.getInstance(modalAtivoEl);
                    if(modalAtivo) modalAtivo.hide();
                }
            }
            if (res.show_copy_modal && res.copy_message_html && res.copy_div_id) {
                const modalId = res.show_copy_modal; 
                const contentDivId = res.copy_div_id; 
                const copyModalElement = document.getElementById(modalId);
                const contentElement = document.getElementById(contentDivId);
                if (copyModalElement && contentElement) {
                    contentElement.innerHTML = res.copy_message_html;
                    contentElement.setAttribute('data-raw-text', res.copy_message_raw); 
                    const modal = new bootstrap.Modal(copyModalElement);
                    modal.show();
                } else {
                    console.error('Modal de cópia ou div de conteúdo não encontrado(a):', modalId, contentDivId);
                }
            }
        })
        .catch(error => {
            console.error('Erro ao enviar formulário:', error);
            Swal.fire('Erro!', 'Ocorreu um erro de comunicação. Tente novamente.', 'error');
        });
    }

    function copiarTextoModal(elementId) {
        const contentElement = document.getElementById(elementId);
        const textToCopy = contentElement.getAttribute('data-raw-text'); 
        if (!textToCopy) {
             Swal.fire('Atenção!', 'Nenhum texto para copiar.', 'warning');
             return;
        }
        if (navigator.clipboard) {
            navigator.clipboard.writeText(textToCopy).then(() => {
                Swal.fire('Copiado!', 'Os dados foram copiados.', 'success');
            }).catch(err => {
                console.error('Erro ao copiar:', err);
                Swal.fire('Erro!', 'Não foi possível copiar.', 'error');
            });
        } else {
            const textArea = document.createElement("textarea");
            textArea.value = textToCopy;
            document.body.appendChild(textArea);
            textArea.focus();
            textArea.select();
            try {
                document.execCommand('copy');
                Swal.fire('Copiado!', 'Os dados foram copiados.', 'success');
            } catch (err) {
                console.error('Erro ao copiar (fallback):', err);
                Swal.fire('Erro!', 'Não foi possível copiar.', 'error');
            }
            document.body.removeChild(textArea);
        }
    }

    function enviarParaWhatsAppModal(elementId) {
        const contentElement = document.getElementById(elementId);
        const textToCopy = contentElement.getAttribute('data-raw-text'); 
        if (!textToCopy) {
             Swal.fire('Atenção!', 'Nenhum texto para enviar.', 'warning');
             return;
        }
        const whatsappUrl = "https://api.whatsapp.com/send?text=" + encodeURIComponent(textToCopy);
        window.open(whatsappUrl, '_blank');
    }

    function exibirModalP2P(titulo, mensagem) {
        const label = document.getElementById('modal_p2p_info_label');
        const content = document.getElementById('p2p-info-content');
        const link = document.getElementById('p2p-whatsapp-link');
        
        if (label) label.innerText = titulo;
        if (content) content.innerText = mensagem;
        if (link) link.href = `https://api.whatsapp.com/send?text=${encodeURIComponent(mensagem)}`;
        
        const infoModalEl = document.getElementById('modal_p2p_info');
        if (infoModalEl) {
            const infoModal = new bootstrap.Modal(infoModalEl);
            infoModal.show();
        }
    }

    function copiarInfoP2P() {
        var textoParaCopiar = document.getElementById('p2p-info-content').innerText;
        navigator.clipboard.writeText(textoParaCopiar).then(() => {
            if (typeof Swal !== 'undefined') {
                Swal.fire('Copiado!', 'Texto copiado para a área de transferência!', 'success');
            } else {
                alert('Texto copiado!');
            }
        }).catch(err => {
            console.error('Erro ao copiar: ', err);
        });
    }
    
    // ==========================================
    // LÓGICA DE INICIALIZAÇÃO (UNIVERSAL)
    // ==========================================
    document.addEventListener('DOMContentLoaded', function() {
        document.body.classList.add('loaded'); // Adiciona 'loaded' (do ZenPanel)
        
        // Atualizar versão na sidebar (do seu painel de dashboard)
        async function checkVersionSidebar() {
            try {
                const response = await fetch('api/check_update.php');
                const data = await response.json();
                const sidebarVersionEl = document.getElementById('current-version-text-sidebar');
                if (sidebarVersionEl) {
                    sidebarVersionEl.textContent = 'v' + data.current_version;
                }
            } catch (e) {
                console.error('Erro ao checar versão da sidebar:', e);
                const sidebarVersionEl = document.getElementById('current-version-text-sidebar');
                if (sidebarVersionEl) { sidebarVersionEl.textContent = 'vN/A'; }
            }
        }
        // Só executa se o elemento existir (evita erros em páginas sem sidebar)
        if (document.getElementById('current-version-text-sidebar')) {
            checkVersionSidebar();
        }

        // INICIALIZAÇÃO DE DATATABLES (do ZenPanel)
        if (typeof $ !== 'undefined' && typeof $.fn.dataTable !== 'undefined') {
            $('.datatable').DataTable({ 
                responsive: true,
                language: { url: 'https://cdn.datatables.net/plug-ins/1.13.7/i18n/pt-BR.json' },
                pageLength: 25,
                order: [[0, 'desc']],
                columnDefs: [ { targets: 'no-sort', orderable: false } ]
            });
        }

        // ==========================================
        //    NOVO SCRIPT PARA SUBMENU NO TOPBAR
        // ==========================================
        let submenuToggles = document.querySelectorAll('.dropdown-menu .dropdown-submenu > a');
        submenuToggles.forEach(function(toggle) {
            toggle.addEventListener('click', function(e) {
                e.preventDefault();
                e.stopPropagation();

                let submenu = this.nextElementSibling;
                if (!submenu) return;

                let parentMenu = this.closest('.dropdown-menu');
                if (parentMenu) {
                    parentMenu.querySelectorAll('.dropdown-menu.show').forEach(function(otherSubmenu) {
                        if (otherSubmenu !== submenu) {
                            otherSubmenu.classList.remove('show');
                        }
                    });
                }
                submenu.classList.toggle('show');
            });
        });

        document.addEventListener('click', function(e) {
            if (!e.target.closest('.dropdown-submenu')) {
                document.querySelectorAll('.dropdown-submenu .dropdown-menu').forEach(function(submenu) {
                    submenu.classList.remove('show');
                });
            }
        });

    });
</script>

</body>
</html>