<?php
// ARQUIVO: /gerenciador/canal_editar.php (VERSÃO FINAL COMPLETA - CORREÇÃO DARK MODE)

require_once('../api/controles/db.php');
$pdo = conectar_bd();
if (!$pdo) { die("Falha fatal ao conectar ao banco de dados."); }

$id = $_GET['id'] ?? null;
if (!$id) { die("ID do canal não fornecido."); }

// Busca os dados do canal específico
$stmt = $pdo->prepare("SELECT * FROM streams WHERE id = :id AND stream_type = 'live'");
$stmt->execute([':id' => $id]);
$canal = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$canal) { die("Canal não encontrado."); }

$categorias = $pdo->query("SELECT id, nome FROM categoria ORDER BY nome")->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Editar Canal: <?= htmlspecialchars($canal['name']) ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css">
    <style>
        /* TEMA CLARO (Padrão) */
        body { background-color: #f0f2f5; color: #333; }
        .card { border: none; border-radius: 0.75rem; box-shadow: 0 4px 6px rgba(0,0,0,0.1); }
        .form-label { font-weight: bold; color: #333; }
        
        /* --- TEMA ESCURO --- */
        body.dark-mode { background-color: #121212; color: #e0e0e0; }
        body.dark-mode .card { background-color: #1e1e1e; border: 1px solid #2c2c2c; }
        body.dark-mode .card-header { background-color: #1e1e1e !important; border-bottom: 1px solid #2c2c2c; }
        body.dark-mode .card-header h4 { color: #ffffff; }
        
        /* CORREÇÃO: Labels e Inputs Brancos */
        body.dark-mode .form-label { color: #f0f0f0 !important; }
        
        body.dark-mode .form-control, 
        body.dark-mode .form-select { 
            background-color: #2a2a2a; 
            color: #ffffff !important; /* Texto branco dentro do input */
            border-color: #444; 
        }
        
        /* Placeholder mais claro no modo escuro */
        body.dark-mode .form-control::placeholder { color: #aaa; opacity: 1; }
    </style>
</head>
<body>
    <div class="container my-4">
        <div class="card">
            <div class="card-header bg-white p-3 d-flex justify-content-between align-items-center">
                <h4 class="mb-0"><i class="fas fa-pencil-alt me-2"></i>Editar Canal</h4>
                <a href="canais.php" class="btn btn-secondary">Voltar para a Lista</a>
            </div>
            <div class="card-body p-4">
                <form id="editCanalForm">
                    <input type="hidden" name="id" value="<?= htmlspecialchars($canal['id']) ?>">
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label for="name" class="form-label">Nome do Canal</label>
                            <input type="text" class="form-control" id="name" name="name" value="<?= htmlspecialchars($canal['name']) ?>" required>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label for="category_id" class="form-label">Categoria</label>
                            <select class="form-select" id="category_id" name="category_id" required>
                                <?php foreach ($categorias as $cat): ?>
                                    <option value="<?= htmlspecialchars($cat['id']) ?>" <?= ($canal['category_id'] == $cat['id']) ? 'selected' : '' ?>>
                                        <?= htmlspecialchars($cat['nome']) ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                    </div>
                    <div class="mb-3">
                        <label for="stream_icon" class="form-label">URL do Logo</label>
                        <input type="text" class="form-control" id="stream_icon" name="stream_icon" value="<?= htmlspecialchars($canal['stream_icon']) ?>">
                    </div>
                    <div class="mb-3">
                        <label for="epg_channel_id" class="form-label">ID do EPG (Opcional)</label>
                        <input type="text" class="form-control" id="epg_channel_id" name="epg_channel_id" value="<?= htmlspecialchars($canal['epg_channel_id']) ?>">
                    </div>
                    <div class="mb-3">
                        <label for="link" class="form-label">URL do Stream</label>
                        <input type="text" class="form-control" id="link" name="link" value="<?= htmlspecialchars($canal['link']) ?>" required>
                    </div>
                    <div class="d-grid mt-4">
                        <button type="submit" class="btn btn-success btn-lg">Salvar Alterações</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

<script>
// --- JAVASCRIPT DO TEMA ---
(function() {
    const themeKey = 'theme'; 
    function applyTheme() {
        const savedTheme = localStorage.getItem(themeKey);
        document.body.classList.toggle('dark-mode', savedTheme === 'dark');
    }
    applyTheme();
    window.addEventListener('storage', e => { if (e.key === themeKey) applyTheme(); });
    // Check periódico removido pois o listener de storage já resolve entre abas
})();

// --- JAVASCRIPT PARA SALVAR O FORMULÁRIO ---
document.getElementById('editCanalForm').addEventListener('submit', async function(event) {
    event.preventDefault();
    const form = event.target;
    const formData = new FormData(form);
    const submitButton = form.querySelector('button[type="submit"]');
    
    submitButton.disabled = true;
    submitButton.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Salvando...';
    
    try {
        // Caminho absoluto para garantir que ache o arquivo
        const response = await fetch('/gerenciador/ajax/canal_atualizar.php', { method: 'POST', body: formData });
        
        const text = await response.text();
        try {
            const result = JSON.parse(text);
            alert(result.message);
            if (result.success) {
                window.location.href = 'canais.php';
            }
        } catch (e) {
            console.error("Resposta inválida do servidor:", text);
            alert("Erro técnico no servidor. Verifique o console.");
        }
    } catch (error) {
        console.error(error);
        alert('Ocorreu um erro de comunicação.');
    } finally {
        submitButton.disabled = false;
        submitButton.innerHTML = 'Salvar Alterações';
    }
});
</script>

</body>
</html>