<?php
// ARQUIVO: /gerenciador/episodio_editar.php
require_once('../api/controles/db.php');
$pdo = conectar_bd();

$id = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT);
if (!$id) { die("ID do episódio inválido."); }

$stmt = $pdo->prepare("SELECT * FROM series_episodes WHERE id = ?");
$stmt->execute([$id]);
$episodio = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$episodio) { die("Episódio não encontrado."); }
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <title>Editar Episódio</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css">
    <style>
        body { background-color: #f0f2f5; }
        .card { border: none; border-radius: 0.75rem; box-shadow: 0 4px 6px rgba(0,0,0,0.1); }
        body.dark-mode { background-color: #121212; color: #e0e0e0; }
        body.dark-mode .card { background-color: #1e1e1e; border: 1px solid #2c2c2c; }
        body.dark-mode .card-header, body.dark-mode h4, body.dark-mode .form-label { color: #ffffff; }
        body.dark-mode .form-control { background-color: #2a2a2a; border-color: #3c3c3c; color: #e0e0e0; }
        body.dark-mode .form-control:focus { background-color: #2a2a2a; border-color: #0d6efd; color: #e0e0e0; }
    </style>
</head>
<body>
<div class="container mt-4">
    <div class="card">
        <div class="card-header"><h4><i class="fas fa-pencil-alt me-2"></i>Editar Episódio</h4></div>
        <div class="card-body">
            <form action="episodio_atualizar.php" method="POST">
                <input type="hidden" name="id" value="<?= htmlspecialchars($episodio['id']) ?>">
                <input type="hidden" name="season_id" value="<?= htmlspecialchars($episodio['season']) ?>">
                <div class="row">
                    <div class="col-md-8 mb-3"><label for="title" class="form-label">Título</label><input type="text" class="form-control" id="title" name="title" value="<?= htmlspecialchars($episodio['title']) ?>" required></div>
                    <div class="col-md-4 mb-3"><label for="episode_num" class="form-label">Número</label><input type="number" class="form-control" id="episode_num" name="episode_num" value="<?= htmlspecialchars($episodio['episode_num']) ?>" required></div>
                </div>
                <div class="mb-3"><label for="link" class="form-label">Link/Caminho</label><input type="text" class="form-control" id="link" name="link" value="<?= htmlspecialchars($episodio['link']) ?>"></div>
                <div class="mb-3"><label for="plot" class="form-label">Sinopse</label><textarea class="form-control" id="plot" name="plot" rows="3"><?= htmlspecialchars($episodio['plot']) ?></textarea></div>
                <div class="row">
                    <div class="col-md-6 mb-3"><label for="duration_secs" class="form-label">Duração (segundos)</label><input type="number" class="form-control" id="duration_secs" name="duration_secs" value="<?= htmlspecialchars($episodio['duration_secs']) ?>"></div>
                    <div class="col-md-6 mb-3"><label for="cover_big" class="form-label">URL da Capa</label><input type="text" class="form-control" id="cover_big" name="cover_big" value="<?= htmlspecialchars($episodio['cover_big']) ?>"></div>
                </div>
                <a href="episodios_gerenciar.php?season_id=<?= htmlspecialchars($episodio['season']) ?>" class="btn btn-secondary">Cancelar</a>
                <button type="submit" class="btn btn-primary">Atualizar Episódio</button>
            </form>
        </div>
    </div>
</div>
<script>(function() { const themeKey = 'theme'; function applyTheme() { const savedTheme = localStorage.getItem(themeKey); document.body.classList.toggle('dark-mode', savedTheme === 'dark'); } applyTheme(); })();</script>
</body>
</html>