<?php
// ARQUIVO: /gerenciador/temporada_adicionar.php
require_once('../api/controles/db.php');
$pdo = conectar_bd();

// Pega o ID da série da URL para saber onde adicionar a temporada
$series_id = filter_input(INPUT_GET, 'series_id', FILTER_VALIDATE_INT);
if (!$series_id) {
    die("ID da série é inválido ou não foi fornecido.");
}

// (Opcional) Busca o nome da série para exibir no título
$stmt_serie = $pdo->prepare("SELECT name FROM series WHERE id = ?");
$stmt_serie->execute([$series_id]);
$serie = $stmt_serie->fetch(PDO::FETCH_ASSOC);
$nome_serie = $serie ? $serie['name'] : 'Série Desconhecida';

// A lógica para salvar o formulário virá aqui depois
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Adicionar Nova Temporada</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css">
    <style>
        /* Seus estilos CSS podem ser colocados aqui ou em um arquivo separado */
        body { background-color: #f0f2f5; }
        .card { border: none; border-radius: 0.75rem; box-shadow: 0 4px 6px rgba(0,0,0,0.1); }
        body.dark-mode { background-color: #121212; color: #e0e0e0; }
        body.dark-mode .card { background-color: #1e1e1e; border: 1px solid #2c2c2c; }
        body.dark-mode .card-header, body.dark-mode h4, body.dark-mode .form-label { color: #ffffff; }
        body.dark-mode .form-control { background-color: #2a2a2a; border-color: #3c3c3c; color: #e0e0e0; }
        body.dark-mode .form-control:focus { background-color: #2a2a2a; border-color: #0d6efd; color: #e0e0e0; }
    </style>
</head>
<body>
    <div class="container mt-4">
        <div class="card">
            <div class="card-header">
                <h4><i class="fas fa-plus me-2"></i>Adicionar Temporada para: <strong><?= htmlspecialchars($nome_serie) ?></strong></h4>
            </div>
            <div class="card-body">
                <form action="temporada_salvar.php" method="POST">
                    
                    <input type="hidden" name="series_id" value="<?= htmlspecialchars($series_id) ?>">

                    <div class="mb-3">
                        <label for="name" class="form-label">Nome da Temporada</label>
                        <input type="text" class="form-control" id="name" name="name" placeholder="Ex: Temporada 1" required>
                    </div>

                    <div class="mb-3">
                        <label for="season_number" class="form-label">Número da Temporada</label>
                        <input type="number" class="form-control" id="season_number" name="season_number" placeholder="Ex: 1" required>
                    </div>

                    <div class="mb-3">
                        <label for="cover" class="form-label">URL da Imagem de Capa</label>
                        <input type="text" class="form-control" id="cover" name="cover" placeholder="https://exemplo.com/capa.jpg">
                    </div>

                    <a href="serie_episodios.php?id=<?= htmlspecialchars($series_id) ?>" class="btn btn-secondary">
                        <i class="fas fa-arrow-left me-2"></i>Cancelar
                    </a>
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-save me-2"></i>Salvar Temporada
                    </button>

                </form>
            </div>
        </div>
    </div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<script>
// Lógica do tema escuro
(function() { const themeKey = 'theme'; function applyTheme() { const savedTheme = localStorage.getItem(themeKey); document.body.classList.toggle('dark-mode', savedTheme === 'dark'); } applyTheme(); })();
</script>
</body>
</html>