﻿<?php
// ======================================================================
// GERENCIADOR DE BOUQUETS v4.0 - CONECTADO AO db.php
// ======================================================================

// --- 1. CONEXÃO CENTRALIZADA ---
$db_path = 'api/controles/db.php';
if (!file_exists($db_path)) {
    http_response_code(500);
    die('Erro: Arquivo de configuração do banco de dados não encontrado em ' . $db_path);
}
require_once($db_path);

try {
    $pdo = conectar_bd();
} catch (PDOException $e) {
    exit();
}

// --- 2. LÓGICA DA API INTERNA (PARA AJAX) ---
$action = $_POST['action'] ?? $_GET['action'] ?? '';

if ($action) {
    // [CORREÇÃO DE CHARSET] Garante que o PHP entenda UTF-8
    $pdo->exec("SET NAMES 'utf8mb4'");
    header('Content-Type: application/json; charset=utf-8');
    
    $bouquet_item_table = 'bouquet_items'; 

    try {
        switch ($action) {
            case 'get_all_bouquets':
                $bouquets = $pdo->query("SELECT id, bouquet_name FROM `bouquets` ORDER BY `bouquet_name` ASC")->fetchAll();
                echo json_encode(['status' => 'success', 'data' => $bouquets]);
                break;

            case 'get_bouquet_details':
                $bouquet_id = intval($_POST['id'] ?? 0);
                
                $sql_all_categories = "
                    SELECT
                        c.id, c.nome, c.type,
                        CASE
                            WHEN c.type = 'series' THEN (SELECT COUNT(*) FROM `series` s WHERE s.category_id = c.id)
                            ELSE (SELECT COUNT(*) FROM `streams` st WHERE st.category_id = c.id AND st.stream_type = c.type)
                        END AS content_count
                    FROM `categoria` c
                    ORDER BY c.type, c.position ASC
                ";
                $all_categories_stmt = $pdo->query($sql_all_categories);
                $all_categories = $all_categories_stmt->fetchAll();

                $stmt = $pdo->prepare("SELECT category_id FROM `$bouquet_item_table` WHERE bouquet_id = ?");
                $stmt->execute([$bouquet_id]);
                $selected_categories_ids = $stmt->fetchAll(PDO::FETCH_COLUMN);
                $selected_categories_ids = array_map('strval', $selected_categories_ids);
                
                echo json_encode(['status' => 'success', 'data' => ['all' => $all_categories, 'selected' => $selected_categories_ids]]);
                break;

            case 'save_bouquet':
                $id = intval($_POST['id'] ?? 0);
                $name = trim($_POST['name'] ?? '');
                $category_ids = $_POST['categories'] ?? [];
                
                if (empty($name)) { http_response_code(400); echo json_encode(['status' => 'error', 'message' => 'O nome do bouquet é obrigatório.']); exit(); }
                
                $pdo->beginTransaction();
                try {
                    if ($id > 0) {
                        $stmt = $pdo->prepare("UPDATE `bouquets` SET bouquet_name = ? WHERE id = ?");
                        $stmt->execute([$name, $id]);
                    } else {
                        $stmt = $pdo->prepare("INSERT INTO `bouquets` (bouquet_name) VALUES (?)");
                        $stmt->execute([$name]);
                        $id = $pdo->lastInsertId();
                    }
                    $stmt = $pdo->prepare("DELETE FROM `$bouquet_item_table` WHERE bouquet_id = ?");
                    $stmt->execute([$id]);
                    
                    if (!empty($category_ids)) {
                        $stmt = $pdo->prepare("INSERT INTO `$bouquet_item_table` (bouquet_id, category_id) VALUES (?, ?)");
                        foreach ($category_ids as $cat_id) {
                            $stmt->execute([$id, intval($cat_id)]);
                        }
                    }
                    $pdo->commit();
                    echo json_encode(['status' => 'success', 'message' => 'Bouquet salvo com sucesso!']);
                } catch (Exception $e) { $pdo->rollBack(); http_response_code(500); echo json_encode(['status' => 'error', 'message' => 'Erro ao salvar o bouquet: '.$e->getMessage()]); }
                break;
                
            case 'delete_bouquet':
                $id = intval($_POST['id'] ?? 0);
                $pdo->beginTransaction();
                try {
                    $pdo->prepare("DELETE FROM `bouquets` WHERE id = ?")->execute([$id]);
                    $pdo->prepare("DELETE FROM `$bouquet_item_table` WHERE bouquet_id = ?")->execute([$id]);
                    $pdo->commit();
                    echo json_encode(['status' => 'success', 'message' => 'Bouquet apagado com sucesso!']);
                } catch (Exception $e) { $pdo->rollBack(); http_response_code(500); echo json_encode(['status' => 'error', 'message' => 'Erro ao apagar o bouquet.']); }
                break;
        }
    exit();
} catch (Exception $e) {
    if ($pdo->inTransaction()) { $pdo->rollBack(); }
    http_response_code(500);
    echo json_encode(['status' => 'error', 'message' => 'Erro interno na API: '.$e->getMessage()]);
    exit();
}
}

// --- 3. INCLUSÃO DO MENU E DADOS INICIAIS ---
if (file_exists("menu.php")) {
    require_once("menu.php");
}

$bouquets_iniciais = $pdo->query("SELECT id, bouquet_name FROM `bouquets` ORDER BY `bouquet_name` ASC")->fetchAll();
?>

<style>
    /* 1. Cores Padrão (Tema Claro) */
    .bouquet-container {
        color: #333; /* Texto escuro */
    }
    .bouquet-card {
        background: #ffffff; /* Fundo do card claro */
        border: 1px solid #dee2e6; /* Borda clara */
    }
    .bouquet-table th {
        background-color: #f4f7f6;
    }
    .bouquet-table td, .bouquet-table th {
        border-color: #dee2e6;
        color: #333;
    }

    /* 2. Sobrescreve para o TEMA ESCURO */
    [data-theme="dark"] .bouquet-container {
        color: #e0e0ff; /* Texto claro */
    }
    [data-theme="dark"] .bouquet-card {
        background: #2a2e33 !important; 
        color: #e4e6eb !important; 
        border-color: #3a3f44 !important;
    }
    [data-theme="dark"] .bouquet-table th {
        background-color: #343a40;
    }
    [data-theme="dark"] .bouquet-table td,
    [data-theme="dark"] .bouquet-table th {
        border-color: #3a3f44;
        color: #e4e6eb;
    }

    /* 3. Cores do Modal (Tema Claro) */
    .modal-content-custom {
        background: #ffffff;
        color: #333;
    }
    .modal-content-custom input[type="text"] {
        border-color: #dee2e6;
        background-color: #ffffff;
        color: #333;
    }
    .category-column {
        background: #fdfdfd;
        border-color: #dee2e6;
    }
    .category-column h3 {
        color: #333;
    }
    .category-list label {
        color: #333;
    }
    .category-list label:hover {
        background-color: #f1f1f1;
    }
    .category-count {
        color: #555;
    }

    /* 4. Cores do Modal (Tema Escuro) */
    [data-theme="dark"] .modal-content-custom {
        background: #2a2a4a;
        color: #e0e0ff;
    }
    [data-theme="dark"] .modal-content-custom input[type="text"] {
        border-color: #444466;
        background-color: #22223b;
        color: #e0e0ff;
    }
    [data-theme="dark"] .category-column {
        background: #22223b;
        border-color: #444466;
    }
    [data-theme="dark"] .category-column h3 {
        color: #e0e0ff;
    }
    [data-theme="dark"] .category-list label {
        color: #e0e0ff;
    }
    [data-theme="dark"] .category-list label:hover {
        background-color: #333355;
    }
    [data-theme="dark"] .category-count {
        color: #b0b0d0;
    }

    /* ==============================================
       Estilos de Layout (Ajustados)
       ============================================== */
    
    body {
        font-family: 'Poppins', sans-serif;
        /* background-color: var(--bg-color); */ /* Removido - menu.php controla isso */
        margin: 0;
        /* padding: 20px; */ /* Removido - menu.php controla isso */
        /* color: var(--text-color); */ /* Removido - menu.php controla isso */
        transition: background-color 0.3s, color 0.3s;
    }
    .bouquet-container {
        max-width: 1100px;
        margin: 0 auto; /* Ajustado para centralizar no container-fluid */
        transition: background 0.3s;
    }
    .bouquet-card {
        padding: 30px;
        border-radius: 12px;
        box-shadow: 0 4px 12px rgba(0,0,0,0.1);
    }
    h1 {
        text-align: center;
        color: var(--primary-color, #4a90e2);
        margin-bottom: 30px;
        font-weight: 600;
    }
    .top-actions {
        display: flex;
        justify-content: flex-end;
        align-items: center;
        margin-bottom: 20px;
        gap: 15px;
    }
    .action-button {
        font-size: 14px;
        font-weight: 500;
        padding: 12px 24px;
        color: #fff;
        border: none;
        border-radius: 8px;
        cursor: pointer;
        transition: background-color 0.3s, box-shadow 0.3s;
        box-shadow: 0 2px 4px rgba(0,0,0,0.1);
    }
    #createBouquetBtn { background-color: var(--success-color, #28a745); }
    #createBouquetBtn:hover { background-color: var(--success-hover, #218838); }

    /* [CORREÇÃO Z-INDEX] */
    .modal-overlay {
        position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background: rgba(0,0,0,0.7); 
        display: none;
        justify-content: center;
        align-items: center;
        z-index: 1050; /* Mais alto que o menu (que geralmente é 1030-1040) */
    }
    .modal-content-custom { /* Renomeado de .modal-content para evitar conflito com Bootstrap */
        padding: 30px;
        border-radius: 12px;
        width: 95%;
        max-width: 1000px;
        max-height: 90vh;
        overflow-y: auto;
        box-shadow: 0 10px 30px rgba(0,0,0,0.2);
        transition: background 0.3s, color 0.3s;
    }
    .modal-content-custom h2 {
        margin-top: 0;
        color: var(--primary-color, #4a90e2);
        font-weight: 600;
    }
    #bouquet_name {
        width: 100%;
        padding: 12px;
        font-size: 16px;
        margin-bottom: 25px;
        box-sizing: border-box;
        border: 1px solid var(--border-color);
        border-radius: 8px;
    }
    
    .category-columns {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(280px, 1fr));
        gap: 25px;
    }
    .category-column {
        border: 1px solid var(--border-color);
        padding: 15px;
        border-radius: 8px;
        transition: background 0.3s;
    }
    .category-column h3 {
        margin-top: 0;
        border-bottom: 2px solid var(--primary-color, #4a90e2);
        padding-bottom: 10px;
        font-size: 1.1em;
        font-weight: 600;
    }
    .category-list {
        max-height: 400px;
        overflow-y: auto;
        padding-right: 10px;
    }
    .category-list label {
        display: flex;
        align-items: center;
        gap: 10px;
        margin-bottom: 8px;
        cursor: pointer;
        padding: 8px;
        border-radius: 5px;
        transition: background-color 0.2s;
    }
    .category-list label:hover {
        background-color: var(--border-color);
    }
    .category-count {
        font-size: 0.9em;
        margin-left: 5px;
    }

    #saveButton { background-color: var(--success-color, #28a745); }
    #saveButton:hover { background-color: var(--success-hover, #218838); }
    #cancelButton { background-color: var(--cancel-color, #6c757d); }
    #cancelButton:hover { background-color: var(--cancel-hover, #5a6268); }

    input[type="checkbox"] {
        accent-color: var(--primary-color, #4a90e2);
    }
    
    /* Tabela de Bouquets */
    .bouquet-table {
        width: 100%;
        border-collapse: collapse;
        margin-top: 20px;
    }
    .bouquet-table th, .bouquet-table td {
        padding: 15px;
        text-align: left;
    }
    .bouquet-table tr {
        border-bottom: 1px solid var(--border-color);
    }
    .bouquet-table tr:last-child {
        border-bottom: none;
    }
    .bouquet-table .actions button {
        background: none;
        border: none;
        cursor: pointer;
        font-size: 16px;
        margin-left: 10px;
        color: var(--text-light);
    }
    .bouquet-table .actions button:hover {
        color: var(--primary-color);
    }

</style>

<div class="container-fluid py-4"> <div class="bouquet-container">
        <div class="bouquet-card">
            <div class="top-actions">
                <button id="createBouquetBtn" class="action-button"><i class="fas fa-plus me-1"></i> Criar Novo Bouquet</button>
            </div>
            <table class="bouquet-table">
                <thead>
                    <tr>
                        <th>Nome do Bouquet</th>
                        <th width="120px" class="text-center">Ações</th>
                    </tr>
                </thead>
                <tbody></tbody>
            </table>
        </div>
    </div>
</div>

<div id="bouquetModal" class="modal-overlay">
    <div class="modal-content-custom">
        <h2 id="modalTitle"></h2>
        <input type="hidden" id="bouquet_id">
        <input type="text" id="bouquet_name" class="form-control" placeholder="Nome do Pacote (ex: Plano Básico)">
        <div class="category-columns">
            <div class="category-column" id="live-column">
                <h3>Canais</h3>
                <label class="select-all-label"><input type="checkbox" class="select-all-checkbox" data-target-column="live-column"> Selecionar Tudo</label>
                <div class="category-list"></div>
            </div>
            <div class="category-column" id="movie-column">
                <h3>Filmes</h3>
                <label class="select-all-label"><input type="checkbox" class="select-all-checkbox" data-target-column="movie-column"> Selecionar Tudo</label>
                <div class="category-list"></div>
            </div>
            <div class="category-column" id="series-column">
                <h3>Séries</h3>
                <label class="select-all-label"><input type="checkbox" class="select-all-checkbox" data-target-column="series-column"> Selecionar Tudo</label>
                <div class="category-list"></div>
            </div>
        </div>
        <div class="modal-actions" style="margin-top: 20px;">
            <button id="cancelButton" class="action-button">Cancelar</button>
            <button id="saveButton" class="action-button">Salvar</button>
        </div>
    </div>
</div>

<script>
$(document).ready(function() {
    const modal = $('#bouquetModal');
    const tableBody = $('.bouquet-table tbody');
    
    // [CORREÇÃO] Remove a lógica de tema daqui.
    // O seu 'menu.php' e 'footer.php' já controlam o tema.
    // O CSS acima agora usa [data-theme="dark"] e vai funcionar automaticamente.

    function apiRequest(action, data, callback) {
        // [CORREÇÃO] Adiciona o Token de Sessão em todos os POSTs
        if (typeof SESSION_TOKEN !== 'undefined') {
            data.token = SESSION_TOKEN;
        }
        
        $.post(window.location.pathname, { action, ...data })
            .done(callback)
            .fail(function(jqXHR) {
                const errorMsg = jqXHR.responseJSON?.message || 'Ocorreu um erro desconhecido.';
                Swal.fire('Erro na API!', errorMsg, 'error');
            });
    }

    function loadBouquets() {
        tableBody.html('<tr><td colspan="2">Carregando...</td></tr>');
        
        // [CORREÇÃO] Usa a função 'apiRequest' (que envia o token)
        apiRequest('get_all_bouquets', {}, function(res) {
            tableBody.empty();
            if (res.status === 'success' && res.data && res.data.length > 0) {
                res.data.forEach(function(bouquet) {
                    tableBody.append(`
                        <tr data-id="${bouquet.id}">
                            <td>${$('<textarea />').html(bouquet.bouquet_name).text()}</td>
                            <td class="actions text-center">
                                <button class="edit-btn" data-id="${bouquet.id}" title="Editar"><i class="fas fa-edit"></i></button>
                                <button class="delete-btn" data-id="${bouquet.id}" title="Apagar"><i class="fas fa-trash"></i></button>
                            </td>
                        </tr>
                    `);
                });
            } else {
                tableBody.html('<tr><td colspan="2">Nenhum bouquet encontrado. Crie um novo.</td></tr>');
            }
        });
    }

    function openModal(bouquet_id = 0, bouquet_name = '') {
        $('#bouquet_id').val(bouquet_id);
        $('#bouquet_name').val(bouquet_name);
        $('#modalTitle').text(bouquet_id ? 'Editar Bouquet' : 'Criar Novo Bouquet');
        $('.category-list').empty().html('Carregando...');
        $('.select-all-checkbox').prop('checked', false);

        apiRequest('get_bouquet_details', { id: bouquet_id }, function(res) {
            if (res.status === 'success') {
                $('.category-list').empty();

                if (!res.data.all || res.data.all.length === 0) {
                    $('.category-list').html('Nenhuma categoria cadastrada.');
                    return;
                }
                
                res.data.all.forEach(function(cat) {
                    const isChecked = res.data.selected.includes(cat.id.toString());
                    const count = cat.content_count !== null ? cat.content_count : 0;
                    const displayName = `${$('<textarea />').html(cat.nome).text()} <span class="category-count">(${count})</span>`;
                    
                    const checkbox = `
                        <label>
                            <input type="checkbox" class="category-checkbox" value="${cat.id}" ${isChecked ? 'checked' : ''}>
                            ${displayName}
                        </label>`;
                    
                    // [CORREÇÃO] O seu PHP/JS já usa 'live', 'movie', 'series'.
                    // O 'streams-column' estava errado.
                    let typeColumn = cat.type; // 'live', 'movie', 'series'
                    
                    if (typeColumn === 'live' || typeColumn === 'movie' || typeColumn === 'series') {
                        $(`#${typeColumn}-column .category-list`).append(checkbox);
                    }
                });
            } else {
                 Swal.fire('Erro!', res.message || 'Falha ao carregar categorias.', 'error');
            }
        });
        modal.css('display', 'flex');
    }
    
    // --- Eventos ---
    $('#createBouquetBtn').on('click', () => openModal());
    
    tableBody.on('click', '.edit-btn', function() {
        const id = $(this).data('id');
        const name = $(this).closest('tr').find('td:first').text();
        openModal(id, name);
    });

    $('#cancelButton').on('click', () => modal.hide());
    
    $('#saveButton').on('click', function() {
        let selectedCategories = [];
        $('.category-checkbox:checked').each(function() {
            selectedCategories.push($(this).val());
        });
        
        apiRequest('save_bouquet', {
            id: $('#bouquet_id').val(),
            name: $('#bouquet_name').val(),
            categories: selectedCategories
        }, function(res) {
            if (res.status === 'success') {
                modal.hide();
                Swal.fire('Sucesso!', res.message, 'success');
                loadBouquets();
            } else {
                Swal.fire('Erro!', res.message, 'error');
            }
        });
    });

    tableBody.on('click', '.delete-btn', function() {
        const id = $(this).data('id');
        Swal.fire({
            title: 'Tem certeza?', text: "Esta ação apagará o bouquet permanentemente!", icon: 'warning',
            showCancelButton: true, confirmButtonText: 'Sim, apagar!', cancelButtonText: 'Cancelar'
        }).then((result) => {
            if (result.isConfirmed) {
                apiRequest('delete_bouquet', { id: id }, function(res) {
                    if (res.status === 'success') {
                        Swal.fire('Apagado!', res.message, 'success');
                        loadBouquets();
                    } else { Swal.fire('Erro!', res.message, 'error'); }
                });
            }
        });
    });

    $('.select-all-checkbox').on('click', function() {
        const isChecked = $(this).prop('checked');
        const targetColumnId = $(this).data('target-column');
        $('#' + targetColumnId).find('.category-checkbox').prop('checked', isChecked);
    });
    
    loadBouquets();
});
</script>

<?php
// Inclui o rodapé
require_once("footer.php"); 
?>