<?php
// ARQUIVO: gerenciador_servidores.php (VERSÃO FINAL COM CÓDIGO À PROVA DE FALHAS)
ini_set('display_errors', 1);
error_reporting(E_ALL);

require_once($_SERVER['DOCUMENT_ROOT'] . '/api/controles/db.php');
$conexao = conectar_bd();

$secret_key = 'Jean909110'; // Use a sua chave secreta real aqui
$mensagem = '';

// --- Processar ações do formulário (POST) ---
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action'])) {
    if ($_POST['action'] == 'add_server') {
        $stmt = $conexao->prepare("INSERT INTO servers (server_name, server_ip, server_port, agent_port, max_connections) VALUES (?, ?, ?, ?, ?)");
        $stmt->execute([$_POST['server_name'], $_POST['server_ip'], $_POST['server_port'], $_POST['agent_port'], $_POST['max_connections']]);
        $mensagem = '<div class="alert alert-success">Servidor adicionado com sucesso!</div>';
    }
    elseif ($_POST['action'] == 'update_server') {
        $stmt = $conexao->prepare("UPDATE servers SET server_name=?, server_ip=?, server_port=?, agent_port=?, max_connections=? WHERE id=?");
        $stmt->execute([$_POST['edit_server_name'], $_POST['edit_server_ip'], $_POST['edit_server_port'], $_POST['edit_agent_port'], $_POST['edit_max_connections'], $_POST['edit_id']]);
        $mensagem = '<div class="alert alert-success">Servidor atualizado com sucesso!</div>';
    }
}

// --- Processar ações da URL (GET) ---
if ($_SERVER['REQUEST_METHOD'] === 'GET' && isset($_GET['action'])) {
    $id = isset($_GET['id']) ? intval($_GET['id']) : 0;
    if ($id > 0) {
        if ($_GET['action'] == 'delete') {
            $stmt = $conexao->prepare("DELETE FROM servers WHERE id = ?");
            $stmt->execute([$id]);
            header('Location: gerenciar_servidores.php?status=deleted_ok');
            exit();
        }
        elseif ($_GET['action'] == 'toggle_status') {
            $stmt_select = $conexao->prepare("SELECT status FROM servers WHERE id = ?");
            $stmt_select->execute([$id]);
            $current_status = $stmt_select->fetchColumn();
            
            if ($current_status !== false) {
                $new_status = ($current_status == 1) ? 0 : 1;
                $stmt_update = $conexao->prepare("UPDATE servers SET status = ? WHERE id = ?");
                $stmt_update->execute([$new_status, $id]);
                header('Location: gerenciar_servidores.php?status=updated_ok');
            } else {
                 header('Location: gerenciar_servidores.php?status=not_found');
            }
            exit();
        }
        elseif ($_GET['action'] == 'reboot_server') {
            $stmt = $conexao->prepare("SELECT server_ip, agent_port FROM servers WHERE id = ?");
            $stmt->execute([$id]);
            $servidor = $stmt->fetch();
            if ($servidor) {
                $url = "http://{$servidor['server_ip']}:{$servidor['agent_port']}/stats_agent.php?token=" . urlencode($secret_key) . "&action=reboot_services";
                @file_get_contents($url);
                $mensagem = '<div class="alert alert-info">Comando de reinicialização enviado para o servidor.</div>';
            }
        }
    }
}

if (isset($_GET['status']) && $_GET['status'] == 'updated_ok') {
    $mensagem = '<div class="alert alert-success">Status do servidor atualizado com sucesso!</div>';
}

require_once("menu.php");
$servidores = $conexao->query("SELECT * FROM servers ORDER BY id ASC")->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Gerenciar Servidores</title>
    <style>
        .progress { height: 18px; font-size: 0.75rem; background-color: #e9ecef; }
        .progress-bar { color: white; font-weight: bold; }
        .stat-box { font-size: 0.8rem; }
        .stat-box .value { font-weight: bold; }
        .text-muted { opacity: 0.8; }
    </style>
</head>
<body>
<div class="container-fluid">
    <h4 class="mb-4 text-muted text-uppercase">Gerenciador e Monitor de Servidores</h4>
    <?= $mensagem ?>
    <div class="card mb-4">
        <div class="card-header"><strong>Adicionar Novo Servidor</strong></div>
        <div class="card-body">
            <form action="gerenciar_servidores.php" method="POST">
                <input type="hidden" name="action" value="add_server">
                <div class="row g-2 align-items-end">
                    <div class="col-md-3"><label>Nome</label><input type="text" class="form-control" name="server_name" required></div>
                    <div class="col-md"><label>IP ou DNS</label><input type="text" class="form-control" name="server_ip" required></div>
                    <div class="col-md-1"><label>P. Stream</label><input type="number" class="form-control" name="server_port" value="8000" required></div>
                    <div class="col-md-1"><label>P. Agente</label><input type="number" class="form-control" name="agent_port" value="80" required></div>
                    <div class="col-md-2"><label>Max. Conexões</label><input type="number" class="form-control" name="max_connections" value="1000" required></div>
                    <div class="col-md-2"><button type="submit" class="btn btn-primary w-100">Adicionar</button></div>
                </div>
            </form>
        </div>
    </div>
    <div class="card">
        <div class="card-header"><strong>Servidores Cadastrados</strong></div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-striped table-hover align-middle">
                    <thead>
                        <tr><th>Servidor</th><th>Status Monitor</th><th>Status LB</th><th>Uso de Recursos</th><th class="text-center">Ações</th></tr>
                    </thead>
                    <tbody>
                        <?php if (empty($servidores)): ?>
                            <tr><td colspan="5" class="text-center">Nenhum servidor cadastrado.</td></tr>
                        <?php else: foreach ($servidores as $servidor): ?>
                            <tr>
                                <td>
                                    <strong><?= htmlspecialchars($servidor['server_name']) ?></strong><br>
                                    <small class="text-muted"><?= htmlspecialchars($servidor['server_ip']) ?></small>
                                </td>
                                <td>
                                    <?php
                                    // <<< INÍCIO DO BLOCO A PROVA DE FALHAS >>>
                                    $stats_data = null;
                                    try {
                                        $url = "http://" . $servidor['server_ip'] . ":" . $servidor['agent_port'] . "/stats_agent.php?token=" . urlencode($secret_key);
                                        $context = stream_context_create(['http' => ['timeout' => 2]]); 
                                        $json_data = @file_get_contents($url, false, $context);
                                        if ($json_data) {
                                            $stats_data = json_decode($json_data, true);
                                            if (json_last_error() !== JSON_ERROR_NONE) { $stats_data = null; }
                                        }
                                    } catch (Exception $e) {
                                        // Captura o erro e impede a página de quebrar. O $stats_data continua null.
                                    }
                                    // <<< FIM DO BLOCO A PROVA DE FALHAS >>>

                                    if ($stats_data && isset($stats_data['status']) && $stats_data['status'] == 'online'): ?>
                                        <span class="badge bg-success">Online</span><br>
                                        <small class="text-muted">Uptime: <?= htmlspecialchars($stats_data['uptime']) ?></small>
                                    <?php else: ?>
                                        <span class="badge bg-danger">Offline</span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php if ($servidor['status'] == 1): ?>
                                        <span class="badge bg-success">Ativo</span>
                                    <?php else: ?>
                                        <span class="badge bg-secondary">Inativo</span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php if ($stats_data && is_array($stats_data) && isset($stats_data['ram'])): ?>
                                        <div class="stat-box">
                                            <strong>RAM:</strong>
                                            <div class="progress"><div class="progress-bar" role="progressbar" style="width: <?= $stats_data['ram']['usage_percent'] ?>%;"><?= $stats_data['ram']['usage_percent'] ?>%</div></div>
                                            <span class="value"><?= $stats_data['ram']['used_mb'] ?> MB</span> / <?= $stats_data['ram']['total_mb'] ?> MB
                                        </div>
                                        <div class="stat-box mt-2">
                                            <strong>Disco:</strong>
                                            <div class="progress"><div class="progress-bar bg-info" role="progressbar" style="width: <?= $stats_data['disk']['usage_percent'] ?>%;"><?= $stats_data['disk']['usage_percent'] ?>%</div></div>
                                            <span class="value"><?= $stats_data['disk']['used_gb'] ?> GB</span> / <?= $stats_data['disk']['total_gb'] ?> GB
                                        </div>
                                    <?php else: echo '<span class="text-muted">N/A</span>'; endif; ?>
                                </td>
                                <td class="text-center">
                                    <a href="?action=reboot_server&id=<?= $servidor['id'] ?>" class="btn btn-sm btn-secondary" title="Reiniciar Serviços" onclick="return confirm('Tem certeza?');"><i class="fas fa-power-off"></i></a>
                                    <button type="button" class="btn btn-sm btn-primary edit-btn" data-bs-toggle="modal" data-bs-target="#editModal" 
                                        data-id="<?= $servidor['id'] ?>" data-name="<?= htmlspecialchars($servidor['server_name']) ?>" 
                                        data-ip="<?= htmlspecialchars($servidor['server_ip']) ?>" data-port="<?= $servidor['server_port'] ?>"
                                        data-agentport="<?= $servidor['agent_port'] ?>" data-connections="<?= $servidor['max_connections'] ?>">Editar</button>
                                    <a href="?action=toggle_status&id=<?= $servidor['id'] ?>" class="btn btn-sm <?= $servidor['status'] == 1 ? 'btn-warning' : 'btn-danger' ?>"><?= $servidor['status'] == 1 ? 'Desativar' : 'Ativar' ?></a>
                                    <a href="?action=delete&id=<?= $servidor['id'] ?>" class="btn btn-sm btn-danger" onclick="return confirm('Tem certeza?');">Excluir</a>
                                </td>
                            </tr>
                        <?php endforeach; endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
<div class="modal fade" id="editModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header"><h5 class="modal-title">Editar Servidor</h5><button type="button" class="btn-close" data-bs-dismiss="modal"></button></div>
            <form action="gerenciar_servidores.php" method="POST">
                <div class="modal-body">
                    <input type="hidden" name="action" value="update_server"><input type="hidden" name="edit_id" id="edit_id">
                    <div class="mb-3"><label class="form-label">Nome</label><input type="text" class="form-control" name="edit_server_name" id="edit_server_name" required></div>
                    <div class="mb-3"><label class="form-label">IP ou DNS</label><input type="text" class="form-control" name="edit_server_ip" id="edit_server_ip" required></div>
                    <div class="row">
                        <div class="col"><label class="form-label">Porta Stream</label><input type="number" class="form-control" name="edit_server_port" id="edit_server_port" required></div>
                        <div class="col"><label class="form-label">Porta Agente</label><input type="number" class="form-control" name="edit_agent_port" id="edit_agent_port" required></div>
                    </div>
                    <div class="mb-3"><label class="form-label">Max. Conexões</label><input type="number" class="form-control" name="edit_max_connections" id="edit_max_connections" required></div>
                </div>
                <div class="modal-footer"><button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button><button type="submit" class="btn btn-primary">Salvar Alterações</button></div>
            </form>
        </div>
    </div>
</div>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<script>
document.addEventListener('DOMContentLoaded', function () {
    if (typeof bootstrap !== 'undefined') {
        const editModalEl = document.getElementById('editModal');
        if (editModalEl) {
            const editModal = new bootstrap.Modal(editModalEl);
            document.querySelectorAll('.edit-btn').forEach(button => {
                button.addEventListener('click', function() {
                    document.getElementById('edit_id').value = this.getAttribute('data-id');
                    document.getElementById('edit_server_name').value = this.getAttribute('data-name');
                    document.getElementById('edit_server_ip').value = this.getAttribute('data-ip');
                    document.getElementById('edit_server_port').value = this.getAttribute('data-port');
                    document.getElementById('edit_agent_port').value = this.getAttribute('data-agentport');
                    document.getElementById('edit_max_connections').value = this.getAttribute('data-connections');
                    editModal.show();
                });
            });
        }
    }
});
</script>
</body>
</html>