<?php
session_start();
require_once('./api/controles/checkLogout.php');
checkLogout();

// Lógica de logout que estava no seu menu.php
if (isset($_GET['sair'])) {
    $_SESSION = array();
    session_destroy();
    if (isset($_COOKIE[session_name()])) {
        setcookie(session_name(), '', time() - 3600, '/');
    }
    header('Location: ./index.php');
    exit();
}

// Carrega as configurações do título e logo
$config = json_decode(file_get_contents('config.json'), true);
?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title><?php echo htmlspecialchars($config['title'] ?? 'Painel'); ?></title>
    <link rel="shortcut icon" href="<?php echo htmlspecialchars($config['logo_path'] ?? ''); ?>">
    
    <link rel="stylesheet" type="text/css" href="/css/menu.css">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <link rel="stylesheet" href="//cdn.datatables.net/2.0.7/css/dataTables.dataTables.min.css">
    <style>
        /* Cole aqui todo o seu bloco <style>...</style> que estava no menu.php */
        :root { /* ... */ }
        [data-theme="dark"] { /* ... */ }
        /* ... etc ... */
    </style>
</head>
<body>
    <header class="fixed-top navbar navbar-expand-lg">
        </header>

    <div class="navigation">
        </div>

    <main class="active overflow-auto page-content w-100" style="position: absolute; height: 100%;">
        <div class="container-fluid py-4">