// Arquivo: /js/pagina-revendedores.js - VERSÃO FINAL UNIFICADA

// =================================================================================
// PARTE 1: INICIALIZAÇÃO DA TABELA DE REVENDEDORES
// =================================================================================
$(document).ready(function() {
    $('#tabela_revendedores').DataTable({
        ajax: { url: 'api/revendedores.php?listar_revendedores=1', type: 'GET' },
        processing: true, serverSide: true, responsive: true,
        language: { url: '//cdn.datatables.net/plug-ins/1.13.7/i18n/pt-BR.json' },
        columns: [
            { data: "id" }, { data: "usuario" }, { data: "creditos" },
            { data: "qnt_clientes" }, { data: "acao", orderable: false, searchable: false }
        ],
        order: [[0, 'desc']]
    });
});

// =================================================================================
// PARTE 2: FUNÇÕES DE INTERATIVIDADE (MODAIS E FORMULÁRIOS)
// =================================================================================

function modal_master(url, action, value = '') {
    const modal = $('#modal_master');
    const modalTitle = modal.find('#modal_master-titulo');
    const modalBody = modal.find('#modal_master-body');
    const modalFooter = modal.find('#modal_master-footer');
    const modalHeader = modal.find('#modal_master-header');
    modalTitle.html('Carregando...');
    modalBody.html('<div class="text-center p-4"><div class="spinner-border text-primary" role="status"></div></div>');
    modalFooter.html('');
    modalHeader.removeClass().addClass('modal-header bg-primary text-white rounded-top-4');
    let postData = {}; postData[action] = value || true;
    $.ajax({
        url: url, type: 'POST', data: postData, dataType: 'json',
        success: function(response) {
            if (response.modal_titulo) modalTitle.html(response.modal_titulo);
            if (response.modal_body) modalBody.html(response.modal_body);
            if (response.modal_footer) modalFooter.html(response.modal_footer);
            if (response.modal_header_class) modalHeader.attr('class', response.modal_header_class);
            modal.modal('show');
        },
        error: function() { Swal.fire('Erro de Comunicação', 'Não foi possível carregar os dados do modal.', 'error'); }
    });
}

function enviarFormularioRevendedor(formId, apiUrl) {
    const form = document.getElementById(formId);
    if (!form) { Swal.fire('Erro de Script', 'Formulário não encontrado: ' + formId, 'error'); return; }
    const formData = new FormData(form);

    Swal.fire({ title: 'Processando...', allowOutsideClick: false, didOpen: () => Swal.showLoading() });

    $.ajax({
        url: apiUrl, type: 'POST', data: formData, processData: false, contentType: false, dataType: 'json',
        success: function(response) {
            const masterModal = $('#modal_master');
            const afterModalClose = () => {
                Swal.close();
                if (response.icon === 'success' && response.show_copy_modal) {
                    const modalId = response.show_copy_modal;
                    const divId = response.copy_div_id;
                    const modalElement = new bootstrap.Modal(document.getElementById(modalId));
                    const divContent = document.getElementById(divId);
                    if (divContent) {
                        divContent.innerHTML = response.copy_message_html;
                        divContent.setAttribute('data-copy-text', response.copy_message_raw);
                    }
                    modalElement.show();
                } else {
                    Swal.fire(response.title, response.msg, response.icon);
                }
                if (response.data_table === 'atualizar') {
                    $('#tabela_revendedores').DataTable().ajax.reload(null, false);
                }
            };
            masterModal.one('hidden.bs.modal', afterModalClose);
            masterModal.modal('hide');
        },
        error: function() { Swal.fire('Erro de Comunicação', 'Não foi possível se conectar ao servidor.', 'error'); }
    });
}

function copiarMensagem(elementId) {
    const element = document.getElementById(elementId);
    if (!element) return;
    const textToCopy = element.getAttribute('data-copy-text');
    if (textToCopy) {
        navigator.clipboard.writeText(textToCopy).then(() => {
            Swal.fire({ toast: true, position: 'top-end', text: 'Copiado!', icon: 'success', showConfirmButton: false, timer: 1500 });
        });
    }
}