﻿<?php
session_start();
require_once("menu.php");

// Proteção: Somente admin master (nível 1) pode ver esta página
if (!isset($_SESSION['nivel_admin']) || $_SESSION['nivel_admin'] != 1) {
    echo "<div class='container p-4'>Acesso negado. Esta é uma ferramenta apenas para o administrador master.</div>";
    // Se o menu.php já tiver um '<body>', pode precisar ajustar isto.
    exit; 
}
?>

<style>
    /* Estilos para a página e para o tema escuro */
    .limpar-wrapper { 
        max-width: 800px; 
        margin: 40px auto; 
    }
    
    [data-theme="dark"] .card { 
        background-color: #2c2c2c !important; 
        border-color: #404040 !important;
        color: #dee2e6;
    }
    [data-theme="dark"] .card-header {
        border-bottom-color: #404040;
    }
    [data-theme="dark"] .alert-danger { 
        background-color: #3a1a1f; 
        color: #f5c2c7; 
        border-color: #582126; 
    }
    [data-theme="dark"] .swal2-popup {
        background-color: #2c2c2c;
        color: #dee2e6;
    }
    [data-theme="dark"] .swal2-input {
        background-color: #343a40;
        color: #f8f9fa;
        border-color: #495057;
    }
</style>

<div class="container p-4 limpar-wrapper">
    <div class="card shadow-sm">
        <div class="card-header bg-danger text-white">
            <h4 class="mb-0"><i class="fas fa-exclamation-triangle"></i> Ferramenta de Limpeza de Conteúdo</h4>
        </div>
        <div class="card-body">
            <h5 class="card-title text-danger">ATENÇÃO: AÇÃO IRREVERSÍVEL</h5>
            <p>Esta ferramenta irá apagar **PERMANENTEMENTE** todo o conteúdo do seu painel.</p>
            <div class="alert alert-danger">
                <strong>Serão esvaziadas (TRUNCATE) as seguintes tabelas:</strong>
                <ul>
                    <li>streams (Filmes e Canais)</li>
                    <li>series (Séries)</li>
                    <li>series_episodes (Episódios)</li>
                    <li>series_seasons (Temporadas)</li>
                    <li>categoria (Todas as Categorias)</li>
                </ul>
            </div>
            <p>Use esta ferramenta apenas se tiver a certeza absoluta de que deseja recomeçar do zero. Não é possível recuperar os dados após esta ação.</p>
            <button id="btnLimparTudo" class="btn btn-danger btn-lg w-100">
                <i class="fas fa-trash-alt"></i> Sim, entendo os riscos. Apagar todo o conteúdo.
            </button>
        </div>
    </div>
</div>

<!-- Inclui o SweetAlert2 (necessário para os pop-ups) -->
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
document.getElementById('btnLimparTudo').addEventListener('click', function() {
    Swal.fire({
        title: 'VOCÊ TEM CERTEZA ABSOLUTA?',
        text: "Esta ação não pode ser desfeita. Todo o conteúdo será apagado. Digite 'APAGAR' para confirmar.",
        icon: 'warning',
        input: 'text',
        inputPlaceholder: 'Digite APAGAR aqui',
        showCancelButton: true,
        cancelButtonText: 'Cancelar',
        confirmButtonText: 'Confirmar Exclusão',
        confirmButtonColor: '#dc3545',
        // Validação para garantir que o usuário digitou 'APAGAR'
        preConfirm: (inputValue) => {
            if (inputValue !== 'APAGAR') {
                Swal.showValidationMessage('Você precisa digitar "APAGAR" para confirmar.')
                return false;
            }
            return true;
        }
    }).then((result) => {
        // Se o usuário confirmou e passou na validação
        if (result.isConfirmed) {
            executarLimpeza();
        }
    });
});

async function executarLimpeza() {
    Swal.fire({
        title: 'A apagar...',
        text: 'A executar os comandos no banco de dados. Por favor, aguarde.',
        allowOutsideClick: false,
        didOpen: () => {
            Swal.showLoading();
        }
    });

    try {
        // Chama o novo script de API
        const response = await fetch('api/controles/ferramentas_api.php', {
            method: 'POST',
            headers: {'Content-Type': 'application/json'},
            body: JSON.stringify({ action: 'limpar_tudo' })
        });

        // ===================================================================
        // ✨ CORREÇÃO: Lê a resposta como TEXTO primeiro.
        // ===================================================================
        const responseText = await response.text();

        let result;
        try {
            // Tenta analisar o texto como JSON
            result = JSON.parse(responseText);
        } catch (e) {
            // Se falhar, o 'responseText' contém o erro do PHP (ex: "Fatal error...")
            throw new Error("Erro de Servidor: " + responseText);
        }
        // ===================================================================


        if (response.ok && result.status === 'success') {
            Swal.fire(
                'Sucesso!',
                'Todo o conteúdo foi apagado com sucesso.',
                'success'
            );
        } else {
            // Mostra o erro exato retornado pelo JSON
            throw new Error(result.message || 'Erro desconhecido no servidor.');
        }
    } catch (error) {
        // ===================================================================
        // ✨ CORREÇÃO: Removido o texto 'Sem Categoria' da mensagem de erro.
        // ===================================================================
        Swal.fire(
            'Erro!',
            'Não foi possível apagar o conteúdo: ' + error.message,
            'error'
        );
    }
}
</script>

