<?php
// ==========================================================
// ARQUIVO: limpar_duplicados.php (VERSÃO 9 - EXCLUSÃO DIRETA RÁPIDA)
// ==========================================================

require_once 'menu.php';
?>

<style>
    /* Tema Escuro */
    [data-theme="dark"] .card {
        background-color: #2a2e33 !important; 
        color: #e4e6eb !important; 
        border-color: #3a3f44 !important;
    }
    [data-theme="dark"] .table {
        color: #e4e6eb;
        border-color: #3a3f44;
    }
    [data-theme="dark"] .table-striped > tbody > tr:nth-of-type(odd) > * {
         --bs-table-accent-bg: rgba(255, 255, 255, 0.05);
    }
    [data-theme="dark"] .table-hover > tbody > tr:hover > * {
         --bs-table-accent-bg: rgba(255, 255, 255, 0.1);
    }
    [data-theme="dark"] .progress {
        background-color: #3a3f44;
    }

    /* Design Profissional dos Cards */
    .stat-card-search {
        border: none;
        border-left-width: 5px;
        border-left-style: solid;
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.05);
        border-radius: 8px; 
    }
    .stat-card-search .card-body {
        padding: 1.5rem; 
    }
    .stat-card-search .stat-icon {
        font-size: 2.5rem;
        opacity: 0.2;
        margin-right: 1.5rem;
    }
    .stat-card-search .stat-info .stat-label {
        font-size: 1.25rem;
        font-weight: 700;
        color: var(--bs-heading-color);
    }
    .stat-card-search .stat-info .stat-description {
        font-size: 0.9rem;
        color: var(--bs-secondary-color);
    }
    
    /* Cores */
    .stat-card-search.card-streams { border-color: #0d6efd; }
    .stat-card-search.card-streams .stat-icon { color: #0d6efd; }
    
    .stat-card-search.card-series { border-color: #d63384; }
    .stat-card-search.card-series .stat-icon { color: #d63384; }

    .stat-card-search.card-episodios { border-color: #6f42c1; }
    .stat-card-search.card-episodios .stat-icon { color: #6f42c1; }
</style>

<div class="container-fluid py-4">

    <div class="d-flex justify-content-between align-items-center mb-3">
        <h4 class="mb-0"><i class="fas fa-eraser me-2"></i>Limpar Conteúdo Duplicado (Modo Rápido)</h4>
    </div>

    <div class="alert alert-danger" role="alert">
        <h4 class="alert-heading"><i class="fas fa-exclamation-triangle"></i> ATENÇÃO! EXCLUSÃO DIRETA!</h4>
        <p>Este modo é **extremamente rápido**, mas apaga os duplicados **diretamente no banco de dados com um clique**, sem mostrar uma lista de resultados.</p>
        <ul>
            <li>**Filmes/Canais:** Apaga se o **NOME** e a **URL (link)** forem idênticos (mantém o item mais antigo).</li>
            <li>**Episódios:** Apaga se o **ID DA SÉRIE** e a **URL (link)** forem idênticos (mantém o item mais antigo).</li>
            <li>**Séries:** Apaga se o **NOME (title)** for idêntico (mantém o item mais antigo).</li>
        </ul>
        <hr>
        <p class="mb-0">A ação é **IRREVERSÍVEL**. Recomenda-se fazer um backup antes de prosseguir.</p>
    </div>
    
    <div class="row">
        <div class="col-lg-4 mb-4">
            <div class="card stat-card-search card-streams h-100">
                <div class="card-body d-flex align-items-center">
                    <div class="stat-icon"><i class="fa-solid fa-film"></i></div>
                    <div class="stat-info flex-grow-1">
                        <div class="stat-label">Canais e Filmes</div>
                        <div class="stat-description">Tabela: `streams`</div>
                    </div>
                    <button class="btn btn-danger" onclick="executarLimpezaRapida('streams', this)">
                        <i class="fas fa-bomb"></i> Limpar Agora
                    </button>
                </div>
            </div>
        </div>
        
        <div class="col-lg-4 mb-4">
            <div class="card stat-card-search card-series h-100">
                <div class="card-body d-flex align-items-center">
                    <div class="stat-icon"><i class="fa-solid fa-clapperboard"></i></div>
                    <div class="stat-info flex-grow-1">
                        <div class="stat-label">Séries</div>
                        <div class="stat-description">Tabela: `series`</div>
                    </div>
                    <button class="btn btn-danger" onclick="executarLimpezaRapida('series', this)">
                        <i class="fas fa-bomb"></i> Limpar Agora
                    </button>
                </div>
            </div>
        </div>
        
        <div class="col-lg-4 mb-4">
            <div class="card stat-card-search card-episodios h-100">
                <div class="card-body d-flex align-items-center">
                    <div class="stat-icon"><i class="fa-solid fa-photo-film"></i></div>
                    <div class="stat-info flex-grow-1">
                        <div class="stat-label">Episódios</div>
                        <div class="stat-description">Tabela: `series_episodes`</div>
                    </div>
                    <button class="btn btn-danger" onclick="executarLimpezaRapida('episodios', this)">
                        <i class="fas fa-bomb"></i> Limpar Agora
                    </button>
                </div>
            </div>
        </div>
    </div>
    
    </div>

<?php
// Inclui o rodapé
require_once 'footer.php';
// O footer.php DEVE carregar jQuery e SweetAlert2
?>

<script>
// Função principal para executar a limpeza rápida
function executarLimpezaRapida(tipo, botao) {
    const $botao = $(botao);
    let tipoNome = '';
    
    switch(tipo) {
        case 'streams': tipoNome = 'Canais/Filmes'; break;
        case 'series': tipoNome = 'Séries'; break;
        case 'episodios': tipoNome = 'Episódios'; break;
    }

    Swal.fire({
        title: `Limpar duplicados de ${tipoNome}?`,
        text: `Isto irá apagar PERMANENTEMENTE todos os duplicados para "${tipoNome}" diretamente do banco. Esta ação não pode ser desfeita.`,
        icon: 'warning',
        showCancelButton: true,
        confirmButtonText: 'Sim, limpar agora!',
        cancelButtonText: 'Cancelar',
        confirmButtonColor: '#dc3545',
        reverseButtons: true
    }).then((result) => {
        if (result.isConfirmed) {
            // Desabilita todos os botões e mostra o spinner
            $('.stat-card-search button').prop('disabled', true);
            $botao.html('<span class="spinner-border spinner-border-sm"></span> Limpando...');

            $.ajax({
                url: 'api/limpar_api.php',
                type: 'POST',
                data: {
                    acao: 'deletar_rapido',
                    tipo: tipo
                },
                dataType: 'json',
                timeout: 900000, // 15 minutos (deve ser igual ao set_time_limit da API)

                success: function(response) {
                    if (response.success) {
                        Swal.fire(
                            'Limpeza Concluída!',
                            `Foram excluídos ${response.total_deletado} itens duplicados.`,
                            'success'
                        );
                    } else {
                        Swal.fire('Erro!', response.error || 'Não foi possível completar a limpeza.', 'error');
                    }
                },
                error: function(xhr, status, error) {
                    let errorMsg = 'A limpeza falhou. Verifique o console (F12).';
                    if (status === 'timeout') {
                        errorMsg = 'A OPERAÇÃO DEMOROU DEMAIS (Timeout 15 min)! O servidor não conseguiu terminar a tempo.';
                    } else if (xhr.responseText) {
                        try {
                            const jsonError = JSON.parse(xhr.responseText);
                            if (jsonError.error) { errorMsg = jsonError.error; }
                        } catch(e) { console.error("Erro AJAX:", xhr.responseText); }
                    }
                    Swal.fire('Erro de Comunicação!', errorMsg, 'error');
                },
                complete: function() {
                    // Reabilita todos os botões
                    $('.stat-card-search button').prop('disabled', false);
                    $botao.html('<i class="fas fa-bomb"></i> Limpar Agora');
                }
            });
        }
    });
}
</script>

<?php
// Inclui o rodapé
require_once 'footer.php';
?>