<?php
session_start();

// Carrega a configuração (Caminho corrigido com __DIR__)
$config_file = __DIR__ . '/config.json';
if (file_exists($config_file)) {
    $config = json_decode(file_get_contents($config_file), true);
} else {
    $config = [
        'title' => 'TOP IPTV',
        'logo_path' => './img/logo_tranparente2.png'
    ];
}

// Lógica de verificação de logout (Caminho corrigido com __DIR__)
require_once(__DIR__ . '/api/controles/checkLogout.php');
checkLogout();

// Lógica de Sair
if (isset($_GET['sair'])) {
    $_SESSION = array();
    session_unset();
    session_destroy();

    if (isset($_COOKIE[session_name()])) {
        setcookie(session_name(), '', time() - 3600, '/');
    }
    header('Location: ./index.php');
    exit();
}

// Lógica para marcar link como 'active'
function is_active($path_fragment) {
    if (strpos($_SERVER['REQUEST_URI'], $path_fragment) !== false) {
        return 'active';
    }
    // Caso especial do dashboard
    if ($path_fragment == 'dashboard.php' && (basename($_SERVER['SCRIPT_NAME']) == 'dashboard.php')) {
        return 'active';
    }
    return '';
}

// Função helper para ver se *qualquer* link de um dropdown está ativo
function is_dropdown_active($links) {
    foreach ($links as $link) {
        if (is_active($link) === 'active') {
            return 'active';
        }
    }
    return '';
}
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=5.0, user-scalable=yes">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    
    <title><?php echo htmlspecialchars($config['title']); ?></title>
    
    <link rel="shortcut icon" href="/<?php echo ltrim(htmlspecialchars($config['logo_path']), './'); ?>">

    <link rel="preconnect" href="https://cdn.jsdelivr.net">
    <link rel="dns-prefetch" href="https://cdn.jsdelivr.net">

    <script src="https://code.jquery.com/jquery-3.7.1.min.js" crossorigin="anonymous"></script>

    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet" crossorigin="anonymous">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css"> <link rel="stylesheet" href="https://cdn.datatables.net/1.13.7/css/dataTables.bootstrap5.min.css">
    <link rel="stylesheet" href="https://cdn.datatables.net/responsive/2.5.0/css/responsive.bootstrap5.min.css">
    
    <style>
        /* CSS Base e Layout (do ZenPanel Dashboard) */
        :root {
            --sidebar-width: 260px;
            --header-height: 60px;
            --primary-color: #4e73df;
            --sidebar-bg: #2c3e50;
            --sidebar-hover: #34495e;
            --sidebar-active: #3498db;
            --touch-target: 44px;
            --transition-speed: 0.3s;
        }
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background-color: #f8f9fc;
            margin: 0;
            padding: 0;
            overflow-x: hidden;
            -webkit-font-smoothing: antialiased;
            -moz-osx-font-smoothing: grayscale;
        }
        html {
            scroll-behavior: smooth;
            -webkit-text-size-adjust: 100%;
        }
        * {
            -webkit-tap-highlight-color: transparent;
            box-sizing: border-box;
        }
        #wrapper {
            display: flex;
            min-height: 100vh;
            position: relative;
        }
        .mobile-overlay {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: rgba(0, 0, 0, 0.5);
            z-index: 1000;
            opacity: 0;
            transition: opacity var(--transition-speed);
        }
        .mobile-overlay.active {
            display: block;
            opacity: 1;
        }
        
        .mobile-menu-toggle {
            display: none;
            /* position: fixed; */ /* REMOVIDO */
            /* top: 10px; */ /* REMOVIDO */
            /* left: 10px; */ /* REMOVIDO */
            /* z-index: 1040; */ /* REMOVIDO */
            width: var(--touch-target);
            height: var(--touch-target);
            border: none;
            background: var(--primary-color);
            color: white;
            border-radius: 8px;
            font-size: 24px;
            cursor: pointer;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
            transition: all 0.2s;
            align-items: center;
            justify-content: center;
        }

        .mobile-menu-toggle:active {
            transform: scale(0.95);
        }
        #content-wrapper {
            flex: 1;
            display: flex;
            flex-direction: column;
            margin-left: var(--sidebar-width);
            transition: margin-left var(--transition-speed);
            width: 100%;
        }
        #content-wrapper.full-width {
            margin-left: 0;
        }
        .topbar {
            height: var(--header-height);
            background: white;
            border-bottom: 1px solid #e3e6f0;
            padding: 0 1.5rem;
            display: flex;
            align-items: center;
            justify-content: space-between;
            position: sticky;
            top: 0;
            z-index: 100;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.04);
        }
        .topbar-left {
            display: flex;
            align-items: center;
            gap: 1rem;
        }
        .topbar-toggle {
            background: none;
            border: none;
            font-size: 1.5rem;
            color: #858796;
            cursor: pointer;
            padding: 8px;
            min-width: var(--touch-target);
            min-height: var(--touch-target);
            display: flex;
            align-items: center;
            justify-content: center;
            border-radius: 6px;
            transition: background 0.2s;
        }
        .topbar-toggle:hover {
            background: #f8f9fc;
        }
        .topbar-nav {
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }
        .topbar-icon {
            background: none;
            border: none;
            font-size: 1.25rem;
            color: #858796;
            cursor: pointer;
            padding: 8px;
            min-width: var(--touch-target);
            min-height: var(--touch-target);
            display: flex;
            align-items: center;
            justify-content: center;
            border-radius: 6px;
            position: relative;
            transition: background 0.2s;
        }
        .topbar-icon:hover {
            background: #f8f9fc;
        }
        .user-dropdown {
            display: flex;
            align-items: center;
            gap: 0.75rem;
            cursor: pointer;
            padding: 6px 12px;
            border-radius: 8px;
            transition: all 0.2s;
            min-height: 44px;
        }
        .user-dropdown:hover {
            background: #f8f9fc;
        }
        .user-avatar {
            width: 36px;
            height: 36px;
            border-radius: 50%;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-weight: 600;
            font-size: 14px;
            flex-shrink: 0;
        }
        .user-avatar img { width: 100%; height: 100%; border-radius: 50%; object-fit: cover; }
        .user-info {
            display: flex;
            flex-direction: column;
        }
        .user-name {
            font-weight: 600;
            font-size: 14px;
            color: #2c3e50;
            line-height: 1.2;
        }
        .user-role {
            font-size: 12px;
            color: #858796;
        }
        main#content { /* MUDADO DE #content para main#content */
            flex: 1;
            padding: 1.5rem;
        }
        .page-header {
            margin-bottom: 1.5rem;
        }
        .page-header h1 {
            color: #2c3e50;
            font-size: 1.75rem;
            font-weight: 600;
            margin: 0 0 0.5rem 0;
        }
        .card {
            border: none;
            border-radius: 10px;
            box-shadow: 0 0.15rem 1.75rem 0 rgba(58, 59, 69, 0.15);
            margin-bottom: 1.5rem;
        }
        .card-header {
            background: white;
            border-bottom: 1px solid #e3e6f0;
            padding: 1rem 1.5rem;
            font-weight: 600;
            color: #2c3e50;
        }

        /* CSS da Sidebar (do ZenPanel Sidebar) */
        .sidebar {
            width: var(--sidebar-width);
            background: var(--sidebar-bg);
            position: fixed;
            top: 0;
            left: 0;
            height: 100vh;
            overflow-y: auto;
            overflow-x: hidden;
            z-index: 1010;
            transition: transform var(--transition-speed) ease, width var(--transition-speed) ease;
            display: flex;
            flex-direction: column;
            box-shadow: 2px 0 10px rgba(0, 0, 0, 0.1);
        }
        .sidebar::-webkit-scrollbar {
            width: 6px;
        }
        .sidebar::-webkit-scrollbar-track {
            background: rgba(255, 255, 255, 0.05);
        }
        .sidebar::-webkit-scrollbar-thumb {
            background: rgba(255, 255, 255, 0.2);
            border-radius: 3px;
        }
        .sidebar-brand {
            height: var(--header-height); /* Alinhado com topbar */
            padding: 0 1.5rem;
            text-align: center;
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
            background: rgba(0, 0, 0, 0.2);
            position: sticky;
            top: 0;
            z-index: 10;
            display: flex;
            align-items: center;
            justify-content: space-between;
        }
        .sidebar-brand-content {
            flex: 1;
            text-align: center;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 0.5rem;
        }
        .sidebar-brand h4 {
            color: white;
            margin: 0;
            font-weight: 700;
            font-size: 1.25rem;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 0.5rem;
        }
        .sidebar-brand h4 img { width: 35px; height: 35px; } /* Logo */
        .sidebar-brand small {
            color: rgba(255, 255, 255, 0.6);
            font-size: 0.7rem;
            display: block;
            margin-top: 0.25rem;
        }
        .sidebar-close {
            display: none;
            background: none;
            border: none;
            color: white;
            font-size: 1.5rem;
            cursor: pointer;
            padding: 0;
            width: 36px;
            height: 36px;
            align-items: center;
            justify-content: center;
            border-radius: 6px;
            transition: background 0.2s;
        }
        .sidebar-close:hover {
            background: rgba(255, 255, 255, 0.1);
        }
        .sidebar-user-mobile {
            display: none;
            padding: 1.25rem;
            background: rgba(0, 0, 0, 0.3);
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
        }
        .sidebar-user-mobile .user-avatar {
            width: 50px;
            height: 50px;
            border-radius: 50%;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-weight: 700;
            font-size: 1.25rem;
            margin: 0 auto 0.75rem;
        }
        .sidebar-user-mobile .user-avatar img { width: 100%; height: 100%; border-radius: 50%; object-fit: cover; }
        .sidebar-user-mobile .user-name {
            color: white;
            font-weight: 600;
            text-align: center;
            margin-bottom: 0.25rem;
        }
        .sidebar-user-mobile .user-role {
            color: rgba(255, 255, 255, 0.7);
            font-size: 0.85rem;
            text-align: center;
        }
        .sidebar-nav {
            padding: 1rem 0;
            flex: 1;
        }
        .nav-section {
            color: rgba(255, 255, 255, 0.5);
            padding: 0.75rem 1.5rem 0.5rem;
            font-size: 0.7rem;
            text-transform: uppercase;
            font-weight: 700;
            letter-spacing: 1px;
            margin-top: 0.75rem;
        }
        .nav-section:first-child {
            margin-top: 0;
        }
        .nav-item {
            margin: 0.25rem 0.75rem;
        }
        .nav-link {
            color: rgba(255, 255, 255, 0.8);
            padding: 0.875rem 1rem;
            border-radius: 8px;
            display: flex;
            align-items: center;
            gap: 0.875rem;
            text-decoration: none;
            transition: all 0.2s ease;
            position: relative;
            font-size: 0.9rem;
            font-weight: 500;
            min-height: var(--touch-target);
        }
        .nav-link:hover {
            background: var(--sidebar-hover);
            color: white;
            transform: translateX(4px);
        }
        .nav-link.active {
            background: var(--sidebar-active);
            color: white;
            box-shadow: 0 4px 12px rgba(52, 152, 219, 0.3);
        }
        .nav-link.active::before {
            content: '';
            position: absolute;
            left: 0;
            top: 50%;
            transform: translateY(-50%);
            width: 4px;
            height: 60%;
            background: white;
            border-radius: 0 2px 2px 0;
        }
        .nav-link i {
            font-size: 1.15rem;
            width: 22px;
            text-align: center;
            flex-shrink: 0;
        }
        .nav-link span {
            flex: 1;
            font-size: 12px; /* Font size 12px do ZenPanel */
        }
        .nav-dropdown-toggle .bi-chevron-down {
            transition: transform 0.3s ease;
            font-size: 0.75rem;
            margin-left: auto;
        }
        .nav-dropdown-toggle.active .bi-chevron-down {
            transform: rotate(180deg);
        }
        .nav-dropdown-menu {
            display: none;
            padding-left: 0.5rem;
            margin: 0.25rem 0;
            max-height: 0;
            overflow: hidden;
            transition: max-height 0.3s ease;
        }
        .nav-dropdown-menu.show {
            display: block;
            max-height: 500px; /* Ajuste conforme necessário */
        }
        .nav-dropdown-menu .nav-link {
            padding: 0.625rem 1rem;
            font-size: 0.875rem;
            margin: 0.125rem 0;
        }
        .nav-dropdown-menu .nav-link i {
            font-size: 1rem;
        }
        .sidebar-footer {
            padding: 1rem;
            border-top: 1px solid rgba(255, 255, 255, 0.1);
            background: rgba(0, 0, 0, 0.2);
            text-align: center;
        }
        .sidebar-footer small {
            color: rgba(255, 255, 255, 0.5);
            font-size: 0.7rem;
        }
        .mobile-only {
            display: none;
        }

        /* CSS do Topbar (do ZenPanel Topbar) */
        .topbar-nav .btn-link {
            position: relative;
            padding: 8px 10px;
            min-width: 44px;
            min-height: 44px;
            display: flex;
            align-items: center;
            justify-content: center;
            border-radius: 8px;
            text-decoration: none;
            transition: all 0.2s;
        }
        .topbar-nav .btn-link:hover {
            background: #f8f9fc;
        }
        .topbar-nav .btn-link .badge {
            font-size: 10px;
            padding: 3px 6px;
            min-width: 18px;
        }
        .user-dropdown {
            display: flex;
            align-items: center;
            gap: 0.75rem;
            cursor: pointer;
            padding: 6px 12px;
            border-radius: 8px;
            transition: all 0.2s;
            min-height: 44px;
        }
        .user-dropdown:hover {
            background: #f8f9fc;
        }
        .dropdown-menu {
            border: none;
            box-shadow: 0 4px 20px rgba(0, 0, 0, 0.1);
            border-radius: 10px;
            padding: 0.5rem 0;
            min-width: 220px;
            margin-top: 0.5rem;
        }
        .dropdown-header {
            padding: 0.75rem 1rem;
            font-size: 14px;
            font-weight: 600;
            color: #2c3e50;
            border-bottom: 1px solid #e3e6f0;
        }
        .dropdown-item {
            padding: 0.75rem 1rem;
            font-size: 14px;
            color: #2c3e50;
            display: flex;
            align-items: center;
            transition: all 0.2s;
            min-height: 44px;
        }
        .dropdown-item:hover {
            background: #f8f9fc;
            color: var(--primary-color);
        }
        .dropdown-item i {
            font-size: 1.1rem;
            width: 20px;
        }
        .dropdown-divider {
            margin: 0.5rem 0;
            border-color: #e3e6f0;
        }
        .dropdown-item.text-danger:hover {
            background: rgba(231, 74, 59, 0.1);
            color: #e74a3b;
        }

        /* ========================================== */
        /* NOVO CSS PARA SUBMENU NO TOPBAR            */
        /* ========================================== */
        .dropdown-submenu {
            position: relative;
        }
        .dropdown-submenu .dropdown-menu {
            top: 0;
            left: 100%;
            margin-top: -1px;
            margin-left: -1px;
            border-radius: 0 6px 6px 6px;
            display: none; /* Escondido por padrão */
        }
        .dropdown-submenu:hover > .dropdown-menu {
            display: block; /* Mostra no hover */
        }
        /* Em telas pequenas, faz o submenu abrir para a esquerda */
        @media (max-width: 991px) {
            /* Remove a regra de abrir para a esquerda */
            /* .dropdown-submenu .dropdown-menu {
                left: auto;
                right: 100%;
                margin-left: 0;
                margin-right: -1px;
            } */
        }
        .dropdown-submenu > a:after {
            content: '›'; /* Seta para o lado */
            float: right;
            font-size: 1.2rem;
            font-weight: 700;
        }
        /* ========================================== */

        /* CSS de Tema e Overrides (do seu menu.php antigo) */
        [data-theme="dark"] body { background-color: #16191c; color: #e4e6eb; }
        [data-theme="dark"] .topbar { background: #212529; border-bottom-color: #3a3f44; box-shadow: 0 2px 4px rgba(0,0,0,0.4); }
        [data-theme="dark"] .card { background-color: #2a2e33; color: #e4e6eb; border-color: #3a3f44; }
        [data-theme="dark"] .card-header { background: #2a2e33; border-bottom-color: #3a3f44; color: #e4e6eb; }
        [data-theme="dark"] .page-header h1 { color: #e4e6eb; }
        [data-theme="dark"] .text-muted { color: #b0b3b8 !important; }
        [data-theme="dark"] .topbar-toggle { color: #b0b3b8; }
        [data-theme="dark"] .topbar-toggle:hover { background: #3a3f44; }
        [data-theme="dark"] .user-dropdown:hover { background: #3a3f44; }
        [data-theme="dark"] .user-name { color: #e4e6eb; }
        [data-theme="dark"] .dropdown-menu { background-color: #2a2e33; border-color: #3a3f44; }
        [data-theme="dark"] .dropdown-item { color: #e4e6eb !important; }
        [data-theme="dark"] .dropdown-item:hover { background-color: var(--sidebar-active, #3498db); color: #ffffff !important; }
        [data-theme="dark"] .modal-content { background-color: #2a2e33; color: #e4e6eb; }
        [data-theme="dark"] .modal-header { border-bottom-color: #3a3f44; }
        [data-theme="dark"] .modal-footer { border-top-color: #3a3f44; }
        #theme-toggle .fa-sun { display: none; } 
        #theme-toggle .fa-moon { display: block; color: #6c757d; }
        [data-theme="dark"] #theme-toggle .fa-sun { display: block; color: #ffc107; } 
        [data-theme="dark"] #theme-toggle .fa-moon { display: none; }

        /* ========================================== */
        /* CSS PARA BOTÃO DE TEMA NA SIDEBAR MOBILE   */
        /* ========================================== */
        #theme-toggle-sidebar .fa-sun { 
            display: none; 
            width: 22px; /* Garante alinhamento */
            text-align: center;
        } 
        #theme-toggle-sidebar .fa-moon { 
            display: block; 
            width: 22px; /* Garante alinhamento */
            text-align: center;
        }
        [data-theme="dark"] #theme-toggle-sidebar .fa-sun { 
            display: block; /* Mostra sol no tema escuro */
        } 
        [data-theme="dark"] #theme-toggle-sidebar .fa-moon { 
            display: none; /* Esconde lua no tema escuro */
        }
        /* Ajuste nos ícones do dropdown de teste */
        .nav-dropdown-menu .fa-tv,
        .nav-dropdown-menu .fa-list-ol {
            width: 22px;
            text-align: center;
        }
        /* ========================================== */

        /* Perfil Customizado (do seu menu.php antigo) */
        .sidebar-user-profile { padding: 1.25rem; background: rgba(0,0,0,0.3); border-bottom: 1px solid rgba(255,255,255,0.1); }
        .sidebar-user-profile .user-avatar { width: 60px; height: 60px; border-radius: 50%; background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); display: flex; align-items: center; justify-content: center; color: white; font-weight: 700; font-size: 1.25rem; margin: 0 auto 0.75rem; border: 2px solid rgba(255,255,255,0.7); }
        .sidebar-user-profile .user-avatar img { width: 100%; height: 100%; border-radius: 50%; object-fit: cover; }
        .sidebar-user-profile .user-name { color: white; font-weight: 600; text-align: center; margin-bottom: 0.25rem; }
        .sidebar-user-profile .user-role { color: rgba(255,255,255,0.7); font-size: 0.85rem; text-align: center; text-transform: uppercase; }
        .sidebar-user-profile .user-stats { padding-top: 10px; margin-top: 10px; border-top: 1px solid rgba(255,255,255,0.2); }
        .sidebar-user-profile .user-stats .info-linha { font-size: 0.8rem; font-weight: 600; color: white; display: flex; justify-content: space-between; align-items: center; margin-bottom: 5px; }
        .sidebar-user-profile .user-stats .badge { font-size: 0.8rem; padding: 4px 8px; }

        /* Overrides de Tema Escuro (do seu menu.php antigo) */
        [data-theme="dark"] .sidebar { background: #212529; border-right-color: #3a3f44; }
        [data-theme="dark"] .sidebar-brand { background: rgba(0,0,0,0.2); border-bottom-color: #3a3f44; }
        [data-theme="dark"] .sidebar-user-profile { background: rgba(0,0,0,0.3); border-bottom-color: #3a3f44; }
        [data-theme="dark"] .nav-link { color: #e4e6eb; }
        [data-theme="dark"] .nav-link.active { background: var(--sidebar-active, #3498db); }
        [data-theme="dark"] .nav-link:hover { background: #3a3f44; }
        
        [data-theme="dark"] .sidebar .nav-dropdown-menu {
            background-color: #2a2e33 !important; /* Fundo escuro p/ submenu */
        }
        [data-theme="dark"] .sidebar .nav-dropdown-menu .nav-link {
            color: #e4e6eb !important; /* Texto claro (forçado) */
            background-color: transparent !important; /* Garante que não tenha fundo branco */
        }
        [data-theme="dark"] .sidebar .nav-dropdown-menu .nav-link:hover,
        [data-theme="dark"] .sidebar .nav-dropdown-menu .nav-link.active {
            background: var(--sidebar-active, #3498db) !important; /* Fundo azul no hover/ativo */
            color: #ffffff !important;
        }
        
        [data-theme="dark"] .nav-section { color: #b0b3b8; }
        [data-theme="dark"] .sidebar-footer { background: rgba(0,0,0,0.2); border-top-color: #3a3f44; }

        /* Estilos de Gráficos (do seu dashboard.php antigo) */
        .resource-card .card-body { display: flex; flex-direction: column; align-items: center; justify-content: center; padding: 1.5rem 1rem; }
        .circular-progress { position: relative; width: 140px; height: 140px; border-radius: 50%; display: flex; align-items: center; justify-content: center; }
        .circular-progress::before { content: ""; position: absolute; height: 80%; width: 80%; background-color: var(--card-bg-color, #ffffff); border-radius: 50%; }
        [data-theme="dark"] .circular-progress::before { background-color: #2a2e33; }
        .progress-value { position: relative; font-size: 2.2rem; font-weight: 500; color: #34495e; }
        [data-theme="dark"] .progress-value { color: #e4e6eb; }
        .resource-card .card-body h6 { font-weight: 500; color: #555 !important; }
        [data-theme="dark"] .resource-card .card-body h6 { color: #b0b3b8 !important; }
        #cpu-progress { background: conic-gradient(#e74c3c calc(var(--value, 0) * 3.6deg), #f0f0f0 0deg); }
        #ram-progress { background: conic-gradient(#2ecc71 calc(var(--value, 0) * 3.6deg), #f0f0f0 0deg); }
        #disk-progress { background: conic-gradient(#e74c3c calc(var(--value, 0) * 3.6deg), #f0f0f0 0deg); }
        [data-theme="dark"] #cpu-progress, 
        [data-theme="dark"] #ram-progress, 
        [data-theme="dark"] #disk-progress { background-color: #3a3f44; }

        /* Estilos de Vencimentos (do seu dashboard.php antigo) */
        .vencimentos-wrapper { background-color: #f8f9fa; padding: 20px; border-radius: 12px; margin-top: 2rem; }
        .vencimentos-wrapper .page-header { background-color: #0d6efd; color: #ffffff; padding: 15px 20px; border-radius: 8px; margin-bottom: 1.5rem; display: flex; justify-content: space-between; align-items: center; flex-wrap: wrap; gap: 15px; }
        .vencimentos-wrapper .page-header h4 { margin-bottom: 0; color: #ffffff; font-size: 1.2rem; font-weight: 600; }
        .vencimentos-wrapper .page-header .header-actions { display: flex; gap: 10px; flex-wrap: wrap; }
        .vencimentos-wrapper .page-header .form-select,
        .vencimentos-wrapper .page-header .btn-primary { background-color: rgba(255, 255, 255, 0.1); border: 1px solid rgba(255, 255, 255, 0.3); color: #ffffff; }
        .vencimentos-wrapper .page-header .form-select option { color: #000; }
        .vencimentos-wrapper .card { background-color: #ffffff !important; border: 1px solid #e9ecef !important; box-shadow: 0 0.125rem 0.25rem rgba(0,0,0,.075); }
        .vencimentos-wrapper .summary-card { padding: 20px; display: flex; align-items: center; gap: 20px; margin-bottom: 1rem; border-radius: 12px !important; }
        .vencimentos-wrapper .summary-card .icon { width: 60px; height: 60px; border-radius: 10px; display: flex; align-items: center; justify-content: center; font-size: 24px; color: #fff; }
        .vencimentos-wrapper .summary-card.card-red .icon { background-color: #dc3545; }
        .vencimentos-wrapper .summary-card.card-blue .icon { background-color: #0d6efd; }
        .vencimentos-wrapper .summary-card.card-green .icon { background-color: #198754; }
        .vencimentos-wrapper .summary-card .info .value { font-size: 2.2rem; font-weight: 700; color: #212529 !important; line-height: 1.2; }
        .vencimentos-wrapper .summary-card .info .label { font-size: 0.9rem; color: #6c757d !important; }
        .vencimentos-wrapper .table th { font-weight: 600; color: #6c757d; text-transform: uppercase; font-size: 0.8rem; background-color: #f8f9fa !important; border-bottom: 1px solid #dee2e6 !important; }
        .vencimentos-wrapper .table thead th { background-color: #0d6efd !important; color: #ffffff !important; border-bottom: none !important; }
        .vencimentos-wrapper .table td { vertical-align: middle; }
        .vencimentos-wrapper .status-badge { display: inline-block; padding: 0.35em 0.65em; font-size: .75em; font-weight: 700; line-height: 1; text-align: center; white-space: nowrap; vertical-align: baseline; border-radius: 50rem; }
        .vencimentos-wrapper .status-bloqueado { color: #842029; background-color: #f8d7da; }
        .vencimentos-wrapper .btn i { margin-right: 5px; }
        .vencimentos-wrapper .alert-warning { color: #664d03; background-color: #fff3cd; border-color: #ffecb5; }
        [data-theme="dark"] .vencimentos-wrapper { background-color: #212529; }
        [data-theme="dark"] .vencimentos-wrapper .page-header .form-select option { background-color: #343a40; color: #f8f9fa; }
        [data-theme="dark"] .vencimentos-wrapper .card { background-color: #2c2c2c !important; border-color: #404040 !important; }
        [data-theme="dark"] .vencimentos-wrapper .summary-card .info .value { color: #f8f9fa !important; }
        [data-theme="dark"] .vencimentos-wrapper .summary-card .info .label { color: #adb5bd !important; }
        [data-theme="dark"] .vencimentos-wrapper .table { color: #dee2e6 !important; }
        [data-theme="dark"] .vencimentos-wrapper .table th { background-color: #212529 !important; border-bottom-color: #495057 !important; color: #adb5bd; }
        [data-theme="dark"] .vencimentos-wrapper .table thead th { background-color: #0d6efd !important; color: #ffffff !important; }
        [data-theme="dark"] .vencimentos-wrapper .table td { border-color: #495057 !important; }
        [data-theme="dark"] .vencimentos-wrapper .alert-warning { color: #ffc107; background-color: #332701; border-color: #4d3c0d; }

        /* Estilos do Rodapé (do seu dashboard.php antigo) */
        .version-footer { text-align: center; padding: 30px 15px; margin-top: 40px; background-color: #f1f1f1; color: #555; font-size: 0.9rem; }
        .version-footer .update-button { display: none; color: #ffffff; border: none; padding: 10px 25px; border-radius: 5px; text-decoration: none; margin-top: 10px; margin-bottom: 20px; transition: background-color 0.3s ease; font-weight: 500; }
        .version-footer .update-button.available { background-color: #28a745; }
        .version-footer .update-button.available:hover { background-color: #218838; }
        .version-footer .update-button.info { background-color: #6c757d; }
        .version-footer .update-button.info:hover { background-color: #5a6268; }
        .version-footer .copyright { margin-top: 15px; font-size: 0.8rem; color: #777; }
        [data-theme="dark"] .version-footer { background-color: #2c2c2c; color: #aaa; }
        [data-theme="dark"] .version-footer .copyright { color: #888; }
        .modal-changelog .modal-dialog { max-width: 850px; }
        .modal-changelog .modal-body { padding: 0; }
        .modal-changelog iframe { width: 100%; height: 70vh; border: none; }

        /* CSS Responsivo (do ZenPanel) */
        @media (max-width: 768px) {
            .mobile-menu-toggle {
                display: flex; /* Mostra o botão mobile */
            }
            #content-wrapper {
                margin-left: 0;
            }
            .topbar {
                padding: 0 0.5rem; /* Padding reduzido */
                height: 55px;
            }
            .topbar-left {
                gap: 0.5rem;
            }
            .user-dropdown > div:not(.user-avatar) { display: none !important; } /* Esconde nome no topbar */
            .user-dropdown .bi-chevron-down { display: none; }
            .topbar-toggle {
                display: none; /* Esconde o botão desktop */
            }
            main#content {
                padding: 1rem;
            }
            .page-header h1 {
                font-size: 1.5rem;
            }
            .sidebar {
                transform: translateX(-100%);
                width: 85vw;
                max-width: 300px;
            }
            .sidebar.active {
                transform: translateX(0);
            }
            .sidebar-close {
                display: flex;
            }
            .sidebar-user-profile {
                display: none; /* Esconde perfil desktop */
            }
            .sidebar-user-mobile {
                display: block; /* Mostra perfil mobile */
            }
            .mobile-only {
                display: block;
            }
            /* CORREÇÃO PARA BOTÕES ESPREMIDOS */
            .topbar-nav { gap: 0.25rem; } 
            .topbar-nav .btn, .topbar-nav .badge { 
                padding: 0.375rem 0.5rem; /* Padding horizontal menor */
                margin: 0 1px !important; /* Margem menor */
                font-size: 0.75rem; 
                white-space: nowrap; 
            }
            .topbar-nav .dropdown-toggle { 
                font-size: 0.75rem; 
            }
        }
        
        @media (min-width: 768px) {
            .sidebar.collapsed {
                width: 0;
                transform: translateX(0);
            }
            .sidebar.collapsed .sidebar-brand-content,
            .sidebar.collapsed .sidebar-user-profile,
            .sidebar.collapsed .sidebar-nav,
            .sidebar.collapsed .sidebar-footer {
                opacity: 0;
                visibility: hidden;
            }
            #content-wrapper.full-width {
                margin-left: 0;
            }
        }

        @media (min-width: 992px) {
            .topbar-toggle {
                display: flex;
            }
        }
    </style>
    
    <script>
        // Previne o "flash" do tema claro. Deve ser executado antes do body.
        (function() {
            if (localStorage.getItem('theme') === 'dark') {
                document.documentElement.setAttribute('data-theme', 'dark');
            }
        })();
    </script>
    </head>
    
    
    
    
    
    
    <script>
        // Previne o "flash" do tema claro. Deve ser executado antes do body.
        (function() {
            if (localStorage.getItem('theme') === 'dark') {
                document.documentElement.setAttribute('data-theme', 'dark');
            }
        })();
    </script>

    <script>
        var SESSION_TOKEN = "<?php echo isset($_SESSION['token']) ? htmlspecialchars($_SESSION['token'], ENT_QUOTES, 'UTF-8') : ''; ?>";
    </script>
    </head>
<body>

    
<body>
    <div class="mobile-overlay" id="mobileOverlay"></div>

    <div id="wrapper">
    
    <div class="sidebar" id="sidebar">
        <div class="sidebar-brand">
            <button class="sidebar-close" id="sidebarClose" type="button" aria-label="Fechar Menu">
                <i class="bi bi-x-lg"></i>
            </button>
            <div class="sidebar-brand-content">
                <h4>
                    <img src="/<?php echo ltrim(htmlspecialchars($config['logo_path']), './'); ?>" alt="Logo">
                    <span><?php echo htmlspecialchars($config['title']); ?></span>
                </h4>
            </div>
        </div>
        
        <div class="sidebar-user-profile">
            <div class="user-avatar">
                <img src="/img/user.png" alt="Foto do Perfil">
            </div>
            <div class="user-name">
                <?php echo isset($_SESSION['username']) ? htmlspecialchars($_SESSION['username']) : 'Admin'; ?>
            </div>
            <div class="user-role" id="tipo_admin">
                </div>
            
            <div class="user-stats">
                <?php if (isset($_SESSION['nivel_admin']) && $_SESSION['nivel_admin'] == 1): ?>
                    <div class="info-linha">
                        <span>Creditos</span>
                        <span class="badge bg-info">
                            <i class="fa-solid fa-infinity me-1"></i> Ilimitados
                        </span>
                    </div>
                <?php else: ?>
                    <div class="info-linha">
                        <span>Creditos</span>
                        <span class="badge bg-success">
                            <i class="fa-solid fa-coins me-1"></i><span id="creditos2"> </span>
                        </span>
                    </div>
                <?php endif; ?>
                
                <div class="info-linha" id="vencimento">
                </div>
            </div>

        </div>

        <div class="sidebar-user-mobile">
            <div class="user-avatar">
                 <img src="/img/user.png" alt="Foto do Perfil">
            </div>
            <div class="user-name"><?php echo isset($_SESSION['username']) ? htmlspecialchars($_SESSION['username']) : 'Admin'; ?></div>
            <div class="user-role" id="tipo_admin_mobile"> </div>
            
            <div class="mt-2 text-center">
                <?php if (isset($_SESSION['nivel_admin']) && $_SESSION['nivel_admin'] == 1): ?>
                    <span class="badge bg-danger fs-6">
                        <i class="fa-solid fa-infinity me-1"></i> Créditos Ilimitados
                    </span>
                <?php else: ?>
                    <span class="badge bg-success fs-6">
                        <i class="fa-solid fa-coins me-1"></i> Créditos: <span id="creditos_sidebar_mobile">...</span>
                    </span>
                <?php endif; ?>
            </div>
        </div>

        <nav class="sidebar-nav">
        
            <form id="teste-p2p-form-sidebar" action="action_p2p_gerar_teste.php" method="POST" style="display: none;"></form>
            <div class="nav-section">Menu Principal</div>
            <div class="nav-item">
                <a href="dashboard.php" class="nav-link <?php echo is_active('dashboard.php'); ?>">
                    <i class="bi bi-speedometer2"></i>
                    <span>Dashboard</span>
                </a>
            </div>
            <div class="nav-item">
                <a href="conexoes_online.php" class="nav-link <?php echo is_active('conexoes_online'); ?>">
                    <i class="bi bi-wifi"></i>
                    <span>Usuarios Online</span>
                </a>
               
            </div>
            <div class="nav-item">
                <a href="dashboard_custom.php" class="nav-link <?php echo is_active('dashboard_custom.php'); ?>">
                    <i class="bi bi-plus-square"></i>
                    <span>Conteudo Novo</span>
                </a>
            </div>

            <?php if (isset($_SESSION['nivel_admin']) && $_SESSION['nivel_admin'] == 1): ?>
                <?php 
                $dropdown_conteudo_active = is_dropdown_active([
                    'gerenciar_categorias.php', 'gerenciar_bouquets.php', 'pagina=canais', 
                    'pagina=filmes', 'pagina=series', 'uploud.php', 
                    'importador2026.php', 'uploud2025.php'
                ]);
                ?>
                <div class="nav-section">Gerenciar Conteúdo</div>
                <div class="nav-item nav-dropdown">
                    <a href="#" class="nav-link nav-dropdown-toggle <?php echo $dropdown_conteudo_active; ?>">
                        <i class="bi bi-gear-fill"></i>
                        <span>Conteudos</span>
                        <i class="bi bi-chevron-down"></i>
                    </a>
                    <div class="nav-dropdown-menu <?php echo $dropdown_conteudo_active ? 'show' : ''; ?>">
                        <a href="gerenciar_categorias.php" class="nav-link <?php echo is_active('gerenciar_categorias.php'); ?>"><i class="bi bi-tags-fill"></i> <span>Categorias</span></a>
                        <a href="gerenciar_bouquets.php" class="nav-link <?php echo is_active('gerenciar_bouquets.php'); ?>"><i class="bi bi-card-list"></i> <span>Bouquets</span></a>
                        <a href="visualizador.php?pagina=canais" class="nav-link <?php echo is_active('pagina=canais'); ?>"><i class="bi bi-tv-fill"></i> <span>Canais</span></a>
                        <a href="visualizador.php?pagina=filmes" class="nav-link <?php echo is_active('pagina=filmes'); ?>"><i class="bi bi-film"></i> <span>Filmes</span></a>
                        <a href="visualizador.php?pagina=series" class="nav-link <?php echo is_active('pagina=series'); ?>"><i class="bi bi-collection-play-fill"></i> <span>Series</span></a>
                        <a href="uploud.php" class="nav-link <?php echo is_active('uploud.php'); ?>"><i class="bi bi-cloud-upload"></i> <span>Uploud</span></a>
                        <a href="importador2026.php" class="nav-link <?php echo is_active('importador2026.php'); ?>"><i class="bi bi-cloud-upload-fill"></i> <span>Importador 2026</span></a>
                        <a href="importar_m3u_zen.php" class="nav-link <?php echo is_active('importar_m3u_zen.php'); ?>"><i class="bi bi-file-earmark-arrow-up"></i> <span>Importar m3u TMDB</span></a>
                    </div>
                </div>
                
                <?php 
                $dropdown_ferramentas_active = is_dropdown_active([
                    'gerenciamento.php', 'excluir_listas.php', 'atualizador', 
                    'gerenciar_servidores.php', 'limpar_conteudo.php'
                ]);
                ?>
                <div class="nav-item nav-dropdown">
                    <a href="#" class="nav-link nav-dropdown-toggle <?php echo $dropdown_ferramentas_active; ?>">
                        <i class="bi bi-tools"></i>
                        <span>Ferramentas</span>
                        <i class="bi bi-chevron-down"></i>
                    </a>
                    <div class="nav-dropdown-menu <?php echo $dropdown_ferramentas_active ? 'show' : ''; ?>">
                        <a href="gerenciamento.php" target="_blank" class="nav-link"><i class="bi bi-eraser"></i> <span>Gerenciar Conteudo em Massa</span></a>
                        <a href="excluir_listas.php" class="nav-link <?php echo is_active('excluir_listas.php'); ?>"><i class="bi bi-calendar-x"></i> <span>Excluir Listas</span></a>
                        <a href="atualizador" class="nav-link <?php echo is_active('atualizador'); ?>"><i class="bi bi-arrow-clockwise"></i> <span>Atualizar TMDB</span></a>
                        <a href="gerenciar_servidores.php" class="nav-link <?php echo is_active('gerenciar_servidores.php'); ?>"><i class="bi bi-server"></i> <span>Load Balance</span></a>
                        <a href="limpar_conteudo.php" class="nav-link <?php echo is_active('limpar_conteudo.php'); ?>"><i class="bi bi-trash-fill"></i> <span>Limpar Conteudo</span></a>
                        <a href="limpar_duplicados.php" class="nav-link <?php echo is_active('limpar_duplicados.php'); ?>"><i class="fa-solid fa-clone text-white"></i> <span>Excluir Conteudo Duplicados</span></a>
                    </div>
                </div>
            <?php endif; ?>

            <div class="nav-section">Gerenciamento</div>
            <?php 
            $dropdown_iptv_active = is_dropdown_active(['clientes.php', 'testes.php', 'migrar_clientes.php']);
            ?>
            <div class="nav-item nav-dropdown">
                <a href="#" class="nav-link nav-dropdown-toggle <?php echo $dropdown_iptv_active; ?>">
                    <i class="bi bi-people-fill"></i>
                    <span>Clientes IPTV</span>
                    <i class="bi bi-chevron-down"></i>
                </a>
                <div class="nav-dropdown-menu <?php echo $dropdown_iptv_active ? 'show' : ''; ?>">
                    <a href="clientes.php" class="nav-link <?php echo is_active('clientes.php'); ?>"><i class="bi bi-person-fill"></i> <span>Clientes</span></a>
                    <a href="testes.php" class="nav-link <?php echo is_active('testes.php'); ?>"><i class="bi bi-person-fill-check"></i> <span>Testes</span></a>
                    <a href="clientes_migrar.php" class="nav-link <?php echo is_active('clientes_migrar.php'); ?>"><i class="bi bi-person-video3"></i> <span>Migrar Clientes</span></a>
                    <a href="visualizador.php?pagina=conexoes_online" class="nav-link <?php echo is_active('conexoes_online.php'); ?>"><i class="fas fa-users"></i> <span>Clientes Online</span></a>
                </div>
            </div>

            <?php 
            $dropdown_p2p_active = is_dropdown_active(['codigos_p2p.php', 'testes_p2p.php']);
            ?>
            <div class="nav-item nav-dropdown">
                <a href="#" class="nav-link nav-dropdown-toggle <?php echo $dropdown_p2p_active; ?>">
                    <i class="bi bi-list-ol"></i>
                    <span>Codigos P2P</span>
                    <i class="bi bi-chevron-down"></i>
                </a>
                <div class="nav-dropdown-menu <?php echo $dropdown_p2p_active ? 'show' : ''; ?>">
                    <a href="codigos_p2p.php" class="nav-link <?php echo is_active('codigos_p2p.php'); ?>"><i class="bi bi-person-check-fill"></i> <span>Gerenciar Clientes</span></a>
                    <a href="testes_p2p.php" class="nav-link <?php echo is_active('testes_p2p.php'); ?>"><i class="bi bi-person-clock"></i> <span>Testes P2P</span></a>
                </div>
            </div>
            
            <?php 
            $dropdown_revenda_active = is_dropdown_active(['revendedores.php', 'gerenciar_revendedores.php']);
            ?>
            <div class="nav-item nav-dropdown">
                <a href="#" class="nav-link nav-dropdown-toggle <?php echo $dropdown_revenda_active; ?>">
                    <i class="bi bi-award-fill"></i>
                    <span>Revendedores</span>
                    <i class="bi bi-chevron-down"></i>
                </a>
                <div class="nav-dropdown-menu <?php echo $dropdown_revenda_active ? 'show' : ''; ?>">
                    <?php if (isset($_SESSION['plano_admin']) && $_SESSION['plano_admin'] != 1): ?>
                    <a href="revendedores.php" class="nav-link <?php echo is_active('revendedores.php'); ?>"><i class="bi bi-people-fill"></i> <span>Revendedores</span></a>
                    <?php endif; ?>
                    <a href="gerenciar_revendedores.php" class="nav-link <?php echo is_active('gerenciar_revendedores.php'); ?>"><i class="bi bi-person-lines-fill"></i> <span>Gestao de Revenda</span></a>
                </div>
            </div>
            
            <?php 
            $dropdown_relatorios_active = is_dropdown_active(['log_creditos.php']);
            ?>
            <div class="nav-item nav-dropdown">
                <a href="#" class="nav-link nav-dropdown-toggle <?php echo $dropdown_relatorios_active; ?>">
                    <i class="bi bi-journal-text"></i>
                    <span>Relatorios</span>
                    <i class="bi bi-chevron-down"></i>
                </a>
                <div class="nav-dropdown-menu <?php echo $dropdown_relatorios_active ? 'show' : ''; ?>">
                    <a href="log_creditos.php" class="nav-link <?php echo is_active('log_creditos.php'); ?>"><i class="bi bi-clock-history"></i> <span>Log de Creditos</span></a>
                </div>
            </div>

            <div class="nav-section">Sistema</div>
            <?php 
            $dropdown_app_active = is_dropdown_active(['admin_loja.php', 'loja.php', 'pedidos.php', 'admin_pedidos.php']);
            ?>
            <div class="nav-item nav-dropdown">
                <a href="#" class="nav-link nav-dropdown-toggle <?php echo $dropdown_app_active; ?>">
                    <i class="bi bi-rocket-takeoff-fill"></i>
                    <span>Aplicacoes</span>
                    <i class="bi bi-chevron-down"></i>
                </a>
                <div class="nav-dropdown-menu <?php echo $dropdown_app_active ? 'show' : ''; ?>">
                    <?php if (isset($_SESSION['nivel_admin']) && $_SESSION['nivel_admin'] == 1): ?>
                    <a href="admin_loja.php" class="nav-link <?php echo is_active('admin_loja.php'); ?>"><i class="bi bi-shop"></i> <span>Gerenciar Loja</span></a>
                    <?php else: ?>
                    <a href="loja.php" class="nav-link <?php echo is_active('loja.php'); ?>"><i class="bi bi-shop-window"></i> <span>Loja de Aplicativos</span></a>
                    <?php endif; ?>
                    
                    <?php if (isset($_SESSION['nivel_admin']) && $_SESSION['nivel_admin'] != 1): ?>
                    <a href="pedidos.php" class="nav-link <?php echo is_active('pedidos.php'); ?>"><i class="bi bi-plus-square-dotted"></i> <span>Pedido de VODs</span></a>
                    <?php endif; ?>
                    
                    <?php if (isset($_SESSION['nivel_admin']) && $_SESSION['nivel_admin'] == 1): ?>
                    <a href="admin_pedidos.php" class="nav-link <?php echo is_active('admin_pedidos.php'); ?>"><i class="bi bi-list-task"></i> <span>Gerenciar Pedidos</span></a>
                    <?php endif; ?>
                    
                    
                    <?php if (isset($_SESSION['nivel_admin']) && $_SESSION['nivel_admin'] == 1): ?>
                    <a href="loja.php" class="nav-link <?php echo is_active('admin_pedidos.php'); ?>"><i class="bi bi-shop-window"></i> <span>Loja Aplicativos</span></a>
                    <?php endif; ?>
                    
                </div>
            </div>
            
            <div class="nav-item">
                <a href="chatbot_integrado_painel.php" class="nav-link <?php echo is_active('chatbot_integrado_painel.php'); ?>">
                    <i class="bi bi-robot"></i>
                    <span>Chatbot IA</span>
                </a>
            </div>

            <div class="nav-item">
                <a href="pagamentos_config.php" class="nav-link <?php echo is_active('pagamentos_config.php'); ?>">
                    <i class="bi bi-currency-dollar"></i>
                    <span>Pagamento</span>
                </a>
            </div>

            <?php 
            $dropdown_settings_active = is_dropdown_active([
                'planos.php', 'ip_manager.php', 'atualizar_epg.php', 'alterar_links.php', 
                'gerenciador_db.php', 'configuracoes.php', 'configuracao_migracao.php', 
                'configuracoes_confianca.php'
            ]);
            ?>
            <div class="nav-item nav-dropdown">
                <a href="#" class="nav-link nav-dropdown-toggle <?php echo $dropdown_settings_active; ?>">
                    <i class="bi bi-sliders"></i>
                    <span>Settings</span>
                    <i class="bi bi-chevron-down"></i>
                </a>
                <div class="nav-dropdown-menu <?php echo $dropdown_settings_active ? 'show' : ''; ?>">
                    <a href='planos.php' class='nav-link <?php echo is_active('planos.php'); ?>'><i class='bi bi-server'></i> <span>Planos</span></a>
                    <?php if (isset($_SESSION['nivel_admin']) && $_SESSION['nivel_admin'] == 1): ?>
                    <a href="ip_manager.php" class="nav-link <?php echo is_active('ip_manager.php'); ?>"><i class="bi bi-shield-lock-fill"></i> <span>Gerenciar IPs Bloqueados</span></a>
                    <a href="atualizar_epg.php" class="nav-link <?php echo is_active('atualizar_epg.php'); ?>"><i class="bi bi-calendar-event-fill"></i> <span>Atualizar EPG</span></a>
                    <a href="alterar_links_em_massa (1).php" class="nav-link <?php echo is_active('alterar_links_em_massa (1).php'); ?>"><i class="bi bi-link-45deg"></i> <span>Alterar Links em Massa</span></a>
                    <a href="gerenciador_db.php" class="nav-link <?php echo is_active('gerenciador_db.php'); ?>"><i class="bi bi-database-fill-up"></i> <span>Backup do Sistema</span></a>
                    <a href="gerenciador/configuracoes.php" class="nav-link <?php echo is_active('configuracoes.php'); ?>"><i class="bi bi-gear-wide-connected"></i> <span>Config Online</span></a>
                    <a href="configuracao_migracao.php" class="nav-link <?php echo is_active('configuracao_migracao.php'); ?>"><i class="bi bi-person-video3"></i> <span>Config Migracao de Clientes</span></a>
                    <a href="configuracoes_confianca.php" class="nav-link <?php echo is_active('configuracoes_confianca.php'); ?>"><i class="bi bi-hand-thumbs-up-fill"></i> <span>Config Renovacao Confianca</span></a>
                    <?php endif; ?>
                </div>
            </div>
            
            <?php if (isset($_SESSION['nivel_admin']) && $_SESSION['nivel_admin'] == 1): ?>
                <?php 
                $dropdown_painel_active = is_dropdown_active(['personalizar.php', 'editar_template.php']);
                ?>
                <div class="nav-item nav-dropdown">
                    <a href="#" class="nav-link nav-dropdown-toggle <?php echo $dropdown_painel_active; ?>">
                        <i class="bi bi-palette-fill"></i>
                        <span>Painel</span>
                        <i class="bi bi-chevron-down"></i>
                    </a>
                    <div class="nav-dropdown-menu <?php echo $dropdown_painel_active ? 'show' : ''; ?>">
                        <a href="personalizar.php" class="nav-link <?php echo is_active('personalizar.php'); ?>"><i class="bi bi-paint-bucket"></i> <span>Personalizar</span></a>
                        <a href="editar_template.php" class="nav-link <?php echo is_active('editar_template.php'); ?>"><i class="bi bi-pencil-square"></i> <span>Editar Template</span></a>
                        <a href="notas_de_atualizacao.php" class="nav-link <?php echo is_active('notas_de_atualizacao.php'); ?>"><i class="fas fa-sync-alt text-white"></i> <span>Atualizações Painel</span></a>
                    </div>
                </div>

                <div class="nav-item">
                    <a href="p2p_config.php" class="nav-link <?php echo is_active('p2p_config.php'); ?>">
                        <i class="bi bi-gear-fill"></i>
                        <span>Configuracoes P2P</span>
                    </a>
                </div>
            <?php endif; ?>

            <div class="nav-section d-none d-md-block">Conta</div>
            <div class="nav-item d-none d-md-block">
                <?php if (isset($_SESSION['nivel_admin']) && $_SESSION['nivel_admin'] == 1): ?>
                    <a class="nav-link" href="editar_admin.php"><i class="bi bi-person-circle"></i> <span>Editar Admin</span></a>
                <?php else: ?>
                    <a class="nav-link" href="#" onclick="modal_master('api/revendedores.php', 'edite_admin_revenda', 'edite')"><i class="bi bi-person-circle"></i> <span>Editar Senha</span></a>
                <?php endif; ?>
            </div>
            <div class="nav-item d-none d-md-block">
                <a href="?sair" class="nav-link logout-link" style="color: #ff6b6b;">
                    <i class="bi bi-box-arrow-right"></i>
                    <span>Sair</span>
                </a>
            </div>

            <div class="nav-section mobile-only">Conta</div>
            <div class="nav-item mobile-only">
                <?php if (isset($_SESSION['nivel_admin']) && $_SESSION['nivel_admin'] == 1): ?>
                    <a class="nav-link" href="editar_admin.php"><i class="bi bi-person-circle"></i> <span>Editar Admin</span></a>
                <?php else: ?>
                    <a class="nav-link" href="#" onclick="modal_master('api/revendedores.php', 'edite_admin_revenda', 'edite')"><i class="bi bi-person-circle"></i> <span>Editar Senha</span></a>
                <?php endif; ?>
            </div>
            <div class="nav-item mobile-only">
                <a href="?sair" class="nav-link logout-link" style="color: #ff6b6b;">
                    <i class="bi bi-box-arrow-right"></i>
                    <span>Sair</span>
                </a>
            </div>
        </nav>

        <div class="sidebar-footer">
            <small>&copy; <?php echo date("Y"); ?> <?php echo htmlspecialchars($config['title']); ?> <span id="current-version-text-sidebar"></span></small>
        </div>
    </div>
    <div id="content-wrapper">
        
        <nav class="topbar">
            
            <div class="d-flex align-items-center gap-2"> <button class="mobile-menu-toggle d-md-none" id="mobileMenuToggle" aria-label="Abrir Menu" type="button">
                    <i class="bi bi-list"></i>
                </button>
                
                <button class="topbar-toggle d-none d-md-flex" id="topbarToggle" type="button" aria-label="Alternar Menu Lateral">
                    <i class="bi bi-list"></i>
                </button>
                
                <div class="dropdown d-md-none">
                    <div class="user-dropdown p-0" data-bs-toggle="dropdown" aria-expanded="false" role="button"> <div class="user-avatar">
                             <img src="/img/user.png" alt="User">
                        </div>
                    </div>
                    <ul class="dropdown-menu dropdown-menu-start">
                        <li class="dropdown-header">
                            <strong><?php echo isset($_SESSION['username']) ? htmlspecialchars($_SESSION['username']) : ''; ?></strong>
                            <br>
                            <small class="text-muted" id="tipo_admin_dropdown_mobile"> 
                                </small>
                        </li>
                        <li class="d-md-none">
                            <div class="dropdown-item-text">
                                <?php if (isset($_SESSION['nivel_admin']) && $_SESSION['nivel_admin'] == 1): ?>
                                    <strong class="text-danger">
                                        <i class="fa-solid fa-infinity me-1"></i> Créditos Ilimitados
                                    </strong>
                                <?php else: ?>
                                    <strong style="color: #28a745;">
                                        <i class="fa-solid fa-coins me-1"></i> Créditos: <span id="creditos-mobile"></span>
                                    </strong>
                                <?php endif; ?>
                            </div>
                        </li>
                        <li><hr class="dropdown-divider"></li>
                        <li>
                            <?php if (isset($_SESSION['nivel_admin']) && $_SESSION['nivel_admin'] == 1): ?>
                                <a class="dropdown-item" href="editar_admin.php">
                                    <i class="bi bi-person-circle me-2"></i> Editar Admin
                                </a>
                            <?php else: ?>
                                <a class="dropdown-item" href="#" onclick="modal_master('api/revendedores.php', 'edite_admin_revenda', 'edite')">
                                    <i class="bi bi-pencil-square me-2"></i> Editar Senha
                                </a>
                            <?php endif; ?>
                        </li>
                        
                        <li>
                            <a class="dropdown-item dropdown-toggle" href="#collapseMobileConfig" data-bs-toggle="collapse" role="button" aria-expanded="false" aria-controls="collapseMobileConfig">
                                <i class="bi bi-gear me-2"></i> Configurações
                            </a>
                            <div class="collapse" id="collapseMobileConfig">
                                <ul class="list-unstyled ms-4"> <li><a class='dropdown-item' href='planos.php'><i class='bi bi-server me-2'></i> <span>Planos</span></a></li>
                                    <?php if (isset($_SESSION['nivel_admin']) && $_SESSION['nivel_admin'] == 1): ?>
                                    <li><a class="dropdown-item" href="ip_manager.php"><i class="bi bi-shield-lock-fill me-2"></i> <span>Gerenciar IPs</span></a></li>
                                    <li><a class="dropdown-item" href="atualizar_epg.php"><i class="bi bi-calendar-event-fill me-2"></i> <span>Atualizar EPG</span></a></li>
                                    <li><a class="dropdown-item" href="alterar_links.php"><i class="bi bi-link-45deg me-2"></i> <span>Alterar Links</span></a></li>
                                    <li><a class="dropdown-item" href="gerenciador_db.php"><i class="bi bi-database-fill-up me-2"></i> <span>Backup</span></a></li>
                                    <li><a class="dropdown-item" href="gerenciador/configuracoes.php"><i class="bi bi-gear-wide-connected me-2"></i> <span>Config Online</span></a></li>
                                    <li><a class="dropdown-item" href="configuracao_migracao.php"><i class="bi bi-person-video3 me-2"></i> <span>Config Migracao</span></a></li>
                                    <li><a class="dropdown-item" href="configuracoes_confianca.php"><i class="bi bi-hand-thumbs-up-fill me-2"></i> <span>Config Confiança</span></a></li>
                                    <?php endif; ?>
                                </ul>
                            </div>
                        </li>
                        <li><hr class="dropdown-divider"></li>
                        <li>
                            <a class="dropdown-item text-danger" href="?sair">
                                <i class="bi bi-box-arrow-right me-2"></i> Sair
                            </a>
                        </li>
                    </ul>
                </div>

            </div>
            
            <div class="topbar-nav">
                
                <?php if (isset($_SESSION['nivel_admin']) && $_SESSION['nivel_admin'] == 1): ?>
                    <div class="badge bg-danger d-none d-lg-flex align-items-center p-2">
                        <i class="fa-solid fa-infinity me-2"></i> Créditos Ilimitados
                    </div>
                <?php else: ?>
                    <div class="badge bg-success d-none d-lg-flex align-items-center p-2"> 
                        <span class="j_credits" style="margin-right: 5px; opacity: 1;" id="creditos"> </span> Creditos
                    </div>
                <?php endif; ?>
                
                <div class="dropdown d-none d-md-block">
                    <div class="user-dropdown" data-bs-toggle="dropdown" aria-expanded="false" role="button">
                        <div class="user-avatar">
                             <img src="/img/user.png" alt="User">
                        </div>
                        <div class="d-none d-md-block">
                            <div class="fw-semibold" style="font-size: 0.9rem;">
                                <?php echo isset($_SESSION['username']) ? htmlspecialchars($_SESSION['username']) : 'Admin'; ?>
                            </div>
                            <small class="text-muted" style="font-size: 0.75rem;" id="tipo_admin_topbar">
                                </small>
                        </div>
                        <i class="bi bi-chevron-down d-none d-md-block"></i>
                    </div>
                    
                    <ul class="dropdown-menu dropdown-menu-end">
                        <li class="dropdown-header">
                            <strong><?php echo isset($_SESSION['username']) ? htmlspecialchars($_SESSION['username']) : ''; ?></strong>
                            <br>
                            <small class="text-muted" id="tipo_admin_dropdown">
                                </small>
                        </li>
                        <li><hr class="dropdown-divider"></li>
                        <li>
                            <?php if (isset($_SESSION['nivel_admin']) && $_SESSION['nivel_admin'] == 1): ?>
                                <a class="dropdown-item" href="editar_admin.php">
                                    <i class="bi bi-person-circle me-2"></i> Editar Admin
                                </a>
                            <?php else: ?>
                                <a class="dropdown-item" href="#" onclick="modal_master('api/revendedores.php', 'edite_admin_revenda', 'edite')">
                                    <i class="bi bi-pencil-square me-2"></i> Editar Senha
                                </a>
                            <?php endif; ?>
                        </li>
                        
                        <li class="dropdown-submenu">
                            <a class="dropdown-item dropdown-toggle" href="#">
                                <i class="bi bi-gear me-2"></i> Configurações
                            </a>
                            <ul class="dropdown-menu">
                                <li><a class='dropdown-item' href='planos.php'><i class='bi bi-server me-2'></i> <span>Planos</span></a></li>
                                <?php if (isset($_SESSION['nivel_admin']) && $_SESSION['nivel_admin'] == 1): ?>
                                <li><a class="dropdown-item" href="ip_manager.php"><i class="bi bi-shield-lock-fill me-2"></i> <span>Gerenciar IPs</span></a></li>
                                <li><a class="dropdown-item" href="atualizar_epg.php"><i class="bi bi-calendar-event-fill me-2"></i> <span>Atualizar EPG</span></a></li>
                                <li><a class="dropdown-item" href="alterar_links.php"><i class="bi bi-link-45deg me-2"></i> <span>Alterar Links</span></a></li>
                                <li><a class="dropdown-item" href="gerenciador_db.php"><i class="bi bi-database-fill-up me-2"></i> <span>Backup</span></a></li>
                                <li><a class="dropdown-item" href="gerenciador/configuracoes.php"><i class="bi bi-gear-wide-connected me-2"></i> <span>Config Online</span></a></li>
                                <li><a class="dropdown-item" href="configuracao_migracao.php"><i class="bi bi-person-video3 me-2"></i> <span>Config Migracao</span></a></li>
                                <li><a class="dropdown-item" href="configuracoes_confianca.php"><i class="bi bi-hand-thumbs-up-fill me-2"></i> <span>Config Confiança</span></a></li>
                                <?php endif; ?>
                            </ul>
                        </li>
                        <li><hr class="dropdown-divider"></li>
                        <li>
                            <a class="dropdown-item text-danger" href="?sair">
                                <i class="bi bi-box-arrow-right me-2"></i> Sair
                            </a>
                        </li>
                    </ul>
                </div>

                <button id="theme-toggle" class="btn btn-link topbar-icon" style="font-size: 1.2rem;">
                    <i class="fas fa-moon"></i>
                    <i class="fas fa-sun"></i>
                </button>
                
                <div class="dropdown">
                    <button class="btn btn-primary dropdown-toggle btn-sm" type="button" id="dropdownTesteRapido" data-bs-toggle="dropdown" aria-expanded="false">
                        <i class="fas fa-bolt"></i> 
                        <span class="d-inline"> Teste Rapido</span> </button>
                    <ul class="dropdown-menu dropdown-menu-end" aria-labelledby="dropdownTesteRapido">
                        <li>
                            <a class="dropdown-item" href="#" onclick="modal_master('api/gerar_teste_direto.php', 'gerar_teste_rapido', '1')">
                                <i class="fas fa-tv me-2"></i> Teste IPTV
                            </a>
                        </li>
                        <li>
                            <form action="action_p2p_gerar_teste.php" method="POST" class="d-inline">
                                <button type="submit" class="dropdown-item">
                                    <i class="fas fa-list-ol me-2"></i> Teste Codigo P2P
                                </button>
                            </form>
                        </li>
                    </ul>
                </div>

            </div>
        </nav>
        
        <main id="content" class="flex-fill p-3 p-md-4">