<?php
// 1. INCLUI O MENU E CABEÇALHO DO SEU PAINEL
require_once 'menu.php';
// Certifique-se de que a variável SESSION_TOKEN ou algo similar esteja acessível
// global $SESSION_TOKEN; 
?>

<style>
 /* --- Estilos de Layout --- */
 .page-title-box h4 {
 font-weight: 600;
 color: var(--text-primary);
 }

 .card {
 border-radius: 12px;
 box-shadow: 0 4px 12px rgba(0, 0, 0, 0.08);
 border: none;
 transition: all 0.3s ease;
 }

 .card:hover {
 transform: translateY(-3px);
 box-shadow: 0 8px 20px rgba(0, 0, 0, 0.1);
 }

 .card-title {
font-weight: 500;
 display: flex;
 align-items: center;
 gap: 10px;
 }

 /* --- Estilos de Formulário --- */
 .form-control {
 border-radius: 8px;
 padding: 12px;
 }
 .form-control:focus {
 box-shadow: 0 0 0 2px var(--sidebar-active-bg);
 border-color: var(--sidebar-active-bg);
 }
 
 .btn {
 border-radius: 8px;
 padding: 12px;
 font-weight: 600;
 transition: all 0.2s ease;
 }
 
 .btn-primary {
 background: linear-gradient(45deg, #0d6efd, #3c82f6);
 border-color: #0d6efd;
 }
 .btn-success {
 background: linear-gradient(45deg, #198754, #28a745);
 border-color: #198754;
 }

 /* --- Estilos da Caixa de Informações --- */
 #info_lista {
 border-left: 4px solid #0d6efd;
 background-color: var(--bg-card);
 }

 .info-details {
 display: flex;
 flex-direction: column;
 gap: 1rem;
 }

 .info-item {
 display: flex;
 align-items: center;
 justify-content: space-between;
 padding-bottom: 0.75rem;
 border-bottom: 1px solid var(--border-color);
 }
 .info-item:last-child {
 border-bottom: none;
 }

 .info-item .label {
 display: flex;
 align-items: center;
 gap: 10px;
 font-size: 0.9rem;
 color: var(--text-secondary);
 }

 .info-item .value {
 font-weight: 600;
 color: var(--text-primary);
 word-break: break-all;
 text-align: right;
 }

 /* Estilos para Custo (Pago) */
 .info-item.cost {
  background-color: #fff3cd; /* Cor de aviso (amarelo claro) */
 color: #664d03;
 padding: 1rem;
 border-radius: 8px;
 margin-top: 1rem;
 }
 [data-theme="dark"] .info-item.cost {
 background-color: #3b320d;
 color: #ffc107;
 }
    /* Estilo para Custo GRATUITO */
    .info-item.cost.free {
        background-color: #d1e7dd; /* Cor de sucesso (verde claro) */
        color: #0f5132;
    }
    [data-theme="dark"] .info-item.cost.free {
        background-color: #114e2d;
        color: #fff;
    }

 .info-item.cost .value {
 color: inherit;
 font-size: 1.1rem;
 }

 #mensagem {
 display: flex;
 align-items: center;
 justify-content: center;
 gap: 10px;
 min-height: 24px;
 }

    /* --- RESPONSIVIDADE (Priorizando Coluna da Esquerda no Topo) --- */
    @media (max-width: 991px) { /* Para tablets e celulares */
        .col-lg-7 {
            order: 1 !important; /* Coloca o formulário (col-lg-7) no topo */
        }
        .col-lg-5 {
            order: 2 !important; /* Coloca o resultado (col-lg-5) abaixo */
            margin-top: 1.5rem; /* Espaçamento entre os blocos no celular */
        }
    }
    @media (max-width: 576px) {
        .card {
            margin-bottom: 1.5rem; 
        }
        .container-fluid {
            padding-left: 10px;
            padding-right: 10px;
        }
    }
</style>

<div class="container-fluid">
 <div class="row">
 <div class="col-12">
 <div class="page-title-box d-sm-flex align-items-center justify-content-between">
 <h4 class="mb-sm-0"><i class="fa-solid fa-people-arrows text-primary"></i> Migrar Clientes</h4>
 </div>
 </div>
 </div>

 <div class="row">
              <div class="col-lg-7 col-md-12"> 
 <div class="card">
 <div class="card-body">
 <h5 class="card-title mb-4"><i class="fa-solid fa-link"></i> Dados da Lista M3U</h5>
 
 <div class="mb-3">
 <label for="m3u_url" class="form-label">Cole o link da lista M3U do cliente:</label>
 <input type="text" class="form-control" id="m3u_url" placeholder="http://servidor.com:porta/get.php?username=...">
 </div>
 
 <button id="btn_analisar" class="btn btn-primary w-100"><i class="fa-solid fa-magnifying-glass"></i> Analisar Informações</button>

 <div id="mensagem" class="mt-3 fw-bold text-center"></div>
 </div>
 </div>
 </div>

              <div class="col-lg-5 col-md-12"> 
 <div class="card" id="info_lista" style="display: none;">
 <div class="card-body">
 <h5 class="card-title mb-4"><i class="fa-solid fa-circle-info"></i> Informações da Lista</h5>

 <div class="info-details">
 <div class="info-item">
 <span class="label"><i class="fa-solid fa-server"></i> Servidor:</span>
 <strong id="res_servidor" class="value"></strong>
 </div>
 <div class="info-item">
 <span class="label"><i class="fa-solid fa-user"></i> Usuário:</span>
 <strong id="res_usuario" class="value"></strong>
 </div>
 <div class="info-item">
 <span class="label"><i class="fa-solid fa-key"></i> Senha:</span>
 <strong id="res_senha" class="value"></strong>
 </div>
 <div class="info-item">
 <span class="label"><i class="fa-solid fa-tower-broadcast"></i> Conexões:</span>
 <strong id="res_conexoes" class="value"></strong>
 </div>
 <div class="info-item">
 <span class="label"><i class="fa-solid fa-calendar-days"></i> Dias Restantes:</span>
 <strong id="res_dias" class="value"></strong>
 </div>
 <div class="info-item cost" id="cost_box">
 <span class="label"><i class="fa-solid fa-coins"></i> Custo de Importação:</span>
 <strong id="res_custo" class="value"></strong>
 </div>
 </div>

 <button id="btn_importar" class="btn btn-success w-100 mt-4"><i class="fa-solid fa-download"></i> Importar Cliente</button>
 </div>
 </div>
 </div>
 </div>
</div>

<?php
// 2. INCLUI O RODAPÉ DO SEU PAINEL (se existir um)
// ==================================================
//          CORREÇÃO - LINHA DESCOMENTADA
// ==================================================
require_once 'footer.php';
?>

<script>
// Variável global para armazenar os dados do cliente após a análise
let dadosClienteParaImportar = {};

// Função que será usada para recarregar o saldo, se existir
function get_credits() {
 // Implemente a lógica para recarregar/atualizar o saldo do painel aqui
 // Exemplo:
 // $.ajax({ url: 'api/get_saldo.php', success: function(data){ $('#saldo_display').text(data.saldo); } });
}

$(document).ready(function(){
    
    // --- AÇÃO DO BOTÃO ANALISAR ---
    $('#btn_analisar').click(function(){
        let m3u_url = $('#m3u_url').val();
        
        if(m3u_url === "") {
            Swal.fire('Atenção!', 'Por favor, insira um link M3U.', 'warning');
            return;
        }

        // Mostra loading
        $('#btn_analisar').prop('disabled', true).html('<span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span> Analisando...');
        $('#info_lista').fadeOut();
        $('#mensagem').html('');


        $.ajax({
            url: 'api/api_migracao.php', 
            type: 'POST',
            data: {
                action: 'analisar',
                url: m3u_url,
                // Assume que SESSION_TOKEN é definido globalmente no seu menu.php ou cabeçalho
                token: (typeof SESSION_TOKEN !== 'undefined' ? SESSION_TOKEN : '')
            },
            dataType: 'json',
            success: function(response){
                if(response.status === 'success'){
                    // Preenche os campos na tela
                    $('#res_servidor').text(response.data.servidor);
                    $('#res_usuario').text(response.data.usuario);
                    $('#res_senha').text(response.data.senha);
                    $('#res_conexoes').text(response.data.conexoes);
                    $('#res_dias').text(response.data.dias_restantes);
                    $('#res_custo').text(response.data.custo_importacao);

                    dadosClienteParaImportar = response.data;
                    
                    // Lógica para mostrar se é gratuito ou pago (Visual)
                    const costBox = $('#cost_box');
                    // Se a API retornou cobrar_credito=0 (Ex: Admin Principal) OU custo = 0, mostra como GRATUITO
                    if (response.data.cobrar_credito == 0 || response.data.custo_importacao === '0,00') {
                        $('#res_custo').text('GRATUITO');
                        costBox.addClass('free').removeClass('cost');
                    } else {
                        costBox.removeClass('free').addClass('cost');
                    }

                    // Mostra a caixa de informações
                    $('#info_lista').fadeIn();
                } else {
                    Swal.fire('Erro na Análise!', response.message, 'error');
                }
            },
            error: function(){
                Swal.fire('Erro de Comunicação!', 'Não foi possível conectar à API. Verifique o console para mais detalhes.', 'error');
            },
            complete: function() {
                // Restaura o botão ao estado original
                $('#btn_analisar').prop('disabled', false).html('<i class="fa-solid fa-magnifying-glass"></i> Analisar Informações');
            }
        });
    });

    // --- AÇÃO DO BOTÃO IMPORTAR ---
    $('#btn_importar').click(function(){
        
        const $btn = $(this); // Salva a referência do botão
        const custoTexto = $('#res_custo').text();
        const cobrarCredito = dadosClienteParaImportar.cobrar_credito;
        
        let confirmacaoHtml = "Você está prestes a importar este cliente para o seu painel.<br>";
        
        if (cobrarCredito == 1 && custoTexto !== 'GRATUITO') {
            confirmacaoHtml += `O custo em créditos será de **R$ ${custoTexto}** e será debitado da sua conta. Deseja continuar?`;
        } else {
            confirmacaoHtml += `**A migração será gratuita.** Deseja importar o cliente?`;
        }

        Swal.fire({
            title: 'Confirmar Importação',
            html: confirmacaoHtml,
            icon: 'question',
            showCancelButton: true,
            confirmButtonColor: '#28a745',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Sim, importar!',
            cancelButtonText: 'Cancelar'
        }).then((result) => {
            if (result.isConfirmed) {
                // Desabilita o botão para evitar cliques duplos
                const originalButtonHtml = $btn.html(); // Usa a variável $btn
                $btn.prop('disabled', true).html('<span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span> Importando...'); // Usa a variável $btn
                
                $.ajax({
                    url: 'api/api_migracao.php',
                    type: 'POST',
                    data: {
                        action: 'importar',
                        cliente: JSON.stringify(dadosClienteParaImportar), // Envia como JSON
                        token: (typeof SESSION_TOKEN !== 'undefined' ? SESSION_TOKEN : '')
                    },
                    dataType: 'json',
                    success: function(response){
                        if(response.status === 'success'){
                            Swal.fire('Sucesso!', response.message, 'success');
                            $('#info_lista').fadeOut();
                            $('#m3u_url').val(''); // Limpa o campo de URL
                            
                            // Tenta atualizar os créditos na tela (só funciona se a função existir)
                            if (typeof get_credits === 'function') {  
                                get_credits();
                            }
                        } else {
                            // Este bloco lida com a resposta do back-end, incluindo "Saldo insuficiente"
                            if (response.message && response.message.includes('Saldo insuficiente')) {
                                Swal.fire('⚠️ Sem Créditos!', response.message, 'warning');
                            } else {
                                Swal.fire('Erro na Importação!', response.message, 'error');
                            }
                        }
                    },
                    error: function(){
                        Swal.fire('Erro de Comunicação!', 'Não foi possível importar o cliente.', 'error');
                    },
                    complete: function() {
                        // Restaura o botão de importação
                        $btn.prop('disabled', false).html(originalButtonHtml); // Usa a variável $btn
                    }
                });
            }
        });
    });
});
</script>