<?php
// ARQUIVO FINAL E ESTÁVEL: monitor.php 
// [CONFIGURAÇÃO: TTL de 5 minutos (300 segundos) para máxima estabilidade]

set_time_limit(0);
ini_set('memory_limit', '128M');
date_default_timezone_set('America/Sao_Paulo'); 

require_once __DIR__ . '/api/controles/db.php'; 

echo "--- MONITOR DE CONEXOES ATIVO (5 MINUTOS TTL) ---\n";

while (true) {
    try {
        $pdo = conectar_bd();

        // MUDANÇA CRÍTICA: TTL DE 5 MINUTOS. 
        // Se a "ultima_atividade" for mais antiga que 5 minutos, ele é removido.
        $stmt = $pdo->prepare("DELETE FROM conexoes WHERE ultima_atividade < NOW() - INTERVAL 300 SECOND");
        $stmt->execute();
        
        $pdo = null; 

    } catch (Exception $e) {
        // Loga erro e continua tentando
        echo "Erro no monitor: " . $e->getMessage() . "\n";
    }
    // Verifica o banco a cada 10 segundos
    sleep(10); 
}
?>
