<?php
// ARQUIVO: redirecionar-live.php
// Verso: v13.0 - BLINDAGEM TOTAL (Anti-VPS + Bloqueio de 2 IP)

ob_start();

date_default_timezone_set('America/Sao_Paulo');
header("Cache-Control: no-cache, no-store, must-revalidate");
header("Pragma: no-cache");
header("Expires: 0");

error_reporting(0);
ini_set('display_errors', 0);

require_once "./api/controles/db.php";

// --- CONFIGURAO DE VDEOS ---
$host = "http://" . $_SERVER["HTTP_HOST"];
$video_banido = "$host/video/block.mp4";             // Conta Vencida, Banida ou VPS Detectada
$video_limite = "$host/video/bloqueio-conexao.mp4";  // Limite Excedido (2 Tela em outro IP)

// --- 1. SEGURANA NIVEL 1: USER AGENTS (Softwares de Restream) ---
$ua_atual = $_SERVER['HTTP_USER_AGENT'] ?? '';
$softwares_proibidos = ['ffmpeg', 'curl', 'wget', 'python', 'golang', 'gstreamer', 'vlc', 'libav'];

foreach ($softwares_proibidos as $soft) {
    if (stripos(strtolower($ua_atual), $soft) !== false) {
        // Bloqueia softwares de servidor tentando puxar o link
        header("Location: $video_banido"); exit;
    }
}
if (empty($ua_atual)) { header("Location: $video_banido"); exit; }


// --- 2. SEGURANA NIVEL 2: HOSTNAME (VPS e Dedicados) ---
$ip_atual = $_SERVER['REMOTE_ADDR'];

// Lista de nomes de servidores de Data Center (Onde restreamers hospedam painis)
$servidores_proibidos = [
    'amazon', 'aws', 'google', 'cloud', 'ovh', 'hetzner', 'digitalocean', 
    'linode', 'vultr', 'azure', 'oracle', 'alibaba', 'dedic', 'server', 'vps'
];

// Pega o nome do provedor de internet do IP (Ex: "ec2-54-20-10.amazon.com" ou "vivo-fibra-sp...")
// Nota: Isso pode demorar 1 seg na primeira conexo.
$hostname = gethostbyaddr($ip_atual); 

if ($hostname) {
    foreach ($servidores_proibidos as $host_proibido) {
        if (stripos(strtolower($hostname), $host_proibido) !== false) {
            // DETECTADO CONEXO VINDA DE DATA CENTER/VPS
            header("Location: $video_banido"); 
            exit;
        }
    }
}

// --- PARMETROS ---
$username = $_GET["usuario"] ?? null;
$password = $_GET["senha"] ?? null;
$arquivo  = $_GET["arquivo"] ?? null;
$type     = $_GET["type_url"] ?? "live";

$stream_id = pathinfo($arquivo, PATHINFO_FILENAME);
if (is_numeric($stream_id)) { $stream_id = (int)$stream_id; }

if (!$arquivo || !$username || !$password) { header("Location: $video_banido"); exit; }

try {
    $conexao = conectar_bd();
    $agora = date('Y-m-d H:i:s');

    // 3. VALIDAO DA CONTA
    $stmt = $conexao->prepare("SELECT id, max_connections, Vencimento, is_banned FROM clientes WHERE usuario = :user AND senha = :pass LIMIT 1");
    $stmt->execute([':user' => $username, ':pass' => $password]);
    $cliente = $stmt->fetch(PDO::FETCH_ASSOC);

    // Bloqueio por conta invlida
    if (!$cliente || ($cliente['is_banned'] == 1) || (new DateTime() > new DateTime($cliente["Vencimento"]))) {
        header("Location: $video_banido"); exit;
    }

    $limite = (int)($cliente['max_connections'] ?? 1);
    if ($limite < 1) $limite = 1;

    // Limpeza rpida
    $conexao->exec("DELETE FROM conexoes WHERE ultima_atividade < NOW() - INTERVAL 20 SECOND");

    // --- 4. LGICA DE CONEXO E BLOQUEIO DE 2 IP ---

    // A. Verifica se  o MESMO DISPOSITIVO (Sesso Exata)
    $stmt_check = $conexao->prepare("SELECT id FROM conexoes WHERE usuario = :user AND ip = :ip AND user_agent = :ua LIMIT 1");
    $stmt_check->execute([':user' => $username, ':ip' => $ip_atual, ':ua' => $ua_atual]);
    $sessao_exata = $stmt_check->fetch(PDO::FETCH_ASSOC);

    if ($sessao_exata) {
        // Atualiza conexo existente
        $stmt_up = $conexao->prepare("UPDATE conexoes SET ultima_atividade = :now, stream_id = :sid WHERE id = :id");
        $stmt_up->execute([':now' => $agora, ':sid' => $stream_id, ':id' => $sessao_exata['id']]);
    
    } else {
        // B. Dispositivo Novo. Verifica Vagas.
        $stmt_count = $conexao->prepare("SELECT COUNT(*) FROM conexoes WHERE usuario = :user");
        $stmt_count->execute([':user' => $username]);
        $ocupadas = (int)$stmt_count->fetchColumn();

        if ($ocupadas < $limite) {
            // TEM VAGA: Libera.
            $stmt_in = $conexao->prepare("INSERT INTO conexoes (usuario, ip, user_agent, stream_id, ultima_atividade) VALUES (:user, :ip, :ua, :sid, :now)");
            $stmt_in->execute([':user' => $username, ':ip' => $ip_atual, ':ua' => $ua_atual, ':sid' => $stream_id, ':now' => $agora]);
        
        } else {
            // C. LIMITE ATINGIDO.
            // Verifica: O "intruso" vem do MESMO IP (Zapping) ou de OUTRO IP (Vizinho/2 Tela)?
            
            $stmt_check_ip = $conexao->prepare("SELECT id FROM conexoes WHERE usuario = :user AND ip = :ip LIMIT 1");
            $stmt_check_ip->execute([':user' => $username, ':ip' => $ip_atual]);
            $mesmo_ip = $stmt_check_ip->fetch(PDO::FETCH_ASSOC);

            if ($mesmo_ip) {
                // MESMO IP:  o dono da casa trocando de canal ou de TV na mesma rede.
                // A gente DERRUBA a conexo antiga e libera a nova (Zapping fludo).
                $stmt_subs = $conexao->prepare("UPDATE conexoes SET ultima_atividade = :now, stream_id = :sid, user_agent = :ua WHERE id = :id");
                $stmt_subs->execute([':now' => $agora, ':sid' => $stream_id, ':ua' => $ua_atual, ':id' => $mesmo_ip['id']]);
            
            } else {
                // IP DIFERENTE: ALERTA VERMELHO!
                // Algum em outra casa est tentando usar a conta enquanto o dono usa.
                // AQUI OCORRE O BLOQUEIO DA 2 TELA.
                header("Location: $video_limite");
                exit;
            }
        }
    }

    // 5. ENTREGA DO LINK
    $tabela = ($type == 'series') ? 'series_episodes' : 'streams';
    $stmt_link = $conexao->prepare("SELECT link, direct_source FROM {$tabela} WHERE id = :id LIMIT 1");
    $stmt_link->execute([':id' => $stream_id]);
    $conteudo = $stmt_link->fetch(PDO::FETCH_ASSOC);

    if (!$conteudo || empty($conteudo['link'])) { header("Location: $video_banido"); exit; }

    $link_final = !empty($conteudo['direct_source']) ? $conteudo['direct_source'] : $conteudo['link'];
    
    ob_end_clean();
    header("Location: " . $link_final);
    exit;

} catch (Exception $e) {
    header("Location: $video_banido");
    exit;
}
?>