<?php
// ARQUIVO: redirecionar-live.php
// Verso: v8.0 - Canais com Bloqueio Diferenciado (Banido vs Limite)

// 1. Limpeza de buffer
ob_start();

date_default_timezone_set('America/Sao_Paulo');
header("Cache-Control: no-cache, no-store, must-revalidate");
header("Pragma: no-cache");
header("Expires: 0");

error_reporting(0);
ini_set('display_errors', 0);

require_once "./api/controles/db.php";

// --- DEFINIO DOS VDEOS DE BLOQUEIO ---
$host = "http://" . $_SERVER["HTTP_HOST"];
$video_banido = "$host/video/block.mp4";             // Conta Vencida, Banida ou Erro Geral
$video_limite = "$host/video/bloqueio-conexao.mp4";  // Limite de Telas Excedido

// --- VARIVEL DE TEMPO ---
$agora = date('Y-m-d H:i:s');

// --- PARMETROS ---
$username = $_GET["usuario"] ?? null;
$password = $_GET["senha"] ?? null;
$arquivo  = $_GET["arquivo"] ?? null;
$type     = $_GET["type_url"] ?? "live"; // Padro 'live'

// Extrai o ID do arquivo (ex: 1234.ts -> 1234)
$stream_id = pathinfo($arquivo, PATHINFO_FILENAME);
if (is_numeric($stream_id)) {
    $stream_id = (int)$stream_id;
}

// Validao bsica
if (!$arquivo || !$username || !$password) {
    header("Location: $video_banido");
    exit;
}

try {
    $conexao = conectar_bd();

    // 1. VERIFICA O CLIENTE
    // Correo: max_connections e is_banned
    $stmt = $conexao->prepare("SELECT id, max_connections, Vencimento, is_banned FROM clientes WHERE usuario = :user AND senha = :pass LIMIT 1");
    $stmt->execute([':user' => $username, ':pass' => $password]);
    $cliente = $stmt->fetch(PDO::FETCH_ASSOC);

    // --- BLOQUEIO 1: CONTA IRREGULAR (Banida ou Vencida) -> block.mp4 ---
    if (!$cliente || 
        ($cliente['is_banned'] == 1) || 
        (new DateTime() > new DateTime($cliente["Vencimento"]))
       ) {
        header("Location: $video_banido");
        exit;
    }

    // 2. GESTO DE CONEXES
    $limite = (int)($cliente['max_connections'] ?? 1);
    if ($limite < 1) $limite = 1;

    $ip = $_SERVER['REMOTE_ADDR'];
    $ua = $_SERVER['HTTP_USER_AGENT'] ?? 'Unknown';

    // A. Limpeza de conexes mortas (30s)
    $conexao->exec("DELETE FROM conexoes WHERE ultima_atividade < NOW() - INTERVAL 30 SECOND");

    // B. Tenta atualizar a conexo existente deste usurio neste IP
    // Isso evita o troca-troca de canais contar como mltiplas conexes
    $stmt_up = $conexao->prepare("UPDATE conexoes SET ultima_atividade = :now, stream_id = :sid WHERE usuario = :user AND ip = :ip");
    $stmt_up->execute([
        ':now'  => $agora,
        ':sid'  => $stream_id,
        ':user' => $username,
        ':ip'   => $ip
    ]);

    // C. Se no atualizou ( nova conexo neste IP), verifica limite
    if ($stmt_up->rowCount() == 0) {
        $stmt_count = $conexao->prepare("SELECT COUNT(*) FROM conexoes WHERE usuario = :user");
        $stmt_count->execute([':user' => $username]);
        $ativas = (int)$stmt_count->fetchColumn();

        // --- BLOQUEIO 2: LIMITE EXCEDIDO -> bloqueio-conexao.mp4 ---
        if ($ativas >= $limite) {
            header("Location: $video_limite");
            exit;
        }

        // Insere nova conexo
        $stmt_in = $conexao->prepare("INSERT INTO conexoes (usuario, ip, user_agent, stream_id, ultima_atividade) VALUES (:user, :ip, :ua, :sid, :now)");
        $stmt_in->execute([
            ':user' => $username,
            ':ip'   => $ip,
            ':ua'   => $ua,
            ':sid'  => $stream_id,
            ':now'  => $agora
        ]);
    }

    // 3. BUSCAR LINK DO CANAL
    // Mantive sua lgica que suporta 'series' aqui caso usem esse arquivo pra tudo,
    // mas o padro  buscar em 'streams'.
    $tabela = ($type == 'series') ? 'series_episodes' : 'streams';
    
    $stmt_link = $conexao->prepare("SELECT link, direct_source FROM {$tabela} WHERE id = :id LIMIT 1");
    $stmt_link->execute([':id' => $stream_id]);
    $conteudo = $stmt_link->fetch(PDO::FETCH_ASSOC);

    if (!$conteudo) {
        header("Location: $video_banido");
        exit;
    }

    // Prioriza direct_source, seno usa link
    $link_final = !empty($conteudo['direct_source']) ? $conteudo['direct_source'] : ($conteudo['link'] ?? '');
    
    if (empty($link_final)) {
        header("Location: $video_banido");
        exit;
    }

    // Limpa buffer e redireciona
    ob_end_clean();
    header("Location: " . $link_final);
    exit;

} catch (Exception $e) {
    // Erro crtico -> block.mp4
    header("Location: $video_banido");
    exit;
}
?>