<?php
// ARQUIVO: series_redirecionamento.php
// Verso com vdeos de bloqueio DIFERENCIADOS (Banido vs Limite Excedido)

ob_start(); // Inicia buffer

header("Content-Type: text/html; charset=UTF-8");
header("Cache-Control: no-store, no-cache, must-revalidate");
date_default_timezone_set('America/Sao_Paulo');

error_reporting(0); 
ini_set('display_errors', 0);

require_once('./api/controles/db.php');

// --- FUNES AUXILIARES ---
function processarUrl($url) {
    $parsedUrl = parse_url($url);
    $path = $parsedUrl['path'] ?? '';
    $pathParts = explode('/', trim($path, '/'));
    
    if (count($pathParts) >= 4) {
        $usuario = $pathParts[1];
        $senha = $pathParts[2];
        $arquivo = pathinfo($pathParts[3], PATHINFO_FILENAME);
    } elseif (count($pathParts) <= 3 && count($pathParts) > 1) {
        $usuario = $pathParts[0];
        $senha = $pathParts[1];
        $arquivo = pathinfo($pathParts[2] ?? '', PATHINFO_FILENAME);
    } else { return false; }
    
    if (empty($arquivo) || !is_numeric($arquivo)) { return false; }
    
    return [ 'dominio' => $parsedUrl['host'] ?? '', 'usuario' => $usuario, 'senha' => $senha, 'arquivo' => $arquivo ];
}

function getHeadersAsJson($url) {
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HEADER, true);
    curl_setopt($ch, CURLOPT_NOBODY, true);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, false);
    curl_setopt($ch, CURLOPT_TIMEOUT, 10);
    $response = curl_exec($ch);
    $headers = [];
    if ($response !== false) {
        $header_text = substr($response, 0, curl_getinfo($ch, CURLINFO_HEADER_SIZE));
        foreach (explode("\r\n", $header_text) as $i => $line) {
            if ($i === 0) { $headers['http_code'] = $line; } 
            else {
                $parts = explode(': ', $line);
                if (count($parts) == 2) { $headers[$parts[0]] = $parts[1]; }
            }
        }
    }
    curl_close($ch);
    return json_encode($headers);
}
// ----------------------------

// --- DEFINIO DOS VDEOS DE BLOQUEIO ---
$host = "http://" . $_SERVER["HTTP_HOST"];
$video_banido = "$host/video/block.mp4";             // Conta Vencida ou Banida
$video_limite = "$host/video/bloqueio-conexao.mp4";  // Limite Excedido (Telas simultneas)

// --- Varivel de Tempo ---
$agora = date('Y-m-d H:i:s');

// ---- Parmetros ----
$type_url = $_GET['type_url'] ?? 'series';
$username = $_GET['usuario'] ?? null;
$password = $_GET['senha'] ?? null;
$arquivo  = $_GET['arquivo'] ?? null;

if ($arquivo) {
    $stream_id = pathinfo($arquivo, PATHINFO_FILENAME);
    $extensao = pathinfo($arquivo, PATHINFO_EXTENSION);
} else {
    $stream_id = null;
    $extensao = 'mp4';
}

if (!$username || !$password || !$stream_id) {
    header("Location: $video_banido");
    exit();
}

try {
    $conexao = conectar_bd();

    // 1. AUTENTICAO
    $query_auth = "SELECT id, max_connections, Vencimento, is_banned FROM clientes WHERE usuario = :username AND senha = :password LIMIT 1";
    $statement = $conexao->prepare($query_auth);
    $statement->execute([':username' => $username, ':password' => $password]);
    $cliente = $statement->fetch(PDO::FETCH_ASSOC);

    // BLOQUEIO 1: CONTA INVLIDA, BANIDA OU VENCIDA -> block.mp4
    if (!$cliente || 
        ($cliente['is_banned'] == 1) || 
        (new DateTime() > new DateTime($cliente["Vencimento"]))
       ) {
        header("Location: $video_banido");
        exit();
    }

    // 2. CONTROLE DE CONEXO
    $ip = $_SERVER['REMOTE_ADDR'];
    $user_agent = $_SERVER['HTTP_USER_AGENT'] ?? 'Desconhecido';
    $limiteConexoes = (int) ($cliente["max_connections"] ?? 1);
    if ($limiteConexoes < 1) $limiteConexoes = 1;

    // Limpeza
    $conexao->exec("DELETE FROM conexoes WHERE ultima_atividade < NOW() - INTERVAL 30 SECOND");
    
    // Atualiza conexo existente
    $stmt_up = $conexao->prepare("UPDATE conexoes SET ultima_atividade = :now_time, stream_id = :sid WHERE usuario = :user AND ip = :ip");
    $stmt_up->execute([ ':now_time' => $agora, ':sid' => $stream_id, ':user' => $username, ':ip' => $ip ]);

    // Se  nova conexo
    if ($stmt_up->rowCount() == 0) {
        $stmt_count = $conexao->prepare("SELECT COUNT(*) FROM conexoes WHERE usuario = :usuario");
        $stmt_count->execute([':usuario' => $username]);
        $conexoes_ativas = (int) $stmt_count->fetchColumn();

        // BLOQUEIO 2: LIMITE EXCEDIDO -> bloqueio-conexao.mp4
        if ($conexoes_ativas >= $limiteConexoes) {
            header("Location: $video_limite");
            exit();
        }

        // Insere
        $stmt_insert = $conexao->prepare("INSERT INTO conexoes (usuario, ip, user_agent, stream_id, ultima_atividade) VALUES (:usuario, :ip, :user_agent, :stream_id, :now_time)");
        $stmt_insert->execute([ ':usuario' => $username, ':ip' => $ip, ':user_agent' => $user_agent, ':stream_id' => $stream_id, ':now_time' => $agora ]);
    }

    // 3. BUSCA DO EPISDIO
    $query_streams = "SELECT * FROM series_episodes WHERE id = :id LIMIT 1";
    $stmt_streams = $conexao->prepare($query_streams);
    $stmt_streams->bindValue(':id', $stream_id, PDO::PARAM_INT);
    $stmt_streams->execute();
    $resultado_streams = $stmt_streams->fetch(PDO::FETCH_ASSOC);

    if (empty($resultado_streams) || empty($resultado_streams['link'])) {
        header("Location: $video_banido"); // Arquivo no encontrado (usa o padro)
        exit();
    }
    
    ob_end_clean(); // Limpa buffer

    // ---- REDIRECIONAMENTOS ----
    $location = $resultado_streams['link'];
    $tipo_link = $resultado_streams['tipo_link'] ?? 'link_direto';

    if ($tipo_link == 'link_direto') { header("Location: ".$location); exit; }
    
    $dados = @processarUrl($location);
    if ($location && $dados && $tipo_link !== 'link_direto2') {
        $url = "http://{$dados['dominio']}/{$type_url}/{$dados['usuario']}/{$dados['senha']}/{$dados['arquivo']}.$extensao";
        if ($tipo_link == 'padrao2') { header("Location: ".$location); exit; }
        
        $location2_json = getHeadersAsJson($url);
        $location2 = json_decode($location2_json, true);
        
        if ($location2 && isset($location2['Location'])) { header("Location: " . (is_array($location2['Location']) ? $location2['Location'][0] : $location2['Location'])); exit; }
        if ($location2 && isset($location2['URLsComToken'])) { header("Location: " . (is_array($location2['URLsComToken']) ? $location2['URLsComToken'][0] : $location2['URLsComToken'])); exit; }
        
        header("Location: $url"); exit;
    }

    $location3_json = getHeadersAsJson($location);
    $location3 = json_decode($location3_json, true);
    
    if ($location3 && isset($location3['Location'])) { header("Location: " . (is_array($location3['Location']) ? $location3['Location'][0] : $location3['Location'])); exit; }
    if (isset($location3['URLsComToken'])) { header("Location: " . (is_array($location3['URLsComToken']) ? $location3['URLsComToken'][0] : $location3['URLsComToken'])); exit; }

    header("Location: $location");
    exit;

} catch (Exception $e) {
    header("Location: $video_banido");
    exit();
}
?>