<?php
// ARQUIVO: redirecionar-movie.php
// Verso com vdeos de bloqueio DIFERENCIADOS (Banido vs Limite Excedido)

// 1. Limpa qualquer lixo de memria
ob_start();

date_default_timezone_set('America/Sao_Paulo');
header("Cache-Control: no-cache, no-store, must-revalidate");
header("Pragma: no-cache");
header("Expires: 0");

error_reporting(0);
ini_set('display_errors', 0);

require_once "./api/controles/db.php";

// --- DEFINIO DOS VDEOS DE BLOQUEIO ---
$host = "http://" . $_SERVER["HTTP_HOST"];
$video_banido = "$host/video/block.mp4";             // Conta Vencida, Banida ou Erro Geral
$video_limite = "$host/video/bloqueio-conexao.mp4";  // Limite de Telas Excedido

// --- VARIVEL DE TEMPO ---
$agora = date('Y-m-d H:i:s');

// --- PARMETROS ---
$username = $_GET["usuario"] ?? null;
$password = $_GET["senha"] ?? null;
$arquivo  = $_GET["arquivo"] ?? null;

// Extrai apenas o ID
$stream_id = pathinfo($arquivo, PATHINFO_FILENAME);
if (is_numeric($stream_id)) {
    $stream_id = (int)$stream_id;
}

// Validao bsica
if (empty($stream_id) || !$username || !$password) {
    header("Location: $video_banido");
    exit;
}

try {
    $conexao = conectar_bd();

    // 1. VERIFICA O CLIENTE
    $stmt = $conexao->prepare("SELECT id, max_connections, Vencimento, is_banned FROM clientes WHERE usuario = :user AND senha = :pass LIMIT 1");
    $stmt->execute([':user' => $username, ':pass' => $password]);
    $cliente = $stmt->fetch(PDO::FETCH_ASSOC);

    // --- BLOQUEIO 1: CONTA IRREGULAR (Banida ou Vencida) -> block.mp4 ---
    if (!$cliente || 
        ($cliente['is_banned'] == 1) || 
        (new DateTime() > new DateTime($cliente["Vencimento"]))
       ) {
        header("Location: $video_banido");
        exit;
    }

    // 2. GESTO DE CONEXES
    $limite = (int)($cliente['max_connections'] ?? 1);
    if ($limite < 1) $limite = 1;

    $ip = $_SERVER['REMOTE_ADDR'];
    $ua = $_SERVER['HTTP_USER_AGENT'] ?? 'Unknown';

    // Remove conexes velhas (30s)
    $conexao->exec("DELETE FROM conexoes WHERE ultima_atividade < NOW() - INTERVAL 30 SECOND");

    // Tenta atualizar a conexo deste usurio neste IP tocando este filme
    $stmt_up = $conexao->prepare("UPDATE conexoes SET ultima_atividade = :now, stream_id = :sid WHERE usuario = :user AND ip = :ip");
    $stmt_up->execute([
        ':now'  => $agora,
        ':sid'  => $stream_id,
        ':user' => $username,
        ':ip'   => $ip
    ]);

    // Se no atualizou nada,  uma conexo nova. Verifica se tem vaga.
    if ($stmt_up->rowCount() == 0) {
        $stmt_count = $conexao->prepare("SELECT COUNT(*) FROM conexoes WHERE usuario = :user");
        $stmt_count->execute([':user' => $username]);
        $ativas = (int)$stmt_count->fetchColumn();

        // --- BLOQUEIO 2: LIMITE EXCEDIDO -> bloqueio-conexao.mp4 ---
        if ($ativas >= $limite) {
            header("Location: $video_limite");
            exit;
        }

        // Insere nova conexo
        $stmt_in = $conexao->prepare("INSERT INTO conexoes (usuario, ip, user_agent, stream_id, ultima_atividade) VALUES (:user, :ip, :ua, :sid, :now)");
        $stmt_in->execute([
            ':user' => $username,
            ':ip'   => $ip,
            ':ua'   => $ua,
            ':sid'  => $stream_id,
            ':now'  => $agora
        ]);
    }

    // 3. BUSCA O FILME
    $stmt_movie = $conexao->prepare("SELECT link, direct_source FROM streams WHERE id = :id LIMIT 1");
    $stmt_movie->execute([':id' => $stream_id]);
    $filme = $stmt_movie->fetch(PDO::FETCH_ASSOC);

    if (!$filme) {
        // Filme no existe -> Redireciona para block padro
        header("Location: $video_banido");
        exit;
    }

    $link_final = !empty($filme['direct_source']) ? $filme['direct_source'] : $filme['link'];

    if (empty($link_final)) {
        header("Location: $video_banido");
        exit;
    }

    // Limpa o buffer e redireciona
    ob_end_clean();
    header("Location: " . $link_final);
    exit;

} catch (Exception $e) {
    // Erro crtico -> block.mp4
    header("Location: $video_banido");
    exit;
}
?>