<?php
// ==========================================================
// ARQUIVO: /revendedores.php (O FRONTEND)
// VERSÃO 21 - CORREÇÃO FINAL (REMOVE DUPLICATE DATATABLE E AJUSTA MENSAGEM)
// ==========================================================

if (session_status() === PHP_SESSION_NONE) {
    session_start();
}
// Define o caminho da API (COMEÇANDO COM /)
$api_path = '/api/revendedores.php';

// Carrega o menu
$page_title = "Gerenciamento de Revendedores"; 
header('Content-Type: text/html; charset=utf-8');
require_once("menu.php"); // Inclui o topo, menu e início da página
?>

<div class="row mb-4">
    <div class="col-md-4">
        <div class="card border-success shadow-sm">
            <div class="card-body"><div class="d-flex justify-content-between align-items-center"><div><h5 class="card-title text-success">Revendedores Ativos</h5><h3 id="count-rev-ativos" class="mb-0">0</h3></div><i class="fas fa-user-check fa-3x text-success" style="opacity: 0.5;"></i></div></div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="card border-warning shadow-sm">
            <div class="card-body"><div class="d-flex justify-content-between align-items-center"><div><h5 class="card-title text-warning">Revendedores Sem Crédito</h5><h3 id="count-rev-vencidos" class="mb-0">0</h3></div><i class="fas fa-user-clock fa-3x text-warning" style="opacity: 0.5;"></i></div></div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="card border-danger shadow-sm">
            <div class="card-body"><div class="d-flex justify-content-between align-items-center"><div><h5 class="card-title text-danger">Revendedores Bloqueados</h5><h3 id="count-rev-bloqueados" class="mb-0">0</h3></div><i class="fas fa-user-lock fa-3x text-danger" style="opacity: 0.5;"></i></div></div>
        </div>
    </div>
</div>

<div class="card bg-dark text-white">
    <div class="card-header d-flex justify-content-between align-items-center">
        <h4 class="text-white">Lista de Revendedores</h4>
        <button type="button" class="btn btn-outline-success" onclick='modal_master("<?php echo $api_path; ?>", "add_revendedor", "0")'>
            <i class="fas fa-plus"></i><span class="ms-2"> Adicionar Revendedor</span>
        </button>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table id="tabela_revendedores" class="display table table-striped table-hover table-dark" style="width:100%;">
                <thead class="table-dark">
                    <tr>
                        <th>#</th>
                        <th>Usuário</th>
                        <th>Créditos</th>
                        <th>Clientes</th>
                        <th>Ações</th>
                    </tr>
                </thead>
                <tbody></tbody>
            </table>
        </div>
    </div>
</div>

<?php
// Carrega o footer (que deve ter os modais de cópia)
require_once("footer.php"); 
?>

<div class="modal fade" id="modal_master_auto" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content bg-dark text-white">
            <div class="modal-header" id="modal_master_auto-header">
                <h5 class="modal-title" id="modal_master_auto-titulo"></h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div id="modal_master_auto-body" class="modal-body"></div>
            <div id="modal_master_auto-footer" class="modal-footer"></div>
        </div>
    </div>
</div>

<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<script src="//cdn.datatables.net/2.0.7/js/dataTables.js"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script src="/js/app.js"></script> 

<script>
// ==================================================
// INÍCIO DO JAVASCRIPT CORRIGIDO
// ==================================================

// Define a URL da API (do PHP)
const API_URL_REVENDEDORES = '<?php echo $api_path; ?>'; // '/api/revendedores.php'

// 1. Funções de Tema e Contagem (só rodam quando o DOM está pronto)
$(document).ready(function() {
    
    // Pega o tema (do seu clientes.php)
    const themeToggleBtn = document.getElementById('theme-toggle');
    const themeIcon = document.getElementById('theme-icon'); 
    const htmlElement = document.documentElement;
    const applyTheme = (theme) => {
        htmlElement.setAttribute('data-bs-theme', theme);
        if (themeIcon) {
            themeIcon.className = theme === 'dark' ? 'fas fa-sun' : 'fas fa-moon';
        }
    };
    const savedTheme = localStorage.getItem('theme') || 'light';
    applyTheme(savedTheme);
    if (themeToggleBtn) {
        themeToggleBtn.addEventListener('click', () => {
            const newTheme = htmlElement.getAttribute('data-bs-theme') === 'dark' ? 'light' : 'dark';
            localStorage.setItem('theme', newTheme);
            applyTheme(newTheme);
        });
    }
    
    // ==================================================
    // ERRO 1 CORRIGIDO: O bloco 'new DataTable(...)' FOI REMOVIDO DAQUI
    // O seu /js/app.js já está a tratar disto.
    // ==================================================

    // 2. Carrega as contagens dos cards
    carregarContagensRevendedores();
}); 

// 3. Função para carregar os cards
function carregarContagensRevendedores() {
    $.ajax({
        url: API_URL_REVENDEDORES, 
        type: 'GET',
        data: { 
            acao: 'obter_contagens_revendedores',
            _cache: new Date().getTime() 
        }, 
        dataType: 'json',
        success: function(response) {
            if (response && typeof response === 'object' && !response.title) {
                $('#count-rev-ativos').text(response.ativos || 0);
                $('#count-rev-vencidos').text(response.vencidos || 0);
                $('#count-rev-bloqueados').text(response.bloqueados || 0);
            } else if (response && response.title) {
                console.error("Erro da API de Contagem (Revendedores):", response.msg);
                $('#count-rev-ativos').text('X');
                $('#count-rev-vencidos').text('X');
                $('#count-rev-bloqueados').text('X');
            }
        },
        error: function(xhr, status, error) {
            console.error("Erro fatal ao chamar API de Contagem (Revendedores):", xhr.responseText);
            $('#count-rev-ativos').text('X');
            $('#count-rev-vencidos').text('X');
            $('#count-rev-bloqueados').text('X');
        }
    });
}

// 4. Função para carregar o modal
function modal_master(endpoint, acao, id) {
    if (endpoint === "revendedores.php") {
        endpoint = API_URL_REVENDEDORES; 
    }
    
    $.ajax({
        url: endpoint, 
        type: 'POST',
        data: { 
            action: acao,
            id: id 
        },
        dataType: 'json',
        success: function(response) {
            $('#modal_master_auto-titulo').html(response.modal_titulo || 'Aviso');
            $('#modal_master_auto-body').html(response.modal_body || 'Ocorreu um erro.');
            $('#modal_master_auto-footer').html(response.modal_footer || '<button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Fechar</button>');
            $('#modal_master_auto-header').removeClass('bg-success bg-info bg-danger').addClass(response.modal_header_class || '');
            
            var modalElement = new bootstrap.Modal(document.getElementById('modal_master_auto'));
            modalElement.show();
        },
        error: function(xhr, status, error) {
            console.error("Erro no modal_master:", status, error, xhr.responseText);
            Swal.fire('Erro!', 'Não foi possível carregar o modal. (API Falhou)', 'error');
        }
    });
}

// ==================================================
// 5. FUNÇÃO 'enviarFormulario' (COM A CORREÇÃO DAS MENSAGENS)
// ==================================================
function enviarFormulario(formId, endpoint) {
    var formData = new FormData(document.getElementById(formId));
    
    if (endpoint === "revendedores.php") {
        endpoint = API_URL_REVENDEDORES; 
    }
    
    $.ajax({
        url: endpoint, 
        type: 'POST',
        data: formData,
        processData: false,
        contentType: false,
        dataType: 'json',
        success: function(response) {
            
            var modalElement = bootstrap.Modal.getInstance(document.getElementById('modal_master_auto'));
            if (modalElement) {
                modalElement.hide();
            }

            if (response.data_table === 'atualizar') {
                $('#tabela_revendedores').DataTable().ajax.reload(null, false);
                carregarContagensRevendedores(); // Atualiza os cards
            }

            // ================================================
            // AQUI ESTÁ A CORREÇÃO (ERRO 2)
            // ================================================

            // Caso 1: ADICIONAR REVENDEDOR (tem 'dados_revendedor_msg')
            if (response.dados_revendedor_msg) {
                const mensagem = response.dados_revendedor_msg;
                const urlWhatsapp = "https://wa.me/?text=" + encodeURIComponent(mensagem);
                
                Swal.fire({
                    title: response.title, // 'Concluído!'
                    // CORRIGIDO: Mostra a mensagem completa no corpo
                    html: '<pre style="text-align: left; white-space: pre-wrap;">' + mensagem + '</pre>', 
                    icon: response.icon,
                    footer: `
                        <button id="copy-rev-data" class="btn btn-primary">
                            <i class="fas fa-copy"></i> Copiar Dados
                        </button>
                        <a href="${urlWhatsapp}" target="_blank" class="btn btn-success">
                            <i class="fab fa-whatsapp"></i> Enviar WhatsApp
                        </a>
                    `,
                    didOpen: () => {
                        $('#copy-rev-data').on('click', () => {
                            navigator.clipboard.writeText(mensagem).then(() => {
                                // Mostra um feedback verde de sucesso
                                const copyBtn = document.getElementById('copy-rev-data');
                                copyBtn.innerHTML = '<i class="fas fa-check"></i> Copiado!';
                                copyBtn.classList.remove('btn-primary');
                                copyBtn.classList.add('btn-success');
                            });
                        });
                    }
                });
            
            // Caso 2: ADICIONAR CRÉDITOS (tem 'dados_operacao_msg')
            } else if (response.dados_operacao_msg) {
                const mensagemOp = response.dados_operacao_msg;
                const urlWhatsappOp = "https://wa.me/?text=" + encodeURIComponent(mensagemOp);

                 Swal.fire({
                    title: response.title, // 'Sucesso!'
                    // CORRIGIDO: Mostra a mensagem completa no corpo
                    html: '<pre style="text-align: left; white-space: pre-wrap;">' + mensagemOp + '</pre>',
                    icon: response.icon,
                    footer: `
                        <button id="copy-op-data" class="btn btn-primary">
                            <i class="fas fa-copy"></i> Copiar Mensagem
                        </button>
                        <a href="${urlWhatsappOp}" target="_blank" class="btn btn-success">
                            <i class="fab fa-whatsapp"></i> Enviar WhatsApp
                        </a>
                    `,
                    didOpen: () => {
                        $('#copy-op-data').on('click', () => {
                            navigator.clipboard.writeText(mensagemOp).then(() => {
                                // Mostra um feedback verde de sucesso
                                const copyBtn = document.getElementById('copy-op-data');
                                copyBtn.innerHTML = '<i class="fas fa-check"></i> Copiado!';
                                copyBtn.classList.remove('btn-primary');
                                copyBtn.classList.add('btn-success');
                            });
                        });
                    }
                });
                
            // Caso 3: SweetAlert Normal (Editar, Excluir, Erros)
            } else if (response.title) {
                Swal.fire(response.title, response.msg, response.icon);
            }
            
        },
        error: function(xhr, status, error) {
            console.error("Erro no enviarFormulario:", status, error, xhr.responseText);
            Swal.fire('Erro!', 'Não foi possível enviar o formulário.', 'error');
        }
    });
}

// Função 'enviardados' (legada) - ela chama a função correta
function enviardados(formId, endpoint) {
    console.warn("Chamando 'enviardados', mudar para 'enviarFormulario'.");
    enviarFormulario(formId, endpoint);
}
</script>

</body>
</html>
