<?php
// Arquivo: api/clientes/listar_testes.php (VERS01O FINAL CORRIGIDA)

header('Content-Type: application/json; charset=utf-8');
require_once __DIR__ . '/../controles/db.php';

try {
    $pdo = conectar_bd();
    
    // CORRIGIDO: Seleciona a coluna "Vencimento" (com V maisculo)
    // Assumindo que "testes" s00o clientes com is_trial = 1
    $stmt = $pdo->prepare(
        "SELECT id, name, usuario, Vencimento 
         FROM clientes 
         WHERE is_trial = 1 
         ORDER BY Criado_em DESC"
    );
    
    $stmt->execute();
    $testes = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    echo json_encode(['status' => 'success', 'data' => $testes]);

} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(['status' => 'error', 'message' => 'Erro ao listar os testes.']);
    // error_log("Erro em listar_testes.php: " . $e->getMessage());
}
?>