<?php
// Define o cabeçalho da resposta como JSON
header('Content-Type: application/json');

// Inclui a conexão com o banco de dados
require_once dirname(__DIR__, 2) . '/api/controles/db.php';

// 1. LER OS DADOS ENVIADOS PELO JAVASCRIPT
$data = json_decode(file_get_contents('php://input'), true);

// 2. VALIDAR OS DADOS RECEBIDOS
// Verifica se o ID e os meses foram enviados e são números válidos
if (!isset($data['id']) || !isset($data['meses']) || !filter_var($data['id'], FILTER_VALIDATE_INT) || !filter_var($data['meses'], FILTER_VALIDATE_INT)) {
    http_response_code(400); // Bad Request
    echo json_encode(['status' => 'error', 'message' => 'ID do cliente ou número de meses inválido.']);
    exit();
}

$id = $data['id'];
$mesesParaRenovar = (int)$data['meses'];

if ($mesesParaRenovar <= 0) {
    http_response_code(400);
    echo json_encode(['status' => 'error', 'message' => 'O número de meses para renovação deve ser maior que zero.']);
    exit();
}


try {
    // 3. CALCULAR A NOVA DATA DE VENCIMENTO
    $dataAtual = new DateTime("now", new DateTimeZone('America/Sao_Paulo'));
    
    // Adiciona o número de meses à data atual
    $dataAtual->add(new DateInterval("P{$mesesParaRenovar}M")); 
    
    // Formata a data para o formato do banco de dados MySQL (DATETIME)
    $novaDataVencimento = $dataAtual->format('Y-m-d H:i:s');
    
    // Conecta ao banco de dados
    $pdo = conectar_bd();

    // 4. EXECUTAR A ATUALIZAÇÃO NO BANCO (SUA LÓGICA CORRETA)
    // Converte o teste em cliente (is_trial = 0) e atualiza a data de vencimento
    $stmt = $pdo->prepare("UPDATE clientes SET Vencimento = :vencimento, is_trial = 0 WHERE id = :id");
    
    $stmt->execute([
        ':vencimento' => $novaDataVencimento,
        ':id' => $id
    ]);

    // Verifica se a atualização realmente afetou alguma linha
    if ($stmt->rowCount() > 0) {
        echo json_encode(['status' => 'success', 'message' => 'Assinatura renovada com sucesso!']);
    } else {
        http_response_code(404); // Not Found
        echo json_encode(['status' => 'error', 'message' => 'Cliente não encontrado ou nenhum dado foi alterado.']);
    }

} catch (PDOException $e) {
    // 5. CAPTURAR ERROS E ENVIAR UMA RESPOSTA CLARA
    http_response_code(500); // Internal Server Error
    echo json_encode(['status' => 'error', 'message' => 'Erro no servidor ao tentar renovar a assinatura.']);

    // Para você (desenvolvedor), registre o erro real em um log
    // error_log("Erro ao renovar cliente: " . $e->getMessage());
}
?>