document.addEventListener('DOMContentLoaded', () => {
    
    const carregarClientesDiagnostico = async () => {
        const tabelaClientes = document.getElementById('tabela-clientes');
        if (!tabelaClientes) {
            console.error("Elemento 'tabela-clientes' não foi encontrado.");
            return;
        }

        try {
            const response = await fetch('/ajax.php?action=listar_clientes');
            
            // MUDANÇA IMPORTANTE: Estamos lendo a resposta como TEXTO, não como JSON.
            const debugText = await response.text();

            // Exibindo o resultado do diagnóstico diretamente na tabela para você ver.
            tabelaClientes.innerHTML = `
                <tr>
                    <td colspan="5">
                        <div class="alert alert-info">
                            <h5 class="alert-heading">Resultado do Diagnóstico do Servidor:</h5>
                            <hr>
                            <pre style="white-space: pre-wrap; word-wrap: break-word; color: #000;">${debugText}</pre>
                        </div>
                    </td>
                </tr>
            `;

        } catch (error) {
            tabelaClientes.innerHTML = `<tr><td colspan="5" class="text-center text-danger">Ocorreu um erro de rede. Não foi possível conectar ao servidor. ${error.message}</td></tr>`;
        }
    };

    // --- CARGA INICIAL ---
    carregarClientesDiagnostico();
});