<?php
session_start();
// Seus includes de verificação de login, etc., podem ir aqui
require_once("menu.php"); // Inclui o topo, menu e início da página

// Define o caminho da API (COMEÇANDO COM /)
$api_path = '/api/testes.php';
?>
<!DOCTYPE html>
<html lang="pt-br" data-bs-theme="light">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Gerenciar Testes</title>
    
    
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
    <link rel="stylesheet" href="//cdn.datatables.net/2.0.7/css/dataTables.dataTables.min.css">
    
    <style>
        body, .card, .modal-content, .bg-body-tertiary {
            transition: background-color 0.3s ease, color 0.3s ease;
        }
    </style>
</head>
<body>


    <div class="row mb-4">
        <div class="col-md-4">
            <div class="card border-success shadow-sm">
                <div class="card-body"><div class="d-flex justify-content-between align-items-center"><div><h5 class="card-title text-success">Testes Ativos</h5><h3 id="count-testes-ativos" class="mb-0">0</h3></div><i class="fas fa-user-check fa-3x text-success" style="opacity: 0.5;"></i></div></div>
            </div>
        </div>

        <div class="col-md-4">
            <div class="card border-warning shadow-sm">
                <div class="card-body"><div class="d-flex justify-content-between align-items-center"><div><h5 class="card-title text-warning">Testes Expirados</h5><h3 id="count-testes-vencidos" class="mb-0">0</h3></div><i class="fas fa-user-clock fa-3x text-warning" style="opacity: 0.5;"></i></div></div>
            </div>
        </div>

        <div class="col-md-4">
            <div class="card border-danger shadow-sm">
                <div class="card-body"><div class="d-flex justify-content-between align-items-center"><div><h5 class="card-title text-danger">Testes Bloqueados</h5><h3 id="count-testes-bloqueados" class="mb-0">0</h3></div><i class="fas fa-user-lock fa-3x text-danger" style="opacity: 0.5;"></i></div></div>
            </div>
        </div>
    </div>
    <div class="card shadow-sm border-0 rounded-3 p-4">
        <h4 class="card-title text-primary d-flex justify-content-between align-items-center mb-4">
            <span class="fw-bold">LISTAR Clientes em Teste</span>
            <div>
                <button type="button" class="btn btn-info rounded-pill" onclick="executarTesteRapido()">
                    <i class="fas fa-bolt me-2"></i> Teste Rápido
                </button>
                <button type="button" class="btn btn-primary rounded-pill" onclick='modal_master("<?php echo $api_path; ?>", "adicionar_testes")'>
                    <i class="fas fa-plus me-2"></i> Adicionar Teste
                </button>
            </div>
        </h4>
        <div class="table-responsive">
            <table id="tabela_testes" class="display table table-striped table-hover" style="width:100%;">
                <thead class="bg-primary text-white">
                    <tr>
                        <th>#</th>
                        <th>Nome</th>
                        <th>Usuário</th>
                        <th>Status</th>
                        <th>Expira em</th>
                        <th style="min-width: 150px;">Ações</th>
                    </tr>
                </thead>
                <tbody></tbody>
            </table>
        </div>
    </div>
</div>

<div class="modal fade" id="modal_master" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header" id="modal_master-header">
                <h5 class="modal-title" id="modal_master-titulo"></h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div id="modal_master-body" class="modal-body p-4"></div>
            <div id="modal_master-footer" class="modal-footer"></div>
        </div>
    </div>
</div>

<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<script src="//cdn.datatables.net/2.0.7/js/dataTables.js"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script src="/js/app.js"></script> <script>
    document.addEventListener('DOMContentLoaded', function() {
        // Define o caminho da API
        const API_URL_TESTES = '<?php echo $api_path; ?>';
        
        const themeToggleBtn = document.getElementById('theme-toggle');
        const themeIcon = document.getElementById('theme-icon');
        const htmlElement = document.documentElement;

        // Função para aplicar o tema e atualizar o ícone
        const applyTheme = (theme) => {
            htmlElement.setAttribute('data-bs-theme', theme);
            if (themeIcon) {
                themeIcon.className = theme === 'dark' ? 'fas fa-sun' : 'fas fa-moon';
            }
        };

        // Verifica se já existe um tema salvo no navegador
        const savedTheme = localStorage.getItem('theme') || 'light';
        applyTheme(savedTheme);

        // Adiciona o evento de clique ao botão
        themeToggleBtn.addEventListener('click', () => {
            const newTheme = htmlElement.getAttribute('data-bs-theme') === 'dark' ? 'light' : 'dark';
            // Salva a nova preferência no navegador
            localStorage.setItem('theme', newTheme);
            applyTheme(newTheme);
        });
        
        
        // ==================================================
        // INÍCIO DO NOVO CÓDIGO PARA OS CARDS DE TESTE
        // ==================================================
        function carregarContagensTestes() {
            $.ajax({
                url: API_URL_TESTES, 
                type: 'GET',
                data: { 
                    acao: 'obter_contagens_testes', // Ação específica para testes
                    _cache: new Date().getTime() // O nosso "quebra-cache"
                }, 
                dataType: 'json',
                success: function(response) {
                    if (response && typeof response === 'object' && !response.title) {
                        $('#count-testes-ativos').text(response.ativos || 0);
                        $('#count-testes-vencidos').text(response.vencidos || 0);
                        $('#count-testes-bloqueados').text(response.bloqueados || 0);
                    } else if (response && response.title) {
                        console.error("Erro da API de Contagem (Testes):", response.msg);
                    }
                },
                error: function(xhr, status, error) {
                    console.error("Erro fatal ao chamar API de Contagem (Testes):", xhr.responseText);
                    $('#count-testes-ativos').text('X');
                    $('#count-testes-vencidos').text('X');
                    $('#count-testes-bloqueados').text('X');
                }
            });
        }
        
        // Chama a nova função
        carregarContagensTestes();
        
        // ==================================================
        // FIM DO NOVO CÓDIGO
        // ==================================================

        // O seu /js/app.js vai tratar de carregar o DataTables
        // (Assumindo que ele usa o ID 'tabela_testes' e o API_URL_TESTES)
        
    });
</script>

</body>
</html>
