<?php
// Inclui o cabeçalho e menu do seu painel principal
require_once 'menu.php';
require_once './api/controles/db.php'; 

$testes_p2p = [];
$template_p2p_atual = '';

// ==================================================
// ### INÍCIO DA NOVA LÓGICA DE CONTAGEM (V17) ###
// ==================================================
$cont_testes_p2p_ativos = 0;
$cont_testes_p2p_vencidos = 0;
// ==================================================

$conexao = conectar_bd();
if ($conexao) {
    try {
        $stmt_template = $conexao->prepare("SELECT valor FROM configuracoes WHERE chave = 'p2p_message_template' LIMIT 1");
        $stmt_template->execute();
        $template_p2p_atual = $stmt_template->fetchColumn();
        
        // ==================================================
        // ### LÓGICA DE CONTAGEM (V17 para Testes P2P) ###
        // ==================================================
        
        $agora_php = date("Y-m-d H:i:s");
        
        // Filtro base: É P2P E É Teste
        $sql_base_p2p_teste = " FROM clientes WHERE is_p2p = 1 AND plano = 'Teste P2P'";
        $params_contagem = [];

        // Adiciona filtro de revendedor (se for um)
        if (isset($_SESSION['nivel_admin']) && $_SESSION['nivel_admin'] == 0) {
            $sql_base_p2p_teste .= " AND admin_id = :admin_id";
            $params_contagem[':admin_id'] = $_SESSION['admin_id'];
        }

        // 1. Contar Testes P2P ATIVOS
        $sql_ativos = "SELECT COUNT(*) " . $sql_base_p2p_teste . " AND (is_banned IS NULL OR is_banned = 0) AND Vencimento >= :agora";
        $stmt_ativos = $conexao->prepare($sql_ativos);
        $stmt_ativos->execute(array_merge($params_contagem, [':agora' => $agora_php]));
        $cont_testes_p2p_ativos = $stmt_ativos->fetchColumn();

        // 2. Contar Testes P2P VENCIDOS
        $sql_vencidos = "SELECT COUNT(*) " . $sql_base_p2p_teste . " AND (is_banned IS NULL OR is_banned = 0) AND Vencimento < :agora";
        $stmt_vencidos = $conexao->prepare($sql_vencidos);
        $stmt_vencidos->execute(array_merge($params_contagem, [':agora' => $agora_php]));
        $cont_testes_p2p_vencidos = $stmt_vencidos->fetchColumn();
        
        // ==================================================
        // ### FIM DA LÓGICA DE CONTAGEM ###
        // ==================================================


        // --- Lógica para a tabela (original) ---
        $sql = "SELECT id, usuario, name, whatsapp, Vencimento FROM clientes WHERE is_p2p = 1 AND plano = 'Teste P2P'";
        $params = [];

        if (isset($_SESSION['nivel_admin']) && $_SESSION['nivel_admin'] == 0) {
            $sql .= " AND admin_id = :admin_id";
            $params[':admin_id'] = $_SESSION['admin_id'];
        }
        
        $sql .= " ORDER BY id DESC";
        $stmt = $conexao->prepare($sql);
        $stmt->execute($params);
        $testes_p2p = $stmt->fetchAll(PDO::FETCH_ASSOC);
        
    } catch(PDOException $e) {
        error_log("Erro na página Testes P2P: " . $e->getMessage());
    }
}
?>

<style>
    /* --- ESTILOS GERAIS --- */
    .card { color: #212529; }
    .table { color: #212529; background-color: #fff; }
    
    /* --- CARDS ESTILO DASHBOARD --- */
    .card-dashboard {
        border: none;
        border-radius: 12px;
        color: #fff;
        position: relative;
        overflow: hidden;
        transition: transform 0.3s ease, box-shadow 0.3s ease;
        height: 100%;
        box-shadow: 0 4px 6px rgba(0,0,0,0.1);
    }
    .card-dashboard:hover {
        transform: translateY(-5px);
        box-shadow: 0 10px 20px rgba(0,0,0,0.2) !important;
    }
    .card-dashboard .card-body {
        position: relative;
        z-index: 2;
        padding: 1.5rem;
    }
    .card-dashboard .icon-bg {
        position: absolute;
        right: 15px;
        bottom: 10px;
        font-size: 4rem;
        opacity: 0.2;
        z-index: 1;
        transform: rotate(-10deg);
    }
    .card-dashboard h5 {
        font-size: 0.9rem;
        text-transform: uppercase;
        font-weight: 600;
        opacity: 0.9;
        margin-bottom: 5px;
    }
    .card-dashboard h3 {
        font-size: 2.2rem;
        font-weight: 700;
        margin-bottom: 0;
    }
    
    /* Gradientes Teste P2P */
    .bg-gradient-teste-yellow { background: linear-gradient(135deg, #f1c40f 0%, #f39c12 100%); color: #fff; }
    .bg-gradient-teste-red { background: linear-gradient(135deg, #e74c3c 0%, #c0392b 100%); color: #fff; }

    /* --- AJUSTE MOBILE DE PONTA A PONTA --- */
    @media (max-width: 768px) {
        .mobile-full-width {
            margin-left: -1.5rem !important; /* Remove padding do container-fluid */
            margin-right: -1.5rem !important;
            width: calc(100% + 3rem) !important;
            border-radius: 0 !important;
            box-shadow: none !important;
            border-left: 0 !important;
            border-right: 0 !important;
        }
        .mobile-full-width .card-header {
            border-radius: 0 !important;
            padding-left: 1.5rem;
            padding-right: 1.5rem;
        }
        .mobile-full-width .card-body {
            padding: 0; /* Remove padding interno para tabela colar */
        }
        .mobile-full-width .table-responsive {
            border: none !important;
        }
    }

    /* TEMA ESCURO */
    [data-theme="dark"] .card { background-color: #2a2e33 !important; color: #e4e6eb !important; border-color: #3a3f44 !important; }
    [data-theme="dark"] .table { color: #e4e6eb !important; border-color: #3a3f44 !important; background-color: transparent !important; }
    [data-theme="dark"] .table th { background-color: #212529 !important; color: #fff !important; border-color: #3a3f44 !important; }
    [data-theme="dark"] .table td { background-color: transparent !important; color: #e4e6eb !important; border-color: #3a3f44 !important; }
</style>

<div class="container-fluid py-4">

    <div class="row mb-4 g-3">
        <div class="col-md-6">
            <div class="card card-dashboard bg-gradient-teste-yellow shadow-sm">
                <div class="card-body">
                    <h5>Testes P2P Ativos</h5>
                    <h3><?php echo $cont_testes_p2p_ativos; ?></h3>
                    <i class="fas fa-user-check icon-bg"></i>
                </div>
            </div>
        </div>
        <div class="col-md-6">
            <div class="card card-dashboard bg-gradient-teste-red shadow-sm">
                <div class="card-body">
                    <h5>Testes P2P Vencidos</h5>
                    <h3><?php echo $cont_testes_p2p_vencidos; ?></h3>
                    <i class="fas fa-user-clock icon-bg"></i>
                </div>
            </div>
        </div>
    </div>

    <div class="card shadow-sm border-0 rounded-3 mobile-full-width">
        
        <div class="card-header bg-white border-bottom py-3 d-flex justify-content-between align-items-center flex-wrap gap-2">
            <h4 class="mb-0 text-warning fw-bold"><i class="fas fa-flask me-2"></i>LISTAR Testes P2P</h4>
            <form action="action_p2p_gerar_teste.php" method="POST" class="m-0">
                <button type="submit" class="btn btn-warning text-white rounded-pill btn-sm px-3 shadow-sm">
                    <i class="fas fa-plus me-2"></i> Gerar Novo Teste
                </button>
            </form>
        </div>
        
        <?php if (isset($_SESSION['mensagem'])): ?>
            <div class="alert <?php echo strpos($_SESSION['msg_type'], 'success') !== false ? 'alert-success' : 'alert-danger'; ?> alert-dismissible fade show m-3" role="alert">
                <?php echo $_SESSION['mensagem']; ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        <?php unset($_SESSION['mensagem']); unset($_SESSION['msg_type']); ?>
        <?php endif; ?>

        <div class="card-body p-0"> <div class="table-responsive">
                <table class="display table table-hover align-middle mb-0" style="width: 100%;">
                    <thead class="table-light">
                        <tr>
                            <th class="ps-3">#</th>
                            <th>Nome</th>
                            <th>Código</th>
                            <th>Vencimento</th>
                            <th class="text-end pe-3">Ações</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (!empty($testes_p2p)): ?>
                            <?php foreach ($testes_p2p as $teste): ?>
                                <tr>
                                    <td class="ps-3"><?php echo $teste['id']; ?></td>
                                    <td class="fw-bold"><?php echo htmlspecialchars($teste['name']); ?></td>
                                    <td><code class="text-warning fw-bold"><?php echo htmlspecialchars($teste['usuario']); ?></code></td>
                                    <td><?php echo date('d/m/Y H:i', strtotime($teste['Vencimento'])); ?></td>
                                    <td class="text-end pe-3">
                                        <div class="btn-group">
                                            <button class="btn btn-outline-info btn-sm" title="Ver Informações"
                                                onclick="exibirModalP2P('Informações do Teste', 
                                                `<?php 
                                                    $venc_fmt = date('d/m/Y H:i', strtotime($teste['Vencimento']));
                                                    $mensagem_pronta = str_replace(
                                                        ['#cliente#', '#codigo#', '#vencimento#'], 
                                                        [htmlspecialchars($teste['name']), $teste['usuario'], $venc_fmt], 
                                                        $template_p2p_atual
                                                    );
                                                    echo addslashes($mensagem_pronta); 
                                                ?>`, 
                                                '<?php echo $teste['whatsapp']; ?>')">
                                                <i class="fas fa-eye"></i>
                                            </button>
                                            
                                            <a href="p2p_renovar_teste_form.php?id=<?php echo $teste['id']; ?>" class="btn btn-outline-warning btn-sm" title="Converter em Cliente">
                                                <i class="fas fa-exchange-alt"></i>
                                            </a>

                                            <a href="action_p2p_excluir.php?id=<?php echo $teste['id']; ?>&from=testes_p2p.php" class="btn btn-outline-danger btn-sm" title="Excluir" onclick="return confirm('Tem certeza que deseja excluir este teste?');">
                                                <i class="fas fa-trash"></i>
                                            </a>
                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        <?php else: ?>
                            <tr>
                                <td colspan="5" class="text-center py-4 text-muted">Nenhum teste P2P encontrado.</td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<?php
require_once 'footer.php';
?>

<script>
function exibirModalP2P(title, message, whatsappNumber) {
    const cleanMessage = message.replace(/\\'/g, "'").replace(/\\"/g, '"').replace(/\\`/g, '`');

    Swal.fire({
        title: title,
        html: `<pre style="white-space: pre-wrap; text-align: left; font-size: 0.9rem;">${cleanMessage}</pre>`,
        icon: 'info',
        showCancelButton: true,
        confirmButtonText: '<i class="fas fa-copy"></i> Copiar',
        cancelButtonText: '<i class="fab fa-whatsapp"></i> WhatsApp',
        confirmButtonColor: '#0d6efd',
        cancelButtonColor: '#25D366',
        reverseButtons: true 
    }).then((result) => {
        if (result.isConfirmed) {
            navigator.clipboard.writeText(cleanMessage).then(() => {
                Swal.fire('Copiado!', 'A mensagem foi copiada para a área de transferência.', 'success');
            }).catch(err => {
                Swal.fire('Erro!', 'Não foi possível copiar a mensagem.', 'error');
            });
        } else if (result.dismiss === Swal.DismissReason.cancel) {
            if (whatsappNumber && whatsappNumber.trim() !== '') {
                const encodedMessage = encodeURIComponent(cleanMessage);
                const whatsappURL = `https://api.whatsapp.com/send?phone=${whatsappNumber}&text=${encodedMessage}`;
                window.open(whatsappURL, '_blank');
            } else {
                Swal.fire('Atenção!', 'O cliente não tem um número de WhatsApp cadastrado para este teste.', 'warning');
            }
        }
    });
}

document.addEventListener('DOMContentLoaded', function() {
    <?php
    if (isset($_SESSION['show_p2p_modal_message'])) {
        echo "exibirModalP2P('" . addslashes($_SESSION['show_p2p_modal_title']) . "', `" . addslashes($_SESSION['show_p2p_modal_message']) . "`, '');";
        unset($_SESSION['show_p2p_modal_message']);
        unset($_SESSION['show_p2p_modal_title']);
    }
    ?>
});
</script>