<?php
// Inclui o cabeçalho e menu do seu painel principal
require_once 'menu.php';
require_once './api/controles/db.php'; 

$testes_p2p = [];
$template_p2p_atual = '';

// ==================================================
// ### INÍCIO DA NOVA LÓGICA DE CONTAGEM (V17) ###
// ==================================================
$cont_testes_p2p_ativos = 0;
$cont_testes_p2p_vencidos = 0;
// ==================================================

$conexao = conectar_bd();
if ($conexao) {
    try {
        $stmt_template = $conexao->prepare("SELECT valor FROM configuracoes WHERE chave = 'p2p_message_template' LIMIT 1");
        $stmt_template->execute();
        $template_p2p_atual = $stmt_template->fetchColumn();
        
        // ==================================================
        // ### LÓGICA DE CONTAGEM (V17 para Testes P2P) ###
        // ==================================================
        
        $agora_php = date("Y-m-d H:i:s");
        
        // Filtro base: É P2P E É Teste
        $sql_base_p2p_teste = " FROM clientes WHERE is_p2p = 1 AND plano = 'Teste P2P'";
        $params_contagem = [];

        // Adiciona filtro de revendedor (se for um)
        if (isset($_SESSION['nivel_admin']) && $_SESSION['nivel_admin'] == 0) {
            $sql_base_p2p_teste .= " AND admin_id = :admin_id";
            $params_contagem[':admin_id'] = $_SESSION['admin_id'];
        }

        // 1. Contar Testes P2P ATIVOS
        // (Lógica V17: não banido E vencimento no futuro)
        $sql_ativos = "SELECT COUNT(*) " . $sql_base_p2p_teste . " AND (is_banned IS NULL OR is_banned = 0) AND Vencimento >= :agora";
        $stmt_ativos = $conexao->prepare($sql_ativos);
        $stmt_ativos->execute(array_merge($params_contagem, [':agora' => $agora_php]));
        $cont_testes_p2p_ativos = $stmt_ativos->fetchColumn();

        // 2. Contar Testes P2P VENCIDOS
        $sql_vencidos = "SELECT COUNT(*) " . $sql_base_p2p_teste . " AND (is_banned IS NULL OR is_banned = 0) AND Vencimento < :agora";
        $stmt_vencidos = $conexao->prepare($sql_vencidos);
        $stmt_vencidos->execute(array_merge($params_contagem, [':agora' => $agora_php]));
        $cont_testes_p2p_vencidos = $stmt_vencidos->fetchColumn();
        
        // ==================================================
        // ### FIM DA LÓGICA DE CONTAGEM ###
        // ==================================================


        // --- Lógica para a tabela (original) ---
        $sql = "SELECT id, usuario, name, whatsapp, Vencimento FROM clientes WHERE is_p2p = 1 AND plano = 'Teste P2P'";
        $params = [];

        if (isset($_SESSION['nivel_admin']) && $_SESSION['nivel_admin'] == 0) {
            $sql .= " AND admin_id = :admin_id";
            $params[':admin_id'] = $_SESSION['admin_id'];
        }
        
        $sql .= " ORDER BY id DESC";
        $stmt = $conexao->prepare($sql);
        $stmt->execute($params);
        $testes_p2p = $stmt->fetchAll(PDO::FETCH_ASSOC);
        
    } catch(PDOException $e) {
        // (Log de erro)
        error_log("Erro na página Testes P2P: " . $e->getMessage());
    }
}
?>

<style>
    /* 1. Define as cores padrão (TEMA CLARO) */
    .card {
        color: #212529; 
    }
    .table {
        color: #212529; 
        background-color: #fff; /* Fundo da tabela claro */
    }
    .table-striped > tbody > tr:nth-of-type(odd) {
        background-color: rgba(0, 0, 0, 0.05); /* Fundo da linha listrada (claro) */
    }
    .table-hover > tbody > tr:hover > * {
         --bs-table-accent-bg: rgba(0, 0, 0, 0.075);
    }


    /* 2. Sobrescreve para o TEMA ESCURO (AGORA COM MAIS ESPECIFICIDADE) */
    [data-theme="dark"] .card {
        background-color: #2a2e33 !important; 
        color: #e4e6eb !important; 
        border-color: #3a3f44 !important;
    }
    
    /* [CORREÇÃO] Força a tabela DENTRO do card a ser escura */
    [data-theme="dark"] .card .table {
        background-color: transparent !important; /* Pega a cor do card */
        color: #e4e6eb !important; 
        border-color: #3a3f44 !important;
    }

    /* Força o texto da célula (td e th) a ser claro */
    [data-theme="dark"] .card .table td,
    [data-theme="dark"] .card .table th {
        color: #e4e6eb !important;
        border-color: #3a3f44 !important;
        /* Remove o fundo branco que o 'display table' estava causando */
        background-color: transparent !important; 
    }
    
    /* Força a linha listrada (ímpar) no tema escuro */
    [data-theme="dark"] .card .table-striped > tbody > tr:nth-of-type(odd) {
        background-color: rgba(255, 255, 255, 0.05) !important; 
    }
    
    /* Força a linha PAR (par) a ter o fundo transparente (do card) */
     [data-theme="dark"] .card .table-striped > tbody > tr:nth-of-type(even) {
         background-color: transparent !important; 
     }
    
    /* Força o hover no tema escuro */
    [data-theme="dark"] .card .table-hover > tbody > tr:hover > * {
        background-color: rgba(255, 255, 255, 0.1) !important; 
        color: #e4e6eb !important;
    }

    /* Garante que o cabeçalho (thead) fique com o fundo azul */
    [data-theme="dark"] .card .table > thead.bg-primary,
    [data-theme="dark"] .card .table > thead.bg-primary > tr {
         background-color: #0d6efd !important; 
         color: #fff !important; 
    }
    /* E que o texto do cabeçalho seja branco */
    [data-theme="dark"] .card .table > thead.bg-primary th {
         color: #fff !important; 
         border-color: #0d6efd !important;
    }
    
    /* ================================================================== */
    /* ### CSS DOS CARDS PROFISSIONAIS (do Dashboard) ### */
    /* ================================================================== */
    .stat-card {
        border: none;
        border-left-width: 5px;
        border-left-style: solid;
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.05);
        transition: transform 0.2s ease, box-shadow 0.2s ease;
        border-radius: 8px; 
    }
    .stat-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 6px 16px rgba(0, 0, 0, 0.08);
    }
    .stat-card .card-body {
        display: flex;
        justify-content: space-between;
        align-items: center;
        padding: 1.5rem; 
    }
    .stat-info .stat-label {
        font-size: 0.9rem;
        color: #adb5bd; 
        text-transform: uppercase;
        font-weight: 700;
    }
    .stat-info .stat-value {
        font-size: 2.25rem;
        font-weight: 700;
        margin: 0;
        color: var(--bs-heading-color); 
    }
    .stat-icon {
        font-size: 3.5rem;
        opacity: 0.15;
    }
    /* Cores (Amarelo e Cinzento/Vermelho) */
    .stat-card.card-testes-ativos { border-color: #ffc107; } /* Amarelo */
    .stat-card.card-testes-ativos .stat-label,
    .stat-card.card-testes-ativos .stat-icon { color: #ffc107; }

    .stat-card.card-vencidos { border-color: #dc3545; } /* Vermelho */
    .stat-card.card-vencidos .stat-label,
    .stat-card.card-vencidos .stat-icon { color: #dc3545; }
        
</style>
<div class="container-fluid py-4">

    <div class="row mb-4">
        <div class="col-md-6 mb-4">
            <div class="card stat-card card-testes-ativos h-100">
                <div class="card-body">
                    <div class="stat-info">
                        <div class="stat-label">Testes P2P Ativos</div>
                        <p class="stat-value"><?php echo $cont_testes_p2p_ativos; ?></p>
                    </div>
                    <div class="stat-icon"><i class="fa-solid fa-user-check"></i></div>
                </div>
            </div>
        </div>
        <div class="col-md-6 mb-4">
            <div class="card stat-card card-vencidos h-100">
                <div class="card-body">
                    <div class="stat-info">
                        <div class="stat-label">Testes P2P Vencidos</div>
                        <p class="stat-value"><?php echo $cont_testes_p2p_vencidos; ?></p>
                    </div>
                    <div class="stat-icon"><i class="fa-solid fa-user-clock"></i></div>
                </div>
            </div>
        </div>
    </div>
    <div class="card shadow-sm border-0 rounded-3 p-4">
        
        <h4 class="card-title text-primary d-flex justify-content-between align-items-center mb-4">
            <span class="fw-bold">LISTAR Testes P2P</span>
            <form action="action_p2p_gerar_teste.php" method="POST" class="m-0">
                <button type="submit" class="btn btn-primary rounded-pill">
                    <i class="fas fa-plus me-2"></i> Gerar Novo Teste
                </button>
            </form>
        </h4>
        
        <?php if (isset($_SESSION['mensagem'])): ?>
            <div class="alert <?php echo strpos($_SESSION['msg_type'], 'success') !== false ? 'alert-success' : 'alert-danger'; ?> alert-dismissible fade show" role="alert">
                <?php echo $_SESSION['mensagem']; ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        <?php unset($_SESSION['mensagem']); unset($_SESSION['msg_type']); ?>
        <?php endif; ?>

        <div class="table-responsive">
            <table class="display table table-striped table-hover border" style="width: 100%;">
                <thead class="bg-primary text-white">
                    <tr>
                        <th>#</th>
                        <th>Nome / Descrição</th>
                        <th>Código (Usuário)</th>
                        <th>Vencimento</th>
                        <th class="text-end">Ações</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (!empty($testes_p2p)): ?>
                        <?php foreach ($testes_p2p as $teste): ?>
                            <tr>
                                <td><?php echo $teste['id']; ?></td>
                                <td><?php echo htmlspecialchars($teste['name']); ?></td>
                                <td><?php echo htmlspecialchars($teste['usuario']); ?></td>
                                <td><?php echo date('d/m/Y H:i', strtotime($teste['Vencimento'])); ?></td>
                                <td class="text-end">
                                    
                                    <button class="btn btn-info btn-sm rounded-circle" style="width: 32px; height: 32px; line-height: 1.5;" title="Ver Informações"
                                        onclick="exibirModalP2P('Informações do Teste', 
                                        `<?php 
                                            $venc_fmt = date('d/m/Y H:i', strtotime($teste['Vencimento']));
                                            // Prepara a mensagem
                                            $mensagem_pronta = str_replace(
                                                ['#cliente#', '#codigo#', '#vencimento#'], 
                                                [htmlspecialchars($teste['name']), $teste['usuario'], $venc_fmt], 
                                                $template_p2p_atual
                                            );
                                            echo addslashes($mensagem_pronta); 
                                        ?>`, 
                                        '<?php echo $teste['whatsapp']; // Adiciona o número de WhatsApp ?>')">
                                        <i class="fas fa-eye"></i>
                                    </button>
                                    <a href="p2p_renovar_teste_form.php?id=<?php echo $teste['id']; ?>" class="btn btn-warning btn-sm rounded-circle" style="width: 32px; height: 32px; line-height: 1.5;" title="Renovar / Converter Teste">
                                        <i class="fas fa-sync-alt"></i>
                                    </a>

                                    <a href="action_p2p_excluir.php?id=<?php echo $teste['id']; ?>&from=testes_p2p.php" class="btn btn-danger btn-sm rounded-circle" style="width: 32px; height: 32px; line-height: 1.5;" title="Excluir" onclick="return confirm('Tem certeza que deseja excluir este teste?');"><i class="fas fa-trash"></i></a>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <tr>
                            <td colspan="5" class="text-center">Nenhum teste P2P encontrado.</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<?php
require_once 'footer.php';
?>

<script>
function exibirModalP2P(title, message, whatsappNumber) {
    // Remove as barras invertidas que o addslashes() colocou
    const cleanMessage = message.replace(/\\'/g, "'").replace(/\\"/g, '"').replace(/\\`/g, '`');

    Swal.fire({
        title: title,
        html: `<pre style="white-space: pre-wrap; text-align: left; font-size: 0.9rem;">${cleanMessage}</pre>`,
        icon: 'info',
        showCancelButton: true,
        confirmButtonText: '<i class="fas fa-copy"></i> Copiar',
        cancelButtonText: '<i class="fab fa-whatsapp"></i> WhatsApp',
        confirmButtonColor: '#0d6efd',
        cancelButtonColor: '#25D366',
        reverseButtons: true // Coloca o botão de WhatsApp à esquerda
    }).then((result) => {
        if (result.isConfirmed) {
            // Ação de Copiar
            navigator.clipboard.writeText(cleanMessage).then(() => {
                Swal.fire('Copiado!', 'A mensagem foi copiada para a área de transferência.', 'success');
            }).catch(err => {
                Swal.fire('Erro!', 'Não foi possível copiar a mensagem.', 'error');
            });
        } else if (result.dismiss === Swal.DismissReason.cancel) {
            // Ação de WhatsApp
            if (whatsappNumber && whatsappNumber.trim() !== '') {
                const encodedMessage = encodeURIComponent(cleanMessage);
                const whatsappURL = `https://api.whatsapp.com/send?phone=${whatsappNumber}&text=${encodedMessage}`;
                window.open(whatsappURL, '_blank');
            } else {
                Swal.fire('Atenção!', 'O cliente não tem um número de WhatsApp cadastrado para este teste.', 'warning');
            }
        }
    });
}

document.addEventListener('DOMContentLoaded', function() {
    <?php
    if (isset($_SESSION['show_p2p_modal_message'])) {
        echo "exibirModalP2P('" . addslashes($_SESSION['show_p2p_modal_title']) . "', `" . addslashes($_SESSION['show_p2p_modal_message']) . "`, '');";
        unset($_SESSION['show_p2p_modal_message']);
        unset($_SESSION['show_p2p_modal_title']);
    }
    ?>
});
</script>