<?php
session_start();
// Verifica se o usuário está logado
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}

require_once('./api/controles/db.php');
require_once('./api/controles/dashboard.php');
require_once("menu.php"); // Inclui o menu do seu painel

// Chama a nova função para buscar todos os dados da página
$dadosVencimentos = getDadosVencimentos(7); // Busca vencimentos para os próximos 7 dias
?>

<style>
    /* ====================================================== */
    /* CSS ATUALIZADO PARA FORÇAR O TEMA CLARO E PERSONALIZADO */
    /* ====================================================== */

    /* Define um fundo claro para o corpo da página de vencimentos */
    .vencimentos-page-wrapper {
        background-color: #f8f9fa; /* Fundo cinza bem claro */
    }

    /* Estilo do Cabeçalho da Página */
    .vencimentos-page-wrapper .page-header {
        background-color: #0d6efd; /* Azul do header na foto */
        color: #ffffff;
        padding: 15px 20px;
        border-radius: 8px;
        margin-bottom: 1.5rem;
        display: flex;
        justify-content: space-between;
        align-items: center;
        flex-wrap: wrap;
    }
    .vencimentos-page-wrapper .page-header h4 {
        margin-bottom: 0;
        color: #ffffff;
        font-size: 1.2rem;
        font-weight: 600;
    }
    .vencimentos-page-wrapper .page-header .header-actions {
        display: flex;
        gap: 10px;
    }
    .vencimentos-page-wrapper .page-header .form-select,
    .vencimentos-page-wrapper .page-header .btn-primary {
        background-color: rgba(255, 255, 255, 0.1);
        border: 1px solid rgba(255, 255, 255, 0.3);
        color: #ffffff;
    }
    .vencimentos-page-wrapper .page-header .form-select option {
        color: #000; /* Texto preto nas opções do select */
    }
    
    /* Força os cards a terem fundo branco */
    .vencimentos-page-wrapper .card {
        background-color: #ffffff !important;
        border: 1px solid #e9ecef !important;
        box-shadow: 0 0.125rem 0.25rem rgba(0,0,0,.075);
    }

    /* Estilos para os Cards de Resumo (KPIs) */
    .summary-card {
        padding: 20px;
        display: flex;
        align-items: center;
        gap: 20px;
        margin-bottom: 1rem;
        border-radius: 12px !important;
    }
    .summary-card .icon {
        width: 60px;
        height: 60px;
        border-radius: 10px;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 24px;
        color: #fff;
    }
    .summary-card.card-red .icon { background-color: #dc3545; }
    .summary-card.card-blue .icon { background-color: #0d6efd; }
    .summary-card.card-green .icon { background-color: #198754; }
    
    .summary-card .info .value {
        font-size: 2.2rem;
        font-weight: 700;
        color: #212529; /* Cor do texto escura */
        line-height: 1.2;
    }
    .summary-card .info .label {
        font-size: 0.9rem;
        color: #6c757d; /* Cor do texto secundária */
    }

    /* Estilos para forçar a tabela a ter o tema claro */
    .vencimentos-page-wrapper .table {
        color: #212529 !important; /* Texto escuro na tabela */
    }
    .vencimentos-page-wrapper .table th {
        font-weight: 600;
        color: #6c757d;
        text-transform: uppercase;
        font-size: 0.8rem;
        background-color: #f8f9fa !important; /* Fundo do header da tabela */
    }
    .vencimentos-page-wrapper .table td {
        vertical-align: middle;
    }
    .status-badge {
        display: inline-block; padding: 0.35em 0.65em; font-size: .75em; font-weight: 700;
        line-height: 1; text-align: center; white-space: nowrap; vertical-align: baseline;
        border-radius: 50rem;
    }
    .status-bloqueado { color: #842029; background-color: #f8d7da; }
    .btn i { margin-right: 5px; }

</style>

<div class="p-3 p-md-4 vencimentos-page-wrapper">
    <div class="page-header">
        <h4><i class="fas fa-arrow-left me-2"></i>Vencimento dos clientes</h4>
        <div class="header-actions">
            <select id="refresh-interval" class="form-select form-select-sm" style="width: auto;">
                <option value="30">30 segundos</option>
                <option value="60">1 minuto</option>
                <option value="300">5 minutos</option>
                <option value="0">Nunca</option>
            </select>
            <button id="update-btn" class="btn btn-sm btn-primary">Atualizar</button>
        </div>
    </div>

    <div class="alert alert-warning" role="alert">
        <i class="fas fa-exclamation-triangle me-2"></i>
        Vencendo nos próximos dias
    </div>

    <div class="row">
        <div class="col-lg-4 col-md-6">
            <div class="card summary-card card-red">
                <div class="icon"><i class="fas fa-times"></i></div>
                <div class="info">
                    <div class="value"><?php echo $dadosVencimentos['nao_renovados_count']; ?></div>
                    <div class="label">Não renovado (Atrasado)</div>
                </div>
            </div>
        </div>
        <div class="col-lg-4 col-md-6">
            <div class="card summary-card card-blue">
                <div class="icon"><i class="fas fa-exclamation"></i></div>
                <div class="info">
                    <div class="value"><?php echo $dadosVencimentos['proximos_vencimentos_count']; ?></div>
                    <div class="label">Próximos vencimentos</div>
                </div>
            </div>
        </div>
        <div class="col-lg-4 col-md-12">
            <div class="card summary-card card-green">
                <div class="icon"><i class="fas fa-dollar-sign"></i></div>
                <div class="info">
                    <div class="value">R$ <?php echo number_format($dadosVencimentos['valor_total_a_receber'], 2, ',', '.'); ?></div>
                    <div class="label">Valor total a receber</div>
                </div>
            </div>
        </div>
    </div>

    <div class="card mt-3">
        <div class="card-body p-0"> <div class="table-responsive">
                <table class="table table-hover mb-0"> <thead>
                        <tr>
                            <th class="py-3 px-3">NOME DO CLIENTE</th>
                            <th>TELEFONE</th>
                            <th>VENCIMENTO</th>
                            <th>STATUS</th>
                            <th>VALOR</th>
                            <th class="text-end px-3">AÇÕES</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (empty($dadosVencimentos['lista_vencidos'])): ?>
                            <tr><td colspan="6" class="text-center text-muted py-4">Nenhum cliente vencido encontrado.</td></tr>
                        <?php else: ?>
                            <?php 
                            $hoje = new DateTime('now', new DateTimeZone('America/Sao_Paulo'));
                            foreach ($dadosVencimentos['lista_vencidos'] as $cliente): 
                                $vencimento = new DateTime($cliente['Vencimento']);
                                $diasAtrasado = $hoje->diff($vencimento)->days;
                                $telefoneLimpo = '55' . preg_replace('/\D/', '', $cliente['telefone']);
                            ?>
                                <tr>
                                    <td class="px-3"><?php echo htmlspecialchars($cliente['name']); ?></td>
                                    <td><?php echo htmlspecialchars($cliente['telefone']); ?></td>
                                    <td>
                                        <?php echo date('d/m/Y', strtotime($cliente['Vencimento'])); ?>
                                        <small class="d-block text-muted">(atrasado <?php echo $diasAtrasado; ?> dias)</small>
                                    </td>
                                    <td><span class="status-badge status-bloqueado">Bloqueado (<?php echo $diasAtrasado; ?> dias)</span></td>
                                    <td>R$ <?php echo number_format($cliente['V_total'], 2, ',', '.'); ?></td>
                                    <td class="text-end px-3">
                                        <a href="https://api.whatsapp.com/send?phone=<?php echo $telefoneLimpo; ?>&text=Olá, <?php echo urlencode($cliente['name']); ?>!" target="_blank" class="btn btn-sm btn-outline-primary me-2"><i class="fab fa-whatsapp"></i> Contato</a>
                                        <button type="button" class="btn btn-sm btn-outline-success" onclick='modal_master("api/clientes.php", "renovar_cliente", "<?php echo $cliente['id']; ?>", "usuario", "<?php echo $cliente['name']; ?>")'><i class="fas fa-sync-alt"></i> Renovar</button>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<script>
document.addEventListener("DOMContentLoaded", function() {
    const intervalSelect = document.getElementById('refresh-interval');
    const updateBtn = document.getElementById('update-btn');
    let refreshTimer = null;

    function startAutoRefresh(intervalSeconds) {
        if (refreshTimer) { clearInterval(refreshTimer); }
        if (intervalSeconds > 0) {
            refreshTimer = setInterval(function() {
                location.reload();
            }, intervalSeconds * 1000);
        }
    }

    updateBtn.addEventListener('click', function() { location.reload(); });
    intervalSelect.addEventListener('change', function() { startAutoRefresh(parseInt(this.value, 10)); });
    startAutoRefresh(parseInt(intervalSelect.value, 10));
});
</script>