<?php
// Desativa erros na tela também aqui para garantir
ini_set('display_errors', 0);
error_reporting(0);

require_once("libs/lib.php");

$user = isset($_COOKIE['xuserm']) ? $_COOKIE['xuserm'] : '';
$pwd = isset($_COOKIE['xpwdm']) ? $_COOKIE['xpwdm'] : '';

$id = trim($_REQUEST['stream']);
$canal = urldecode($_REQUEST['canal']);
$img = urldecode($_REQUEST['img']);
$idcatg = trim($_REQUEST['catg']);
$sessao = isset($_REQUEST['sessao']) ? $_REQUEST['sessao'] : '';

// URL apontando para o proxy corrigido
$stream_url = "proxy_player.php?user=$user&pwd=$pwd&stream=$id";

?>
<!DOCTYPE html>
<html lang="pt-br">
   <head>
      <?php include("inc/head.php"); ?>
      
      <meta http-equiv="Content-Security-Policy" content="upgrade-insecure-requests">

      <script type="text/javascript" src="https://cdn.jsdelivr.net/npm/clappr@latest/dist/clappr.min.js"></script>
      <script type="text/javascript" src="https://cdn.jsdelivr.net/gh/clappr/clappr-level-selector-plugin@latest/dist/level-selector.min.js"></script>
      
      <script src="https://cdn.jsdelivr.net/npm/hls.js@latest"></script>
      
      <script src='https://content.jwplatform.com/libraries/fgbTqCCh.js'></script>
      
      <style>
         .video-container {
             background-color: #000;
             position: relative;
             width: 100%;
             height: 100vh; /* Ocupa altura total se possível */
             max-height: 650px;
         }
         #livevideo {
             position: absolute;
             top: 0;
             left: 0;
             width: 100%;
             height: 100%;
         }
         body { background-color: #111; color: #eee; }
      </style>
   </head>
   
   <body onselectstart="return false" oncontextmenu="return false" ondragstart="return false">
      <div id="single-video-fullwidth" class="container-fluid standard-bg">
         
         <div class="row header-top">
            <?php include("inc/header.php"); ?>
         </div>
         
         <div class="row home-mega-menu">
            <div class="col-md-12">
               <nav class="navbar navbar-default">
                  <div class="navbar-header">
                     <button class="navbar-toggle" type="button" data-toggle="collapse" data-target=".js-navbar-collapse">
                     <span class="sr-only">Menu</span>
                     <span class="icon-bar"></span><span class="icon-bar"></span><span class="icon-bar"></span>
                     </button>
                  </div>
                  <div class="collapse navbar-collapse js-navbar-collapse megabg dropshd ">
                     <ul class="nav navbar-nav">
                        <?php include("inc/menu.php"); ?>
                     </ul>
                     <div class="search-block">
                        <?php include("inc/busca.php"); ?> 
                     </div>
                  </div>
               </nav>
            </div>
         </div>

         <div class="row">
            
            <div class="col-lg-2 col-md-3 hidden-sm hidden-xs">
               <aside class="dark-bg">
                  <article>
                     <h2 class="icon" style="color:#fff;"><?php echo TXT_CANAIS_SUGESTAO; ?></h2>
                     <ul class="sidebar-links" style="max-height: 600px; overflow-y: auto;">
                        <?php
                        $url_api = IP."/player_api.php?username=$user&password=$pwd&action=get_live_streams&category_id=$idcatg";
                        $resposta = apixtream($url_api);
                        $output = json_decode($resposta,true);
                        
                        if($output && is_array($output)){
                            foreach($output as $index) {
                               $c_nome = $index['name'];
                               $c_type = $index['stream_type'];
                               $c_id = $index['stream_id'];
                               $c_img = $index['stream_icon']; 
                               $c_cat = $index['category_id'];
                        ?>
                           <li class="fa fa-chevron-right">
                               <a href="canal.php?sessao=<?php echo $sessao; ?>&stream=<?php echo $c_id; ?>&streamtipo=<?php echo $c_type; ?>&canal=<?php echo urlencode($c_nome); ?>&img=<?php echo urlencode($c_img); ?>&catg=<?php echo $c_cat; ?>">
                                   <?php echo limitar_texto($c_nome, 20); ?>
                               </a>
                           </li>
                        <?php 
                            } 
                        }
                        ?>
                     </ul>
                  </article>
               </aside>
            </div>

            <div class="col-lg-10 col-md-9 col-sm-12">
               <div id="single-video-fullwidth-wrapper">
                  <article class="post-video">
                     <div class="video-info dropshd">
                        
                        <div class="video-container">
                           <?php if($_GET['player'] == 3) { ?>
                               <video id="livevideo" controls autoplay></video>
                           <?php } else if($_GET['player'] == 4) { ?>
                               <div id="livevideo"></div>
                           <?php } else { ?>
                               <div id="livevideo"></div> <?php } ?>
                        </div>
                        
                        <h2 class="title main-head-title" style="padding: 10px;"><?php echo $canal; ?></h2>
                        
                        <div class="text-right" style="padding: 10px;">
                             <span style="color:#aaa; margin-right:10px;">Opções:</span>
                             <a href="?sessao=<?php echo $sessao; ?>&stream=<?php echo $id; ?>&streamtipo=live&catg=<?php echo $idcatg; ?>&canal=<?php echo urlencode($canal); ?>&img=<?php echo urlencode($img); ?>&player=1" class="btn <?php if($_GET['player']==1 || $_GET['player']=='') echo 'btn-primary'; else echo 'btn-default'; ?>">Clappr (Padrão)</a>
                             <a href="?sessao=<?php echo $sessao; ?>&stream=<?php echo $id; ?>&streamtipo=live&catg=<?php echo $idcatg; ?>&canal=<?php echo urlencode($canal); ?>&img=<?php echo urlencode($img); ?>&player=3" class="btn <?php if($_GET['player']==3) echo 'btn-primary'; else echo 'btn-default'; ?>">HLS (Leve)</a>
                             <a href="?sessao=<?php echo $sessao; ?>&stream=<?php echo $id; ?>&streamtipo=live&catg=<?php echo $idcatg; ?>&canal=<?php echo urlencode($canal); ?>&img=<?php echo urlencode($img); ?>&player=4" class="btn <?php if($_GET['player']==4) echo 'btn-primary'; else echo 'btn-default'; ?>">JW Player</a>
                        </div>

                     </div>
                     <div class="clearfix spacer"></div>
                  </article>
               </div>
            </div>
         </div>
      </div>
      
      <?php include("inc/scripts.php"); ?>
      
      <?php if($_GET['player'] == 1 || $_GET['player'] == '') { ?>
      <script>
         var player = new Clappr.Player({
             source: "<?php echo $stream_url; ?>",
             parentId: "#livevideo",
             mimeType: "application/x-mpegURL",
             autoPlay: true,
             width: '100%',
             height: '100%',
             poster: "<?php echo $img; ?>",
             plugins: [LevelSelector],
             playback: {
                 playInline: true,
                 recycleVideo: true,
                 triggerFatalErrorOnResourceDenied: false
             }
         });
      </script>
      <?php } ?>
      
      <?php if($_GET['player'] == 3) { ?>
      <script>
         var video = document.getElementById('livevideo');
         var streamUrl = "<?php echo $stream_url; ?>";
         
         if(Hls.isSupported()) {
             var hls = new Hls({
                 debug: false,
                 enableWorker: true,
                 lowLatencyMode: true,
                 backBufferLength: 90
             });
             hls.loadSource(streamUrl);
             hls.attachMedia(video);
             hls.on(Hls.Events.MANIFEST_PARSED,function() {
                 video.play();
             });
             hls.on(Hls.Events.ERROR, function (event, data) {
                 if (data.fatal) {
                     switch (data.type) {
                     case Hls.ErrorTypes.NETWORK_ERROR:
                         console.log("Erro de rede, tentando recuperar...");
                         hls.startLoad();
                         break;
                     case Hls.ErrorTypes.MEDIA_ERROR:
                         console.log("Erro de mídia, tentando recuperar...");
                         hls.recoverMediaError();
                         break;
                     default:
                         hls.destroy();
                         break;
                     }
                 }
             });
         }
         else if (video.canPlayType('application/vnd.apple.mpegurl')) {
             video.src = streamUrl;
             video.addEventListener('loadedmetadata',function() {
                 video.play();
             });
         }
      </script>
      <?php } ?>
      
      <?php if($_GET['player'] == 4) { ?>
      <script type="text/javascript">
         jwplayer("livevideo").setup({
             "file": "<?php echo $stream_url; ?>",
             "width": "100%",
             "height": "100%",
             "autostart": true,
             "type": "hls"
         });
      </script>
      <?php } ?>

   </body>
</html>