<?php
require_once $_SERVER['DOCUMENT_ROOT'] . '/api/controles/db.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST' || empty($_POST['ids']) || !is_array($_POST['ids'])) {
    header('Location: ' . $_SERVER['HTTP_REFERER']);
    exit;
}

$ids_sanitizados = array_map('intval', $_POST['ids']);
$tipo = isset($_POST['tipo']) ? $_POST['tipo'] : '';
$placeholders = implode(',', array_fill(0, count($ids_sanitizados), '?'));

try {
    $conn = conectar_bd();

    if ($tipo === 'filme' && count($ids_sanitizados) > 0) {
        $stmt = $conn->prepare("DELETE FROM streams WHERE id IN ($placeholders) AND stream_type = 'movie'");
        $stmt->execute($ids_sanitizados);
    } elseif ($tipo === 'serie' && count($ids_sanitizados) > 0) {
        $conn->beginTransaction();
        $stmt_ep = $conn->prepare("DELETE FROM series_episodes WHERE series_id IN ($placeholders)");
        $stmt_ep->execute($ids_sanitizados);
        $stmt_serie = $conn->prepare("DELETE FROM series WHERE id IN ($placeholders)");
        $stmt_serie->execute($ids_sanitizados);
        $conn->commit();
    } elseif ($tipo === 'canal' && count($ids_sanitizados) > 0) {
        $stmt = $conn->prepare("DELETE FROM streams WHERE id IN ($placeholders) AND stream_type = 'live'");
        $stmt->execute($ids_sanitizados);
    }

    header('Location: ' . $_SERVER['HTTP_REFERER']);
    exit;

} catch (PDOException $e) {
    if (isset($conn) && $conn->inTransaction()) {
        $conn->rollBack();
    }
    die("Falha ao excluir em massa: " . $e->getMessage());
}
?>